/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstance;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SessionFailureTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISCSIInstanceImpl
extends TableRowImpl
implements ISCSIInstance {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public ISCSIInstanceImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        StringBuffer sb = new StringBuffer(this.getInstanceVswitch().getName());
        sb.append(" ISCSI Instance");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    public VSwitch getInstanceVswitch() throws RemoteException {
        return this.getParentVSwitch();
    }

    @Override
    public Integer getMinVersionSupported() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VERSION_MIN);
    }

    @Override
    public Integer getMaxVersionSupported() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VERSION_MAX);
    }

    @Override
    public String getVendorId() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VENDOR_ID);
    }

    @Override
    public String getVendorVersion() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION);
    }

    @Override
    public BigInteger getNumOfPortals() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS);
    }

    @Override
    public BigInteger getNumOfNodes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES);
    }

    @Override
    public BigInteger getNumOfSessions() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS);
    }

    @Override
    public BigInteger getNumOfSessionFailures() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE);
    }

    @Override
    public SessionFailureTypeConstant getLastFailureType() throws RemoteException {
        return (SessionFailureTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE);
    }

    @Override
    public String getLastRemoteNodeName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME);
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_VERSION_MIN, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_VERSION_MAX, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_VENDOR_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

