/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPort;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSITransportType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SCSIInitiatorPortImpl
extends StatisticsImpl
implements SCSIInitiatorPort {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> s_parametersToCalculateMap;

    public SCSIInitiatorPortImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SCSI_INITIATOR_PORT, aCED, s_parametersToCalculateMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(ClassID.SCSI_INITIATOR_PORT.toString());
        try {
            ISCSIInitiatorImpl initiator = this.getInitiatorImpl();
            if (initiator != null) {
                sb.append(" ");
                sb.append(" - Initiator ");
                sb.append(initiator.getAlias());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sb.toString();
    }

    private ISCSIInitiatorImpl getInitiatorImpl() throws RemoteException {
        CommKeyClassId iscsiInitiatorCommKeyClassId;
        CommKeyClassId scsiInitiatorCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_INITIATOR_ID);
        if (scsiInitiatorCommKeyClassId != null && (iscsiInitiatorCommKeyClassId = this.getCluster().getISCSIId(scsiInitiatorCommKeyClassId)) != null) {
            ISCSIInitiatorImpl initiatorCommKeyClassIdImpl = (ISCSIInitiatorImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiInitiatorCommKeyClassId);
            return initiatorCommKeyClassIdImpl;
        }
        return null;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.SCSI_INITIATOR_PORT_STATISTICS_GROUP_TYPE;
    }

    @Override
    public SCSIPortRoleConstant getRole() {
        SCSIPortRoleConstant role = (SCSIPortRoleConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_PORT_ROLE);
        return role;
    }

    @Override
    public SCSITransportType getTransportType() throws RemoteException {
        SCSITransportType transportType = (SCSITransportType)this.getSrValueOf(ParameterCode.SCSI_PORT_TRANSPORT_TYPE);
        return transportType;
    }

    @Override
    public String getName() throws RemoteException {
        String name = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_NAME);
        return name;
    }

    @Override
    public BigInteger getReadMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_READ_MB);
    }

    @Override
    public BigInteger getWrittenMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB);
    }

    @Override
    public Integer getISID() throws RemoteException {
        Integer isid = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_ISID);
        return isid;
    }

    @Override
    public BigInteger getOutCommands() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS);
    }

    @Override
    public ISCSIInitiator getInitiator() throws RemoteException {
        return this.getInitiatorImpl();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INITIATOR_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_PORT_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_PORT_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_PORT_ISID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_PORT_READ_MB, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        s_parametersToCalculateMap = new HashMap();
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_READ_MB, ClientParameterCode.SCSI_TARGET_PORT_READ_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB_PER_SEC);
    }
}

