/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.Initiator;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.TargetAccessModeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class InitiatorImpl
extends SCSIDeviceImpl
implements Initiator {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private VSwitchImpl m_vswitch;

    protected InitiatorImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        VSwitchImpl vSwitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        this.setParentVSwitch(vSwitch);
        return changedValues;
    }

    @Override
    public VSwitchImpl getParentVSwitch() {
        return this.m_vswitch;
    }

    public void setParentVSwitch(VSwitchImpl vswitch) {
        this.m_vswitch = vswitch;
    }

    @Override
    public TargetAccessModeConstant getTargetAccessMode() throws RemoteException {
        return this.getTargetAccessMode(null);
    }

    public TargetAccessModeConstant getTargetAccessMode(VSwitch vSwitch) throws RemoteException {
        TargetAccessModeConstant accessMode = (TargetAccessModeConstant)this.getValueOf(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE);
        return accessMode;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_ALIAS, vSwitch == null);
        return alias;
    }

    @Override
    public String getName() throws RemoteException {
        return this.getName(null);
    }

    @Override
    public String getName(VSwitchImpl vSwitch) {
        String name = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_NAME, vSwitch == null);
        return name;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

