/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISCSIRemoteInitiatorStatisticsImpl
extends StatisticsImpl
implements ISCSIRemoteInitiatorStatistics {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static HashMap<ParameterCode, ClientParameterCode> s_parametersToCalculateMap;
    private static SrLogger theLogger;

    public ISCSIRemoteInitiatorStatisticsImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS, aCED, s_parametersToCalculateMap);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getInitiatorAlias();
        return changedValues;
    }

    @Override
    protected PollingGroupType getGroupType() {
        return PollingGroupType.ISCSI_REMOTE_INITIATOR_STATISTICS_GROUP_TYPE;
    }

    private ISCSIRemoteInitiatorImpl getRemoteInitiatorImpl() throws RemoteException {
        CommKeyClassId initiatorCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_REMOTE_INITIATOR_ID);
        if (initiatorCommKeyClassId != null) {
            ISCSIRemoteInitiatorImpl initiatorImpl = (ISCSIRemoteInitiatorImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(initiatorCommKeyClassId);
            return initiatorImpl;
        }
        return null;
    }

    @Override
    public String getInitiatorAlias() throws RemoteException {
        ISCSIRemoteInitiatorImpl initiatorImpl = this.getRemoteInitiatorImpl();
        if (initiatorImpl != null) {
            return initiatorImpl.getInitiatorAlias();
        }
        return null;
    }

    @Override
    public String getInitiatorName() throws RemoteException {
        ISCSIRemoteInitiatorImpl initiatorImpl = this.getRemoteInitiatorImpl();
        if (initiatorImpl != null) {
            return initiatorImpl.getInitiatorName();
        }
        return null;
    }

    @Override
    public ISCSITarget getTarget() throws RemoteException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.SCSI_TARGET_ID);
        ISCSITarget target = null;
        if (scsiTargetCommKeyClassId != null) {
            CommKeyClassId iscsiTargetCommKeyClassId = this.cluster.getISCSIId(scsiTargetCommKeyClassId);
            if (iscsiTargetCommKeyClassId != null) {
                target = (ISCSITarget)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
            } else {
                theLogger.trace(SrLogCategories.LEGACY, ">>>>>>ISCSIRemoteInitiatorStatisticsImpl: getTarget(), iscsiTargetCommKeyClassId == null");
            }
        }
        return target;
    }

    @Override
    public VSwitch getVSwitch() throws RemoteException {
        return this.getParentVSwitch();
    }

    @Override
    public BigInteger getAttachedTimes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES);
    }

    @Override
    public BigInteger getOutCommands() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_OUT_COMMANDS);
    }

    @Override
    public BigInteger getReadMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_READ_MB);
    }

    @Override
    public BigInteger getWrittenMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_WRITTEN_MB);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_OUT_COMMANDS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_READ_MB, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_WRITTEN_MB, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        s_parametersToCalculateMap = new HashMap();
        theLogger = SrLogger.getLogger();
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_OUT_COMMANDS, ClientParameterCode.ISCSI_REMOTE_INITIATOR_OUT_CMDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_WRITTEN_MB, ClientParameterCode.ISCSI_REMOTE_INITIATOR_WRITTEN_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_READ_MB, ClientParameterCode.ISCSI_REMOTE_INITIATOR_READ_MB_PER_SEC);
    }
}

