/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISCSIRemoteInitiatorImpl
extends TableRowImpl
implements ISCSIRemoteInitiator {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private ArrayList m_initiatorAllSessions = new ArrayList();

    public ISCSIRemoteInitiatorImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_REMOTE_INITIATOR, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getInitiatorAlias();
        return changedValues;
    }

    @Override
    public void clear() throws RemoteException {
        this.m_initiatorAllSessions.clear();
        super.clear();
    }

    @Override
    public VSwitch getInitiatorVswitchParent() throws RemoteException {
        return this.getParentVSwitch();
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_INITIATOR_SESSIONS, this.getInitiatorSessions());
        return parameterList;
    }

    @Override
    public ISCSISession[] getInitiatorSessions() throws RemoteException {
        ISCSISession[] sessions = new ISCSISession[this.m_initiatorAllSessions.size()];
        return this.m_initiatorAllSessions.toArray(sessions);
    }

    public void addInitiatorSession(ISCSISessionImpl iscsiSessionImpl) {
        this.m_initiatorAllSessions.add(iscsiSessionImpl);
    }

    public void removeInitiatorSession(ISCSISessionImpl iscsiSessionImpl) {
        this.m_initiatorAllSessions.remove(iscsiSessionImpl);
    }

    @Override
    public String getInitiatorAlias() throws RemoteException {
        if (this.m_initiatorAllSessions != null && this.m_initiatorAllSessions.size() > 0) {
            ISCSISession firstSession = (ISCSISession)this.m_initiatorAllSessions.get(0);
            return firstSession.getInitiatorAlias();
        }
        return null;
    }

    @Override
    public String getInitiatorName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_INITIATOR_NAME);
    }

    @Override
    public ISCSITargetImpl getTarget() throws RemoteException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.SCSI_TARGET_ID);
        ISCSITargetImpl target = null;
        if (scsiTargetCommKeyClassId != null) {
            CommKeyClassId iscsiTargetCommKeyClassId = this.cluster.getISCSIId(scsiTargetCommKeyClassId);
            target = (ISCSITargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
        }
        return target;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

