/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.SRPCredentialsImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.InitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.target.ISCSIRemoteDiscoveryPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ISCSIInitiatorImpl
extends InitiatorImpl
implements ISCSIInitiator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private ArrayList m_sessions = new ArrayList();
    private ArrayList m_remoteTargets = new ArrayList();
    private ArrayList m_remoteDiscoveryPortals = new ArrayList();
    private CHAPCredentialsImpl m_chapCredentials;
    private SRPCredentialsImpl m_srpCredentials;

    public ISCSIInitiatorImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_INITIATOR, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap map = super.getClientParameterList();
        map.put(ClientParameterCode.ISCSI_INITIATOR_REMOTE_TARGETS, this.getISCSIRemoteTargets());
        map.put(ClientParameterCode.ISCSI_INITIATOR_REMOTE_DISCOVERY_PORTALS, this.getISCSIRemoteDiscoveryPortals());
        return map;
    }

    @Override
    public void clear() throws RemoteException {
        this.m_sessions.clear();
        this.m_remoteTargets.clear();
        this.m_remoteDiscoveryPortals.clear();
        this.setCHAPCredentials(null);
        this.setSRPCredentials(null);
        super.clear();
    }

    @Override
    public String toString() {
        return ClassID.ISCSI_INITIATOR + " " + this.getAlias();
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_ALIAS, vSwitch == null);
        return alias;
    }

    @Override
    public String getCHAPUserName() throws RemoteException {
        return this.m_chapCredentials == null ? null : this.m_chapCredentials.getUserName();
    }

    @Override
    public String getSRPUserName() throws RemoteException {
        return this.m_srpCredentials == null ? null : this.m_srpCredentials.getUserName();
    }

    @Override
    public ISCSIRemoteTarget[] getISCSIRemoteTargets() throws RemoteException {
        ISCSIRemoteTarget[] array = new ISCSIRemoteTarget[this.m_remoteTargets.size()];
        return this.m_remoteTargets.toArray(array);
    }

    @Override
    public ISCSIRemotePortalDiscovery[] getISCSIRemoteDiscoveryPortals() throws RemoteException {
        ISCSIRemotePortalDiscovery[] array = new ISCSIRemotePortalDiscovery[this.m_remoteDiscoveryPortals.size()];
        return this.m_remoteDiscoveryPortals.toArray(array);
    }

    @Override
    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.m_sessions.size()];
        return this.m_sessions.toArray(array);
    }

    public void setCHAPCredentials(CHAPCredentialsImpl credentials) {
        this.m_chapCredentials = credentials;
    }

    public CHAPCredentialsImpl getCHAPCredentials() {
        return this.m_chapCredentials;
    }

    public void setSRPCredentials(SRPCredentialsImpl credentials) {
        this.m_srpCredentials = credentials;
    }

    public SRPCredentialsImpl getSRPCredentials() {
        return this.m_srpCredentials;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ISCSIInitiatorImpl.changeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        String chapUserName = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME);
        String chapPassword = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_CHAP_PASSWORD);
        boolean isCHAPCredChange = chapUserName != null || chapPassword != null;
        String srpUserName = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_SRP_USER_NAME);
        String srpPassword = (String)parameterList.get(ClientParameterCode.ISCSI_INITIATOR_SRP_PASSWORD);
        boolean isSRPCredChange = srpUserName != null || srpPassword != null;
        HashMap<ClientParameterCode, String> map = new HashMap<ClientParameterCode, String>();
        if (chapUserName != null) {
            map.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, chapUserName);
        }
        if (chapPassword != null) {
            map.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, chapPassword);
        }
        if (this.m_chapCredentials != null && isCHAPCredChange) {
            midFutures.add(this.m_chapCredentials.changeElement(map));
        }
        map.clear();
        if (srpUserName != null) {
            map.put(ClientParameterCode.SRP_CREDENTIALS_USER_NAME, srpUserName);
        }
        if (srpPassword != null) {
            map.put(ClientParameterCode.SRP_CREDENTIALS_PASSWORD, srpPassword);
        }
        if (this.m_srpCredentials != null && isSRPCredChange) {
            midFutures.add(this.m_srpCredentials.changeElement(map));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public boolean isMyIdentity(String identityName) throws RemoteException {
        String name = this.getName();
        if (name == null) {
            theLogger.error(SrLogCategories.ILLEGAL_STATE, "The wwui name of the iSCSI initiator is null. This may point to a DB corruption in object ", this);
            return false;
        }
        return name.equals(identityName);
    }

    private String getInitiatorCommKeyFromIdentityAlias(String identityAlias) {
        StringBuffer sb = new StringBuffer();
        String commKeySuffix = identityAlias.substring(identityAlias.indexOf("_") + 1);
        StringTokenizer st = new StringTokenizer(commKeySuffix, "_");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(".");
        }
        String returnStr = sb.toString().substring(0, sb.toString().length() - 1);
        return returnStr;
    }

    public void addRemoteTarget(ISCSIRemoteTarget remoteTarget) {
        this.m_remoteTargets.add(remoteTarget);
    }

    public void removeRemoteTarget(ISCSIRemoteTarget remoteTarget) {
        this.m_remoteTargets.remove(remoteTarget);
    }

    public void clearAllRemoteTargets() {
        this.m_remoteTargets.clear();
    }

    public void addRemoteDiscoveryPortal(ISCSIRemotePortalDiscovery remoteDiscoveryPortal) {
        this.m_remoteDiscoveryPortals.add(remoteDiscoveryPortal);
    }

    public void removeRemoteDiscoveryPortal(ISCSIRemotePortalDiscovery remoteDiscoveryPortal) {
        this.m_remoteDiscoveryPortals.remove(remoteDiscoveryPortal);
    }

    public void clearAllRemoteDiscoveryPortals() {
        this.m_remoteDiscoveryPortals.clear();
    }

    public ISCSIRemotePortalDiscoveryImpl getRemoteDiscoveryPortal(String ip, int port) throws RemoteException {
        for (int index = 0; index < this.m_remoteDiscoveryPortals.size(); ++index) {
            ISCSIRemotePortalDiscoveryImpl portal = (ISCSIRemotePortalDiscoveryImpl)this.m_remoteDiscoveryPortals.get(index);
            if (!portal.isEqual(ip, port)) continue;
            return portal;
        }
        return null;
    }

    public boolean isRemoteDiscoveryPortalExisted(String ip, int port) throws RemoteException {
        return this.getRemoteDiscoveryPortal(ip, port) != null;
    }

    public SrFuture<Void> createRemoteDiscoveryPortal(String ipAddress, Integer port) throws RemoteException, IllegalValueException {
        return this.createRemoteDiscoveryPortal(ipAddress, port, null);
    }

    public SrFuture<Void> createRemoteDiscoveryPortal(String ipAddress, Integer port, Integer period) throws RemoteException, IllegalValueException {
        ISCSIRemoteDiscoveryPortalValidator validator = new ISCSIRemoteDiscoveryPortalValidator(this, ipAddress, port);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL);
        SrType[] vswitchesToSet = new CommKeyClassId[]{this.getActiveVswitch().getCommKeyClassId()};
        element.setValues(ParameterCode.VSWITCH_ID, vswitchesToSet);
        element.setValue(ParameterCode.SCSI_INITIATOR_ID, this.getSCSIDeviceId());
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, new SrIpAddress(ipAddress));
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_PORT, new SrInteger((int)port));
        if (period != null) {
            element.setValue(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, new SrInteger((int)period));
        }
        return this.getCluster().createElement(element, ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, ipAddress + " : " + String.valueOf(port));
    }

    public boolean isRemoteDiscoveryPortalExistedAsISNSServer(String ip) throws RemoteException {
        ClusterImpl parentCluster = this.getCluster();
        return parentCluster.isIPExistedAsISNSServer(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsRadiusServer(String ip) throws RemoteException {
        ClusterImpl parentCluster = this.getCluster();
        return parentCluster.isIPExistedAsRadiusServer(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsLocalIP(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsLocalIP(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsRoutIP(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsRoutIP(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsLocalPortal(String ip, int port) throws RemoteException {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsLocalPortal(ip, port);
    }

    public boolean isRemoteDiscoveryPortalExistedAsSNMPManager(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsSNMPManager(ip);
    }

    public boolean isRemoteDiscoveryPortalExistedAsNeighbor(String ip) throws RemoteException {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        return parentVSwitch.isIPExistedAsNeighbor(ip);
    }

    public void addSession(ISCSISession session) {
        this.m_sessions.add(session);
    }

    public void removeSession(ISCSISession session) {
        this.m_sessions.remove(session);
    }

    public void clearAllSessions() {
        this.m_sessions.clear();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INITIATOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_INITIATOR_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_DEVICE_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

