/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.SRPCredentials;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SRPCredentialsImpl
extends CredentialsImpl
implements SRPCredentials {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public SRPCredentialsImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected void initUserNameParameterCode() {
        this.userNameParameterCode = ParameterCode.SRP_CREDENTIALS_USER_NAME;
    }

    @Override
    public String getPassword() throws RemoteException {
        return (String)this.getValueOf(null, ParameterCode.SRP_CREDENTIALS_PASSWORD, true);
    }

    @Override
    public String getPassword(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.SRP_CREDENTIALS_PASSWORD, vSwitch == null);
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        ErrorAssertingListener.listenTo(this.getIdentityParent().createSRPCredentials(this.getUserName(), this.getPassword(), this.cluster.getOtherVSwitches(this.getVSwitches())));
        return 2;
    }

    @Override
    protected void synchronizeMe(HashMap parameterList) throws IllegalValueException {
        String userName = this.getUserName();
        Object userNameParam = parameterList.get(ClientParameterCode.SRP_CREDENTIALS_USER_NAME);
        if (userNameParam != null) {
            userName = (String)((SrString)userNameParam).value();
        }
        String password = null;
        Object passwordParam = parameterList.get(ClientParameterCode.SRP_CREDENTIALS_PASSWORD);
        if (passwordParam != null) {
            password = (String)((SrString)passwordParam).value();
        }
        ErrorAssertingListener.listenTo(this.getIdentityParent().createSRPCredentials(userName, password, this.cluster.getOtherVSwitches(this.getVSwitches())));
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String result = super.isValid(parameterList);
        if (result == null) {
            String userName = (String)parameterList.get(ClientParameterCode.SRP_CREDENTIALS_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.SRP_CREDENTIALS_PASSWORD);
            IdentityImpl chapCredParentIdentity = this.getIdentityParent();
            CredentialsValidator srpCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = srpCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.SRP_CREDENTIALS_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = srpCredValidator.isPasswordValid(password);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.SRP_CREDENTIALS_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return ClassID.SRP_CREDENTIALS + " " + this.getUserName();
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.SRP_CREDENTIALS_PASSWORD);
        params.add(ParameterCode.SRP_CREDENTIALS_USER_NAME);
        params.add(ParameterCode.CREDENTIALS_PARENT);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SRP_CREDENTIALS_USER_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SRP_CREDENTIALS_PASSWORD, new ParameterCode.Flags(false, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

