/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import java.rmi.RemoteException;

public class IdentityNameValidator
extends LogicObjectValidator {
    private Identity identity;
    private String name;

    public IdentityNameValidator(Identity identity, String name) {
        this.identity = identity;
        this.name = name;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (this.identity.getAlias().equals("DEF_ALL")) {
            this.setErrorMsg("Cannot execute changes to the Identity DEF_ALL");
            return false;
        }
        if (((IdentityImpl)this.identity).isNameExist(this.name) != null) {
            this.setErrorMsg("Identity Name " + this.name + " is already existed. Please specify another one");
            return false;
        }
        return true;
    }
}

