/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.identity.IdentityAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.identity.IdentityNameValidator;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class IdentityImpl
extends SynchronizeableImpl
implements Identity {
    public static final String DEF_ALL_IDENTITY_ALIAS_PREFIX = "DEF_ALL";
    public static final String INITIATOR_IDENTITY_ALIAS_PREFIX = "SELF";
    public static final String REMOTE_TARGET_IDENTITY_ALIAS_PREFIX = "REMOTE_TARGET";
    public static final String DR_REMOTE_INITIATOR_IDENTITY_ALIAS_PREFIX = "RemoteInitiator";
    public static final String DR_IDENTITY_ALL_ALIAS = "DR_IDENTITY_ALL";
    private static SrLogger theLogger = SrLogger.getLogger();
    private Vector<IdentityNameImpl> myIdentityNames = new Vector();
    private Vector<CredentialsImpl> myCredentials = new Vector();
    private String alias;
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public IdentityImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.alias = this.getAlias(null);
        return changedValues;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String toString() {
        return this.getAlias();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_ALIAS, vSwitch == null);
    }

    @Override
    public String getDescription() throws RemoteException {
        return this.getDescription(null);
    }

    public String getDescription(VSwitchImpl vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_DESCRIPTION, vSwitch == null);
    }

    @Override
    public IdentityPurposeConstant getPurpose() {
        return this.getPurpose(null);
    }

    public IdentityPurposeConstant getPurpose(VSwitchImpl vSwitch) {
        IdentityPurposeConstant purpose = (IdentityPurposeConstant)this.getSrValueOf(vSwitch, ParameterCode.IDENTITY_PURPOSE, vSwitch == null);
        if (purpose == null) {
            purpose = IdentityPurposeConstant.UNKNOWN;
        }
        return purpose;
    }

    public boolean isDefAll() {
        return this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX);
    }

    public boolean isPurposeUnknown() {
        return this.getPurpose().equals(IdentityPurposeConstant.UNKNOWN);
    }

    public boolean isOfLocalInitiator() {
        return this.getPurpose().equals(IdentityPurposeConstant.LOCAL_INITIATOR);
    }

    public boolean isOfLocalTarget() {
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        if (connectedVswitches.length == 1) {
            return this.isOfLocalTarget(connectedVswitches[0]);
        }
        VSwitchImpl vswitch1 = connectedVswitches[0];
        VSwitchImpl vswitch2 = connectedVswitches[1];
        return this.isOfLocalTarget(vswitch1) || this.isOfLocalTarget(vswitch2);
    }

    public boolean isOfLocalTarget(VSwitchImpl vSwitch) {
        return this.getPurpose(vSwitch).equals(IdentityPurposeConstant.LOCAL_TARGET);
    }

    public boolean isOfRemoteInitiator() {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_INITIATOR);
    }

    public boolean isOfRemoteTarget() {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_TARGET);
    }

    public boolean isOfRemoteInitiatorDR() {
        return this.getPurpose().equals(IdentityPurposeConstant.REMOTE_INITIATOR_DR);
    }

    public boolean isDRIdentityAll() {
        return this.getAlias().equals(DR_IDENTITY_ALL_ALIAS);
    }

    public Vector<IdentityNameImpl> getIdentityNames() throws RemoteException {
        return new Vector<IdentityNameImpl>(this.myIdentityNames);
    }

    private Vector<String> getIdentityNamesStr() throws RemoteException {
        Vector<String> names = new Vector<String>(this.myIdentityNames.size());
        for (int index = 0; index < this.myIdentityNames.size(); ++index) {
            names.add(this.myIdentityNames.elementAt(index).getName());
        }
        return names;
    }

    public void addName(IdentityNameImpl name) throws RemoteException {
        this.myIdentityNames.addElement(name);
    }

    public void removeName(IdentityName name) throws RemoteException {
        if (!this.isOfLocalInitiator()) {
            this.myIdentityNames.remove(name);
        }
    }

    public void removeAllCredentials() {
        for (CredentialsImpl credentialsImpl : this.myCredentials) {
            this.removeCredentialsFromLocalTarget(credentialsImpl);
        }
        this.myCredentials.clear();
    }

    public void removeAllNames() {
        this.myIdentityNames.clear();
    }

    public void addCredentials(CredentialsImpl cred) {
        this.myCredentials.addElement(cred);
    }

    private void removeCredentialsFromLocalTarget(CredentialsImpl cred) {
        ISCSITargetImpl localTarget;
        IdentityImpl identity = cred.getIdentityParent();
        if (identity.isOfLocalTarget() && (localTarget = this.getCluster().getTargetListMgr().getTargetByAlias(identity.getAlias())) != null) {
            localTarget.setCredentials(null);
        }
    }

    public void removeCredentials(CredentialsImpl cred) {
        this.removeCredentialsFromLocalTarget(cred);
        this.myCredentials.remove(cred);
    }

    public IdentityNameImpl isNameExist(String name) throws RemoteException {
        for (IdentityNameImpl identityName : this.myIdentityNames) {
            String value = identityName.getName();
            if (!value.equals(name)) continue;
            return identityName;
        }
        return null;
    }

    public IdentityName getIdentityName(String name) throws RemoteException {
        for (IdentityName identityName : this.myIdentityNames) {
            String value = identityName.getName();
            if (!value.equals(name)) continue;
            return identityName;
        }
        return null;
    }

    public CredentialsImpl isCredentialsExist(ClassID classId, String userName) {
        for (CredentialsImpl credentials : this.myCredentials) {
            String value;
            if (!credentials.getClassId().equals(classId) || !(value = credentials.getUserName()).equals(userName)) continue;
            return credentials;
        }
        return null;
    }

    public CredentialsImpl isCredentialExist(ClassID classId, String userName) throws RemoteException {
        for (CredentialsImpl credentials : this.myCredentials) {
            if (!credentials.getClassId().equals(classId)) continue;
            String user = credentials.getUserName();
            if (user == null) {
                user = "";
            }
            if (!userName.equals(user)) continue;
            return credentials;
        }
        return null;
    }

    public Vector<CredentialsImpl> getCredentials() throws RemoteException {
        return this.myCredentials;
    }

    public Vector<CredentialsImpl> getCredentials(ClassID classId) throws RemoteException {
        Vector<CredentialsImpl> returnCredentials = new Vector<CredentialsImpl>();
        for (CredentialsImpl credentials : this.myCredentials) {
            if (!credentials.getClassId().equals(classId)) continue;
            returnCredentials.add(credentials);
        }
        return returnCredentials;
    }

    public Vector<CredentialsImpl> getCHAPCredentials() throws RemoteException {
        return this.getCredentials(ClassID.CHAP_CREDENTIALS);
    }

    public Vector<CredentialsImpl> getSRPCredentials() throws RemoteException {
        return this.getCredentials(ClassID.SRP_CREDENTIALS);
    }

    @Override
    public SrFuture<Void> createIdentityName(String name) throws RemoteException, IllegalValueException {
        return this.createIdentityName(name, new Vector<VSwitchImpl>(Arrays.asList(this.getConnectedVSwitches())));
    }

    private void removeAlreadyKnownNames(ArrayList names) throws RemoteException {
        for (int index = 0; index < this.getIdentityNamesStr().size(); ++index) {
            String name = this.getIdentityNamesStr().get(index);
            if (!names.contains(name)) continue;
            names.remove(name);
        }
    }

    public SrFuture<Void> createUnknownIdentityNames(ArrayList names, Vector vSwitches) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("IdentityImpl.createUnknownIdentityNames");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        this.removeAlreadyKnownNames(names);
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            midFutures.add(this.createIdentityName(name, vSwitches));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> createIdentityName(String name, List<VSwitchImpl> vSwitches) throws RemoteException, IllegalValueException {
        IdentityNameValidator identityNameValidator = new IdentityNameValidator(this, name);
        if (identityNameValidator.isValid()) {
            return this.synchronizeIdentityName(name, vSwitches);
        }
        throw new IllegalValueException(identityNameValidator.getErrorMsg());
    }

    public SrFuture<Void> synchronizeIdentityName(String name, List<VSwitchImpl> vSwitches) throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.IDENTITY_NAME);
        Parameter identName = new Parameter(ParameterCode.IDENTITY_NAME_VALUE, new SrString(name));
        element.addParameter(identName);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.IDENTITY_NAME_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        if (vSwitches == null) {
            vSwitches = this.getVSwitches();
        }
        return this.cluster.createElement(element, ClassID.IDENTITY_NAME, name, vSwitches);
    }

    @Override
    public SrFuture<Void> createSRPCredentials(String userName, String password) throws RemoteException, IllegalValueException {
        CredentialsValidator credentialsValidator = new CredentialsValidator(this, ClassID.SRP_CREDENTIALS, userName, password, false);
        if (!credentialsValidator.isValid()) {
            throw new IllegalValueException(credentialsValidator.getErrorMsg());
        }
        return this.createSRPCredentials(userName, password, null);
    }

    public SrFuture<Void> createSRPCredentials(String userName, String password, List<VSwitchImpl> vSwitches) throws IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.SRP_CREDENTIALS);
        Parameter user = new Parameter(ParameterCode.SRP_CREDENTIALS_USER_NAME, new SrString(userName));
        element.addParameter(user);
        Parameter pswd = new Parameter(ParameterCode.SRP_CREDENTIALS_PASSWORD, new SrString(password));
        element.addParameter(pswd);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.CREDENTIALS_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        return this.cluster.createElement(element, ClassID.SRP_CREDENTIALS, userName, vSwitches);
    }

    @Override
    public SrFuture<Void> createCHAPCredentials(String userName, String password, boolean isRadiusEnabled) throws RemoteException, IllegalValueException {
        CredentialsValidator credentialsValidator = new CredentialsValidator(this, ClassID.CHAP_CREDENTIALS, userName, password, isRadiusEnabled);
        if (!credentialsValidator.isValid()) {
            throw new IllegalValueException(credentialsValidator.getErrorMsg());
        }
        return this.createCHAPCredentials(userName, password, isRadiusEnabled, null);
    }

    public SrFuture<Void> createCHAPCredentials(String userName, String password, boolean isRadiusEnabled, List<VSwitchImpl> vSwitches) throws IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.CHAP_CREDENTIALS);
        if (userName != null && !userName.equals("")) {
            Parameter user = new Parameter(ParameterCode.CHAP_CREDENTIALS_USER_NAME, new SrString(userName));
            element.addParameter(user);
        }
        if (password != null && !password.equals("")) {
            Parameter pswd = new Parameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD, new SrString(password));
            element.addParameter(pswd);
        }
        int radiusEn = 1;
        if (isRadiusEnabled) {
            radiusEn = 2;
            element.removeParameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD);
        }
        Parameter radius = new Parameter(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new SrInteger(radiusEn));
        element.addParameter(radius);
        CommKeyClassId identCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter identOwner = new Parameter(ParameterCode.CREDENTIALS_PARENT, identCommKeyClassId);
        element.addParameter(identOwner);
        return this.cluster.createElement(element, ClassID.CHAP_CREDENTIALS, userName, vSwitches);
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        HashMap<ParameterCode, String[]> inconsistentValues = super.checkConsistencyBetweenVSwitches();
        if (inconsistentValues == null) {
            inconsistentValues = new HashMap<ParameterCode, String[]>();
        }
        List<VSwitchImpl> vswitches = this.getVSwitches();
        int vswitchesCount = vswitches.size();
        String[] userNames = new String[vswitchesCount];
        Enumeration<CredentialsImpl> e = this.myCredentials.elements();
        while (e.hasMoreElements()) {
            CredentialsImpl cred = e.nextElement();
            if (cred.isRedundant()) continue;
            for (int i = 0; i < vswitchesCount; ++i) {
                userNames[i] = cred.getUserName(vswitches.get(i));
            }
            inconsistentValues.put(cred.getUserNameParameterCode(), userNames);
        }
        String[] names = new String[vswitchesCount];
        Enumeration<IdentityNameImpl> e2 = this.myIdentityNames.elements();
        while (e2.hasMoreElements()) {
            IdentityNameImpl name = e2.nextElement();
            if (name.isRedundant()) continue;
            for (int i = 0; i < vswitchesCount; ++i) {
                names[i] = name.getName(vswitches.get(i));
            }
            inconsistentValues.put(ParameterCode.IDENTITY_NAME_VALUE, names);
        }
        return inconsistentValues;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        return super.synchronize();
    }

    @Override
    public boolean isNeedToSynchronize() throws RemoteException {
        if (this.isOfLocalInitiator() || this.isOfRemoteTarget() || this.isOfLocalTarget() && this.getDescription().equals("#forTarget#")) {
            return false;
        }
        boolean needSync = super.isNeedToSynchronize();
        boolean isNamesNeedSync = false;
        boolean isCredNeedSync = false;
        Enumeration<IdentityNameImpl> e = this.myIdentityNames.elements();
        while (e.hasMoreElements()) {
            IdentityName name = e.nextElement();
            if (this.cluster.getVSwitches().size() <= name.getConnectedVSwitchCounter()) continue;
            isNamesNeedSync = true;
            break;
        }
        Enumeration<CredentialsImpl> enumeration = this.myCredentials.elements();
        while (enumeration.hasMoreElements()) {
            Credentials cred = enumeration.nextElement();
            if (cred instanceof CHAPCredentials && ((CHAPCredentials)cred).isRadiusEnabled()) {
                if (this.cluster.getVSwitches().size() <= cred.getConnectedVSwitchCounter()) continue;
                isCredNeedSync = true;
                break;
            }
            isCredNeedSync = false;
            break;
        }
        return needSync || isNamesNeedSync || isCredNeedSync;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            if (!(this.isOfLocalTarget() && this.getDescription().equals("#forTarget#") || this.isOfRemoteTarget() || this.isOfLocalInitiator() || this.isInSynchronizingMode())) {
                theLogger.trace(SrLogCategories.LEGACY, "Synchronizing: creating Identity on other ", VSwitchImpl.VSWITCH_DISPLAY_STRING, ".");
                ErrorAssertingListener.listenTo(this.cluster.createIdentity(this.getAlias(), this.getDescription(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getPurpose()));
                this.setSynchronizingMode(true);
                return 2;
            }
            return 0;
        }
        return this.synchronizeNamesAndCredentials();
    }

    private int synchronizeNamesAndCredentials() throws RemoteException, IllegalValueException {
        boolean syncWasSent = false;
        Enumeration<SynchronizeableImpl> e = this.myIdentityNames.elements();
        while (e.hasMoreElements()) {
            IdentityNameImpl identityName = e.nextElement();
            if (identityName.isRedundant()) continue;
            theLogger.trace(SrLogCategories.LEGACY, "Synchronizing: creating Identity Name on other ", VSwitchImpl.VSWITCH_DISPLAY_STRING, ".");
            identityName.synchronize();
            syncWasSent = true;
        }
        e = this.myCredentials.elements();
        while (e.hasMoreElements()) {
            CredentialsImpl cred = (CredentialsImpl)e.nextElement();
            if (cred.isRedundant() || !(cred instanceof CHAPCredentials)) continue;
            boolean shouldSynchronize = true;
            if (cred instanceof CHAPCredentials) {
                List<VSwitchImpl> vSwitches = this.cluster.getOtherVSwitches(cred.getVSwitches());
                boolean isRadiusExist = this.cluster.getRadiusServersList().isServerExistOnVSwitches(vSwitches);
                boolean bl = shouldSynchronize = isRadiusExist && ((CHAPCredentials)((Object)cred)).isRadiusEnabled();
            }
            if (shouldSynchronize) {
                theLogger.trace(SrLogCategories.LEGACY, "Synchronizing: creating Identity Credentials on other ", VSwitchImpl.VSWITCH_DISPLAY_STRING, ".");
                cred.synchronize();
                syncWasSent = true;
                continue;
            }
            theLogger.info(SrLogCategories.LEGACY, "Cannot Synchronize CHAP Credentials (Radius Server is missing or not enabled.");
        }
        return syncWasSent ? 2 : 0;
    }

    @Override
    public void doneSynchronizing() throws RemoteException {
        try {
            this.synchronizeNamesAndCredentials();
            super.doneSynchronizing();
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizingMode(false);
                Vector<ISCSITargetImpl> targets = this.getCluster().getStorage().getTargetList();
                int targetsListSize = targets.size();
                for (int i = 0; i < targetsListSize; ++i) {
                    ISCSITargetImpl currTarget = targets.get(i);
                    AclImpl currTargetACL = currTarget.getAclForTarget();
                    if (!currTargetACL.isNeedToSynchronize()) continue;
                    currTargetACL.synchronizeMe();
                }
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, "Could not synchronize Name/Credentials for identity - ", this.getAlias(), " ", ive);
        }
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String description;
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage();
        }
        String alias = (String)parameterList.get(ClientParameterCode.IDENTITY_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (this.cluster.getIdentitiesList().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.IDENTITY_ALIAS, new SrString(alias));
        }
        if ((description = (String)parameterList.get(ClientParameterCode.IDENTITY_DESCRIPTION)) != null) {
            parameterList.put(ClientParameterCode.IDENTITY_DESCRIPTION, new SrString(description));
        }
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return IdentityAlarmGenerator.getInstance();
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    protected String canBeDeleted() {
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return "You cannot delete the Identity 'DEF_ALL'";
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        if (this.getAlias().equals(DEF_ALL_IDENTITY_ALIAS_PREFIX)) {
            return true;
        }
        return super.isRedundant();
    }

    public boolean isRADIUSServerInUse(RadiusServerImpl radSrv) {
        Enumeration<CredentialsImpl> e = this.myCredentials.elements();
        while (e.hasMoreElements()) {
            CredentialsImpl credentials = e.nextElement();
            if (!(credentials instanceof CHAPCredentialsImpl) || !((CHAPCredentialsImpl)credentials).isRadiusEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean areNamesEqual(ArrayList names) throws RemoteException {
        if (names.size() != this.getIdentityNames().size()) {
            return false;
        }
        Vector<String> identityNamesStr = this.getIdentityNamesStr();
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            if (identityNamesStr.contains(name)) continue;
            return false;
        }
        return true;
    }

    public boolean atLeastOneNameIncluded(ArrayList names) throws RemoteException {
        Vector<String> identityNamesStr = this.getIdentityNamesStr();
        for (int index = 0; index < names.size(); ++index) {
            String name = (String)names.get(index);
            if (!identityNamesStr.contains(name)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> deleteNames(ArrayList namesToDelete) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("IdentityImpl.deleteNames");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int index = 0; index < namesToDelete.size(); ++index) {
            String name = (String)namesToDelete.get(index);
            IdentityName nameElement = this.getIdentityName(name);
            if (nameElement == null) continue;
            midFutures.add(nameElement.deleteElement());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.IDENTITY_ALIAS);
        params.add(ParameterCode.IDENTITY_DESCRIPTION);
        return params;
    }

    @Override
    protected ArrayList<RadiusServerImpl> getAdditionalDependantObjectsForSynchronization() throws RemoteException {
        ArrayList list = super.getAdditionalDependantObjectsForSynchronization();
        list.addAll(this.myIdentityNames);
        list.addAll(this.myCredentials);
        list.addAll(this.getAllRadiusServer());
        return list;
    }

    private ArrayList<RadiusServerImpl> getAllRadiusServer() throws RemoteException {
        Vector<ExternalServerImpl> radius = this.getCluster().getAllRadiusServers();
        ArrayList<RadiusServerImpl> identityRadius = new ArrayList<RadiusServerImpl>();
        for (RadiusServerImpl radiusServerImpl : radius) {
            if (!this.isRADIUSServerInUse(radiusServerImpl)) continue;
            identityRadius.add(radiusServerImpl);
        }
        return identityRadius;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_DESCRIPTION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_PURPOSE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_DEVICE_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

