/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;

public class CredentialsValidator
extends LogicObjectValidator {
    protected IdentityImpl myIdentity;
    protected String userName;
    protected String password;
    protected ClassID classId;
    protected boolean radius;

    public CredentialsValidator(IdentityImpl identity, ClassID classId, String userName, String password, boolean radius) {
        this.myIdentity = identity;
        this.userName = userName;
        this.password = password;
        this.classId = classId;
        this.radius = radius;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (this.myIdentity.getAlias().equals("DEF_ALL")) {
            this.setErrorMsg("Cannot execute changes to the Identity DEF_ALL");
            return false;
        }
        if (this.userName == null) {
            this.setErrorMsg("User Name cannot be NULL");
            return false;
        }
        boolean isEmptyUserName = this.userName.equals("");
        if (this.radius) {
            if (isEmptyUserName) {
                if (this.isAlreadyExistEmptyUserName()) {
                    this.setErrorMsg(ErrorMessage.CREDENTIALS_ALREADY_EXIST.getMessage(this.userName));
                    return false;
                }
            } else if (!isEmptyUserName && this.isUserNameExist()) {
                this.setErrorMsg(ErrorMessage.NAME_ALREADY_IN_USE.getMessage(this.userName));
                return false;
            }
            return true;
        }
        String msg = this.isUserNameValid(this.userName);
        if (msg != null) {
            this.setErrorMsg(msg);
            return false;
        }
        boolean isEmptyPassword = this.password.equals("");
        if (isEmptyPassword) {
            this.setErrorMsg("Password cannot be empty");
            return false;
        }
        msg = this.isPasswordValid(this.password);
        if (msg != null) {
            this.setErrorMsg(msg);
            return false;
        }
        return true;
    }

    private boolean isAlreadyExistEmptyUserName() throws RemoteException {
        for (CredentialsImpl cred : this.myIdentity.getCredentials()) {
            CHAPCredentialsImpl chap;
            if (!cred.getClassId().equals(ClassID.CHAP_CREDENTIALS) || !(chap = (CHAPCredentialsImpl)cred).isRadiusEnabled() || !chap.getUserName().equals("")) continue;
            return true;
        }
        return false;
    }

    private boolean isUserNameExist() {
        CredentialsImpl cred = this.myIdentity.isCredentialsExist(this.classId, this.userName);
        return cred != null;
    }

    public String isUserNameValid(String userName) {
        boolean isEmptyUserName = userName.equals("");
        if (isEmptyUserName) {
            return "User Name cannot be empty";
        }
        if (this.isUserNameExist()) {
            return ErrorMessage.NAME_ALREADY_IN_USE.getMessage(userName);
        }
        int len = userName.length();
        if (len < CredentialsImpl.MIN_USER_NAME_LENGTH || len > CredentialsImpl.MAX_USER_NAME_LENGTH) {
            StringBuffer sb = new StringBuffer();
            sb.append("Username should contain ");
            sb.append(CredentialsImpl.MIN_USER_NAME_LENGTH);
            sb.append("-");
            sb.append(CredentialsImpl.MAX_USER_NAME_LENGTH);
            sb.append(" characters");
            return sb.toString();
        }
        return null;
    }

    public String isPasswordValid(String password) {
        int len;
        boolean isEmptyPassword;
        boolean bl = isEmptyPassword = password == null || password.equals("");
        if (!(isEmptyPassword || (len = password.length()) >= CredentialsImpl.MIN_PASSWORD_LENGTH && len <= CredentialsImpl.MAX_PASSWORD_LENGTH)) {
            StringBuffer sb = new StringBuffer();
            sb.append("Password should contain ");
            sb.append(CredentialsImpl.MIN_PASSWORD_LENGTH);
            sb.append("-");
            sb.append(CredentialsImpl.MAX_PASSWORD_LENGTH);
            sb.append(" characters");
            return sb.toString();
        }
        return null;
    }
}

