/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CredentialsImpl
extends SynchronizeableImpl
implements Credentials {
    public static final int MIN_USER_NAME_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_USER_NAME_LENGTH));
    public static final int MAX_USER_NAME_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_USER_NAME_LENGTH));
    public static final int MIN_PASSWORD_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_PASSWORD_LENGTH));
    public static final int MAX_PASSWORD_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_PASSWORD_LENGTH));
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private IdentityImpl identityParent;
    protected ParameterCode userNameParameterCode;
    protected String password;
    private SynchronizeableImpl m_iscsiDevice;

    protected CredentialsImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.initUserNameParameterCode();
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        boolean isLocalInitiatorIdentity = this.identityParent.getAlias().startsWith("SELF");
        if (!this.isRedundant() && !isLocalInitiatorIdentity) {
            this.synchronizeMe(parameterList);
        }
        return super.changeElement(parameterList);
    }

    protected abstract void initUserNameParameterCode();

    protected ParameterCode getUserNameParameterCode() {
        return this.userNameParameterCode;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.identityParent = this.getIdentityParent(this.getFirstVSwitch());
        this.password = this.getPassword(null);
        return changedValues;
    }

    public abstract String getPassword(VSwitch var1) throws RemoteException;

    @Override
    public String getUserName() {
        return this.getUserName(null);
    }

    public String getUserName(VSwitchImpl vSwitch) {
        String userName = (String)this.getValueOf(vSwitch, this.userNameParameterCode, vSwitch == null);
        return userName == null ? "" : userName;
    }

    @Override
    public IdentityImpl getIdentityParent() {
        return this.identityParent;
    }

    public IdentityImpl getIdentityParent(VSwitchImpl vSwitch) {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.CREDENTIALS_PARENT, vSwitch == null);
        IdentityImpl identity = (IdentityImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    public abstract String getPassword() throws RemoteException;

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Checking synchronizing for ", this.getClassId(), " ", this.toString());
        this.setSynchronizePending(true);
        if (!this.isRedundant()) {
            theLogger.trace(SrLogCategories.LEGACY, "Begin synchronizing for ", this.getClassId(), " ", this.toString());
            return this.synchronizeMe();
        }
        return 0;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public String getAlias() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    protected abstract void synchronizeMe(HashMap var1) throws IllegalValueException;

    public void setISCSIDevice(SynchronizeableImpl device) {
        this.m_iscsiDevice = device;
    }

    public SynchronizeableImpl getISCSIDevice() {
        return this.m_iscsiDevice;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.CREDENTIALS_PARENT, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

