/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRSyncPairAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterSyncPairAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRActivateImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.dr.InnerActivate;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class DRSyncPairImpl
extends DRPairImpl
implements DRSyncPair,
DRActivate {
    private DRSyncPairActivateImpl m_activateSyncPair;

    public DRSyncPairImpl(DRClusterSyncPairImpl element) throws RemoteException {
        super(element);
        if (this.m_activateSyncPair == null) {
            this.m_activateSyncPair = new DRSyncPairActivateImpl(element);
        }
    }

    @Override
    public void setElement(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        super.setElement(element, role);
        if (this.m_activateSyncPair == null) {
            this.m_activateSyncPair = new DRSyncPairActivateImpl(element);
        } else {
            this.m_activateSyncPair.setElement(element, role);
        }
    }

    @Override
    public void removeElement(DRClusterLogicObjectImpl pair) {
        super.removeElement(pair);
        this.m_activateSyncPair.removeElement(pair);
    }

    @Override
    public SrFuture<Void> plannedFailover() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.plannedFailover();
    }

    @Override
    public SrFuture<Void> disasterOccured() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.disasterOccured();
    }

    @Override
    public SrFuture<Void> fallback() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.fallback();
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return DRSyncPairAlarmGenerator.getInstance();
    }

    @Override
    public SrFuture<Void> startReplicate() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.startReplicate();
    }

    @Override
    public SrFuture<Void> abortReplicate() throws RemoteException, IllegalValueException {
        return this.m_activateSyncPair.abortReplicate();
    }

    protected ParameterCode getActivateParameterCode() throws IllegalValueException {
        return this.m_activateSyncPair.getLocalElement().getActivateParameterCode();
    }

    protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
    }

    @Override
    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterSyncPairAlarmGenerator.getInstance();
    }

    @Override
    public SrFuture<Void> recover(CommKeyClassId volume) throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(ClassID.SYNC_PAIR);
        DRRoleConstant role = this.getRoleOfElementToBeRecovered();
        ced.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, role);
        return super.recover(ced, volume);
    }

    @Override
    public SrFuture<Void> abortInitialSync() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRSyncPairImpl.abortInitialSync");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        midFutures.add(this.validAndActivate(DRActivateConstant.SUSPEND_INIT_SYNC));
        midFutures.add(((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter(this.getParameterCode(MasterParameterCode.DR_ACTIVATE), DRActivateConstant.SUSPEND_INIT_SYNC)));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> startInitialSync() throws RemoteException, IllegalValueException {
        this.validAndActivate(DRActivateConstant.RESUME_INIT_SYNC);
        MasterParameter parameter = new MasterParameter(this.getParameterCode(MasterParameterCode.DR_ACTIVATE), DRActivateConstant.RESUME_INIT_SYNC);
        return ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(parameter);
    }

    @Override
    protected boolean isSnapshotNeeded(DRActivateConstant state) {
        return false;
    }

    protected class DRSyncPairActivateImpl
    extends DRActivateImpl
    implements InnerActivate {
        protected DRSyncPairActivateImpl(DRClusterLogicObject element) throws RemoteException {
            super((DRClusterLogicObjectImpl)element);
        }

        public void abortInitialSync() throws RemoteException, IllegalValueException {
        }

        public void startInitialSync() throws RemoteException, IllegalValueException {
        }

        protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
        }

        @Override
        public AlarmGenerator getAlarmGenerator() {
            return null;
        }

        @Override
        public AlarmGenerator getClusterAlarmGenerator() {
            return DrClusterSyncPairAlarmGenerator.getInstance();
        }

        @Override
        public void registerToPropagatedStateChange() {
        }

        @Override
        public SrFuture<Void> validAndActivateForChildren(ChangeConstant state) throws IllegalValueException {
            return new CompleteFuture<Void>("DRSyncPairImpl.validAndActivateForChildren");
        }

        @Override
        public DRSyncPair returnSource() throws RemoteException {
            return DRSyncPairImpl.this;
        }

        @Override
        protected void checkThatChildAndFatherAreMached() throws IllegalValueException {
            if (!((DRClusterPairImpl)this.getActiveElement()).getExposedVolume().getActiveVswitch().equals(this.getActiveVswitch())) {
                throw new IllegalValueException("Pair is not synchronized in the cluster, please perform cluster synchronization.");
            }
        }
    }
}

