/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DRPiTImpl
extends TableRowImpl
implements DRPiT {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private DRLogicObject m_drObjectParent;

    public DRPiTImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    DRClusterLogicObjectImpl getClusterObjectParent() throws RemoteException {
        return (DRClusterLogicObjectImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(this.getCommKeyClassIdValueOf(ParameterCode.DR_PIT_PARENT_ID));
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.DR_PIT_PARENT, this.m_drObjectParent);
        params.put(ClientParameterCode.DR_PIT_CLUSTER, this.cluster);
        return params;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        DRPiTStateConstant pitState = (DRPiTStateConstant)aCED.getValue(ParameterCode.DR_PIT_STATE);
        SrTimeTicks prevLastUpdate = (SrTimeTicks)this.getSrValueOf(ParameterCode.DR_PIT_LAST_UPDATE);
        SrGauge prevPendingData = (SrGauge)this.getSrValueOf(ParameterCode.DR_PIT_PENDING_DATA);
        SrGauge pendingData = (SrGauge)aCED.getValue(ParameterCode.DR_PIT_PENDING_DATA);
        if (prevLastUpdate != null && prevPendingData != null && pendingData != null && !DRPiTStateConstant.FORMING.equals(pitState)) {
            SrTimeTicks lastUpdate = (SrTimeTicks)aCED.getValue(ParameterCode.DR_PIT_LAST_UPDATE);
            long transferredData = prevPendingData.longValue() - pendingData.longValue();
            long timePassed = lastUpdate.longValue() - prevLastUpdate.longValue();
            if (timePassed < 30000L && timePassed > 0L) {
                double rate = (double)transferredData / (double)(timePassed / 100L);
                aCED.addParameter(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(rate));
            } else {
                aCED.addParameter(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(-1.0));
            }
        } else {
            aCED.addParameter(ParameterCode.DR_PIT_TRANSFER_RATE, new SrDouble(-1.0));
        }
        return super.changeParameterList(aCED);
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public Long getDateAndTime() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_DATE);
    }

    @Override
    public Long getTotalDataMBytes() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_TOTAL_DATA);
    }

    @Override
    public Long getPendingDataMBytes() throws RemoteException {
        return (Long)this.getValueOf(ParameterCode.DR_PIT_PENDING_DATA);
    }

    @Override
    public DRPiTStateConstant getState() throws RemoteException {
        return (DRPiTStateConstant)this.getValueOf(ParameterCode.DR_PIT_STATE);
    }

    @Override
    public DRLogicObject getDRObjectParent() throws RemoteException {
        return this.m_drObjectParent;
    }

    public void setDRObjectParent(DRLogicObject drLogicObject) {
        this.m_drObjectParent = drLogicObject;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_PARENT_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_DATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_TOTAL_DATA, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_PENDING_DATA, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_LAST_UPDATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_TRANSFER_RATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

