/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRExtendedPairAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterExtendedPairAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRExtendedPair;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRExtendedPairImpl
extends DRAbstractConsistencyGroupImpl
implements DRExtendedPair {
    private DRAsyncPairImpl m_pair = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public DRExtendedPairImpl(DRClusterExtendedPairImpl element) throws RemoteException {
        super(element);
    }

    @Override
    public void addPair(DRAsyncPairImpl newPair) {
        if (this.m_pair == null) {
            this.m_pair = newPair;
        } else if (this.m_pair != newPair) {
            theLogger.warn(SrLogCategories.LEGACY, "attempt to add an Async Pair ", newPair, " different  than the current extended pair ", this.m_pair);
        }
    }

    @Override
    public void removePair(DRAsyncPairImpl pair) {
        if (pair.equals(this.m_pair)) {
            this.m_pair = null;
        }
    }

    @Override
    public boolean hasNoPairs() {
        return this.m_pair == null;
    }

    @Override
    public DRAsyncPair getPair() throws RemoteException {
        return this.m_pair;
    }

    @Override
    public DRAsyncPair[] getPairs() {
        if (this.m_pair != null) {
            return new DRAsyncPair[]{this.m_pair};
        }
        return null;
    }

    @Override
    public int getPendingData() {
        return 0;
    }

    @Override
    public int getPendingPiTs() {
        return 0;
    }

    @Override
    public int getOnlineInitSyncDataTransferred() {
        return 0;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return DRExtendedPairAlarmGenerator.getInstance();
    }

    public SrFuture<Void> startInitialSync() throws RemoteException, IllegalValueException {
        return this.getPair().startInitialSync();
    }

    public SrFuture<Void> abortInitialSync() throws RemoteException, IllegalValueException {
        return this.getPair().abortInitialSync();
    }

    protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
        ((DRClusterLogicObjectImpl)((Object)this.getPair())).validAndActivate(params);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_EXTENDED_PAIR_PAIR, this.getPair());
        return parameterList;
    }

    @Override
    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterExtendedPairAlarmGenerator.getInstance();
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public int getPairsCount() {
        if (this.m_pair == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public String toString() {
        try {
            if (this.getPair() != null) {
                return this.getPair().toString();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return super.toString();
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        if (this.m_pair != null) {
            return this.m_pair.deleteElement();
        }
        return new CompleteFuture<Void>("DRExtendedPairImpl.deleteElement");
    }
}

