/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRConsistencyGroupAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterConsistencyGroupAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralAliasObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class DRConsistencyGroupImpl
extends DRAbstractConsistencyGroupImpl
implements DRConsistencyGroup,
GeneralAliasObject {
    private ArrayList<DRAsyncPairImpl> m_pairs = null;

    public DRConsistencyGroupImpl(DRClusterConsistencyGroupImpl element) throws RemoteException {
        super(element);
    }

    @Override
    public void addPair(DRAsyncPairImpl newPair) throws IllegalValueException {
        if (this.m_pairs == null) {
            this.m_pairs = new ArrayList();
        }
        this.m_pairs.add(newPair);
    }

    @Override
    public void removePair(DRAsyncPairImpl pair) {
        this.m_pairs.remove(pair);
        if (this.m_pairs.size() == 0) {
            this.m_pairs = null;
        }
    }

    @Override
    public DRAsyncPair[] getPairs() {
        if (this.m_pairs == null) {
            return null;
        }
        return this.m_pairs.toArray(new DRAsyncPair[this.m_pairs.size()]);
    }

    @Override
    public boolean hasNoPairs() {
        return this.m_pairs == null;
    }

    @Override
    public int getPendingData() {
        return 0;
    }

    @Override
    public int getPendingPiTs() {
        return 0;
    }

    @Override
    public int getOnlineInitSyncDataTransferred() {
        return 0;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return DRConsistencyGroupAlarmGenerator.getInstance();
    }

    public SrFuture<Void> startInitialSync() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRConsistencyGroupImpl.startInitialSync");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int i = 0; i < this.getPairs().length; ++i) {
            midFutures.add(((DRPairImpl)((Object)this.getPairs()[i])).startInitialSync());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> abortInitialSync() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRConsistencyGroupImpl.abortInitialSync");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int i = 0; i < this.getPairs().length; ++i) {
            midFutures.add(((DRAsyncPairImpl)this.getPairs()[i]).abortInitialSync());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_PAIRS, this.getPairs());
        return parameterList;
    }

    @Override
    public AlarmGenerator getClusterAlarmGenerator() {
        return DrClusterConsistencyGroupAlarmGenerator.getInstance();
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public String getAlias() {
        if (this.getLocalElement() != null) {
            return ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias();
        }
        return ((DRClusterConsistencyGroupImpl)this.getRemoteElement()).getAlias();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        if (this.getLocalElement() != null) {
            return ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias();
        }
        return ((DRClusterConsistencyGroupImpl)this.getRemoteElement()).getAlias();
    }

    @Override
    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        String alias2;
        String alias1;
        String[] string = null;
        if (this.getLocalElement() != null && this.getRemoteElement() != null && !(alias1 = ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias()).equals(alias2 = ((DRClusterConsistencyGroupImpl)this.getLocalElement()).getAlias())) {
            string = new String[]{alias1, alias2};
        }
        return string;
    }

    public CommKey[] getCommKeys() throws RemoteException {
        return null;
    }

    public CommKeyClassId getCommKeyClassId() throws RemoteException {
        return null;
    }

    @Override
    public String toString() {
        return this.getAlias();
    }

    @Override
    public int getPairsCount() {
        if (this.m_pairs == null) {
            return 0;
        }
        return this.m_pairs.size();
    }

    @Override
    protected void checkIfAllPairsAreNonFunctional() throws IllegalValueException {
        DRAsyncPair[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            if (!((DRAsyncPairImpl)pairs[i]).checkNonFunctionalOfVolumes()) continue;
            return;
        }
        throw new IllegalValueException("Can't activate the command since all the pairs are non functional");
    }

    @Override
    protected void checkThatChildAndFatherAreMached() throws IllegalValueException {
    }
}

