/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DRAsyncPairAlarmGenerator;
import com.sanrad.nms.server.alarm.dr.DrClusterAsyncPairAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRExtendedPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRPiTContainer;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DRAsyncPairImpl
extends DRPairImpl
implements DRAsyncPair,
DRPiTContainer {
    private static SrLogger theLogger = SrLogger.getLogger();
    private DRAbstractConsistencyGroupImpl parentGroup;
    private BigInteger m_localCopySize = null;
    private ArrayList m_pits = new ArrayList();

    public DRAsyncPairImpl(DRClusterAsyncPairImpl element, DRRoleConstant role) throws RemoteException, IllegalValueException {
        super(element, role);
    }

    public DRAsyncPairImpl(DRClusterAsyncPairImpl element, DRRoleConstant role, DRAbstractConsistencyGroupImpl groupParent) throws RemoteException {
        super(element, role);
        this.parentGroup = groupParent;
    }

    @Override
    public void setElement(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        VolumeNodeImpl localCopy;
        super.setElement(element, role);
        if (!this.isPartial() && (localCopy = this.findLocalCopyToPair()) != null) {
            this.m_localCopySize = localCopy.getAccessibleSpace();
        }
    }

    public VolumeNodeImpl findLocalCopyToPair() {
        VolumeNodeImpl vol;
        if (this.isPartial()) {
            return null;
        }
        if (DRPairInitialSyncTypeConstant.OFFLINE.equals(this.getInitalSyncType()) && this.getSecondaryVolume().getRemoteVolume() != null && this.getSecondaryVolume().getRemoteVolume().isProvisioned() && (vol = this.getSecondaryVolume().getRemoteVolume().findEquivelentInternalVolume(this.getLocalElement().getCluster())) != null) {
            theLogger.trace(SrLogCategories.LEGACY, "find local copy ", vol);
            return vol;
        }
        return null;
    }

    public void setConsistencyGroup(DRAbstractConsistencyGroupImpl groupParent) {
        this.parentGroup = groupParent;
    }

    @Override
    public DRPiT[] getPiTs() throws RemoteException {
        return this.m_pits.toArray(new DRPiT[this.m_pits.size()]);
    }

    @Override
    public int getPendingData() {
        return 0;
    }

    @Override
    public int getPendingPiTs() {
        return 0;
    }

    @Override
    public int getOnlineInitSyncDataTransferred() {
        return 0;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return DRAsyncPairAlarmGenerator.getInstance();
    }

    protected void validAndActivateForPairs(ParameterList params) throws RemoteException, IllegalValueException {
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        VolumeNodeImpl localCopy;
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_CONSISTENCY_GROUP, this.parentGroup);
        DRClusterAsyncPairImpl local = (DRClusterAsyncPairImpl)this.getLocalElement();
        DRClusterAsyncPairImpl remote = (DRClusterAsyncPairImpl)this.getRemoteElement();
        if (local != null) {
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_JOURNAL_VOLUME, local.getJournal());
            if (local.getSnapshotId() != null) {
                parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME, local.getSnapshot());
            }
        }
        if (remote != null) {
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_JOURNAL_VOLUME, remote.getJournal());
            if (remote.getSnapshotId() != null) {
                parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME, remote.getSnapshot());
            }
        }
        DRClusterAsyncPairImpl activePair = (DRClusterAsyncPairImpl)this.getActiveElement();
        DRClusterAsyncPairImpl inactivePair = (DRClusterAsyncPairImpl)this.getInactiveElement();
        if (activePair != null) {
            Object pendingPits = activePair.getValueOf(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS);
            Object pendingData = activePair.getValueOf(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA);
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_NOT_REPLICATED_PITS, pendingPits);
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_NOT_REPLICATED_DATA, pendingData);
            parameterList.remove(ClientParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
        }
        if (inactivePair != null) {
            Object pits = inactivePair.getValueOf(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS);
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_NOT_MERGED_PITS, pits);
            Object lastMerge = inactivePair.getValueOf(ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE, lastMerge);
        }
        if ((localCopy = this.findLocalCopyToPair()) != null) {
            parameterList.put(ClientParameterCode.DR_ASYNC_PAIR_OFFLINE_LOCAL_COPY, localCopy);
        }
        return parameterList;
    }

    @Override
    public SrFuture<Void> recover(CommKeyClassId volume, CommKeyClassId snapshot, CommKeyClassId journal) throws RemoteException, IllegalValueException {
        if (journal == null) {
            throw new IllegalValueException("pair cannot be recovered since no journal was given");
        }
        DRAbstractConsistencyGroupImpl pairGroup = this.getParentGroup();
        DRRoleConstant role = this.getRoleOfElementToBeRecovered();
        ConfigElementData ced = this.createConfigElementDataForGroup(pairGroup, role, volume);
        ced.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, journal);
        ced.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, snapshot);
        return super.recover(ced, volume);
    }

    @Override
    public void registerToPropagatedStateChange() {
        super.registerToPropagatedStateChange();
        if (this.parentGroup.getClassId().equals(ClassID.EXTENDED_PAIR)) {
            this.addPropagationStateDependentObjectAndListener(this.parentGroup);
        } else {
            this.parentGroup.addPropagationStateDependentObjectAndListener(this);
        }
    }

    @Override
    public AlarmGenerator getClusterAlarmGenerator() throws RemoteException {
        return DrClusterAsyncPairAlarmGenerator.getInstance();
    }

    private ConfigElementData createConfigElementDataForGroup(DRAbstractConsistencyGroupImpl group, DRRoleConstant role, CommKeyClassId volume) throws RemoteException {
        ConfigElementData ced = null;
        if (group.isComplete()) {
            DRClusterAbstractConsistencyGroupImpl recoveredGroup = (DRClusterAbstractConsistencyGroupImpl)group.getElement(role);
            ced = new ConfigElementData(ClassID.ASYNC_PAIR);
            ced.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, recoveredGroup.getCommKeyClassId());
            return ced;
        }
        DRClusterAbstractConsistencyGroupImpl existingGroup = (DRClusterAbstractConsistencyGroupImpl)group.getPartialElement();
        if (group instanceof DRConsistencyGroupImpl) {
            ced = new ConfigElementData(ClassID.CONSISTENCY_GROUP);
            SrString groupAlias = new SrString(((DRClusterConsistencyGroupImpl)existingGroup).getAlias());
            ced.setValue(ParameterCode.DR_VIRT_GROUP_ALIAS, groupAlias);
        } else if (group instanceof DRExtendedPairImpl) {
            ced = new ConfigElementData(ClassID.EXTENDED_PAIR);
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "recovered group class Id ", group.getClassId(), " is not recognized");
            ced = new ConfigElementData(ClassID.ASYNC_PAIR);
            return ced;
        }
        ced.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, role);
        VolumeNodeImpl volumeNode = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(volume);
        ClusterImpl recoveringCluster = volumeNode.getCluster();
        this.copyPolicies(ced, existingGroup, recoveringCluster);
        return ced;
    }

    private void copyPolicies(ConfigElementData ced, DRClusterAbstractConsistencyGroupImpl group, ClusterImpl cluster) throws RemoteException {
        VSwitchImpl groupVSwitch = group.getActiveVswitch();
        HashMap<ClientParameterCode, Serializable> pitPolicy = new HashMap<ClientParameterCode, Serializable>();
        Policy currPiTPolicy = group.getPiTPolicy(groupVSwitch);
        pitPolicy.put(ClientParameterCode.DR_POLICY_METHOD, currPiTPolicy.getType());
        pitPolicy.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, currPiTPolicy.getStartAt());
        pitPolicy.put(ClientParameterCode.DR_POLICY_RUN_EVERY, (Long)currPiTPolicy.getValue());
        HashMap<ClientParameterCode, Serializable> transferPolicy = new HashMap<ClientParameterCode, Serializable>();
        Policy currTransferPolicy = group.getTransferPolicy(groupVSwitch);
        transferPolicy.put(ClientParameterCode.DR_POLICY_METHOD, currTransferPolicy.getType());
        transferPolicy.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, currTransferPolicy.getStartAt());
        transferPolicy.put(ClientParameterCode.DR_POLICY_RUN_EVERY, (Long)currTransferPolicy.getValue());
        HashMap<ClientParameterCode, PolicyTypeConstant> mergePolicy = new HashMap<ClientParameterCode, PolicyTypeConstant>();
        Policy currMergePolicy = group.getMergePolicy(groupVSwitch);
        mergePolicy.put(ClientParameterCode.DR_POLICY_METHOD, currMergePolicy.getType());
        DRRootImpl.getInstance().prepareElementPolicies(ced, pitPolicy, transferPolicy, mergePolicy, cluster);
    }

    public DRAbstractConsistencyGroupImpl getParentGroup() {
        return this.parentGroup;
    }

    public JournalVolume getJournalVolume(DRRoleConstant role) throws RemoteException {
        if (role.equals(DRRoleConstant.LOCAL)) {
            DRClusterAsyncPairImpl localPair = (DRClusterAsyncPairImpl)this.getLocalElement();
            if (localPair != null) {
                return localPair.getJournal();
            }
            return null;
        }
        if (role.equals(DRRoleConstant.REMOTE)) {
            DRClusterAsyncPairImpl remotePair = (DRClusterAsyncPairImpl)this.getRemoteElement();
            if (remotePair != null) {
                return remotePair.getJournal();
            }
            return null;
        }
        return null;
    }

    @Override
    public SrFuture<Void> changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRAsyncPairImpl.changeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (code.equals(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME)) {
            DRClusterLogicObjectImpl localElement = this.getLocalElement();
            if (localElement != null) {
                midFutures.add(localElement.changeElement(ClientParameterCode.DR_ASYNC_PAIR_SNAPSHOT_VOLUME, value));
            }
        } else if (code.equals(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME)) {
            DRClusterLogicObjectImpl remoteElement = this.getRemoteElement();
            if (remoteElement != null) {
                midFutures.add(remoteElement.changeElement(ClientParameterCode.DR_ASYNC_PAIR_SNAPSHOT_VOLUME, value));
            }
        } else {
            midFutures.add(super.changeElement(code, value));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap clientParameterList) throws IllegalValueException {
        DRClusterLogicObjectImpl remoteElement;
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRAsyncPairImpl.changeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        HashMap paramsForLocal = new HashMap(clientParameterList);
        HashMap paramsForRemote = new HashMap(clientParameterList);
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        for (Object code : clientParameterList.keySet()) {
            Object value = clientParameterList.get(code);
            if (!(value instanceof ChangeConstant)) continue;
            midFutures.add(this.validAndActivate((ChangeConstant)value));
        }
        if (localElement != null) {
            if (clientParameterList.containsKey(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME)) {
                CommKeyClassId primarySnapshotId = (CommKeyClassId)clientParameterList.get(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME);
                if (primarySnapshotId != null && localElement.getCluster().getConnectedVSwitchCounter() > primarySnapshotId.getCommKeys().length) {
                    theLogger.trace(SrLogCategories.LEGACY, "Primary Snapshot ID for pair <", this, "> creation is not redundant:", primarySnapshotId);
                }
                paramsForLocal.put(ClientParameterCode.DR_ASYNC_PAIR_SNAPSHOT_VOLUME, clientParameterList.get(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME));
            }
            midFutures.add(localElement.changeElement(paramsForLocal));
        }
        if ((remoteElement = this.getRemoteElement()) != null) {
            if (clientParameterList.containsKey(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME)) {
                CommKeyClassId secondarySnapshotId = (CommKeyClassId)clientParameterList.get(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME);
                if (secondarySnapshotId != null && remoteElement.getCluster().getConnectedVSwitchCounter() > secondarySnapshotId.getCommKeys().length) {
                    theLogger.trace(SrLogCategories.LEGACY, "Secondary Snapshot ID for pair <", this, "> creation is not redundant:", secondarySnapshotId);
                }
                paramsForRemote.put(ClientParameterCode.DR_ASYNC_PAIR_SNAPSHOT_VOLUME, clientParameterList.get(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME));
            }
            midFutures.add(remoteElement.changeElement(paramsForRemote));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public boolean checkNonFunctionalOfVolumes() {
        return this.getPrimaryVolume().getLocalVolume() != null && !this.getPrimaryVolume().getLocalVolume().isNonFunctional() && this.getSecondaryVolume().getRemoteVolume() != null && !this.getSecondaryVolume().getRemoteVolume().isNonFunctional() || this.m_localCopySize != null;
    }

    @Override
    protected SrFuture<Void> validAndActivateForFather(ParameterList params) throws IllegalValueException {
        Validator.getInstance().isValidAccordingToAlarm(this.parentGroup, params);
        return new CompleteFuture<Void>("DRAsyncPairImpl.validAndActivateForFather");
    }

    public DRInitialSyncStateConstant getInitialSyncState() throws RemoteException {
        DRClusterAsyncPairImpl element = (DRClusterAsyncPairImpl)this.getActiveElement();
        if (element == null) {
            element = (DRClusterAsyncPairImpl)this.getInactiveElement();
        }
        return element.getInitialSyncState();
    }

    @Override
    protected boolean isSnapshotNeeded(DRActivateConstant state) {
        return this.isInitialSyncState(DRInitialSyncStateConstant.NEED_SYNC);
    }

    public DRAbstractConsistencyGroupImpl getCg() {
        return this.parentGroup;
    }

    @Override
    public SrFuture<Void> refreshPiTs() throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("Site.plannedFailover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterAsyncPairImpl local = (DRClusterAsyncPairImpl)this.getLocalElement();
        DRClusterAsyncPairImpl remote = (DRClusterAsyncPairImpl)this.getRemoteElement();
        if (local != null) {
            midFutures.add(local.refreshPiTs(this.getClusterPiTs(local.getCluster())));
        }
        if (remote != null) {
            midFutures.add(remote.refreshPiTs(this.getClusterPiTs(remote.getCluster())));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public void addPiT(DRPiTImpl pit) {
        if (!this.m_pits.contains(pit)) {
            this.m_pits.add(pit);
        }
    }

    @Override
    public void removePiT(DRPiTImpl pit) {
        this.m_pits.remove(pit);
    }

    @Override
    public DRPiT[] clearClusterPiTs(ClusterImpl cluster) {
        ArrayList<DRPiTImpl> removedPits = new ArrayList<DRPiTImpl>();
        Iterator i = this.m_pits.iterator();
        while (i.hasNext()) {
            DRPiTImpl pit = (DRPiTImpl)i.next();
            if (!pit.getCluster().equals(cluster)) continue;
            removedPits.add(pit);
            i.remove();
        }
        return removedPits.toArray(new DRPiT[removedPits.size()]);
    }

    private DRPiT[] getClusterPiTs(ClusterImpl cluster) {
        ArrayList<DRPiTImpl> pitList = new ArrayList<DRPiTImpl>();
        for (DRPiTImpl pit : this.m_pits) {
            if (!pit.getCluster().equals(cluster)) continue;
            pitList.add(pit);
        }
        return pitList.toArray(new DRPiT[pitList.size()]);
    }

    public SnapshotVolumeImpl getLocalSnapshot() {
        if (this.getLocalElement() != null) {
            return ((DRClusterAsyncPairImpl)this.getLocalElement()).getSnapshot();
        }
        return null;
    }

    public SnapshotVolumeImpl getRemoteSnapshot() {
        if (this.getRemoteElement() != null) {
            return ((DRClusterAsyncPairImpl)this.getRemoteElement()).getSnapshot();
        }
        return null;
    }

    public BigInteger getVolumeLocalCopySize() {
        return this.m_localCopySize;
    }

    @Override
    public SrFuture<Void> validAndActivateForChildren(ChangeConstant state) throws IllegalValueException {
        return super.validAndActivateForChildren(state);
    }

    @Override
    public SrFuture<Void> endInitialSync() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRAsyncPairImpl.endInitialSync");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        midFutures.add(super.validAndActivate(DRActivateConstant.END_INITIAL_SYNC));
        if (!this.getInitalSyncType().equals(DRPairInitialSyncTypeConstant.OFFLINE) || this.getSecondaryVolume().getRemoteVolume().isProvisioned()) {
            throw new IllegalValueException("Can't do end initial sync for pair type " + this.getInitalSyncType());
        }
        this.m_localCopySize = null;
        midFutures.add(((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter(this.getParameterCode(MasterParameterCode.DR_ACTIVATE), DRActivateConstant.END_INITIAL_SYNC)));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }
}

