/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.DRVolumeTypeConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DRClusterPairImpl
extends DRClusterLogicObjectImpl
implements DRClusterPair {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected DRRoleConstant m_role;
    private String myPrimaryVolDebugInfo;
    private String mySecondaryVolDebugInfo;
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected DRClusterPairImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    public void setRole(DRRoleConstant role) {
        this.m_role = role;
    }

    @Override
    public boolean isLocal() {
        return this.getRole().equals(DRRoleConstant.LOCAL);
    }

    @Override
    public DRRoleConstant getRole() {
        return this.m_role;
    }

    public VolumeNodeImpl getPrimaryVolume() {
        CommKeyClassId primaryId = this.getPrimaryVolumeId();
        if (primaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(primaryId);
    }

    public VolumeNode getPrimaryVolume(VSwitchImpl vSwitch) {
        CommKeyClassId primaryId = this.getPrimaryVolumeId(vSwitch);
        if (primaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(primaryId);
    }

    public boolean isIllegalVolPair() throws RemoteException {
        if (this.getPrimaryVolume(this.getActiveVswitch()) == null || this.getSecondaryVolume(this.getActiveVswitch()) == null) {
            return false;
        }
        return !this.getPrimaryVolume(this.getActiveVswitch()).equals(this.getPrimaryVolume(this.getInactiveVSwitch())) && this.getSecondaryVolume(this.getActiveVswitch()).equals(this.getSecondaryVolume(this.getInactiveVSwitch()));
    }

    public VolumeNodeImpl getSecondaryVolume() {
        CommKeyClassId secondaryId = this.getSecondaryVolumeId();
        if (secondaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(secondaryId);
    }

    public VolumeNode getSecondaryVolume(VSwitchImpl vSwitch) {
        CommKeyClassId secondaryId = this.getSecondaryVolumeId(vSwitch);
        if (secondaryId == null) {
            return null;
        }
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(secondaryId);
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType() throws RemoteException {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType(VSwitchImpl vSwitch) {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, vSwitch == null);
    }

    public DRInitialSyncStateConstant getInitialSyncState() throws RemoteException {
        return (DRInitialSyncStateConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE);
    }

    public DRInitialSyncStateConstant getInitialSyncState(VSwitchImpl vSwitch) {
        return (DRInitialSyncStateConstant)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, vSwitch == null);
    }

    public LU getLUOfExposedVolume() throws RemoteException {
        VolumeNodeImpl secondaryVol;
        DRRoleConstant role = this.getRole();
        if (DRRoleConstant.LOCAL.equals(role)) {
            VolumeNodeImpl primaryVol = this.getPrimaryVolume();
            if (primaryVol.isExposed()) {
                return primaryVol.getParentLU();
            }
        } else if (DRRoleConstant.REMOTE.equals(role) && (secondaryVol = this.getSecondaryVolume()).isExposed()) {
            return secondaryVol.getParentLU();
        }
        return null;
    }

    public CommKeyClassId getPrimaryVolumeId(VSwitchImpl vSwitch) {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_PRIMARY_ID, vSwitch == null);
    }

    public CommKeyClassId getPrimaryVolumeId() {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_PAIR_PRIMARY_ID);
    }

    public CommKeyClassId getSecondaryVolumeId(VSwitchImpl vSwitch) {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_PAIR_SECONDARY_ID, vSwitch == null);
    }

    public CommKeyClassId getSecondaryVolumeId() {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_PAIR_SECONDARY_ID);
    }

    public VolumeNode getVolume(DRVolumeTypeConstant volumeType) throws RemoteException {
        if (volumeType.equals(DRVolumeTypeConstant.PRIMARY)) {
            return this.getPrimaryVolume();
        }
        return this.getSecondaryVolume();
    }

    private boolean isSamePairObject(VolumeNodeImpl primary, VolumeNodeImpl secondary) throws RemoteException {
        VSwitchImpl vSwitch = this.getActiveVswitch();
        CommKeyClassId currentPrimaryId = this.getPrimaryVolumeId(vSwitch);
        CommKeyClassId currentSecondaryId = this.getSecondaryVolumeId(vSwitch);
        VolumeNodeImpl currentPrimary = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(currentPrimaryId);
        VolumeNodeImpl currentSecondary = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(currentSecondaryId);
        return currentPrimary.equals(primary) && currentSecondary.equals(secondary) || currentPrimary.equals(secondary) && currentSecondary.equals(primary);
    }

    public boolean isInternalDR() throws RemoteException {
        return this.getPrimaryVolume().getParentLU() == null && this.getSecondaryVolume().getParentLU() == null;
    }

    public VolumeNodeImpl getInternalVolume() throws RemoteException {
        return this.isLocal() ? this.getSecondaryVolume() : this.getPrimaryVolume();
    }

    public VolumeNodeImpl getExposedVolume() {
        return this.isLocal() ? this.getPrimaryVolume() : this.getSecondaryVolume();
    }

    public boolean equalsInCluster(HashMap parameterList) throws RemoteException {
        CommKeyClassId primaryID = (CommKeyClassId)parameterList.get(ParameterCode.DR_PAIR_PRIMARY_ID);
        CommKeyClassId secondaryID = (CommKeyClassId)parameterList.get(ParameterCode.DR_PAIR_SECONDARY_ID);
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(primaryID);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(secondaryID);
        return this.isSamePairObject(primaryVolume, secondaryVolume);
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        VSwitchImpl result = null;
        if (vSwitches.length > 0) {
            if (vSwitches.length == 1) {
                return vSwitches[0];
            }
            if (DRModeConstant.NORMAL.equals(this.getSrValueOf(vSwitches[0], ParameterCode.DR_PAIR_MODE))) {
                if (DRRoleConstant.LOCAL.equals(this.getRole()) && this.getPrimaryVolume() != null) {
                    result = this.getPrimaryVolume().getActiveVswitch();
                }
                if (DRRoleConstant.REMOTE.equals(this.getRole()) && this.getSecondaryVolume() != null) {
                    result = this.getSecondaryVolume().getActiveVswitch();
                }
            } else if (DRModeConstant.SWITCHED.equals(this.getSrValueOf(vSwitches[0], ParameterCode.DR_PAIR_MODE))) {
                if (this.getRole().equals(DRRoleConstant.REMOTE) && this.getSecondaryVolume() != null) {
                    result = this.getSecondaryVolume().getActiveVswitch();
                }
                if (this.getRole().equals(DRRoleConstant.LOCAL) && this.getPrimaryVolume() != null) {
                    result = this.getPrimaryVolume().getActiveVswitch();
                }
            }
        }
        if (result != null && this.getConnectedVSwitchesAsList().contains(result) && result.isConnected()) {
            return result;
        }
        return super.getDominantVswitch();
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        VSwitchImpl vs = this.getActiveVswitch();
        if (vs != null) {
            HashMap<ParameterCode, Parameter> parameterList = this.getParameters(vs);
            return ElementEventImpl.convertParameterList(parameterList, this);
        }
        return super.getClientParameterList();
    }

    @Override
    public String toString() {
        VolumeNodeImpl pri = null;
        VolumeNodeImpl sec = null;
        if (this.getConnectedVSwitches().length > 0) {
            pri = this.getPrimaryVolume();
            sec = this.getSecondaryVolume();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        if (pri != null) {
            sb.append(pri);
        }
        sb.append(" - ");
        if (sec != null) {
            sb.append(sec);
        }
        sb.append(' ');
        return sb.toString();
    }

    public SrFuture<Void> refreshInitialSyncProgress() throws RemoteException {
        return this.refreshFields(new ParameterCode[]{ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED});
    }

    public DRPairInitialSyncTypeConstant getInitalSyncType() {
        return (DRPairInitialSyncTypeConstant)this.getSrValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        StringBuilder sb;
        HashMap params = super.changeParameterList(aCED);
        VolumeNodeImpl primaryVolume = this.getPrimaryVolume();
        VolumeNodeImpl secondaryVolume = this.getSecondaryVolume();
        if (primaryVolume != null) {
            primaryVolume.addMergeListener(this);
            sb = new StringBuilder();
            sb.append(primaryVolume.toString()).append(':').append(this.getPrimaryVolumeId());
            this.myPrimaryVolDebugInfo = sb.toString();
        } else if (this.myPrimaryVolDebugInfo == null) {
            this.myPrimaryVolDebugInfo = String.valueOf(this.getPrimaryVolumeId());
        }
        if (secondaryVolume != null) {
            secondaryVolume.addMergeListener(this);
            sb = new StringBuilder();
            sb.append(secondaryVolume.toString()).append(':').append(this.getSecondaryVolumeId());
            this.mySecondaryVolDebugInfo = sb.toString();
        } else if (this.mySecondaryVolDebugInfo == null) {
            this.mySecondaryVolDebugInfo = String.valueOf(this.getSecondaryVolumeId());
        }
        return params;
    }

    @Override
    protected void notifyChildElementsWillBeMerged(LogicObjectImpl childElement, LogicObjectImpl mantainedElement) {
        DRClusterPairImpl mantainedPair = this.cluster.getDRManager().getPair((VolumeNodeImpl)mantainedElement);
        if (mantainedPair == null) {
            return;
        }
        VolumeNodeImpl primVolume = this.getPrimaryVolume();
        VolumeNodeImpl secVolume = this.getSecondaryVolume();
        VolumeNodeImpl mantainedPairPrimVolume = mantainedPair.getPrimaryVolume();
        VolumeNodeImpl mantainedPairSecVolume = mantainedPair.getSecondaryVolume();
        if (primVolume == null || secVolume == null || mantainedPairPrimVolume == null || mantainedPairSecVolume == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Secondary nor primary volumes cannot be null. primVolume: ", primVolume, "; secVolume: ", secVolume, "; mantainedPairPrimVolume: ", mantainedPairPrimVolume, "; mantainedPairSecVolume: ", mantainedPairSecVolume);
            return;
        }
        if (((Object)primVolume).equals(childElement) && ((Object)secVolume).equals(mantainedPairSecVolume) || ((Object)secVolume).equals(childElement) && ((Object)primVolume).equals(mantainedPairPrimVolume)) {
            mantainedPair.merge(this);
        }
    }

    @Override
    protected ArrayList getAdditionalDependantObjectsForSynchronization() throws RemoteException {
        ArrayList list = super.getAdditionalDependantObjectsForSynchronization();
        list.add(this.getReleventVolume().getParentLU());
        return list;
    }

    private VolumeNodeImpl getReleventVolume() {
        if (DRRoleConstant.LOCAL.equals(this.getRole())) {
            return this.getPrimaryVolume();
        }
        return this.getSecondaryVolume();
    }

    public abstract ConfigElementDataList synchronize(Map<CommKeyClassId, ConfigElementData> var1) throws RemoteException, IllegalValueException;

    @Override
    public void clear() throws RemoteException {
        super.clear();
    }

    String toStringForVSW() {
        StringBuilder clusterInfo = new StringBuilder("Cluster[");
        clusterInfo.append(this.cluster);
        for (VSwitchImpl vs : this.cluster.getVSwitches()) {
            clusterInfo.append(',').append(vs);
        }
        clusterInfo.append(']');
        return "DRClusterPair[" + this.myPrimaryVolDebugInfo + ',' + this.mySecondaryVolDebugInfo + clusterInfo.toString() + "]";
    }

    @Override
    public CommKey[] removeFromVSwitch(VSwitch vSwitch) throws RemoteException {
        return super.removeFromVSwitch(vSwitch);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_PRIMARY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_SECONDARY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_MODE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

