/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.event.SrCreateElementEvent;
import com.sanrad.nms.server.event.SrRemoveElementEvent;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.util.SrPostponedExecutor;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DRClusterManager {
    protected static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl m_cluster = null;
    private ArrayList<DRClusterSyncPairImpl> m_syncPairs = new ArrayList();
    private HashMap m_groupsWithPairs = new HashMap();
    private HashMap m_emptyGroups = new HashMap();
    private ArrayList<DRClusterConsistencyGroupImpl> m_consistencyGroupsWithPairs = new ArrayList();
    private ArrayList<DRClusterConsistencyGroupImpl> m_emptyConsistencyGroups = new ArrayList();
    private ArrayList<DRClusterExtendedPairImpl> m_extendedPairsWithPairs = new ArrayList();
    private ArrayList<DRClusterExtendedPairImpl> m_emptyExtendedPairs = new ArrayList();
    private ArrayList<DRClusterPairImpl> m_pendingPairs = new ArrayList();
    private static final int CREATE_EVENT_TYPE = 1;
    private static final int CHANGE_EVENT_TYPE = 2;
    private static final int REMOVE_EVENT_TYPE = 3;

    public DRClusterManager(ClusterImpl cluster) {
        this.m_cluster = cluster;
        this.m_groupsWithPairs.put(ClassID.CONSISTENCY_GROUP, this.m_consistencyGroupsWithPairs);
        this.m_groupsWithPairs.put(ClassID.EXTENDED_PAIR, this.m_extendedPairsWithPairs);
        this.m_emptyGroups.put(ClassID.CONSISTENCY_GROUP, this.m_emptyConsistencyGroups);
        this.m_emptyGroups.put(ClassID.EXTENDED_PAIR, this.m_emptyExtendedPairs);
    }

    public void discoveryStarted() {
        StringBuilder clusterInfo = new StringBuilder("Cluster[");
        clusterInfo.append(this.m_cluster);
        for (VSwitchImpl vs : this.m_cluster.getVSwitches()) {
            clusterInfo.append(',').append(vs);
        }
        clusterInfo.append(']');
        this.m_consistencyGroupsWithPairs.clear();
        this.m_emptyConsistencyGroups.clear();
        this.m_extendedPairsWithPairs.clear();
        this.m_emptyExtendedPairs.clear();
        this.m_pendingPairs.clear();
        this.m_syncPairs.clear();
    }

    public LogicObjectImpl newElement(ClassID classId, CommKey[] commKeys, ConfigElementData aCED, SrPostponedExecutor aEventMonitor) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        LogicObjectImpl element = null;
        if (classId.isDRGroup()) {
            element = this.newConsistencyGroup(aCED, commKeys, classId);
        } else if (classId.equals(ClassID.ASYNC_PAIR)) {
            element = this.newAsyncPair(aCED, commKeys, classId, aEventMonitor);
        } else if (classId.equals(ClassID.SYNC_PAIR)) {
            element = this.newSyncPair(aCED, commKeys, classId);
        } else if (classId.equals(ClassID.DR_CONSISTENCY_GROUP_PIT) || classId.equals(ClassID.DR_ASYNC_PAIR_PIT)) {
            element = this.newDRPiT(classId, aCED);
        }
        return element;
    }

    public void removeElement(LogicObjectImpl element, VSwitchImpl vSwitch, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        try {
            ClassID classId = element.getClassId();
            if (classId.isDRGroup()) {
                this.removeConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element, aEventMonitor);
            } else if (classId.equals(ClassID.ASYNC_PAIR)) {
                this.removeAsyncPair((DRClusterAsyncPairImpl)element, vSwitch, aEventMonitor);
            } else if (classId.equals(ClassID.SYNC_PAIR)) {
                this.removeSyncPair((DRClusterSyncPairImpl)element, vSwitch);
            }
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.LEGACY, ive, " exception caught in DRClusterManager::removeElement(", element, ", ", vSwitch, ")");
        }
    }

    public void bruteForceRemoveElement(DRClusterLogicObjectImpl element) throws RemoteException {
        ArrayList list = this.getElementList(element);
        if (list != null) {
            this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(element.getCommKeyClassId());
            list.remove(element);
        }
    }

    private ArrayList getElementList(DRClusterLogicObjectImpl element) {
        if (element != null) {
            if (this.m_consistencyGroupsWithPairs.contains(element)) {
                return this.m_consistencyGroupsWithPairs;
            }
            if (this.m_extendedPairsWithPairs.contains(element)) {
                return this.m_extendedPairsWithPairs;
            }
            if (this.m_emptyConsistencyGroups.contains(element)) {
                return this.m_emptyConsistencyGroups;
            }
            if (this.m_emptyExtendedPairs.contains(element)) {
                return this.m_emptyExtendedPairs;
            }
            if (this.m_syncPairs.contains(element)) {
                return this.m_syncPairs;
            }
            if (this.m_pendingPairs.contains(element)) {
                return this.m_pendingPairs;
            }
        }
        return null;
    }

    private ArrayList getGroupList(DRGroupListType groupType, ClassID classId) {
        if (groupType.equals(DRGroupListType.WITH_PAIRS)) {
            return (ArrayList)this.m_groupsWithPairs.get(classId);
        }
        return (ArrayList)this.m_emptyGroups.get(classId);
    }

    private DRClusterAsyncPair[] getPendingPairs() {
        if (this.m_pendingPairs == null) {
            return null;
        }
        DRClusterAsyncPair[] pairsArray = new DRClusterAsyncPair[this.m_pendingPairs.size()];
        return this.m_pendingPairs.toArray(pairsArray);
    }

    public boolean isDRExist() {
        return !this.m_consistencyGroupsWithPairs.isEmpty() || !this.m_extendedPairsWithPairs.isEmpty() || !this.m_emptyConsistencyGroups.isEmpty() || !this.m_emptyExtendedPairs.isEmpty() || !this.m_syncPairs.isEmpty();
    }

    private DRClusterAbstractConsistencyGroup[] createArrayOfGroups(ClassID classId, int size) {
        DRClusterAbstractConsistencyGroup[] groups;
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            groups = new DRClusterConsistencyGroup[size];
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            groups = new DRClusterExtendedPair[size];
        } else {
            throw new IllegalArgumentException("Wrong ClassID " + classId);
        }
        return groups;
    }

    public DRClusterConsistencyGroup[] getConsistencyGroups() throws RemoteException {
        ArrayList<DRClusterConsistencyGroupImpl> all = new ArrayList<DRClusterConsistencyGroupImpl>();
        all.addAll(this.m_consistencyGroupsWithPairs);
        return all.toArray(new DRClusterConsistencyGroup[all.size()]);
    }

    public DRClusterExtendedPair[] getExtendedPairs() throws RemoteException {
        ArrayList<DRClusterExtendedPairImpl> all = new ArrayList<DRClusterExtendedPairImpl>();
        all.addAll(this.m_extendedPairsWithPairs);
        return all.toArray(new DRClusterExtendedPair[all.size()]);
    }

    public DRClusterSyncPair[] getSyncPairs() throws RemoteException {
        DRClusterSyncPair[] syncPairs = new DRClusterSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        return syncPairs;
    }

    public DRClusterPair[] getAllPairs() {
        ArrayList<DRClusterPair> all = new ArrayList<DRClusterPair>();
        all.addAll(this.m_syncPairs);
        for (DRClusterConsistencyGroupImpl cg : this.m_consistencyGroupsWithPairs) {
            all.addAll(Arrays.asList(cg.getPairs()));
        }
        for (DRClusterExtendedPairImpl exPair : this.m_extendedPairsWithPairs) {
            all.add(exPair.getPair());
        }
        return all.toArray(new DRClusterPair[all.size()]);
    }

    public DRClusterPairImpl getPair(VolumeNodeImpl volume) {
        DRClusterPair[] pairs = this.getAllPairs();
        int i = pairs.length;
        while (i-- > 0) {
            if (!volume.equals(((DRClusterPairImpl)pairs[i]).getPrimaryVolume()) && !volume.equals(((DRClusterPairImpl)pairs[i]).getSecondaryVolume())) continue;
            return (DRClusterPairImpl)pairs[i];
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl newConsistencyGroup(ConfigElementData aCED, CommKey[] commKeys, ClassID classId) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        DRClusterAbstractConsistencyGroupImpl newGroup = null;
        CommKeyClassId groupId = new CommKeyClassId(commKeys, classId);
        DRClusterAsyncPairImpl matchingPair = this.findPairInListByGroupId(this.getPendingPairs(), groupId);
        if (matchingPair != null) {
            newGroup = this.createAndAddConsistencyGroup(DRGroupListType.WITH_PAIRS, aCED, commKeys, classId);
            newGroup.addPair(matchingPair);
            DRRoleConstant groupRole = (DRRoleConstant)aCED.getValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
            matchingPair.setRole(groupRole);
            this.m_pendingPairs.remove(matchingPair);
            return newGroup;
        }
        VSwitchImpl vSwitch = (VSwitchImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID));
        newGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, classId, vSwitch);
        if (newGroup != null) {
            throw new AlreadyKnownByVSwitch(newGroup);
        }
        newGroup = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, aCED, classId);
        if (newGroup != null) {
            throw new AlreadyKnownByVSwitch(newGroup);
        }
        newGroup = this.createAndAddConsistencyGroup(DRGroupListType.EMPTY, aCED, commKeys, classId);
        return newGroup;
    }

    private DRClusterAsyncPairImpl newAsyncPair(ConfigElementData aCED, CommKey[] commKeys, ClassID classId, SrPostponedExecutor aEventMonitor) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        DRClusterAsyncPairImpl matchingPair = null;
        DRClusterAbstractConsistencyGroupImpl matchingGroup = null;
        CommKeyClassId groupId = (CommKeyClassId)aCED.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        ClassID groupClass = groupId.getClassID();
        matchingPair = (DRClusterAsyncPairImpl)this.findPairInGroupByPairAttributes(DRGroupListType.WITH_PAIRS, aCED, groupClass);
        if (matchingPair != null) {
            matchingGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(matchingPair.getGroupId());
            DRClusterAbstractConsistencyGroupImpl newPairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
            if (newPairGroup != null && matchingGroup != newPairGroup) {
                this.mergeGroups(matchingGroup, newPairGroup, aEventMonitor);
            }
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingPair = (DRClusterAsyncPairImpl)this.findPairInListByPairAttributes(this.getPendingPairs(), aCED);
        if (matchingPair != null) {
            matchingGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, groupClass, null);
            if (matchingGroup == null) {
                matchingGroup = this.findGroupInListByGroupId(DRGroupListType.EMPTY, groupId, groupClass, null);
            }
            if (matchingGroup != null) {
                this.recreateElement(matchingPair, matchingPair.getActiveVswitch(), matchingPair.getCommKeyClassId(), aEventMonitor);
                if (matchingGroup.isEmpty()) {
                    this.addItemToGroupList(DRGroupListType.WITH_PAIRS, matchingGroup);
                    this.removeItemFromGroupList(DRGroupListType.EMPTY, matchingGroup);
                }
                matchingPair = this.createAndAddPairToGroup(aCED, commKeys, matchingGroup, aEventMonitor);
                return matchingPair;
            }
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingGroup = this.findGroupInListByGroupId(DRGroupListType.EMPTY, groupId, groupClass, null);
        if (matchingGroup != null) {
            matchingPair = this.createAndAddPairToGroup(aCED, commKeys, matchingGroup, aEventMonitor);
            this.addItemToGroupList(DRGroupListType.WITH_PAIRS, matchingGroup);
            this.removeItemFromGroupList(DRGroupListType.EMPTY, matchingGroup);
            return matchingPair;
        }
        matchingGroup = this.findGroupInListByGroupId(DRGroupListType.WITH_PAIRS, groupId, groupClass, null);
        if (matchingGroup != null) {
            matchingPair = this.createAsyncPair(aCED, commKeys);
            matchingGroup.addPair(matchingPair);
            matchingPair.setRole(matchingGroup.getRole());
            return matchingPair;
        }
        matchingPair = this.createAsyncPair(aCED, commKeys);
        this.m_pendingPairs.add(matchingPair);
        return matchingPair;
    }

    private DRClusterSyncPairImpl newSyncPair(ConfigElementData aCED, CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException, AlreadyKnownByVSwitch, InvalidElementException {
        DRClusterPair[] syncPairs = new DRClusterSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        DRClusterSyncPairImpl matchingPair = (DRClusterSyncPairImpl)this.findPairInListByPairAttributes(syncPairs, aCED);
        if (matchingPair != null) {
            throw new AlreadyKnownByVSwitch(matchingPair);
        }
        matchingPair = this.createSyncPair(aCED, commKeys);
        this.m_syncPairs.add(matchingPair);
        return matchingPair;
    }

    private DRPiTImpl newDRPiT(ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        DRPiTImpl pit = new DRPiTImpl(this.m_cluster, classId, aCED);
        pit.changeParameterList(aCED);
        return pit;
    }

    private DRClusterAbstractConsistencyGroupImpl removeConsistencyGroup(DRClusterAbstractConsistencyGroupImpl group, SrPostponedExecutor aEventMonitor) throws RemoteException, IllegalValueException, InvalidElementException {
        if (group.getConnectedVSwitchCounter() == 1) {
            ArrayList groupList;
            ClassID classId = group.getClassId();
            if (group.isEmpty()) {
                groupList = this.getGroupList(DRGroupListType.EMPTY, classId);
            } else {
                DRClusterAsyncPairImpl pair;
                groupList = this.getGroupList(DRGroupListType.WITH_PAIRS, classId);
                if (classId.equals(ClassID.EXTENDED_PAIR) && (pair = ((DRClusterExtendedPairImpl)group).getPair()) != null) {
                    this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(pair.getCommKeyClassId());
                }
            }
            groupList.remove(group);
        } else {
            this.rematchEmptyGroupWithNoPairs(group, aEventMonitor);
        }
        return group;
    }

    private DRClusterAsyncPairImpl removeAsyncPair(DRClusterAsyncPairImpl pair, VSwitchImpl vSwitch, SrPostponedExecutor aEventMonitor) throws RemoteException, IllegalValueException, InvalidElementException {
        if (pair.getConnectedVSwitchCounter() == 1) {
            if (this.m_pendingPairs.contains(pair)) {
                this.m_pendingPairs.remove(pair);
            } else {
                CommKeyClassId groupId = pair.getGroupId();
                DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
                if (pairGroup != null) {
                    if (pairGroup.getClassId().equals(ClassID.CONSISTENCY_GROUP)) {
                        ((DRClusterConsistencyGroupImpl)pairGroup).removePair(pair);
                        DRClusterAsyncPair[] pairs = pairGroup.getPairs();
                        if (pairs == null || pairs.length == 0) {
                            this.m_consistencyGroupsWithPairs.remove(pairGroup);
                            this.m_emptyConsistencyGroups.add((DRClusterConsistencyGroupImpl)pairGroup);
                            if (pair.isMerged()) {
                                SrRemoveElementEvent removeEvent = this.prepareRemoveElementEvent(pairGroup);
                                this.m_cluster.elementEvent(removeEvent);
                                SrCreateElementEvent recreateEvent = this.prepareCreateElementEvent(pairGroup);
                                this.m_cluster.elementEvent(recreateEvent);
                            } else {
                                DRClusterAbstractConsistencyGroupImpl groupMatch = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, pairGroup, pairGroup.getClassId());
                                if (groupMatch != null) {
                                    this.mergeGroups(pairGroup, groupMatch, aEventMonitor);
                                }
                            }
                        }
                    } else {
                        this.m_extendedPairsWithPairs.remove(pairGroup);
                        if (pair.isMerged()) {
                            this.m_emptyExtendedPairs.add((DRClusterExtendedPairImpl)pairGroup);
                            SrRemoveElementEvent removeEvent = this.prepareRemoveElementEvent(pairGroup);
                            this.m_cluster.elementEvent(removeEvent);
                            SrCreateElementEvent recreateEvent = this.prepareCreateElementEvent(pairGroup);
                            this.m_cluster.elementEvent(recreateEvent);
                        } else {
                            this.m_cluster.getCommKeyRefMap().removeCommKeyClassIdAndRef(pairGroup.getCommKeyClassId());
                        }
                    }
                } else {
                    theLogger.warn(SrLogCategories.LEGACY, "pair ", pair, " is not pending has no group object reference!");
                }
            }
            pair.clearMergeNotifiers();
        } else if (!this.m_pendingPairs.contains(pair)) {
            CommKeyClassId groupId = pair.getGroupId();
            if (groupId != null) {
                DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
                if (pairGroup.getClassId().equals(ClassID.CONSISTENCY_GROUP)) {
                    VSwitchImpl vSwitchToRemain = this.m_cluster.getOtherVSwitch(vSwitch);
                    CommKey[] commKeysToRemain = pairGroup.getCommKeysOfVSwitch(vSwitchToRemain);
                    this.splitGroupWithOnePair(pairGroup, commKeysToRemain, pairGroup.getClassId(), vSwitchToRemain, aEventMonitor);
                } else if (pairGroup.getConnectedVSwitchCounter() == 2) {
                    HashMap<ParameterCodes, Object> parameters = pairGroup.getParameterListValues(vSwitch);
                    parameters.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
                    ConfigElementData data = new ConfigElementData(pairGroup.getCommKeys(), pairGroup.getClassId(), parameters);
                    SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, data);
                    this.m_cluster.elementEvent(removeEvent);
                }
            } else {
                theLogger.warn(SrLogCategories.LEGACY, "pair ", pair, " that is not pending has no group object reference!");
            }
        }
        return pair;
    }

    private SrCreateElementEvent prepareCreateElementEvent(LogicObjectImpl element) throws RemoteException {
        ConfigElementDataList dataList = this.prepareConfigElementDataListForEvent(element, 1);
        return new SrCreateElementEvent((Object)this, dataList);
    }

    private SrRemoveElementEvent prepareRemoveElementEvent(LogicObjectImpl element) throws RemoteException {
        ConfigElementDataList dataList = this.prepareConfigElementDataListForEvent(element, 3);
        return new SrRemoveElementEvent((Object)this, dataList);
    }

    private ConfigElementDataList prepareConfigElementDataListForEvent(LogicObjectImpl element, int eventType) throws RemoteException {
        List<VSwitchImpl> vswitchesList = element.getVSwitches();
        ConfigElementDataList dataList = new ConfigElementDataList();
        for (VSwitchImpl vs : vswitchesList) {
            CommKeyClassId elementSpecificKey = CommKeyUtil.getSpecificCommKeyClassId(element.getCommKeyClassId(), vs.getCommKeyClassId());
            ConfigElementData data = new ConfigElementData(elementSpecificKey);
            HashMap<Object, Object> parameters = null;
            switch (eventType) {
                case 3: {
                    parameters = new HashMap();
                    break;
                }
                case 1: {
                    parameters = element.getParameterListValues(vs);
                    parameters.put(ParameterCode.VSWITCH_ID, vs.getCommKeyClassId());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported event type: " + eventType);
                }
            }
            parameters.put(ParameterCode.VSWITCH_ID, vs.getCommKeyClassId());
            data.addParameter(parameters);
        }
        return dataList;
    }

    private DRClusterSyncPairImpl removeSyncPair(DRClusterSyncPairImpl pair, VSwitchImpl vSwitch) throws RemoteException {
        if (pair.getConnectedVSwitchCounter() == 1) {
            pair.clearMergeNotifiers();
            return this.m_syncPairs.remove(pair) ? pair : null;
        }
        return null;
    }

    public DRClusterAbstractConsistencyGroupImpl rematchEmptyGroupWithNoPairs(DRClusterAbstractConsistencyGroupImpl group, SrPostponedExecutor aEventMonitor) throws RemoteException, IllegalValueException, InvalidElementException {
        DRClusterAbstractConsistencyGroupImpl matchingGroup;
        if (group.getConnectedVSwitchCounter() == 1 && group.isEmpty() && (matchingGroup = this.findGroupInListByGroupAttributes(DRGroupListType.EMPTY, group, group.getClassId())) != null && matchingGroup.isEmpty()) {
            this.mergeGroups(matchingGroup, group, aEventMonitor);
            return matchingGroup;
        }
        return null;
    }

    private DRClusterAsyncPairImpl findPairInListByGroupId(DRClusterAsyncPair[] pairs, CommKeyClassId groupId) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRClusterAsyncPairImpl currPair = (DRClusterAsyncPairImpl)pairs[i];
                if (!currPair.matchToGroupID(groupId)) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId, VSwitchImpl groupVSwitch) throws RemoteException {
        DRClusterAsyncPairImpl selectedPair = this.findPairInGroupByGroupId(groupType, groupId, classId);
        if (selectedPair != null) {
            VSwitchImpl vSwitchToLookFor = groupVSwitch != null ? this.m_cluster.getOtherVSwitch(groupVSwitch) : null;
            CommKeyClassId selectedPairGroupId = selectedPair.getGroupId(vSwitchToLookFor);
            return (DRClusterAbstractConsistencyGroupImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(selectedPairGroupId);
        }
        DRClusterAbstractConsistencyGroupImpl selectedGroup = this.findGroupMatchToGroupId(groupType, groupId, classId);
        return selectedGroup;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupMatchToGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
                CommKeyClassId currGroupId = currGroup.getCommKeyClassId();
                if (!currGroupId.equals(groupId)) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRClusterAsyncPairImpl findPairInGroupByGroupId(DRGroupListType groupType, CommKeyClassId groupId, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        for (int i = 0; i < groups.size(); ++i) {
            DRClusterAsyncPairImpl selectedPair;
            DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
            DRClusterAsyncPair[] pairs = currGroup.getPairs();
            if (pairs == null || (selectedPair = this.findPairInListByGroupId(pairs, groupId)) == null) continue;
            return selectedPair;
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupAttributes(DRGroupListType groupType, ConfigElementData aCED, ClassID classId) throws RemoteException {
        return this.findGroupInListByGroupAttributes(groupType, aCED.getParametersList(), classId);
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupAttributes(DRGroupListType groupType, HashMap parameterList, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterAbstractConsistencyGroupImpl currGroup = (DRClusterAbstractConsistencyGroupImpl)groups.get(i);
                if (!currGroup.getClassId().equals(classId) || !currGroup.equalsInCluster(parameterList)) continue;
                if (classId.equals(ClassID.EXTENDED_PAIR)) {
                    return currGroup;
                }
                SrString alias = (SrString)parameterList.get(ParameterCode.DR_VIRT_GROUP_ALIAS);
                if (!((DRClusterConsistencyGroupImpl)currGroup).isSameAlias((String)alias.value())) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl findGroupInListByGroupAttributes(DRGroupListType groupType, DRClusterAbstractConsistencyGroupImpl group, ClassID classId) throws RemoteException {
        VSwitchImpl vSwitch = group.getActiveVswitch();
        HashMap<ParameterCode, Object> parameterList = group.getParameterListValues(vSwitch);
        parameterList.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
        return this.findGroupInListByGroupAttributes(groupType, parameterList, classId);
    }

    private DRClusterPairImpl findPairInListByPairAttributes(DRClusterPair[] pairs, ConfigElementData aCED) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRClusterPairImpl currPair = (DRClusterPairImpl)pairs[i];
                if (!currPair.equalsInCluster(aCED.getParametersList())) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterPairImpl findPairInGroupByPairAttributes(DRGroupListType groupType, ConfigElementData aCED, ClassID classId) throws RemoteException {
        ArrayList groups = this.getGroupList(groupType, classId);
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                DRClusterPairImpl currPair = this.findPairInListByPairAttributes(((DRClusterAbstractConsistencyGroupImpl)groups.get(i)).getPairs(), aCED);
                if (currPair == null) continue;
                return currPair;
            }
        }
        return null;
    }

    private DRClusterAbstractConsistencyGroupImpl createAndAddConsistencyGroup(DRGroupListType groupType, ConfigElementData aCED, CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException, InvalidElementException {
        ArrayList groupList = this.getGroupList(groupType, classId);
        DRClusterAbstractConsistencyGroupImpl newGroup = this.createGroupObject(classId, aCED);
        groupList.add(newGroup);
        newGroup.changeParameterList(aCED);
        return newGroup;
    }

    private DRClusterAbstractConsistencyGroupImpl createGroupObject(ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        DRClusterAbstractConsistencyGroupImpl newObject = null;
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            newObject = new DRClusterConsistencyGroupImpl(this.m_cluster, aCED);
        } else if (classId.equals(ClassID.EXTENDED_PAIR)) {
            newObject = new DRClusterExtendedPairImpl(this.m_cluster, aCED);
        } else {
            throw new IllegalArgumentException();
        }
        return newObject;
    }

    private DRClusterAsyncPairImpl createAsyncPair(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, IllegalValueException, InvalidElementException {
        DRClusterAsyncPairImpl newPair = new DRClusterAsyncPairImpl(this.m_cluster, aCED);
        newPair.changeParameterList(aCED);
        return newPair;
    }

    private DRClusterSyncPairImpl createSyncPair(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, IllegalValueException, InvalidElementException {
        DRClusterSyncPairImpl newPair = new DRClusterSyncPairImpl(this.m_cluster, aCED);
        newPair.changeParameterList(aCED);
        return newPair;
    }

    private void addItemToGroupList(DRGroupListType listType, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        ArrayList list = this.getGroupList(listType, group.getClassId());
        list.add(group);
    }

    private void removeItemFromGroupList(DRGroupListType listType, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        ArrayList list = this.getGroupList(listType, group.getClassId());
        list.remove(group);
    }

    private boolean splitGroupWithOnePair(DRClusterAbstractConsistencyGroupImpl group, CommKey[] remainingKeys, ClassID classId, VSwitchImpl remainingVSwitch, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        DRClusterAsyncPair[] pairs = group.getPairs();
        if (pairs != null && pairs.length == 1) {
            return this.splitGroup(group, remainingKeys, classId, remainingVSwitch, aEventMonitor);
        }
        return false;
    }

    private boolean splitGroup(DRClusterAbstractConsistencyGroupImpl group, CommKey[] remainingKeys, ClassID classId, VSwitchImpl remainingVSwitch, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        int numOfGroupVSwitches = group.getConnectedVSwitchCounter();
        if (numOfGroupVSwitches > 1) {
            VSwitchImpl splitVswitch = this.m_cluster.getOtherVSwitch(remainingVSwitch);
            CommKey[] splitKeys = CommKeyUtil.getAllButThisCommKey(group.getCommKeys(), remainingKeys);
            this.recreateElement(group, splitVswitch, new CommKeyClassId(splitKeys, classId), aEventMonitor);
            return true;
        }
        return false;
    }

    private void mergeGroups(DRClusterAbstractConsistencyGroupImpl mergeIntoGroup, DRClusterAbstractConsistencyGroupImpl depracatedGroup, SrPostponedExecutor aEventMonitor) throws RemoteException, IllegalValueException, InvalidElementException {
        DRClusterAsyncPair[] newPairs = depracatedGroup.getPairs();
        if (newPairs != null) {
            for (int i = 0; i < newPairs.length; ++i) {
                mergeIntoGroup.addPair((DRClusterAsyncPairImpl)newPairs[i]);
            }
        }
        VSwitchImpl vSwitchToRemain = mergeIntoGroup.getConnectedVSwitches()[0];
        VSwitchImpl vSwitch = this.m_cluster.getOtherVSwitch(vSwitchToRemain);
        this.recreateElement(depracatedGroup, vSwitch, depracatedGroup.getCommKeyClassId(), aEventMonitor);
    }

    private void recreateElement(DRClusterLogicObjectImpl element, VSwitchImpl vSwitch, CommKeyClassId commKeyClassId, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        HashMap<ParameterCodes, Object> parameters = element.getParameterListValues(vSwitch);
        parameters.put(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId());
        ConfigElementData data = new ConfigElementData(commKeyClassId.getCommKeys(), commKeyClassId.getClassID(), parameters);
        this.recreateElement(data, aEventMonitor);
    }

    private void recreateElement(final ConfigElementData ced, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        aEventMonitor.addOperation(new Runnable(){

            @Override
            public void run() {
                SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, ced);
                SrCreateElementEvent createEvent = new SrCreateElementEvent((Object)this, ced);
                DRClusterManager.this.m_cluster.elementEvent(removeEvent);
                DRClusterManager.this.m_cluster.elementEvent(createEvent);
            }
        });
    }

    public SrFuture<Void> removeEmptyGroupsWithNoPairs() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("Site.disasterOccured_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterConsistencyGroup[] groups = this.getConsistencyGroups();
        int groupsLength = groups.length;
        for (int i = 0; i < groupsLength; ++i) {
            if (!((DRClusterAbstractConsistencyGroupImpl)((Object)groups[i])).hasNoPairs()) continue;
            DRAbstractConsistencyGroupImpl currDRGroup = (DRAbstractConsistencyGroupImpl)DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterConsistencyGroupImpl)groups[i]);
            if (currDRGroup != null) {
                if (currDRGroup.isInDeletionProcess()) continue;
                midFutures.add(groups[i].deleteElement());
                continue;
            }
            midFutures.add(groups[i].deleteElement());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private DRClusterAsyncPairImpl createAndAddPairToGroup(ConfigElementData aCED, CommKey[] commKeys, DRClusterAbstractConsistencyGroupImpl group, SrPostponedExecutor aEventMonitor) throws RemoteException, IllegalValueException, InvalidElementException {
        CommKeyClassId groupId = (CommKeyClassId)aCED.getValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        ClassID groupClass = groupId.getClassID();
        CommKeyClassId vSwitchId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        VSwitchImpl vSwitch = (VSwitchImpl)this.m_cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchId);
        this.splitGroup(group, groupId.getCommKeys(), groupClass, vSwitch, aEventMonitor);
        DRClusterAsyncPairImpl pair = this.createAsyncPair(aCED, commKeys);
        group.addPair(pair);
        pair.setRole(group.getRole());
        return pair;
    }

    public synchronized SrFuture<Void> synchronize() throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("DRClusterManager.synchronize");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterPair[] pairs = this.getAllPairs();
        if (pairs == null || pairs.length == 0) {
            return new CompleteFuture<Void>("DRClusterManager.synchronize");
        }
        HashMap<CommKeyClassId, ConfigElementData> accumlator = new HashMap<CommKeyClassId, ConfigElementData>();
        ConfigElementDataList[] pairLists = new ConfigElementDataList[pairs.length + 1];
        for (int i = 0; i < pairs.length; ++i) {
            pairLists[i] = ((DRClusterPairImpl)pairs[i]).synchronize(accumlator);
        }
        pairLists[pairs.length] = new ConfigElementDataList(SynchronizeableImpl.createCedForForceStateSync(((DRClusterPairImpl)pairs[0]).getActiveVswitch()));
        for (ConfigElementDataList curCedList : pairLists) {
            midFutures.add(DataMgrAdapter.getInstance().createElement(curCedList));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public DRClusterConsistencyGroupImpl getEmptyCG(String aAlias) throws RemoteException {
        if (aAlias == null) {
            throw new IllegalArgumentException("aAlias must not be null");
        }
        for (DRClusterConsistencyGroupImpl cg : this.m_emptyConsistencyGroups) {
            if (!cg.isSameAlias(aAlias)) continue;
            return cg;
        }
        return null;
    }

    private static class DRGroupListType {
        public static final DRGroupListType WITH_PAIRS = new DRGroupListType();
        public static final DRGroupListType EMPTY = new DRGroupListType();
        public static final DRGroupListType ALL = new DRGroupListType();

        private DRGroupListType() {
        }
    }
}

