/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.AnnexControlFunction;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.CFErrorReasonConstant;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DRClusterLogicObjectImpl
extends SynchronizeableImpl
implements DRClusterLogicObject {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;
    private boolean myIsInSwitchProcess = false;

    protected DRClusterLogicObjectImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ConfigElementDataList cfList;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        Object innerObj = aCED.getValue(cfCode);
        if (innerObj instanceof ConfigElementDataList && (cfList = (ConfigElementDataList)innerObj) != null) {
            AnnexControlFunction[] cfArray = new AnnexControlFunction[cfList.size()];
            cfList.toArray(cfArray);
            aCED.addParameter(cfCode, cfArray);
        }
        return super.changeParameterList(aCED);
    }

    @Override
    protected String canBeDeleted() {
        if (!this.getSrValueOf(this.getParameterCode(MasterParameterCode.DR_REPLICATION_STATE)).equals(DRReplicationStateConstant.INACTIVE)) {
            HashMap<ParameterCode, DRActivateConstant> map = new HashMap<ParameterCode, DRActivateConstant>();
            map.put(this.getParameterCode(MasterParameterCode.DR_ACTIVATE), DRActivateConstant.ABORT_REPLICATE);
            try {
                theLogger.logAndAssert(SrLogCategories.SYSTEM, "This method used to call", "changeElement in order to abort replication. This code was commented out ", "and should be reinspected in order to implement the correct behaviour. In the ", "meanwhile it should be regarded as a bug.");
                ErrorAssertingListener.listenTo(this.changeElement(map));
            }
            catch (IllegalValueException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void validAndActivate(ParameterList params) throws IllegalValueException {
        if (this.isLocal()) {
            Validator.getInstance().isValidAccordingToAlarm(this, params);
        }
    }

    public MasterParameter getActivateParameter() throws RemoteException, IllegalValueException {
        ParameterCode activateParameterCode = this.getActivateParameterCode();
        return new MasterParameter(activateParameterCode, this.getSrValueOf(activateParameterCode));
    }

    public MasterParameter getActivateInitialSyncStateParameter() throws RemoteException, IllegalValueException {
        ParameterCode activateParameterCode = this.getActivateParameterCode();
        return new MasterParameter(activateParameterCode, this.getSrValueOf(activateParameterCode));
    }

    public AlarmGenerator getElarmGenerator() {
        return null;
    }

    public DRModeConstant getMode() {
        return (DRModeConstant)this.getSrValueOf(this.getParameterCode(MasterParameterCode.DR_MODE));
    }

    public SrBITSConstant getReplicationState() throws RemoteException {
        return (SrBITSConstant)this.getSrValueOf(this.getParameterCode(MasterParameterCode.DR_REPLICATION_STATE));
    }

    public DRReplicationStateConstant getFailOverState() throws RemoteException {
        if (this.getReplicationState().contains(DRReplicationStateConstant.FALLBACK)) {
            return DRReplicationStateConstant.FALLBACK;
        }
        if (this.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
            return DRReplicationStateConstant.PLANNED_FAILOVER;
        }
        return null;
    }

    public abstract ParameterCode getActivateParameterCode() throws IllegalValueException;

    public abstract boolean isLocal();

    public abstract DRRoleConstant getRole();

    public boolean isDisasterOccured(MasterParameter param) throws RemoteException {
        ConfigElementData ced = this.buildCedForVswitch(this.getActiveVswitch(), new ParameterList(param));
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().readElement(ced));
        return !ced.getParametersList().get(param).equals(DRModeConstant.SWITCHED);
    }

    public DRRoleConstant getRoleAccordingToMode() throws RemoteException {
        if (this.getMode().equals(DRModeConstant.NORMAL)) {
            return DRRoleConstant.LOCAL;
        }
        if (this.getMode().equals(DRModeConstant.SWITCHED)) {
            return DRRoleConstant.REMOTE;
        }
        return null;
    }

    public GeneralLogicObject getDrSource() throws RemoteException {
        return DRRootImpl.getInstance().findDRObjectWithIdenticalElement(this);
    }

    public boolean isCfWaiting(VSwitch vswitch) throws RemoteException {
        AnnexControlFunction[] cf;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        if (cfCode != null && (cf = (AnnexControlFunction[])this.getParameter(vswitch, cfCode).getValue()) != null) {
            for (int i = 0; i < cf.length; ++i) {
                if (!cf[i].isWaiting()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCfWaiting() throws RemoteException {
        return this.isCfWaiting(this.getActiveVswitch());
    }

    public boolean isCfFail(VSwitch vswitch) throws RemoteException {
        AnnexControlFunction[] cf;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        if (cfCode != null && (cf = (AnnexControlFunction[])this.getParameter(vswitch, cfCode).getValue()) != null) {
            for (int i = 0; i < cf.length; ++i) {
                if (!cf[i].isFail()) continue;
                return true;
            }
        }
        return false;
    }

    public CFErrorReasonConstant getErrorReason(VSwitch vswitch) throws RemoteException {
        AnnexControlFunction[] cf;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        if (cfCode != null && (cf = (AnnexControlFunction[])this.getParameter(vswitch, cfCode).getValue()) != null) {
            for (int i = 0; i < cf.length; ++i) {
                if (cf[i].getReason().equals(CFErrorReasonConstant.NONE)) continue;
                return cf[i].getReason();
            }
            return CFErrorReasonConstant.NONE;
        }
        return null;
    }

    public CFErrorReasonConstant getErrorReason() throws RemoteException {
        return this.getErrorReason(this.getActiveVswitch());
    }

    public SrType getCfAction(VSwitch vswitch) throws RemoteException {
        AnnexControlFunction[] cf;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        if (cfCode != null && (cf = (AnnexControlFunction[])this.getParameter(vswitch, cfCode).getValue()) != null) {
            return cf[0].getAction();
        }
        return null;
    }

    public CFStateConstant getCfState(VSwitch vswitch) throws RemoteException {
        AnnexControlFunction[] cf;
        ParameterCode cfCode = this.getParameterCode(MasterParameterCode.CF);
        if (cfCode == null && (cf = (AnnexControlFunction[])this.getParameter(vswitch, cfCode).getValue()) != null) {
            return cf[0].getState();
        }
        return null;
    }

    public CFStateConstant getCfState() throws RemoteException {
        return this.getCfState(this.getActiveVswitch());
    }

    public SrType getCfAction() throws RemoteException {
        return this.getCfAction(this.getActiveVswitch());
    }

    public boolean isCfFail() throws RemoteException {
        return this.isCfFail(this.getActiveVswitch());
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        return 0;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public String getAlias(VSwitchImpl inSwitch) {
        return null;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        ConfigElementDataList cedList = new ConfigElementDataList();
        HashMap<CommKeyClassId, ConfigElementData> accumulator = new HashMap<CommKeyClassId, ConfigElementData>();
        ConfigElementData elem = this.buildCEDForSynchronization(cedList, accumulator);
        if (elem.getCommKeyClassId().getCommKeys() == null) {
            cedList.add(elem);
            cedList.add(SynchronizeableImpl.createCedForForceStateSync(this.getActiveVswitch()));
            ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().createElement(cedList));
        }
        return 0;
    }

    public boolean isInSwitchProcess() {
        return this.myIsInSwitchProcess;
    }

    public void setInSwitchProcess(boolean aIsISwitchProcess) {
        this.myIsInSwitchProcess = aIsISwitchProcess;
    }

    static {
        theLogger = null;
        theLogger = SrLogger.getLogger();
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

