/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.AliasObject;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DRClusterConsistencyGroupImpl
extends DRClusterAbstractConsistencyGroupImpl
implements DRClusterConsistencyGroup,
AliasObject {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    DRAliasConsistencyGroupImpl cg_alias = null;

    public DRClusterConsistencyGroupImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.CONSISTENCY_GROUP, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        ConfigElementData ced = new ConfigElementData(this.getClassId());
        this.cg_alias = new DRAliasConsistencyGroupImpl(this.getCluster(), this.getClassId(), ced);
    }

    @Override
    public void addPairToGroup(DRClusterAsyncPairImpl newPair) {
        if (this.m_pairs == null) {
            this.m_pairs = new ArrayList();
        }
        this.m_pairs.add(newPair);
    }

    @Override
    public DRClusterAsyncPair[] getPairs() {
        if (this.m_pairs == null) {
            return null;
        }
        DRClusterAsyncPair[] pairsArray = new DRClusterAsyncPair[this.m_pairs.size()];
        return this.m_pairs.toArray(pairsArray);
    }

    public void removePair(DRClusterAsyncPairImpl pair) {
        this.m_pairs.remove(pair);
    }

    public boolean isSameAlias(String aAlias) throws RemoteException {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length == 0) {
            return false;
        }
        for (VSwitchImpl vs : vSwitches) {
            if (aAlias.equals(this.getAlias(vs))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return this.cg_alias.isValid(parameterList);
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_PAIRS, this.getPairs());
        return parameterList;
    }

    @Override
    public String toString() {
        SrType alias = this.getSrValueOf(ParameterCode.DR_VIRT_GROUP_ALIAS);
        if (alias != null) {
            return alias.toString();
        }
        return super.toString();
    }

    @Override
    public String getAlias() {
        return this.cg_alias.getAlias();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return this.cg_alias.getAlias(vSwitch);
    }

    @Override
    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return this.cg_alias.checkAliasConsistencyBetweenVSwitches();
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        this.cg_alias.changeParameterList(aCED);
        return super.changeParameterList(aCED);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> list = new ArrayList<ParameterCode>();
        list.add(ParameterCode.DR_VIRT_GROUP_ALIAS);
        return list;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_VIRT_GROUP_ALIAS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }

    private static class DRAliasConsistencyGroupImpl
    extends AliasObjectImpl
    implements AliasObject {
        private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

        protected DRAliasConsistencyGroupImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
            super(cluster, classId, aCED);
            this.validateAndInit(aCED, theParameterCodeFlagsMap);
        }

        @Override
        protected String canBeDeleted() {
            return "Can't remove alias";
        }

        @Override
        protected String isValid(HashMap parameterList) {
            Object alias = parameterList.get(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS);
            if (alias != null && alias instanceof String) {
                String aliasValidator = this.isAliasValid((String)alias);
                if (aliasValidator != null) {
                    return aliasValidator;
                }
                if (DRRootImpl.getInstance().isAliasExist((String)alias)) {
                    return "a consistency group with this alias already exists";
                }
                parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS, new SrString((String)alias));
            }
            return null;
        }

        @Override
        public AlarmGenerator getAlarmGenerator() {
            return null;
        }

        @Override
        public void registerToPropagatedStateChange() {
        }

        @Override
        public String getAlias() {
            return (String)this.getValueOf(ParameterCode.DR_VIRT_GROUP_ALIAS);
        }

        @Override
        public String getAlias(VSwitchImpl vSwitch) {
            return (String)this.getValueOf(vSwitch, ParameterCode.DR_VIRT_GROUP_ALIAS);
        }

        static {
            HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
            parameterCodeFlagsMap.put(ParameterCode.DR_VIRT_GROUP_ALIAS, new ParameterCode.Flags(true, false));
            theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        }
    }
}

