/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.policies.PolicyImpl;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DRClusterAsyncPairImpl
extends DRClusterPairImpl
implements DRClusterAsyncPair {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;

    public DRClusterAsyncPairImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ASYNC_PAIR, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    public boolean matchToGroupID(CommKeyClassId groupId) throws RemoteException {
        return this.getGroupId().equals(groupId);
    }

    public CommKeyClassId getGroupId(VSwitchImpl vSwitch) throws RemoteException {
        return (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_ASYNC_PAIR_GROUP_ID, vSwitch == null);
    }

    public JournalVolumeImpl getJournal() throws RemoteException {
        CommKeyClassId jourID = this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        return (JournalVolumeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(jourID);
    }

    public SnapshotVolumeImpl getSnapshot() {
        CommKeyClassId snapID = this.getSnapshotId();
        if (snapID != null) {
            return (SnapshotVolumeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(snapID);
        }
        return null;
    }

    public CommKeyClassId getSnapshotId() {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
    }

    public CommKeyClassId getGroupId() throws RemoteException {
        return this.getCommKeyClassIdValueOf(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
    }

    public DRClusterAbstractConsistencyGroupImpl getGroup() throws RemoteException {
        CommKeyClassId groupId = this.getGroupId();
        return (DRClusterAbstractConsistencyGroupImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(groupId);
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public ParameterCode getActivateParameterCode() {
        return ParameterCode.DR_ASYNC_PAIR_ACTIVATE;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ConfigElementDataList list = new ConfigElementDataList();
        this.getCluster().prepareVSwitchIDs(ced, "prepare element for remove volume tree", this.getConnectedVSwitchesAsList());
        list.add(ced);
        if (DRRoleConstant.REMOTE.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, this.getPrimaryVolumeId());
            if (this.getSecondaryVolume().isProvisioned()) {
                SnapshotVolumeImpl sns = this.getSnapshot();
                if (sns != null) {
                    list.addAll(this.getSecondaryVolume().removeVolumeTree(sns));
                } else {
                    list.addAll(this.getSecondaryVolume().removeVolumeTree());
                }
            }
        } else if (DRRoleConstant.LOCAL.equals(this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, this.getSecondaryVolumeId());
        }
        CommKeyClassId groupId = this.getGroupId();
        ced.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, groupId);
        DRClusterAbstractConsistencyGroupImpl pairGroup = this.getGroup();
        if (pairGroup == null) {
            throw new IllegalStateException("GDR pair without CG, pair: " + this);
        }
        DRClusterAsyncPair[] allPairs = pairGroup.getPairs();
        if (allPairs != null && allPairs.length == 1) {
            list.add(new ConfigElementData(groupId));
        }
        return DataMgrAdapter.getInstance().removeElement(list);
    }

    public SrFuture<Void> refreshPiTs(DRPiT[] currentPits) throws RemoteException {
        VSwitchImpl[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            CommKeyClassId[] pitKeyList = new CommKeyClassId[currentPits.length];
            int i2 = currentPits.length;
            while (i2-- > 0) {
                pitKeyList[i2] = currentPits[i2].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(ClassID.DR_ASYNC_PAIR_PIT);
            element.setValue(ParameterCode.DR_PIT_PARENT_ID, this.getCommKeyClassId());
            element.addParameter(new Parameter(ParameterCode.DR_PIT_LIST, pitKeyList));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            return DataMgrAdapter.getInstance().refreshTableFields(element);
        }
        return new CompleteFuture<Void>("DRClusterAsyncPairImpl.refreshPits");
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        ConfigElementDataList list = this.synchronize(new HashMap<CommKeyClassId, ConfigElementData>());
        list.add(SynchronizeableImpl.createCedForForceStateSync(this.getActiveVswitch()));
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().createElement(list));
        return 0;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        params.add(ParameterCode.DR_PAIR_PRIMARY_ID);
        params.add(ParameterCode.DR_PAIR_SECONDARY_ID);
        params.add(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        params.add(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        params.add(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        return params;
    }

    @Override
    public ConfigElementDataList synchronize(Map<CommKeyClassId, ConfigElementData> accumulator) throws RemoteException, IllegalValueException {
        ConfigElementDataList cedList = new ConfigElementDataList();
        DRClusterAbstractConsistencyGroupImpl group = (DRClusterAbstractConsistencyGroupImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(this.getGroupId());
        theLogger.logAndAssert(SrLogCategories.ERROR, group != null, new Object[]{"a pair can NOT exist without a group."});
        ConfigElementData elem = this.buildCEDForSynchronization(cedList, accumulator);
        if (elem.getCommKeyClassId().getCommKeys() == null) {
            if (!(elem.getParametersList().get(ParameterCode.DR_ASYNC_PAIR_GROUP_ID) instanceof CommKeyClassId) && group.getClassId().equals(ClassID.EXTENDED_PAIR)) {
                elem.removeParameter(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
                elem.setClassId(ClassID.EXTENDED_PAIR);
                this.addParametersForAbstractCg(elem, group);
            } else if (this.getGroupId().getClassID().equals(ClassID.CONSISTENCY_GROUP)) {
                ConfigElementData element = (ConfigElementData)elem.getParametersList().get(ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
                this.addParametersForAbstractCg(element, group);
            }
            cedList.add(elem);
        }
        return cedList;
    }

    private ConfigElementData addParametersForAbstractCg(ConfigElementData elem, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        elem.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, group.getRole());
        PolicyImpl pitPolicy = (PolicyImpl)group.getPiTPolicy(this.getActiveVswitch());
        PolicyImpl transferPolicy = (PolicyImpl)group.getTransferPolicy(this.getActiveVswitch());
        PolicyImpl mergePolicy = (PolicyImpl)group.getMergePolicy(this.getActiveVswitch());
        DRRootImpl.getInstance().prepareElementPolicies(elem, pitPolicy.getClientParameterList(), transferPolicy.getClientParameterList(), mergePolicy.getClientParameterList(), this.getCluster());
        return elem;
    }

    static {
        theLogger = SrLogger.getLogger();
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_ACTIVATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_PARENT_LAST_UPDATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ASYNC_PAIR_CF, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

