/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterActivateImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DRClusterAbstractConsistencyGroupImpl
extends DRClusterActivateImpl
implements DRClusterAbstractConsistencyGroup {
    ArrayList<DRClusterAsyncPairImpl> m_pairs = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static int m_policiesIndex;
    private static final int PIT;
    private static final int TRANSFER;
    public static final int MERGE;

    protected DRClusterAbstractConsistencyGroupImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    private static int increment() {
        return m_policiesIndex++;
    }

    public boolean isEmpty() {
        DRClusterAsyncPair[] pairs = this.getPairs();
        return pairs == null || pairs.length == 0;
    }

    public boolean equalsInCluster(HashMap parameterList) throws RemoteException {
        DRRoleConstant newRole;
        CommKeyClassId newVSwitchId;
        int numOfVswitches = this.getConnectedVSwitchCounter();
        if (numOfVswitches != 1) {
            return false;
        }
        VSwitchImpl vSwitch = this.getActiveVswitch();
        CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
        if (vSwitchId.equals(newVSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID))) {
            return false;
        }
        DRRoleConstant myRole = this.getRole();
        if (myRole != (newRole = (DRRoleConstant)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_ROLE))) {
            return false;
        }
        Policy[] currPolicies = this.getPoliciesByParameters(vSwitch);
        Policy[] compareToPolicies = this.getPoliciesByParameterList(parameterList);
        return this.allPoliciesEqual(currPolicies, compareToPolicies);
    }

    private boolean allPoliciesEqual(Policy[] myPolicies, Policy[] otherPolicies) throws RemoteException {
        for (int i = 0; i < myPolicies.length; ++i) {
            Policy myCurrPolicy = myPolicies[i];
            Policy otherCurrPolicy = otherPolicies[i];
            if (this.policiesEqual(myCurrPolicy, otherCurrPolicy)) continue;
            return false;
        }
        return true;
    }

    private boolean policiesEqual(Policy pol1, Policy pol2) {
        if (pol1 != null && pol2 != null) {
            return pol1.equals(pol2);
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        return this.getRole().equals(DRRoleConstant.LOCAL);
    }

    @Override
    public DRRoleConstant getRole() {
        return (DRRoleConstant)this.getSrValueOf(ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
    }

    public long getPendingPiTs() throws RemoteException {
        BigInteger pendingPiTs = (BigInteger)this.getValueOf(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
        if (pendingPiTs != null) {
            return pendingPiTs.longValue();
        }
        return 0L;
    }

    public void addPair(DRClusterAsyncPairImpl newPair) throws IllegalValueException {
        this.addPairToGroup(newPair);
    }

    public Policy getPiTPolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId pitStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
            CommKeyClassId pitParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID);
            if (pitStartKey != null && pitParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, pitStartKey, pitParamsKey);
            }
        }
        return null;
    }

    public Policy getTransferPolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId transferStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
            CommKeyClassId transferParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID);
            if (transferStartKey != null && transferParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, transferStartKey, transferParamsKey);
            }
        }
        return null;
    }

    public Policy getMergePolicy(VSwitch vSwitch) throws RemoteException {
        if (vSwitch != null) {
            CommKeyClassId vSwitchId = vSwitch.getCommKeyClassId();
            CommKeyClassId mergeStartKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
            CommKeyClassId mergeParamsKey = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID);
            if (mergeStartKey != null && mergeParamsKey != null) {
                return PoliciesManager.getInstance().getPolicy(vSwitchId, mergeStartKey, mergeParamsKey);
            }
        }
        return null;
    }

    protected Policy[] getPoliciesByParameters(VSwitch vSwitch) throws RemoteException {
        return new Policy[]{this.getPiTPolicy(vSwitch), this.getTransferPolicy(vSwitch), this.getMergePolicy(vSwitch)};
    }

    protected Policy[] getPoliciesByParameterList(HashMap parameterList) throws RemoteException {
        CommKeyClassId vSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        CommKeyClassId pitStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        CommKeyClassId pitParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID);
        CommKeyClassId transferStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        CommKeyClassId transferParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID);
        CommKeyClassId mergeStartKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        CommKeyClassId mergeParamsKey = (CommKeyClassId)parameterList.get(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID);
        return this.createPoliciesInArray(vSwitchId, pitStartKey, pitParamsKey, transferStartKey, transferParamsKey, mergeStartKey, mergeParamsKey);
    }

    private Policy[] createPoliciesInArray(CommKeyClassId vSwitchId, CommKeyClassId pitStartKey, CommKeyClassId pitParamsKey, CommKeyClassId transferStartKey, CommKeyClassId transferParamsKey, CommKeyClassId mergeStartKey, CommKeyClassId mergeParamsKey) throws RemoteException {
        Policy[] policies = new Policy[m_policiesIndex];
        policies[DRClusterAbstractConsistencyGroupImpl.PIT] = PoliciesManager.getInstance().getPolicy(vSwitchId, pitStartKey, pitParamsKey);
        policies[DRClusterAbstractConsistencyGroupImpl.TRANSFER] = PoliciesManager.getInstance().getPolicy(vSwitchId, transferStartKey, transferParamsKey);
        policies[DRClusterAbstractConsistencyGroupImpl.MERGE] = PoliciesManager.getInstance().getPolicy(vSwitchId, mergeStartKey, mergeParamsKey);
        return policies;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        Object ive = null;
        HashMap repPolicy = null;
        HashMap transferPolicy = null;
        HashMap mergePolicy = null;
        ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
        String msg = this.isValid(parameterList);
        for (ClientParameterCode currParam : parameterList.keySet()) {
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY)) {
                repPolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY)) {
                transferPolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (currParam.equals(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY)) {
                mergePolicy = (HashMap)parameterList.get(currParam);
                continue;
            }
            if (msg == null) {
                ParameterCode currCode = currParam.getParameterCode();
                if (currCode == null) continue;
                Parameter currParameter = new Parameter(currCode, parameterList.get(currParam));
                ced.addParameter(currParameter);
                continue;
            }
            throw new IllegalValueException(msg);
        }
        DRRootImpl.getInstance().prepareElementPolicies(ced, repPolicy, transferPolicy, mergePolicy, this.getCluster());
        if (!ced.getParametersList().isEmpty()) {
            return DataMgrAdapter.getInstance().changeElement(ced);
        }
        if (ive != null) {
            throw ive;
        }
        return new CompleteFuture<Void>("DRClusterAbstractConsistencyGroupImpl.changeElement");
    }

    public abstract DRClusterAsyncPair[] getPairs();

    public abstract void addPairToGroup(DRClusterAsyncPairImpl var1) throws IllegalValueException;

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        VSwitchImpl vs = this.getActiveVswitch();
        HashMap parameterList = super.getClientParameterList();
        if (vs != null) {
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY, this.getPiTPolicy(vs));
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY, this.getTransferPolicy(vs));
            parameterList.put(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY, this.getMergePolicy(vs));
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "No ", ClassID.VSWITCH, " found for ", this);
        }
        return parameterList;
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        if (this.getPairs() == null || this.getPairs().length == 0 || this.getConnectedVSwitches().length == 1) {
            return super.getDominantVswitch();
        }
        return ((LogicObjectImpl)((Object)this.getPairs()[0])).getDominantVswitch();
    }

    @Override
    public ParameterCode getActivateParameterCode() {
        return ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE;
    }

    public boolean comparePolicies() throws RemoteException {
        Policy mergePolicy = this.getMergePolicy(this.getActiveVswitch());
        Policy transferPolicy = this.getTransferPolicy(this.getActiveVswitch());
        Policy pitPolicy = this.getPiTPolicy(this.getActiveVswitch());
        if (mergePolicy == null || pitPolicy == null || transferPolicy == null) {
            return false;
        }
        return mergePolicy.equals(this.getMergePolicy(this.getInactiveVSwitch())) && pitPolicy.equals(this.getPiTPolicy(this.getInactiveVSwitch())) && transferPolicy.equals(this.getTransferPolicy(this.getInactiveVSwitch()));
    }

    public boolean isPairEquals(DRClusterAbstractConsistencyGroupImpl group) {
        if (this.hasNoPairs() || group.hasNoPairs()) {
            return false;
        }
        return Arrays.equals(this.getPairs(), group.getPairs());
    }

    public boolean hasNoPairs() {
        return this.m_pairs == null;
    }

    public SrFuture<Void> refreshPiTs(DRPiT[] currentPits) throws RemoteException {
        VSwitchImpl[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            CommKeyClassId[] pitKeyList = new CommKeyClassId[currentPits.length];
            int i2 = currentPits.length;
            while (i2-- > 0) {
                pitKeyList[i2] = currentPits[i2].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(ClassID.DR_CONSISTENCY_GROUP_PIT);
            element.setValue(ParameterCode.DR_PIT_PARENT_ID, this.getCommKeyClassId());
            element.addParameter(new Parameter(ParameterCode.DR_PIT_LIST, pitKeyList));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            return DataMgrAdapter.getInstance().refreshTableFields(element);
        }
        return new CompleteFuture<Void>("DRClusterAbstractConsistencyGroupImpl.refreshPiTs");
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        DRClusterAsyncPair[] pairs = this.getPairs();
        HashMap<CommKeyClassId, ConfigElementData> accumulator = new HashMap<CommKeyClassId, ConfigElementData>();
        ConfigElementDataList[] pairLists = new ConfigElementDataList[pairs.length + 1];
        for (int i = 0; i < pairs.length; ++i) {
            pairLists[i] = ((DRClusterAsyncPairImpl)pairs[i]).synchronize(accumulator);
        }
        pairLists[pairs.length] = new ConfigElementDataList(SynchronizeableImpl.createCedForForceStateSync(this.getActiveVswitch()));
        for (ConfigElementDataList curList : pairLists) {
            ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().createElement(curList));
        }
        return 0;
    }

    @Override
    protected ArrayList getAdditionalDependantObjectsForSynchronization() throws RemoteException {
        ArrayList list = super.getAdditionalDependantObjectsForSynchronization();
        JournalVolumeImpl journal = ((DRClusterAsyncPairImpl)this.getPairs()[0]).getJournal();
        if (JournalVolumeActivityConstants.INACTIVE.equals(journal.getActivityState(this.getActiveVswitch().getCommKeyClassId()))) {
            list.add(journal);
        }
        return list;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_VIRT_GROUP_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_MODE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_PIT_PARENT_LAST_UPDATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CONSISTENCY_GROUP_CF, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        m_policiesIndex = 0;
        PIT = DRClusterAbstractConsistencyGroupImpl.increment();
        TRANSFER = DRClusterAbstractConsistencyGroupImpl.increment();
        MERGE = DRClusterAbstractConsistencyGroupImpl.increment();
    }
}

