/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.util.concurrent.DefaultFutureListener;
import java.rmi.RemoteException;

public class NeighborUpdater {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster;
    private String myDescription;

    public NeighborUpdater(ClusterImpl aCluster, String aDescription) {
        this.myCluster = aCluster;
        this.myDescription = aDescription;
        theLogger.info(SrLogCategories.NEIGHBOR_DB, "Created a neighbor updater for cluster ", aCluster);
    }

    public String toString() {
        String retVal = "neighbor updater. Instanciated by " + this.myDescription;
        retVal = this.myCluster.getAlias() + " " + retVal;
        return retVal;
    }

    public void discoverComplete(ClusterImpl aCluster) {
        if (!this.myCluster.equals(aCluster)) {
            return;
        }
        theLogger.info(SrLogCategories.NEIGHBOR_DB, "Setting the neighbors in cluster ", aCluster);
        try {
            DefaultFutureListener.listenTo(new Runnable(){

                @Override
                public void run() {
                    theLogger.info(SrLogCategories.NEIGHBOR_DB, "Updating the DB for cluster ", NeighborUpdater.this.myCluster);
                    LogicMgrAOImpl.getInstance().updateDB(LogicMgrAOImpl.DB_UPDATE_DELAY, NeighborUpdater.this.myCluster);
                }
            }, aCluster.setNeighborsInCluster());
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "A remote exception has occured inside a server context.");
        }
    }
}

