/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.jmx.SrMBean;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImplJmxMBean;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ClusterImplJmx
extends SrMBean
implements ClusterImplJmxMBean {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster;
    private static final String NOT_REMOVABLE_IP = "myNotRemovableIP";
    private Field myNotRemovable;

    public ClusterImplJmx(ClusterImpl aCluster) {
        super("ClusterImpl [" + aCluster.getAlias() + "(" + aCluster.getCommKeyClassId() + ")" + "]");
        this.myCluster = aCluster;
        try {
            this.myNotRemovable = this.myCluster.getClass().getDeclaredField(NOT_REMOVABLE_IP);
        }
        catch (SecurityException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access ClusterImpl through reflection.");
        }
        catch (NoSuchFieldException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access ClusterImpl through reflection.");
        }
        this.myNotRemovable.setAccessible(true);
    }

    @Override
    public String getNotRemovableVswitch() {
        try {
            Object retVal = this.myNotRemovable.get(this.myCluster);
            if (retVal == null) {
                return "None";
            }
            return (String)retVal;
        }
        catch (SecurityException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
            return "Reflection Error";
        }
        catch (IllegalArgumentException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
            return "Reflection Error";
        }
        catch (IllegalAccessException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
            return "Reflection Error";
        }
    }

    @Override
    public List<String> getVSwitchesIPs() {
        List<VSwitchImpl> allVSs = this.myCluster.getVSwitches();
        ArrayList<String> retVal = new ArrayList<String>(allVSs.size());
        for (VSwitchImpl curVS : allVSs) {
            retVal.add(curVS.getName());
        }
        return retVal;
    }

    @Override
    public boolean isDiscoverCompleted() throws RemoteException {
        return this.myCluster.isDiscoverCompleted();
    }

    @Override
    public void setNotRemovableVswitch(String notRemovableVswitch) {
        try {
            String valToSet = notRemovableVswitch;
            if ("".equals(notRemovableVswitch.trim())) {
                valToSet = null;
            }
            this.myNotRemovable.set(this.myCluster, valToSet);
        }
        catch (SecurityException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
        }
        catch (IllegalArgumentException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
        }
        catch (IllegalAccessException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not access the field ", NOT_REMOVABLE_IP, " of cluster ", this.myCluster);
        }
    }
}

