/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.alarm.GeneralAlarmMgrImpl;
import com.sanrad.nms.server.alarm.cluster.ClusterAlarmGenerator;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrChangeElementEvent;
import com.sanrad.nms.server.event.SrCheckListEvent;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrElementOperationErrorEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventObject;
import com.sanrad.nms.server.event.SrTrapEvent;
import com.sanrad.nms.server.event.SrVSwitchMessageEvent;
import com.sanrad.nms.server.logic.AliasSynchronizer;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.CreationDeletionDependencyMgr;
import com.sanrad.nms.server.logic.DBCorruptionMgr;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.acl.PolicyManagerImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImplJmx;
import com.sanrad.nms.server.logic.cluster.EventQueueElement;
import com.sanrad.nms.server.logic.cluster.NeighborUpdater;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterManager;
import com.sanrad.nms.server.logic.dr.DREvent;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.IdentitiesList;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.identity.IdentityValidator;
import com.sanrad.nms.server.logic.identity.SRPCredentialsImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatisticsImpl;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPortImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnectionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstanceImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatisticsImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.policies.PolicyParamTableEntryImpl;
import com.sanrad.nms.server.logic.policies.PolicyTableEntryImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.logic.raid.AttachedRaidImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaidsMgr;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.scsi.SCSIISCSIDeviceMap;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerList;
import com.sanrad.nms.server.logic.srv.isns.ISNSServerImpl;
import com.sanrad.nms.server.logic.srv.isns.ISNSServerValidator;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerImpl;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerValidator;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgrImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.storage.StoragePoolMgr;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.RemoteTargetList;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.target.TargetQosGroup;
import com.sanrad.nms.server.logic.target.TargetQosGroupImpl;
import com.sanrad.nms.server.logic.target.TargetQosMgr;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotScheduler;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotSchedulerImpl;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotSchedulerMgr;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.ManagerImpl;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCNodeImpl;
import com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatisticsImpl;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.VSwitchClusterMap;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrNumber;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchCapabilityConstant;
import com.sanrad.util.SrPostponedExecutor;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;

public class ClusterImpl
extends VSwitchGroupImpl
implements Cluster,
VSwitchConnectivityListener {
    private ClusterDebugObject myDebugObj = null;
    private ClusterImplJmx myBean = null;
    private SrFuture<Void> myRediscoverFuture = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private boolean myIsAddNeighborContext = false;
    private String myNotRemovableIP = null;
    private String myRemovedInconsistentNeighborName = null;
    private static final String ALIAS_PREFIX = "Stor";
    public static final int MAX_VSWITCHES_IN_CLUSTER = 2;
    private StorageImpl storage;
    private ArrayList<VSwitchImpl> myVSwitches = new ArrayList();
    private boolean clusterDiscoveryCompleted = false;
    private GeneralAlarmMgrImpl alarmMgr = AlarmMgrImpl.getInstance();
    private GeneralAlarmMgrImpl drAlarmMgr = DrAlarmMgrImpl.getInstance();
    private PolicyManagerImpl policyMgr = new PolicyManagerImpl();
    private TargetQosMgr myTargetQosMgr = new TargetQosMgr(this);
    private AttachedRaidsMgr myAttachedRaidMgr = new AttachedRaidsMgr(this);
    private SnapshotSchedulerMgr mySnapshotSchedulerMgr = new SnapshotSchedulerMgr(this);
    private Vector<VSwitchConnectivityListener> vSwitchConnectivityListeners = new Vector();
    private CopyOperationManagerImpl copyOperMgr = new CopyOperationManagerImpl(this);
    private IdentitiesList identities = new IdentitiesList();
    private ExternalServerList radiusServerList = new ExternalServerList();
    private ExternalServerList isnsServerList = new ExternalServerList();
    private DBCorruptionMgr myCorruptionMgr = new DBCorruptionMgr(this);
    private CreationDeletionDependencyMgr myDependencyMgr = new CreationDeletionDependencyMgr(this);
    private CommKeyRefMap myCommKeyRefMap = new CommKeyRefMap();
    private boolean synchronizeClusterParametersDone = false;
    private HashMap<CommKeyClassId, ConfigElementData> pendingNewElements = new HashMap();
    private SCSIISCSIDeviceMap m_scsiDeviceIscsiNodeMap = new SCSIISCSIDeviceMap();
    private DRClusterManager drManager = new DRClusterManager(this);
    private SrBITSConstant m_capability = VSwitchCapabilityConstant.getMinimalCapability();
    private boolean myIsNeedRestartRediscovery = false;

    public ClusterImpl(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(ClassID.CLUSTER, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.storage = new StorageImpl(this);
        this.toStringValue = ClassID.CLUSTER.toString();
        this.cluster = this;
        this.myDebugObj = new ClusterDebugObject(this.getAlias());
    }

    public DRClusterManager getDRManager() {
        return this.drManager;
    }

    public DBCorruptionMgr getCorruptionMgr() {
        return this.myCorruptionMgr;
    }

    public void addVSwitchConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.add(listener);
    }

    public void removeVSwitchConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.remove(listener);
    }

    private void fireVSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        Iterator<VSwitchConnectivityListener> itr = this.vSwitchConnectivityListeners.iterator();
        while (itr.hasNext()) {
            itr.next().vSwitchConnectivityChanged(event);
        }
    }

    @Override
    public void vSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        this.fireVSwitchConnectivityChanged(event);
    }

    @Override
    public StorageImpl getStorage() {
        return this.storage;
    }

    @Override
    public CommKeyRefMap getCommKeyRefMap() {
        return this.myCommKeyRefMap;
    }

    @Override
    public boolean isDiscoverCompleted() {
        if (!this.isClusterDiscoveryCompleted()) {
            return false;
        }
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (vSwitch.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isDiscoverOfOtherVSwitchesCompleted(VSwitch thisVSwitch) throws RemoteException {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (thisVSwitch.equals(vSwitch) || vSwitch.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<VSwitchImpl> getVSwitches() {
        return this.myVSwitches;
    }

    public VSwitchImpl getMyNeighbor(String myIp) {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            Vector<NeighborImpl> neighbors = vSwitch.getNeighborTable();
            for (NeighborImpl neighbor : neighbors) {
                if (!neighbor.getIPAddress().equals(myIp)) continue;
                return vSwitch;
            }
        }
        return null;
    }

    public Vector<NeighborImpl> getNeighbors() throws RemoteException {
        Vector<NeighborImpl> neighbors = new Vector<NeighborImpl>();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            neighbors.addAll(vSwitch.getNeighborTable());
        }
        return neighbors;
    }

    public List<ISCSITargetImpl> getTargetsExposedOnVSwitch(VSwitchImpl vSwitch) {
        return this.getTargetListMgr().getTargetsExposedOnVSwitch(vSwitch.getName());
    }

    public List<ISCSITargetImpl> getOtherVSwitchTargetsExposedOnVSwitch(VSwitchImpl exposedOnVSwitch) {
        VSwitchImpl other = this.getOtherVSwitch(exposedOnVSwitch);
        if (other == null) {
            return this.getTargetsExposedOnVSwitch(exposedOnVSwitch);
        }
        return this.getTargetListMgr().getTargetsExposedOnVSwitch(other, exposedOnVSwitch.getName());
    }

    @Override
    public VSwitchImpl getOtherVSwitch(VSwitch vSwitch) throws RemoteException {
        VSwitchImpl vSwitchImpl = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitch.getCommKeyClassId());
        return this.getOtherVSwitch(vSwitchImpl);
    }

    @Override
    public VSwitchImpl getOtherVSwitch(VSwitchImpl aVswitch) {
        if (aVswitch == null) {
            return null;
        }
        for (VSwitchImpl otherVSwitch : this.getVSwitches()) {
            if (aVswitch.equals(otherVSwitch)) continue;
            return otherVSwitch;
        }
        return null;
    }

    public boolean isVSwitchNameExistOnOtherVSwitch(String name, String myIpAddress) throws RemoteException {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (myIpAddress.equals(vSwitch.getMgmIPAddr()) || !vSwitch.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainVSwitch(String vSwitchIp) throws RemoteException {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (vSwitch.getMgmIPAddr().equals(vSwitchIp)) {
                return true;
            }
            for (NeighborImpl neighbor : vSwitch.getNeighborTable()) {
                if (!neighbor.getIPAddress().equals(vSwitchIp)) continue;
                return true;
            }
        }
        return false;
    }

    public ISCSISessionImpl getISCSISessionActiveForRemoteInitiator(String iscsiRemoteInitiatorName) throws RemoteException {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            Enumeration<ISCSISessionImpl> n = vSwitch.getISCSISessionsTable().elements();
            while (n.hasMoreElements()) {
                ISCSISessionImpl session = n.nextElement();
                if (!session.getInitiatorName().equals(iscsiRemoteInitiatorName)) continue;
                return session;
            }
        }
        return null;
    }

    public boolean isVSwitchNameExist(String name) {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (!vSwitch.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<VSwitchImpl> getOtherVSwitches(List<VSwitchImpl> vSwitches) {
        ArrayList<VSwitchImpl> otherVSwitches = new ArrayList<VSwitchImpl>();
        for (VSwitchImpl vSwitch : vSwitches) {
            for (VSwitchImpl next : this.myVSwitches) {
                if (next.equals(vSwitch)) continue;
                otherVSwitches.add(next);
            }
        }
        return otherVSwitches;
    }

    private VSwitchImpl getVSwitch(ClassID classId, CommKey[] commKeys, ConfigElementData aCED) throws RemoteException {
        CommKeyClassId vSwitchCommKeyClassId = null;
        if (classId.equals(ClassID.VSWITCH)) {
            vSwitchCommKeyClassId = new CommKeyClassId(commKeys, classId);
        } else {
            Object vSwitchObj = aCED.getValue(ParameterCode.VSWITCH_ID);
            if (vSwitchObj instanceof CommKeyClassId) {
                vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            } else if (vSwitchObj != null) {
                vSwitchCommKeyClassId = ((CommKeyClassId[])vSwitchObj)[0];
                theLogger.trace(SrLogCategories.LEGACY, "ParameterCode.VSWITCH_ID shouldn't be an array");
            }
        }
        if (vSwitchCommKeyClassId != null) {
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        theLogger.trace(SrLogCategories.LEGACY, "No ", ClassID.VSWITCH, " found for ", classId, " with commkeys ", commKeys[0]);
        return null;
    }

    public VSwitchImpl getVSwitchUnderTakeover() {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (!vSwitch.isUnderTakeover()) continue;
            return vSwitch;
        }
        return null;
    }

    public VSwitchImpl getVSwitchByName(String name) {
        String neighborName;
        Vector<NeighborImpl> neighbors;
        VSwitchImpl vSwitch;
        VSwitchImpl vSwitchNeighbor;
        for (VSwitchImpl vSwitch2 : this.myVSwitches) {
            if (!vSwitch2.getName().equals(name)) continue;
            return vSwitch2;
        }
        if (this.myVSwitches.size() > 1 && this.getConnectedVSwitchCounter() > 0 && (vSwitchNeighbor = this.getMyNeighbor((vSwitch = this.getConnectedVSwitches()[0]).getMgmIPAddr())) != null && (neighbors = vSwitchNeighbor.getNeighborTable()) != null && !neighbors.isEmpty() && (neighborName = neighbors.firstElement().getName()).equals(name)) {
            return vSwitch;
        }
        return null;
    }

    public VSwitchImpl getVSwitchByIPAddress(String aIpAddr) {
        for (VSwitchImpl curVS : this.myVSwitches) {
            if (!curVS.getMgmIPAddr().equals(aIpAddr)) continue;
            return curVS;
        }
        return null;
    }

    @Override
    public SrFuture<Void> createIdentity(String alias, String description) throws RemoteException, IllegalValueException {
        IdentityValidator identityValidator = new IdentityValidator(this, alias, description);
        if (!identityValidator.isValid()) {
            throw new IllegalValueException(identityValidator.getErrorMsg());
        }
        return this.createIdentity(alias, description, null, null, null, null);
    }

    public SrFuture<Void> createIdentity(String alias, String description, List<VSwitchImpl> vSwitches, IdentityPurposeConstant purpose) throws RemoteException, IllegalValueException {
        return this.createIdentity(alias, description, vSwitches, purpose, null, null);
    }

    private SrFuture<Void> createIdentity(String alias, String description, List<VSwitchImpl> vSwitches, IdentityPurposeConstant purpose, ArrayList identityNames, Target targetForACL) throws RemoteException, IllegalValueException {
        boolean setUniqueAlias;
        ConfigElementData element = new ConfigElementData(ClassID.IDENTITY);
        Parameter identityPurpose = new Parameter(ParameterCode.IDENTITY_PURPOSE, purpose == null ? IdentityPurposeConstant.UNKNOWN : purpose);
        element.addParameter(identityPurpose);
        IdentityPurposeConstant setPurpose = (IdentityPurposeConstant)identityPurpose.getValue();
        String setAlias = alias;
        boolean bl = setUniqueAlias = !setPurpose.equals(IdentityPurposeConstant.REMOTE_TARGET) && !setPurpose.equals(IdentityPurposeConstant.LOCAL_TARGET) && !setPurpose.equals(IdentityPurposeConstant.UNKNOWN);
        if (setUniqueAlias && (vSwitches == null || vSwitches.containsAll(this.myVSwitches))) {
            StringBuffer sb = new StringBuffer(setAlias);
            String currTime = String.valueOf(System.currentTimeMillis());
            sb.append(currTime);
            setAlias = sb.toString();
        }
        Parameter identityAlias = new Parameter(ParameterCode.IDENTITY_ALIAS, new SrString(setAlias));
        element.addParameter(identityAlias);
        Parameter identityDescription = new Parameter(ParameterCode.IDENTITY_DESCRIPTION, new SrString(description));
        element.addParameter(identityDescription);
        if (identityNames != null) {
            if (setPurpose.equals(IdentityPurposeConstant.REMOTE_INITIATOR_DR)) {
                if (this.getIdentitiesList().isDrIdentityOnPendingCreateForInitiatorNames(identityNames)) {
                    return new CompleteFuture<Void>("ClusterImpl.createIdentity");
                }
                this.getIdentitiesList().addDrIdentityPendingCreateForInitiatorNames(setAlias, identityNames);
            }
            SrString[] names = new SrString[identityNames.size()];
            for (int index = 0; index < identityNames.size(); ++index) {
                String nameStr = (String)identityNames.get(index);
                names[index] = new SrString(nameStr);
            }
            Parameter identityNamesParameter = new Parameter(ParameterCode.IDENTITY_NAMES, names);
            element.addParameter(identityNamesParameter);
        }
        if (targetForACL != null) {
            Parameter targetForACLParameter = new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, targetForACL.getCommKeyClassId());
            element.addParameter(targetForACLParameter);
        }
        return this.createElement(element, ClassID.IDENTITY, setAlias, vSwitches);
    }

    @Override
    public SrFuture<Void> createRadiusServer(String serverIp, String port, String key) throws RemoteException, IllegalValueException {
        RadiusServerValidator radiusServerValidator = new RadiusServerValidator(this, serverIp, port, key);
        if (!radiusServerValidator.isValid()) {
            throw new IllegalValueException(radiusServerValidator.getErrorMsg());
        }
        return this.createRadiusServer(serverIp, port, key, null);
    }

    public SrFuture<Void> createRadiusServer(String serverIp, String port, String key, List<VSwitchImpl> vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.RADIUS_SERVER);
        Parameter serverIpParam = new Parameter(ParameterCode.RADIUS_SERVER_IP_ADDRESS, new SrIpAddress(serverIp));
        element.addParameter(serverIpParam);
        Parameter serverPortParam = new Parameter(ParameterCode.RADIUS_SERVER_PORT, new SrInteger(port));
        element.addParameter(serverPortParam);
        Parameter serverKeyParam = new Parameter(ParameterCode.RADIUS_SERVER_KEY, new SrString(key));
        element.addParameter(serverKeyParam);
        return this.createElement(element, ClassID.RADIUS_SERVER, serverIp, vSwitches);
    }

    @Override
    public SrFuture<Void> createISNSServer(String serverIp) throws RemoteException, IllegalValueException {
        ISNSServerValidator isnsServerValidator = new ISNSServerValidator(this, serverIp);
        if (!isnsServerValidator.isValid()) {
            throw new IllegalValueException(isnsServerValidator.getErrorMsg());
        }
        return this.createISNSServer(serverIp, null);
    }

    public SrFuture<Void> createISNSServer(String serverIp, List<VSwitchImpl> vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.ISNS_SERVER);
        Parameter serverIpParam = new Parameter(ParameterCode.ISNS_SERVER_IP_ADDRESS, new SrIpAddress(serverIp));
        element.addParameter(serverIpParam);
        return this.createElement(element, ClassID.ISNS_SERVER, serverIp, vSwitches);
    }

    public SrFuture<Void> addVSwitch(VSwitchImpl vSwitch) throws RemoteException, IllegalValueException {
        return this.addVSwitch(vSwitch.getMgmIPAddr(), vSwitch.getMgmMask(), vSwitch.getSnmpPort(), vSwitch.getTrapPort(), vSwitch.getReadCommunity(), vSwitch.getWriteCommunity(), vSwitch.getTimeout(), vSwitch.getNumberOfRetries(), vSwitch.getSnmpVersion());
    }

    @Override
    public SrFuture<Void> addVSwitch(String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumberOfRetries, SnmpVersion aSnmpVersion) throws RemoteException, IllegalValueException {
        if (this.getVSwitchesCount() == 1 && !this.getVSwitches().get(0).isConnected()) {
            return new FailedFuture<Void>(new IllegalStateException(Server.BUNDLE.getString(SrServerBundleKeys.ADD_VS_DISCONNECTED_VALIDATION)), "ClusterImpl.addVSwitch");
        }
        if (this.getVSwitchesCount() < 2) {
            VSwitchValidator validator = new VSwitchValidator(this, aIpAddr, aMask, aReadCommunity, aWriteCommunity);
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            VSwitchImpl vSwitch = this.getVSwitchByIPAddress(aIpAddr);
            if (vSwitch == null) {
                ConfigElementData element = new ConfigElementData(ClassID.VSWITCH);
                element.addParameter(new Parameter(ParameterCode.VSWITCH_GROUP_ID, new SrInteger(this.getVSwitchGroupId())));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_IP_ADDRESS, new SrIpAddress(aIpAddr)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_IP_MASK, new SrIpAddress(aMask)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_READ_COMMUNITY, new SrString(aReadCommunity)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_WRITE_COMMUNITY, new SrString(aWriteCommunity)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_SNMP_UDP_PORT, new SrInteger(aSnmpPort)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_TRAP_UDP_PORT, new SrInteger(aTrapPort)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_SNMP_VERSION, aSnmpVersion));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_MAX_RETRIES, new SrInteger(aNumberOfRetries)));
                element.addParameter(new Parameter(ParameterCode.VSWITCH_TIMEOUT, new SrLong(aTimeout)));
                SrNumber pollIntervalValue = null;
                Parameter pollInterval = null;
                pollInterval = this.getParameter((VSwitch)null, ParameterCode.GENERAL_POLL_INTERVAL);
                if (pollInterval != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.GENERAL_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.ISCSI_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.ISCSI_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.VIRTUALIZATION_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.ACL_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.ACL_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.NET_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.NET_POLL_INTERVAL, pollIntervalValue));
                }
                if ((pollInterval = this.getParameter((VSwitch)null, ParameterCode.STATISTIC_POLL_INTERVAL)) != null && (pollIntervalValue = (SrNumber)pollInterval.getValue()) != null) {
                    element.addParameter(new Parameter(ParameterCode.STATISTIC_POLL_INTERVAL, pollIntervalValue));
                }
                this.setRemovedInconsistentNeighborName(null);
                if (this.getNotRemovableVswitch() == null) {
                    this.setNotRemovableVswitch(aIpAddr);
                }
                return this.createElement(element, ClassID.VSWITCH, aIpAddr, new Vector<VSwitchImpl>());
            }
        } else {
            String msg = "You cannot manage more than 2 " + VSwitch.VSWITCHES_DISPLAY_STRING + " within a cluster";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        return new CompleteFuture<Void>("ClusterImpl.addVSwitch");
    }

    private void synchronizeClusterParameters() throws RemoteException {
        VSwitchImpl vSwitch2;
        VSwitchImpl vSwitch1;
        if (!this.synchronizeClusterParametersDone && this.myVSwitches.size() > 1 && (vSwitch1 = this.myVSwitches.get(0)).isNeighborOf(vSwitch2 = this.myVSwitches.get(1)) && vSwitch2.isNeighborOf(vSwitch1)) {
            Integer keepAliveInterval1 = vSwitch1.getKeepAliveInterval();
            Integer suspiciousInterval1 = vSwitch1.getSuspiciousInterval();
            Integer faultyInterval1 = vSwitch1.getFaultyInterval();
            Boolean failoverEnable1 = vSwitch1.isFailoverEnable();
            Integer keepAliveInterval2 = vSwitch2.getKeepAliveInterval();
            Integer suspiciousInterval2 = vSwitch2.getSuspiciousInterval();
            Integer faultyInterval2 = vSwitch2.getFaultyInterval();
            Boolean failoverEnable2 = vSwitch2.isFailoverEnable();
            HashMap<ClientParameterCode, Boolean> parameterList1 = new HashMap<ClientParameterCode, Boolean>();
            HashMap<ClientParameterCode, Constable> parameterList2 = new HashMap<ClientParameterCode, Constable>();
            if (keepAliveInterval1 != null && keepAliveInterval2 != null && keepAliveInterval1.compareTo(keepAliveInterval2) != 0) {
                StringBuffer debugMsg = new StringBuffer("Keep-Alive-Interval ");
                debugMsg.append(keepAliveInterval1);
                debugMsg.append(" in " + ClassID.VSWITCH + " ");
                debugMsg.append(vSwitch1);
                debugMsg.append(" is different than in " + ClassID.VSWITCH + " ");
                debugMsg.append(vSwitch2);
                debugMsg.append(" (");
                debugMsg.append(keepAliveInterval2);
                debugMsg.append(")");
                theLogger.trace(SrLogCategories.LEGACY, debugMsg);
                parameterList2.put(ClientParameterCode.KEEP_ALIVE, keepAliveInterval1);
            }
            if (suspiciousInterval1 != null && suspiciousInterval2 != null && suspiciousInterval1.compareTo(suspiciousInterval2) != 0) {
                theLogger.trace(SrLogCategories.LEGACY, "Suspicious-Interval ", suspiciousInterval1, " in ", ClassID.VSWITCH, " ", vSwitch1, " is different than in ", ClassID.VSWITCH, " ", vSwitch2, " (", suspiciousInterval2, ")");
                parameterList2.put(ClientParameterCode.SUSPICIOUS_INTERVAL, suspiciousInterval1);
            }
            if (faultyInterval1 != null && faultyInterval2 != null && faultyInterval1.compareTo(faultyInterval2) != 0) {
                theLogger.trace(SrLogCategories.LEGACY, "Faulty-Interval ", faultyInterval1, " in ", ClassID.VSWITCH, " ", vSwitch1, " is different than in ", ClassID.VSWITCH, " ", vSwitch2, " (", faultyInterval2, ")");
                parameterList2.put(ClientParameterCode.FAULTY_INTERVAL, faultyInterval1);
            }
            if (failoverEnable1 != null && failoverEnable2 != null && !failoverEnable1.equals(failoverEnable2)) {
                theLogger.trace(SrLogCategories.LEGACY, "Failover Enable ", failoverEnable1, " in ", ClassID.VSWITCH, " ", vSwitch1, " is different than in ", ClassID.VSWITCH, " ", vSwitch2, " (", failoverEnable2, ")");
                if (!failoverEnable2.booleanValue()) {
                    parameterList2.put(ClientParameterCode.FAILOVER_ENABLE, Boolean.TRUE);
                } else {
                    parameterList1.put(ClientParameterCode.FAILOVER_ENABLE, Boolean.TRUE);
                }
            }
            if (!parameterList2.isEmpty()) {
                theLogger.trace(SrLogCategories.LEGACY, "Cluster parameters are being synchronized from ", ClassID.VSWITCH, " ", vSwitch1, " to ", ClassID.VSWITCH, " ", vSwitch2);
                try {
                    this.synchronizeClusterParametersDone = true;
                    ErrorAssertingListener.listenTo(vSwitch2.changeElement(parameterList2));
                }
                catch (IllegalValueException ive) {
                    theLogger.warn(SrLogCategories.LEGACY, ive);
                }
            }
            if (!parameterList1.isEmpty()) {
                theLogger.trace(SrLogCategories.LEGACY, "Cluster parameters are being synchronized from ", ClassID.VSWITCH, " ", vSwitch2, " to ", ClassID.VSWITCH, " ", vSwitch1);
                try {
                    this.synchronizeClusterParametersDone = true;
                    ErrorAssertingListener.listenTo(vSwitch1.changeElement(parameterList1));
                }
                catch (IllegalValueException ive) {
                    theLogger.warn(SrLogCategories.LEGACY, ive);
                }
            }
        }
    }

    private VSwitchImpl newVSwitch(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch = new VSwitchImpl(this, aCED);
        vSwitch.changeParameterList(aCED);
        this.myVSwitches.add(vSwitch);
        Cluster cluster = vSwitch.getWatingMovingCluster();
        if (cluster != null) {
            if (cluster.equals(this)) {
                theLogger.trace(SrLogCategories.LEGACY, "Shouldn't be here!!! ClusterImpl::newVSwitch(HashMap)");
                theLogger.error(SrLogCategories.LEGACY, "Cluster ", cluster, " is waiting to ", ClassID.VSWITCH, " ", vSwitch, ", whereas it is added to cluster ", this);
            }
            vSwitch.setWatingMovingCluster(null);
        }
        CommKeyClassId clusterCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        VSwitchClusterMap.getInstance().add((CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID), clusterCommKeyClassId);
        return vSwitch;
    }

    public FCNodeImpl newFCNode(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        FCNodeImpl fcNode = new FCNodeImpl(this, aCED);
        fcNode.changeParameterList(aCED);
        return fcNode;
    }

    public IPTableRowImpl newIPTableRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        IPTableRowImpl ipTableRowImpl = new IPTableRowImpl(this, aCED);
        ipTableRowImpl.changeParameterList(aCED);
        return ipTableRowImpl;
    }

    private InterfaceTableRowImpl newInterfaceRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap<ParameterCodes, Object> parameterList = aCED.getParametersList();
        IANAifTypeConstant type = (IANAifTypeConstant)parameterList.get(ParameterCode.IF_TYPE);
        InterfaceTableRowImpl interfaceTableRow = null;
        interfaceTableRow = type.equals(IANAifTypeConstant.IANA_IF_TYPE_FC) ? new FCInterfaceTableRowImpl(this, aCED) : (type.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI) ? new PSCSIInterfaceTableRowImpl(this, aCED) : (type.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET) ? new EthernetInterfaceTableRowImpl(this, aCED) : new InterfaceTableRowImpl(this, aCED)));
        ((TableRowImpl)interfaceTableRow).changeParameterList(aCED);
        return interfaceTableRow;
    }

    private ISCSIInstanceImpl newISCSIInstance(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ISCSIInstanceImpl iscsiInstanceImpl = new ISCSIInstanceImpl(this, ClassID.ISCSI_INSTANCE, aCED);
        iscsiInstanceImpl.changeParameterList(aCED);
        return iscsiInstanceImpl;
    }

    private ISCSIInitiatorImpl newISCSIInitiator(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ISCSIInitiatorImpl iscsiInitiatorImpl = new ISCSIInitiatorImpl(this, aCED);
        iscsiInitiatorImpl.changeParameterList(aCED);
        VSwitchImpl vSwitch = iscsiInitiatorImpl.getParentVSwitch();
        vSwitch.addISCSIInitiator(iscsiInitiatorImpl);
        return iscsiInitiatorImpl;
    }

    private SCSIInitiatorPortImpl newSCSIInitiatorPort(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        SCSIInitiatorPortImpl initiatorPort = new SCSIInitiatorPortImpl(this.cluster, aCED);
        initiatorPort.changeParameterList(aCED);
        ISCSIInitiator initiator = initiatorPort.getInitiator();
        if (initiator != null) {
            ((ISCSIInitiatorImpl)initiator).addSCSIPort(initiatorPort);
        }
        return initiatorPort;
    }

    private ISCSISessionImpl newISCSISession(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        IdentityImpl identity;
        SessionDirectionConstant sessionDirection = (SessionDirectionConstant)aCED.getValue(ParameterCode.ISCSI_SESSION_DIRECTION);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        LogicObjectImpl initiator = null;
        SynchronizeableImpl target = null;
        if (SessionDirectionConstant.IN_BOUND.equals(sessionDirection)) {
            SrString remoteInitiatorName = (SrString)aCED.getValue(ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
            if (remoteInitiatorName == null) {
                theLogger.warn(SrLogCategories.ERROR, "Session's (", aCED, ") remote initiator name is null.");
                return null;
            }
            ISCSIRemoteInitiatorImpl remoteInitiator = vSwitch.getRemoteInitiatorByName(remoteInitiatorName.toString());
            if (remoteInitiator == null) {
                theLogger.warn(SrLogCategories.ERROR, "Session's (", aCED, ") remote initiator (", remoteInitiatorName, ") is unknown to the VS (", vSwitch, "). Remote initiators in the VS: ", vSwitch.getRemoteInitiators());
                return null;
            }
            target = remoteInitiator.getTarget();
            initiator = remoteInitiator;
        } else if (SessionDirectionConstant.OUT_BOUND.equals(sessionDirection)) {
            Object[] initiators;
            SrString remoteTargetName = (SrString)aCED.getValue(ParameterCode.ISCSI_SESSION_TARGET_NAME);
            ISCSIRemoteTargetImpl remoteTarget = this.getCluster().getRemoteTargetListMgr().getRemoteTargetByName(remoteTargetName.toString());
            if (remoteTarget == null) {
                theLogger.warn(SrLogCategories.ERROR, "Couldn't find the remote target by name (", remoteTargetName, ") in the cluster's (", this.getCluster(), ") remote target manager list: ", Arrays.toString(this.getCluster().getRemoteTargetListMgr().getAll()));
                return null;
            }
            target = remoteTarget;
            for (ISCSIInitiator iSCSIInitiator : initiators = remoteTarget.getAllConnectedInitiators()) {
                if (iSCSIInitiator == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "remoteTarget.getAllConnectedInitiators() contains null, for target ", remoteTarget, Arrays.toString(initiators));
                    continue;
                }
                SrString remoteInitiatorName = (SrString)aCED.getValue(ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
                String currInitiatorName = iSCSIInitiator.getName();
                if (currInitiatorName == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "The initiator ", iSCSIInitiator, " has a null name.");
                    continue;
                }
                if (!currInitiatorName.equals(remoteInitiatorName.toString())) continue;
                initiator = (ISCSIInitiatorImpl)iSCSIInitiator;
                break;
            }
        } else {
            throw new IllegalStateException("Invalid SessionDirectionConstant, sessionDirection: " + sessionDirection);
        }
        ISCSISessionImpl iscsiSessionImpl = new ISCSISessionImpl(this, ClassID.ISCSI_SESSION, aCED);
        iscsiSessionImpl.changeParameterList(aCED);
        if (!iscsiSessionImpl.addToInitiatorAndTarget()) {
            theLogger.error(SrLogCategories.ERROR, "Failed adding the sesion to the initiator and target. LOCALLY FOUND - target: ", target, "; initiator: ", initiator);
            return null;
        }
        String identityAlias = "N/A";
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY);
        if (identityCommKeyClassId != null && (identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identityCommKeyClassId)) != null) {
            identityAlias = identity.getAlias();
        }
        iscsiSessionImpl.setIdentityAlias(identityAlias);
        return iscsiSessionImpl;
    }

    private ISCSIConnectionImpl newISCSIConnection(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        CommKeyClassId sessionParent = (CommKeyClassId)aCED.getValue(ParameterCode.ISCSI_SESSION_ID);
        ISCSISessionImpl iscsiSessionImpl = (ISCSISessionImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(sessionParent);
        if (iscsiSessionImpl == null || this.getCommKeyRefMap().getRefByCommKeyClassID(sessionParent) == null) {
            theLogger.warn(SrLogCategories.LEGACY, "Couldn't create an iSCSI connection element: ISCSISessionImpl parent (", sessionParent, ") element is null. aCED: ", aCED);
            return null;
        }
        ISCSIConnectionImpl iscsiConnectionImpl = new ISCSIConnectionImpl(this, ClassID.ISCSI_CONNECTION, aCED);
        iscsiConnectionImpl.changeParameterList(aCED);
        iscsiSessionImpl.addConnection(iscsiConnectionImpl);
        return iscsiConnectionImpl;
    }

    private ISCSISessionStatisticsImpl newISCSISessionStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        CommKeyClassId sessionParent = (CommKeyClassId)aCED.getValue(ParameterCode.ISCSI_SESSION_ID);
        if (sessionParent == null || this.getCommKeyRefMap().getRefByCommKeyClassID(sessionParent) == null) {
            theLogger.warn(SrLogCategories.LEGACY, "Couldn't create an iSCSI Session Statistics element: ISCSISessionImpl parent element is null.");
            theLogger.warn(SrLogCategories.LEGACY, "Couldn't create an iSCSI Session Statistics element: ISCSISessionImpl parent (", sessionParent, ") element is null. aCED: ", aCED);
            return null;
        }
        ISCSISessionStatisticsImpl iscsiSessionStatisticsImpl = new ISCSISessionStatisticsImpl(this, aCED);
        iscsiSessionStatisticsImpl.changeParameterList(aCED);
        return iscsiSessionStatisticsImpl;
    }

    private ISCSIRemoteInitiatorImpl newISCSIRemoteInitiator(ConfigElementData aCED) throws RemoteException, IllegalValueException, AlreadyKnownByVSwitch, InvalidElementException {
        ISCSIRemoteInitiatorImpl iscsiRemoteInitiatorImpl = new ISCSIRemoteInitiatorImpl(this, aCED);
        iscsiRemoteInitiatorImpl.changeParameterList(aCED);
        CommKeyClassId scsiTargetId = (CommKeyClassId)aCED.getValue(ParameterCode.SCSI_TARGET_ID);
        CommKeyClassId iscsiTargetId = this.getISCSIId(scsiTargetId);
        ISCSITargetImpl target = (ISCSITargetImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetId);
        target.addRemoteInitiator(iscsiRemoteInitiatorImpl);
        return iscsiRemoteInitiatorImpl;
    }

    private ISCSIRemoteInitiatorStatisticsImpl newISCSIRemoteInitiatorStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ISCSIRemoteInitiatorStatisticsImpl iscsiRemoteInitiatorStatisticsImpl = new ISCSIRemoteInitiatorStatisticsImpl(this, aCED);
        iscsiRemoteInitiatorStatisticsImpl.changeParameterList(aCED);
        return iscsiRemoteInitiatorStatisticsImpl;
    }

    public PortalTableRowImpl newPortalRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        SrIpAddress ipAddress;
        CommKeyClassId vsID = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vsID);
        IPTableRowImpl tableRow = vSwitch.getIPTableRow((ipAddress = (SrIpAddress)aCED.getValue(ParameterCode.ISCSI_PORTAL_IP_ADDRESS)).toDisplayString());
        if (tableRow == null) {
            throw new InvalidElementException(aCED, "");
        }
        PortalTableRowImpl portalTableRowImpl = new PortalTableRowImpl(this, aCED);
        portalTableRowImpl.changeParameterList(aCED);
        return portalTableRowImpl;
    }

    public IPRouteTableRowImpl newIPRouteRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        IPRouteTableRowImpl ipRouteTableRowImpl = new IPRouteTableRowImpl(this, aCED);
        ipRouteTableRowImpl.changeParameterList(aCED);
        return ipRouteTableRowImpl;
    }

    public ManagerImpl newManager(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ManagerImpl managerImpl = new ManagerImpl(this, aCED);
        managerImpl.changeParameterList(aCED);
        return managerImpl;
    }

    public SrFuture<Void> removeNeighbor(String neighborIp) throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.removeNeighbor");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            midFutures.add(vSwitch.removeNeighbor(neighborIp));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private NeighborImpl newNeighbor(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        SrIpAddress neighborIpValue = (SrIpAddress)aCED.getValue(ParameterCode.NEIGHBOR_IP_ADDRESS);
        String neighborIp = neighborIpValue.toDisplayString();
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        if (this.getVSwitchByIPAddress(neighborIp) == null) {
            try {
                SrInteger snmpPort = (SrInteger)aCED.getValue(ParameterCode.NEIGHBOR_PORT);
                SrInteger numberOfRetries = (SrInteger)aCED.getValue(ParameterCode.NEIGHBOR_RETRIES);
                SrInteger timeout = (SrInteger)aCED.getValue(ParameterCode.NEIGHBOR_TIMEOUT);
                ErrorAssertingListener.listenTo(this.addVSwitch(neighborIp, vSwitch.getMgmMask(), snmpPort.intValue(), vSwitch.getTrapPort(), vSwitch.getReadCommunity(), vSwitch.getWriteCommunity(), timeout.intValue(), numberOfRetries.intValue(), vSwitch.getSnmpVersion()));
            }
            catch (IllegalValueException ive) {
                ((VSwitchImpl)vSwitch).setNeighborInvalid(neighborIp);
                ClusterImpl cluster = (ClusterImpl)SystemRootImpl.getInstance().getClusterOfVSwitch(neighborIp);
                if (cluster != null) {
                    theLogger.error(SrLogCategories.LEGACY, ive, "Failed to create neighbor, cluster: ", cluster);
                } else {
                    theLogger.error(SrLogCategories.LEGACY, ive, "Failed to create neighbor, cluster is null.");
                }
                return null;
            }
        }
        ((VSwitchImpl)vSwitch).setNeighborInvalid(null);
        NeighborImpl neighborImpl = new NeighborImpl(this, aCED);
        neighborImpl.changeParameterList(aCED);
        return neighborImpl;
    }

    private IdentityImpl newIdentity(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        IdentityImpl knownIdentity;
        String alias = (String)((SrString)aCED.getValue(ParameterCode.IDENTITY_ALIAS)).value();
        IdentityPurposeConstant identityPurpose = (IdentityPurposeConstant)aCED.getValue(ParameterCode.IDENTITY_PURPOSE);
        boolean isLocalInitiatorIdentity = identityPurpose.equals(IdentityPurposeConstant.LOCAL_INITIATOR);
        if (!isLocalInitiatorIdentity && (knownIdentity = this.identities.getIdentityByAlias(alias)) != null) {
            throw new AlreadyKnownByVSwitch(knownIdentity);
        }
        IdentityImpl identity = new IdentityImpl(this, ClassID.IDENTITY, aCED);
        identity.changeParameterList(aCED);
        if (isLocalInitiatorIdentity) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
            VSwitch vSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            this.identities.addIdentity(identity, vSwitch.getName());
        } else {
            this.identities.addIdentity(identity);
        }
        return identity;
    }

    private RadiusServerImpl newRadiusServer(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        SrIpAddress ip = (SrIpAddress)aCED.getValue(ParameterCode.RADIUS_SERVER_IP_ADDRESS);
        String ipAddress = ip.toDisplayString();
        ExternalServerImpl knownIdentity = this.radiusServerList.getExternalServerByIP(ipAddress);
        if (knownIdentity != null) {
            throw new AlreadyKnownByVSwitch(knownIdentity);
        }
        RadiusServerImpl radiusServer = new RadiusServerImpl(this, aCED);
        radiusServer.changeParameterList(aCED);
        this.radiusServerList.addExternalServer(radiusServer);
        return radiusServer;
    }

    private ISNSServerImpl newISNSServer(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        InetAddress ipAddress = (InetAddress)((SrIpAddress)aCED.getValue(ParameterCode.ISNS_SERVER_IP_ADDRESS)).value();
        ExternalServerImpl knownIdentity = this.isnsServerList.getExternalServerByIP(ipAddress.getHostAddress());
        if (knownIdentity != null) {
            throw new AlreadyKnownByVSwitch((ISNSServerImpl)knownIdentity);
        }
        ISNSServerImpl isnsServer = new ISNSServerImpl(this, ClassID.ISNS_SERVER, aCED);
        isnsServer.changeParameterList(aCED);
        this.isnsServerList.addExternalServer(isnsServer);
        return isnsServer;
    }

    private PolicyParamTableEntryImpl newPolicyParamTableEntry(CommKeyClassId aCommKeyClassId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        PoliciesManager.getInstance().newPolicyParams(aCommKeyClassId, aCED);
        PolicyParamTableEntryImpl policyParamTableEntryImpl = new PolicyParamTableEntryImpl(this, aCED);
        policyParamTableEntryImpl.changeParameterList(aCED);
        return policyParamTableEntryImpl;
    }

    private PolicyTableEntryImpl newPolicyTableEntry(CommKeyClassId aCommKeyClassId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        PoliciesManager.getInstance().newPolicyStart(aCommKeyClassId, aCED);
        PolicyTableEntryImpl policyTableEntryImpl = new PolicyTableEntryImpl(this, aCED);
        policyTableEntryImpl.changeParameterList(aCED);
        return policyTableEntryImpl;
    }

    private AclEntryImpl newAclEntry(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.ACL_ENTRY_IDENTITY);
        IdentityImpl identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)aCED.getValue(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        TargetImpl targetParent = (TargetImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        if (targetParent != null && identity != null) {
            Integer permissionVal = (Integer)((SrInteger)aCED.getValue(ParameterCode.ACL_ENTRY_ACCESS)).value();
            Permission permission = Permission.getPermission(permissionVal);
            Integer positionVal = (Integer)((SrInteger)aCED.getValue(ParameterCode.ACL_ENTRY_POSITION)).value();
            int position = positionVal;
            AclImpl acl = targetParent.getAclForTarget();
            if (acl != null) {
                theLogger.trace(SrLogCategories.LEGACY, acl.toDisplayString());
                AclEntryImpl knownEntry = acl.getEntry(identity, permission, position, this.isDiscoverCompleted());
                StringBuffer sb = new StringBuffer("@@@@ entry - ");
                sb.append(identity.getAlias());
                sb.append(", ");
                sb.append(permission.toString());
                sb.append(", ");
                sb.append(position);
                sb.append("- ");
                if (knownEntry != null) {
                    sb.append("Already Known !");
                    theLogger.trace(SrLogCategories.LEGACY, sb);
                    if (!identity.isOfRemoteInitiatorDR()) {
                        acl.setHighestPostionIfHighest(knownEntry.getPosition());
                    }
                    throw new AlreadyKnownByVSwitch(knownEntry);
                }
                sb.append("is NEW !!");
                theLogger.trace(SrLogCategories.LEGACY, sb);
                AclEntryImpl entry = new AclEntryImpl(this, ClassID.ACL_ENTRY, acl, aCED);
                entry.changeParameterList(aCED);
                ErrorAssertingListener.listenTo(acl.addAclEntry(entry));
                return entry;
            }
        } else {
            if (targetParent == null) {
                theLogger.error(SrLogCategories.LEGACY, "targetParent ", targetCommKeyClassId, " is null in ClusterImpl::newAclEntry()");
            }
            if (identity == null) {
                theLogger.error(SrLogCategories.LEGACY, "identity ", identCommKeyClassId, " is null in ClusterImpl::newAclEntry()");
            }
        }
        return null;
    }

    private IdentityNameImpl newIdentityName(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId parent = (CommKeyClassId)aCED.getValue(ParameterCode.IDENTITY_NAME_PARENT);
        String name = (String)((SrString)aCED.getValue(ParameterCode.IDENTITY_NAME_VALUE)).value();
        IdentityImpl identityParent = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        IdentityNameImpl knownIdentityName = identityParent.isNameExist(name);
        if (knownIdentityName != null) {
            throw new AlreadyKnownByVSwitch(knownIdentityName);
        }
        IdentityNameImpl identityName = null;
        if (identityParent != null) {
            identityName = new IdentityNameImpl(this, ClassID.IDENTITY_NAME, aCED);
            identityName.changeParameterList(aCED);
            identityParent.addName(identityName);
        }
        return identityName;
    }

    private SRPCredentialsImpl newSrpCredentials(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId parent = (CommKeyClassId)aCED.getValue(ParameterCode.CREDENTIALS_PARENT);
        String userName = (String)((SrString)aCED.getValue(ParameterCode.SRP_CREDENTIALS_USER_NAME)).value();
        Object ref = this.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        if (ref == null) {
            String msg = "Found SRP credentials with no identity matching !";
            theLogger.warn(SrLogCategories.LEGACY, msg);
            theLogger.trace(SrLogCategories.LEGACY, msg, ", user name: ", userName);
            throw new IllegalValueException(msg);
        }
        IdentityImpl identityParent = (IdentityImpl)ref;
        CredentialsImpl knownIdentityCred = identityParent.isCredentialExist(ClassID.SRP_CREDENTIALS, userName);
        if (knownIdentityCred != null) {
            throw new AlreadyKnownByVSwitch(knownIdentityCred);
        }
        SRPCredentialsImpl srpCred = new SRPCredentialsImpl(this, ClassID.SRP_CREDENTIALS, aCED);
        srpCred.changeParameterList(aCED);
        identityParent.addCredentials(srpCred);
        this.setCredentialsWithLocalTarget(srpCred);
        return srpCred;
    }

    private CHAPCredentialsImpl newChapCredentials(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        Object ref;
        CommKeyClassId parent = (CommKeyClassId)aCED.getValue(ParameterCode.CREDENTIALS_PARENT);
        Object userParameter = aCED.getValue(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
        String userName = "";
        if (userParameter != null) {
            userName = (String)((SrString)userParameter).value();
        }
        if ((ref = this.getCommKeyRefMap().getRefByCommKeyClassID(parent)) == null) {
            String msg = "Found CHAP credentials with no identity matching !";
            theLogger.warn(SrLogCategories.LEGACY, msg);
            theLogger.trace(SrLogCategories.LEGACY, msg, ", user name: ", userName);
            return null;
        }
        IdentityImpl identityParent = (IdentityImpl)ref;
        CredentialsImpl knownIdentityCred = identityParent.isCredentialExist(ClassID.CHAP_CREDENTIALS, userName);
        if (knownIdentityCred != null) {
            throw new AlreadyKnownByVSwitch(knownIdentityCred);
        }
        CHAPCredentialsImpl chapCred = new CHAPCredentialsImpl(this, ClassID.CHAP_CREDENTIALS, aCED);
        chapCred.changeParameterList(aCED);
        identityParent.addCredentials(chapCred);
        this.setCredentialsWithLocalTarget(chapCred);
        return chapCred;
    }

    private void setLocalTargetCredentials(ISCSITargetImpl localTarget) throws RemoteException {
        Vector<IdentityImpl> allIdentities = this.identities.getAllIdentities();
        for (IdentityImpl identity : allIdentities) {
            if (!localTarget.getAlias().equals(identity.getAlias())) continue;
            Vector<CredentialsImpl> credentials = identity.getCredentials();
            if (!credentials.isEmpty()) {
                CredentialsImpl cred = credentials.elementAt(0);
                localTarget.setCredentials(cred);
                cred.setISCSIDevice(localTarget);
                this.fireISCSITargetCredentialsChanged(localTarget);
                continue;
            }
            theLogger.warn(SrLogCategories.LEGACY, "No credentials found for ", identity.getClassId(), " ", identity, " in cluster ", this);
        }
    }

    private void setCredentialsWithLocalTarget(CredentialsImpl cred) throws RemoteException {
        ISCSITargetImpl localTarget;
        IdentityImpl identity = cred.getIdentityParent();
        if (identity.isOfLocalTarget() && (localTarget = this.getTargetListMgr().getTargetByAlias(identity.getAlias())) != null) {
            localTarget.setCredentials(cred);
            cred.setISCSIDevice(localTarget);
            this.fireISCSITargetCredentialsChanged(localTarget);
        }
    }

    private void setRemoteTargetCHAPCredentials(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        Vector<CredentialsImpl> chapCredentials;
        IdentityImpl remoteTargetIdentity = (IdentityImpl)remoteTarget.getIdentity();
        if (remoteTargetIdentity != null && (chapCredentials = remoteTargetIdentity.getCHAPCredentials()) != null && chapCredentials.size() > 0) {
            CHAPCredentialsImpl chapCred = (CHAPCredentialsImpl)chapCredentials.elementAt(0);
            remoteTarget.setCHAPCredentials(chapCred);
            chapCred.setISCSIDevice(remoteTarget);
            this.fireISCSIRemoteTargetCredentialsChanged(remoteTarget);
        }
    }

    private void setLocalInitiatorCredentials(ISCSIInitiatorImpl localInitiator) throws RemoteException {
        Vector<IdentityImpl> allIdentities = this.identities.getAllIdentities();
        for (int i = 0; i < allIdentities.size(); ++i) {
            IdentityNameImpl identityFirstName;
            Vector<IdentityNameImpl> identityNames;
            IdentityImpl identity = allIdentities.get(i);
            if (!identity.isOfLocalInitiator() || (identityNames = identity.getIdentityNames()) == null || identityNames.size() <= 0 || !localInitiator.isMyIdentity((identityFirstName = identity.getIdentityNames().elementAt(0)).getName())) continue;
            Vector<CredentialsImpl> chapCredentials = identity.getCHAPCredentials();
            Vector<CredentialsImpl> srpCredentials = identity.getSRPCredentials();
            if (!chapCredentials.isEmpty()) {
                CHAPCredentialsImpl chapCred = (CHAPCredentialsImpl)chapCredentials.elementAt(0);
                localInitiator.setCHAPCredentials(chapCred);
                chapCred.setISCSIDevice(localInitiator);
            }
            if (srpCredentials.isEmpty()) continue;
            SRPCredentialsImpl srpCred = (SRPCredentialsImpl)srpCredentials.elementAt(0);
            localInitiator.setSRPCredentials(srpCred);
            srpCred.setISCSIDevice(localInitiator);
        }
    }

    private TableRowImpl removeTabelRow(TableRowImpl row) throws RemoteException {
        VSwitchImpl vSwitch = row.getParentVSwitch();
        vSwitch.removeTableRow(row);
        return row;
    }

    private CommKeyClassId getCommKeyClassIDOfElement(Object eventElement, int eventType) {
        CommKeyClassId commKeyClassID = null;
        if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12 || eventType == 13 || eventType == 24) {
            ConfigElementData ced = (ConfigElementData)eventElement;
            commKeyClassID = new CommKeyClassId(ced.getCommKey(), ced.getClassId());
        } else if (eventType == 6) {
            commKeyClassID = ((SrVSwitchMessageEvent)eventElement).getVSwitchData();
        }
        return commKeyClassID;
    }

    private void runEvent(EventQueueElement eventQueueElement, Object eventElement, int eventType, SrPostponedExecutor aEventMonitor) throws RemoteException {
        HashMap changedVals = null;
        try {
            if (eventType == 23) {
                this.notifyClusterDBReadingCompleted();
            } else if (eventType == 16) {
                SrCheckListEvent event = (SrCheckListEvent)eventQueueElement.getQueueElement();
                ErrorAssertingListener.listenTo(this.checkForElementsDeletion(event, aEventMonitor));
            } else {
                LogicObjectImpl element;
                if (eventType == 17) {
                    ErrorAssertingListener.listenTo(this.rediscover());
                    return;
                }
                CommKeyClassId commKeyClassID = this.getCommKeyClassIDOfElement(eventElement, eventType);
                if (commKeyClassID.getClassID().equals(ClassID.STORAGE_DOMAIN)) {
                    commKeyClassID = (CommKeyClassId)((ConfigElementData)eventElement).getValue(ParameterCode.VSWITCH_ID);
                }
                if ((element = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeyClassID)) == null && eventType != 1 && eventType != 8 && eventType != 2 && eventType != 3 && eventType != 10 && eventType != 15 && eventType != 18 && eventType != 24) {
                    StringBuffer debugMsg = new StringBuffer("Element for event type ");
                    debugMsg.append(eventType);
                    debugMsg.append(" is null - (");
                    debugMsg.append(commKeyClassID.getClassID());
                    debugMsg.append(" commkey is [");
                    if (commKeyClassID.getCommKeys() != null && commKeyClassID.getCommKeys().length > 0) {
                        debugMsg.append(commKeyClassID.getCommKeys()[0]);
                    }
                    debugMsg.append("] ");
                    debugMsg.append(eventQueueElement);
                    debugMsg.append(" was NOT re-added to queue");
                    theLogger.warn(SrLogCategories.LEGACY, debugMsg);
                } else {
                    ConfigElementData ced = null;
                    if (eventType == 6) {
                        this.vSwitchDiscoverCompleted((VSwitchImpl)element);
                    } else {
                        ced = (ConfigElementData)eventElement;
                        VSwitchImpl vSwitch = this.getVSwitch(ced.getClassId(), ced.getCommKey(), ced);
                        switch (eventType) {
                            case 24: {
                                SrTrapEvent trap = (SrTrapEvent)eventQueueElement.getQueueElement();
                                element = this.addNewStorageNotification(ced, trap.getTrapType());
                                break;
                            }
                            case 1: 
                            case 8: {
                                if (ced.getClassId() == ClassID.ALARM_TYPE) break;
                                element = (LogicObjectImpl)this.elementCreated(ced, aEventMonitor);
                                break;
                            }
                            case 18: {
                                if (element == null) {
                                    if (ClassID.VSWITCH.equals(ced.getClassId()) || !this.isDiscoverCompleted()) break;
                                    element = (LogicObjectImpl)this.elementCreated(ced, aEventMonitor);
                                    break;
                                }
                            }
                            case 2: 
                            case 4: 
                            case 9: {
                                changedVals = this.elementChanged(element, ced, aEventMonitor);
                                if (changedVals == null) {
                                    theLogger.error(SrLogCategories.BUG, "The CED: ", ced, " generated a null changed values.");
                                }
                                if (changedVals == null || !changedVals.isEmpty()) break;
                                StringBuilder logMsg = new StringBuilder("The changed values are empty for the CED : ");
                                logMsg.append(ced).append(" which affects the element: [");
                                logMsg.append(element == null ? "NULL" : element.getClassId());
                                logMsg.append("] ").append(element);
                                theLogger.trace(SrLogCategories.INFORMATIVE, logMsg);
                                break;
                            }
                            case 3: {
                                ErrorAssertingListener.listenTo(this.removeElementByEvent(element, ced, aEventMonitor));
                                break;
                            }
                            case 10: {
                                this.creationFailed(ced, vSwitch);
                                break;
                            }
                            case 15: {
                                this.operationFailed(ced, vSwitch);
                                break;
                            }
                            case 11: {
                                this.changeElementFailed(element, vSwitch, ced.getParametersList());
                                break;
                            }
                            case 12: 
                            case 13: {
                                this.operationFailed(eventType, element, vSwitch, ced.getParametersList());
                                break;
                            }
                            default: {
                                theLogger.logAndAssert(SrLogCategories.LEGACY, "Type ", eventType, " not found in ", this.getClass());
                            }
                        }
                        if (eventType == 8 || eventType == 9) {
                            ParameterCode[] badValues = ((SrElementOperationErrorEvent)eventQueueElement.getQueueElement()).getErrorParams();
                            element.setParametersBadValue(vSwitch, badValues);
                        }
                        if (this.isDiscoverCompleted() && element != null && (vSwitch != null || element.getClassId().equals(ClassID.CLUSTER) || element.getClassId().equals(ClassID.VSWITCH))) {
                            if (element.getClassId().equals(ClassID.ACL_ENTRY)) {
                                TargetImpl targetElement = ((AclEntryImpl)element).getAclParent().getTargetParent();
                                this.generateAlarms(eventType, targetElement, vSwitch);
                            } else if (!(element.getClassId().isDRClassId() || changedVals != null && changedVals.isEmpty())) {
                                this.generateAlarms(eventType, element, vSwitch);
                            }
                        }
                    }
                }
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive);
        }
        catch (InvalidElementException iee) {
            this.myCorruptionMgr.handleInvalidElementException(iee);
        }
    }

    private void generateAlarmsForMirrors(int aEventType, VSwitchImpl aVS) {
        if (aVS == null) {
            return;
        }
        for (MirrorVolumeImpl curMir : this.getStorage().getAllRootMirrors()) {
            try {
                this.generateAlarms(aEventType, curMir, aVS);
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, exp, "A remote exception has occured inside a server context.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventQueueElement eventQueueElement) {
        SrPostponedExecutor eventMonitor = new SrPostponedExecutor();
        try {
            if (eventQueueElement.getQueueElement() instanceof SrEventObject) {
                this.myDebugObj.setRunningEvent((SrEventObject)eventQueueElement.getQueueElement());
                this.myDebugObj.setRunningObject(eventQueueElement.getQueueElement());
            } else {
                this.myDebugObj.setRunningObject(eventQueueElement.getQueueElement());
            }
            theLogger.trace(SrLogCategories.LEGACY, "Removed from Event Queue: ", eventQueueElement);
            EventObject eventObject = (EventObject)eventQueueElement.getQueueElement();
            int eventType = eventQueueElement.getType();
            if (eventObject instanceof ErrorEvent) {
                this.handleErrorEvent((ErrorEvent)eventObject);
            } else if (eventObject instanceof SrEvent) {
                if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 13 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12 || eventType == 24) {
                    ConfigElementDataList cedList = ((SrElementEvent)eventObject).getElements();
                    for (ElementData ced : cedList) {
                        this.runEvent(eventQueueElement, ced, eventType, eventMonitor);
                    }
                } else if (eventType == 6) {
                    this.runEvent(eventQueueElement, (SrVSwitchMessageEvent)eventObject, eventType, eventMonitor);
                } else if (eventType == 23) {
                    this.runEvent(eventQueueElement, null, eventType, eventMonitor);
                } else if (eventType == 16) {
                    this.runEvent(eventQueueElement, null, eventType, eventMonitor);
                } else {
                    theLogger.error(SrLogCategories.LEGACY, "Undefined event type ", eventType, " before runEvent");
                }
            } else if (eventObject instanceof DREvent) {
                if (eventType == 3) {
                    LogicObjectImpl element = ((DREvent)eventObject).getElement();
                    VSwitchImpl vSwitch = element.getConnectedVSwitches()[0];
                    ErrorAssertingListener.listenTo(this.elementRemoved(element, vSwitch, vSwitch.getMgmIPAddr(), eventMonitor));
                } else {
                    theLogger.warn(SrLogCategories.LEGACY, "ClusterImpl::run(), DREvent ", eventObject, " was received with event type ", eventType);
                }
            } else {
                theLogger.warn(SrLogCategories.LEGACY, "ClusterImpl::run(), cluster ", this, " received unrecognized event ", eventObject);
            }
            this.myDebugObj.setRunningObject(null);
            this.myDebugObj.setRunningEvent(null);
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, this.getDebugInfo("A remote exception has caught in a server context."));
        }
        catch (RuntimeException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, this.getDebugInfo("The exception has caught for logging purposes only, but has not been dealt with. Therefore it has been rethrown and should be caught later."));
            throw exp;
        }
        catch (InvalidElementException exp) {
            this.myCorruptionMgr.handleInvalidElementException(exp);
        }
        finally {
            eventMonitor.perform();
        }
    }

    @Override
    public boolean isDBCorrupted() {
        return !this.myCorruptionMgr.getCorruptedElementsForAlarms().isEmpty();
    }

    private void createElementCompleted(VSwitchImpl vSwitch, final LogicObjectImpl element, CommKey[] commKeys, ClassID classId, SrPostponedExecutor aPostEventExecutor) throws RemoteException, InvalidElementException {
        if (element != null) {
            if (element.getClassId().isDRClassId()) {
                if (this.isDiscoverCompleted()) {
                    if (classId.equals(ClassID.ASYNC_PAIR)) {
                        DRClusterAsyncPairImpl asyncPair = (DRClusterAsyncPairImpl)element;
                        CommKeyClassId pairsGroupId = asyncPair.getGroupId(vSwitch);
                        DRClusterAbstractConsistencyGroupImpl pairGroup = (DRClusterAbstractConsistencyGroupImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(pairsGroupId);
                        if (pairGroup != null) {
                            if (DRRootImpl.getInstance().findDRObjectWithIdenticalElement(pairGroup) == null) {
                                this.sendDREvent(pairGroup, 1);
                            }
                            this.sendDREvent(element, 1);
                        }
                    } else if (classId.isDRGroup()) {
                        DRClusterAsyncPair[] pairs = ((DRClusterAbstractConsistencyGroupImpl)element).getPairs();
                        if (pairs != null && pairs.length > 0) {
                            if (DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element) == null) {
                                this.sendDREvent(element, 1);
                            }
                            for (DRClusterAsyncPair curPair : pairs) {
                                if (DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterAsyncPairImpl)curPair) != null) continue;
                                this.sendDREvent((DRClusterAsyncPairImpl)curPair, 1);
                            }
                        }
                    } else {
                        this.sendDREvent(element, 1);
                    }
                }
            } else if (this.isDiscoverCompleted() || classId.equals(ClassID.VSWITCH) || classId.equals(ClassID.NEIGHBORE)) {
                this.myDependencyMgr.publishCreatedElementOrPostpone(element);
            }
            if (element.getClassId().equals(ClassID.LUN)) {
                ErrorAssertingListener.listenTo(((LUImpl)element).readSCSILunElement());
            }
            StringBuffer debugMsg = new StringBuffer(classId.toString());
            debugMsg.append(" ");
            debugMsg.append(element);
            debugMsg.append(" was created");
            theLogger.info(SrLogCategories.ELEMENT_CREATION, debugMsg);
            if (!this.isDiscoverCompleted()) {
                SystemRootImpl.setStatusInProcess(debugMsg.toString());
            }
            element.registerToPropagatedStateChange();
            if (classId.equals(ClassID.VSWITCH)) {
                if (this.isClusterDiscoveryCompleted()) {
                    this.myIsNeedRestartRediscovery = true;
                    Runnable updateRaidCtrlRun = new Runnable(){

                        @Override
                        public void run() {
                            ((VSwitchImpl)element).updateRaidControl();
                        }
                    };
                    SrFuture<Void> rediscoverFuture = this.rediscover();
                    DefaultFutureListener.listenTo(updateRaidCtrlRun, rediscoverFuture);
                }
            } else if (vSwitch != null) {
                vSwitch.setConnected(true);
            }
            if (classId.equals(ClassID.NEIGHBORE)) {
                this.synchronizeClusterParameters();
            }
        } else if (!classId.equals(ClassID.COPY_OPERATION)) {
            theLogger.error(SrLogCategories.LEGACY, "Error in create new element ", classId, " in ", this.getClass(), "::newElement()");
        }
    }

    private void operationFailed(ConfigElementData ced, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer("Operation failed for ");
        msg.append(this.getMsgForElement(ced, vSwitch));
        theLogger.warn(SrLogCategories.LEGACY, msg);
        this.handleSyncConfigurationError(ced);
        if (vSwitch != null && vSwitch.isConnected() && this.isDiscoverCompleted()) {
            ElementEventImpl event = new ElementEventImpl((Object)vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            LogicMgrAOImpl.getInstance().__configurationError(event);
        }
    }

    private void creationFailed(ConfigElementData ced, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer("Failed to create ");
        if (ced.getClassId().equals(ClassID.SNMP_MANAGER) && ced.getValue(ParameterCode.MANAGER_IP_ADDRESS) == null) {
            msg.append(ced.getClassId());
            msg.append(" on ");
            msg.append(ClassID.VSWITCH);
            msg.append(" ");
            msg.append(vSwitch);
        } else {
            msg.append(this.getMsgForElement(ced, vSwitch));
        }
        theLogger.warn(SrLogCategories.LEGACY, msg);
        this.handleSyncConfigurationError(ced);
        if (vSwitch != null && vSwitch.isConnected() && this.isDiscoverCompleted()) {
            ElementEventImpl event = new ElementEventImpl((Object)vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            LogicMgrAOImpl.getInstance().__configurationError(event);
        }
    }

    private void operationFailed(int eventType, LogicObjectImpl element, VSwitchImpl vSwitch, HashMap parameterList) throws RemoteException {
        StringBuffer msg = null;
        if (eventType == 13) {
            msg = new StringBuffer("Failed to read ");
        } else if (eventType == 12) {
            msg = new StringBuffer("Failed to remove ");
        } else {
            msg = new StringBuffer("Undefined \"Failed\" event type in operationFailed()");
            msg.append(eventType);
            theLogger.error(SrLogCategories.LEGACY, msg);
            return;
        }
        msg.append(element.getClassId());
        if (eventType == 12) {
            element.clearDeletionStatus();
        }
        msg.append(" ");
        msg.append(element);
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        if (vSwitch != null) {
            ElementEventImpl event = new ElementEventImpl((Object)vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            if ((eventType != 13 || !element.getClassId().equals(ClassID.VSWITCH)) && vSwitch.isConnected() && this.isDiscoverCompleted()) {
                LogicMgrAOImpl.getInstance().__configurationError(event);
            }
        } else {
            msg.append(" (" + ClassID.VSWITCH + " probably was removed in the meantime)");
        }
        theLogger.warn(SrLogCategories.LEGACY, msg);
    }

    private HardwareImpl createVSwitchHardware(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HardwareImpl hardware = new HardwareImpl(this.cluster, aCED);
        hardware.changeParameterList(aCED);
        return hardware;
    }

    private TCPStatisticsImpl createTCPStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        TCPStatisticsImpl tcp = new TCPStatisticsImpl(this.cluster, aCED);
        tcp.changeParameterList(aCED);
        return tcp;
    }

    private EthernetStatisticsImpl createEthernetStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        EthernetStatisticsImpl ethernet = new EthernetStatisticsImpl(this.cluster, aCED);
        ethernet.changeParameterList(aCED);
        return ethernet;
    }

    private UDPStatisticsImpl createUDPStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        UDPStatisticsImpl udp = new UDPStatisticsImpl(this.cluster, aCED);
        udp.changeParameterList(aCED);
        return udp;
    }

    private ICMPStatisticsImpl createICMPStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        ICMPStatisticsImpl icmp = new ICMPStatisticsImpl(this.cluster, aCED);
        icmp.changeParameterList(aCED);
        return icmp;
    }

    private IPStatisticsImpl newIPStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        IPStatisticsImpl ip = new IPStatisticsImpl(this.cluster, aCED);
        ip.changeParameterList(aCED);
        return ip;
    }

    private InterfaceStatisticsTableRowImpl newInterfaceRowStatistics(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        InterfaceStatisticsTableRowImpl interfaceStatisticsTableRowImpl = new InterfaceStatisticsTableRowImpl(this, aCED);
        interfaceStatisticsTableRowImpl.changeParameterList(aCED);
        return interfaceStatisticsTableRowImpl;
    }

    private UDPListenerStatisticsTableRowImpl newUDPListenerStatisticsRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        UDPListenerStatisticsTableRowImpl udpListenerStatisticsTableRowImpl = new UDPListenerStatisticsTableRowImpl(this, aCED);
        udpListenerStatisticsTableRowImpl.changeParameterList(aCED);
        return udpListenerStatisticsTableRowImpl;
    }

    private TCPConnectionStatisticsTableRowImpl newTCPConnectionStatisticsRow(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        TCPConnectionStatisticsTableRowImpl tcpConnectionStatisticsTableRowImpl = new TCPConnectionStatisticsTableRowImpl(this, aCED);
        tcpConnectionStatisticsTableRowImpl.changeParameterList(aCED);
        return tcpConnectionStatisticsTableRowImpl;
    }

    private void changeElementFailed(LogicObjectImpl element, VSwitchImpl vSwitch, HashMap parameterList) throws RemoteException {
        VSwitchImpl otherVSwitch;
        StringBuffer msg = new StringBuffer("Failed to change ");
        msg.append(element.getClassId());
        msg.append(" ");
        msg.append(element);
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        if (element.getClassId().equals(ClassID.ISCSI_TARGET) && parameterList.containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) && (otherVSwitch = this.getOtherVSwitch(vSwitch)) != null) {
            otherVSwitch.clearDeletionStatus();
        }
        this.handleSyncConfigurationError(element);
        if (vSwitch != null) {
            ElementEventImpl event = new ElementEventImpl((Object)vSwitch, vSwitch);
            event.setErrorMesaage(msg.toString());
            event.setVSwitchIp(vSwitch.getMgmIPAddr());
            if (vSwitch.isConnected() && this.isDiscoverCompleted()) {
                LogicMgrAOImpl.getInstance().__configurationError(event);
            }
        } else {
            msg.append(" (" + ClassID.VSWITCH + " probably was removed in the meantime)");
        }
        theLogger.warn(SrLogCategories.LEGACY, msg);
    }

    private LogicObjectImpl addNewStorageNotification(ConfigElementData aCED, SrTrapType aType) throws RemoteException, IllegalValueException, InvalidElementException, IllegalArgumentException {
        if (aCED.getClassId() != ClassID.STORAGE_NOTIFICATION) {
            throw new IllegalArgumentException("Event of STORAGE_NOTIFICATION_EVENT contained CED of ClassID " + aCED.getClassId());
        }
        SrStorageNotificationImpl notificationElement = new SrStorageNotificationImpl(this, aCED);
        notificationElement.changeParameterList(aCED);
        if (notificationElement == null) {
            throw new IllegalArgumentException("Event of STORAGE_NOTIFICATION_EVENT contained CED " + aCED + " which does not contain a SrStorageNotificationImpl instance.");
        }
        SrStorageNotificationMgrImpl.getInstance().addNotification(notificationElement, aType);
        return notificationElement;
    }

    private LogicObject elementCreated(ConfigElementData aCED, SrPostponedExecutor aPostEventExecutor) throws RemoteException, IllegalValueException, InvalidElementException {
        LogicObjectImpl element;
        block165: {
            if (!this.myCorruptionMgr.setAsPendingIfDependedOnMissingElements(aCED)) {
                return null;
            }
            ClassID classId = aCED.getClassId();
            CommKey[] commKeys = aCED.getCommKey();
            element = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
            if (element != null) {
                ConfigElementData changeCed = new ConfigElementData(commKeys, classId);
                changeCed.addParameter(aCED.getParametersList());
                SrChangeElementEvent changeEvent = new SrChangeElementEvent((Object)this, changeCed);
                this.elementEvent(changeEvent);
                return null;
            }
            try {
                IdentityNameImpl name;
                IdentityImpl identityParent;
                if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
                    element = this.storage.newDirectAccessDevice(aCED);
                } else if (classId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE)) {
                    element = this.storage.newSequentialAccessDevice(aCED);
                } else if (classId.equals(ClassID.GENERAL_SCSI_DEVICE)) {
                    element = this.storage.newGeneralSCSIDevice(aCED);
                } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                    element = this.storage.newSubDirectAccessDevice(aCED);
                } else if (classId.equals(ClassID.ATTACHED_RAID)) {
                    element = this.myAttachedRaidMgr.newAttachedRaid(aCED);
                } else if (classId.equals(ClassID.CONCAT_VOLUME)) {
                    element = this.storage.newConcatinationVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.CUBE_VOLUME)) {
                    element = this.storage.newCubeVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.MIRROR_VOLUME)) {
                    element = this.storage.newMirrorVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.STRIPE_VOLUME)) {
                    element = this.storage.newStripeVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.TRANSPARENT_VOLUME)) {
                    element = this.storage.newTransparentVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.ISCSI_TARGET)) {
                    element = this.storage.newISCSITarget(aCED);
                } else if (classId.equals(ClassID.ISCSI_TARGET_QOS_GROUP)) {
                    element = this.myTargetQosMgr.newISCSITargetQosGroup(aCED);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    element = this.storage.newISCSIRemoteTarget(aCED);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    element = this.storage.newISCSIRemoteTargetPortal(aCED);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL)) {
                    element = this.storage.newISCSIRemotePortalDiscovery(aCED);
                } else if (classId.equals(ClassID.SCSI_TARGET_PORT)) {
                    element = this.storage.newSCSITargetPort(aCED);
                } else if (classId.equals(ClassID.LUN)) {
                    element = this.storage.newLU(aCED);
                } else if (classId.equals(ClassID.SCSI_LUN)) {
                    element = this.storage.newSCSILun(aCED);
                } else if (classId.equals(ClassID.VSWITCH)) {
                    element = this.newVSwitch(aCED);
                } else if (classId.equals(ClassID.NETWORK_CONFIGURATION)) {
                    element = this.newIPTableRow(aCED);
                } else if (classId.equals(ClassID.PORTAL)) {
                    element = this.newPortalRow(aCED);
                } else if (classId.equals(ClassID.IP_ROUTE)) {
                    element = this.newIPRouteRow(aCED);
                } else if (classId.equals(ClassID.NEIGHBORE)) {
                    element = this.newNeighbor(aCED);
                } else if (classId.equals(ClassID.SNMP_MANAGER)) {
                    element = this.newManager(aCED);
                } else if (classId.equals(ClassID.IDENTITY)) {
                    element = this.newIdentity(aCED);
                } else if (classId.equals(ClassID.IDENTITY_NAME)) {
                    element = this.newIdentityName(aCED);
                } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
                    element = this.newSrpCredentials(aCED);
                } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
                    element = this.newChapCredentials(aCED);
                } else if (classId.equals(ClassID.ACL_ENTRY)) {
                    element = this.newAclEntry(aCED);
                } else if (classId.equals(ClassID.COPY_OPERATION)) {
                    element = this.copyOperMgr.newCopyOper(aCED);
                } else if (classId.equals(ClassID.RADIUS_SERVER)) {
                    element = this.newRadiusServer(aCED);
                } else if (classId.equals(ClassID.ISNS_SERVER)) {
                    element = this.newISNSServer(aCED);
                } else if (classId.equals(ClassID.LU_IDENTIFIER)) {
                    element = this.storage.newLUIdentifier(aCED);
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                    element = this.storage.newSnapshotVolume(aCED, commKeys);
                } else if (classId.equals(ClassID.SNAPSHOT_SCHEDULER)) {
                    element = this.mySnapshotSchedulerMgr.newSnapshotScheduler(aCED);
                } else if (classId.equals(ClassID.JOURNAL_VOLUME)) {
                    element = this.storage.newJournalVolume(aCED, commKeys);
                } else if (classId.isDRClassId()) {
                    element = this.drManager.newElement(classId, commKeys, aCED, aPostEventExecutor);
                } else if (classId.equals(ClassID.POLICY_PARAMS)) {
                    element = this.newPolicyParamTableEntry(new CommKeyClassId(commKeys, classId), aCED);
                } else if (classId.equals(ClassID.POLICY_START)) {
                    element = this.newPolicyTableEntry(new CommKeyClassId(commKeys, classId), aCED);
                } else if (classId.equals(ClassID.FC_NODE)) {
                    element = this.newFCNode(aCED);
                } else if (classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE)) {
                    element = this.newInterfaceRow(aCED);
                } else if (classId.equals(ClassID.HARDWARE)) {
                    element = this.createVSwitchHardware(aCED);
                } else if (classId.equals(ClassID.STATISTIC_TCP)) {
                    element = this.createTCPStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_UDP)) {
                    element = this.createUDPStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_ICMP)) {
                    element = this.createICMPStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_IP)) {
                    element = this.newIPStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_ETHERNET)) {
                    element = this.createEthernetStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_INTERFACE)) {
                    element = this.newInterfaceRowStatistics(aCED);
                } else if (classId.equals(ClassID.STATISTIC_UDP_LISTENER)) {
                    element = this.newUDPListenerStatisticsRow(aCED);
                } else if (classId.equals(ClassID.STATISTIC_TCP_CONNECTION)) {
                    element = this.newTCPConnectionStatisticsRow(aCED);
                } else if (classId.equals(ClassID.ISCSI_INSTANCE)) {
                    element = this.newISCSIInstance(aCED);
                } else if (classId.equals(ClassID.ISCSI_SESSION)) {
                    element = this.newISCSISession(aCED);
                } else if (classId.equals(ClassID.ISCSI_SESSION_STATISTICS)) {
                    element = this.newISCSISessionStatistics(aCED);
                } else if (classId.equals(ClassID.ISCSI_CONNECTION)) {
                    element = this.newISCSIConnection(aCED);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR)) {
                    element = this.newISCSIRemoteInitiator(aCED);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS)) {
                    element = this.newISCSIRemoteInitiatorStatistics(aCED);
                } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
                    element = this.newISCSIInitiator(aCED);
                } else if (classId.equals(ClassID.SCSI_INITIATOR_PORT)) {
                    element = this.newSCSIInitiatorPort(aCED);
                } else {
                    theLogger.warn(SrLogCategories.LEGACY, "Class id ", classId, " not found in ", this.getClass(), "::newElement()");
                    return null;
                }
                if (element == null) {
                    theLogger.warn(SrLogCategories.INFORMATIVE, "this code shouldn't be reached. This means that the element creation ", "utitlity methods returned a null, which they shouldn't do. aCED: ", aCED);
                    this.pendingNewElements.put(aCED.getCommKeyClassId(), aCED);
                    return null;
                }
                this.myCommKeyRefMap.addCommKeyClassIdAndRef(commKeys, classId, element);
                VSwitchImpl vSwitch = this.getVSwitch(classId, commKeys, aCED);
                this.createElementCompleted(vSwitch, element, commKeys, classId, aPostEventExecutor);
                this.myCorruptionMgr.subElementCreated(new CommKeyClassId(commKeys, classId), element, aPostEventExecutor);
                if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
                    this.fireTotalCapacityChanged();
                } else if (classId.equals(ClassID.LUN)) {
                    this.fireAccessibleSpaceChanged();
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                    VolumeNodeImpl snapshotSource = ((SnapshotVolumeImpl)element).getSourceVolume(vSwitch);
                    this.checkSnapshotConsistencyWithSourceExposedOn(snapshotSource, vSwitch);
                } else if (classId.equals(ClassID.ISCSI_TARGET)) {
                    this.setLocalTargetCredentials((ISCSITargetImpl)element);
                    this.addSCSIiSCSIMap(vSwitch, (ISCSITargetImpl)element);
                    this.storage.getTargetListMgr().updateVswitch(vSwitch);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                    ISCSIRemoteTargetImpl elem = (ISCSIRemoteTargetImpl)element;
                    this.setRemoteTargetCHAPCredentials(elem);
                    if (SystemRootImpl.getInstance().isDiscoverCompleted()) {
                        ErrorAssertingListener.listenTo(this.setRemoteTargetAliasIfCreatedByVSwitch(elem, vSwitch));
                    }
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    ISCSIRemoteTargetPortalImpl elem = (ISCSIRemoteTargetPortalImpl)element;
                    ISCSIRemoteTargetImpl remoteTargetElem = (ISCSIRemoteTargetImpl)elem.getRemoteTarget();
                    remoteTargetElem.removePendingCreatedRemotePortalIfNeeded(elem, vSwitch.getCommKeyClassId());
                } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
                    this.setLocalInitiatorCredentials((ISCSIInitiatorImpl)element);
                    this.addSCSIiSCSIMap(vSwitch, (ISCSIInitiatorImpl)element);
                } else if (classId.equals(ClassID.IDENTITY_NAME) && (identityParent = (name = (IdentityNameImpl)element).getIdentityParent()).isOfRemoteInitiatorDR()) {
                    String identityAlias = identityParent.getAlias();
                    this.getIdentitiesList().removeDrIdentityPendingCreateForInitiatorNames(identityAlias, name.getName());
                }
                if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
                    ErrorAssertingListener.listenTo(this.synchronizeNewElementBetweenSites(element, vSwitch, false));
                }
            }
            catch (AlreadyKnownByVSwitch akbv) {
                CommKeyClassId fromVSwitch;
                DRLogicObjectImpl drElement;
                element = akbv.getElement();
                if (classId.equals(ClassID.COPY_OPERATION)) {
                    element.addCommKeys(commKeys);
                    this.myCommKeyRefMap.addCommKeyClassIdAndRef(commKeys, classId, element);
                    this.myCorruptionMgr.subElementCreated(new CommKeyClassId(commKeys, classId), element, aPostEventExecutor);
                    this.elementChanged(element, aCED, aPostEventExecutor);
                }
                element.changeParameterList(aCED);
                StringBuffer debugMsg = new StringBuffer(classId.toString());
                debugMsg.append(" ");
                debugMsg.append(element);
                debugMsg.append(" already known by " + ClassID.VSWITCH);
                theLogger.trace(SrLogCategories.LEGACY, debugMsg);
                if (!this.isDiscoverCompleted()) {
                    SystemRootImpl.setStatusInProcess(debugMsg.toString());
                }
                VSwitchImpl vSwitch = this.getVSwitch(classId, commKeys, aCED);
                if (!element.getClassId().equals(ClassID.VSWITCH) && vSwitch != null) {
                    vSwitch.setConnected(true);
                }
                element.addCommKeys(commKeys);
                this.myCommKeyRefMap.addCommKeyClassIdAndRef(commKeys, classId, element);
                this.myCorruptionMgr.subElementCreated(new CommKeyClassId(commKeys, classId), element, aPostEventExecutor);
                if (classId.isDRElementClassId() && (drElement = DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element)) != null) {
                    this.generateAlarms(2, drElement, this.getVSwitch(aCED));
                }
                if (classId.equals(ClassID.JOURNAL_VOLUME) && this.isDiscoverCompleted()) {
                    CommKeyClassId activeOn = (CommKeyClassId)aCED.getValue(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
                    if (activeOn != null) {
                        VSwitch activeOnVSwitch = (VSwitch)this.getCommKeyRefMap().getRefByCommKeyClassID(activeOn);
                        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, element);
                        HashMap<ParameterCode, VSwitch> map = new HashMap<ParameterCode, VSwitch>();
                        map.put(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, activeOnVSwitch);
                        elementEvent.setParameterList(map);
                        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
                    }
                } else if (classId.equals(ClassID.SNAPSHOT_VOLUME) && this.isDiscoverCompleted()) {
                    CommKeyClassId newVSwitchId = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
                    VSwitchImpl existingVSwitch = this.getOtherVSwitch((VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(newVSwitchId));
                    SnapshotActivateTypeConstants activateConstant = (SnapshotActivateTypeConstants)((SnapshotVolumeImpl)element).getParameters(existingVSwitch).get(ParameterCode.SNAPSHOT_ACTIVATE).getValue();
                    if (activateConstant.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                        ConfigElementData ced = new ConfigElementData(element.getCommKeyClassId());
                        ced.setValue(ParameterCode.SNAPSHOT_ACTIVATE, activateConstant);
                        ced.setValue(ParameterCode.VSWITCH_ID, newVSwitchId);
                        SnapshotVolumeImpl snap = (SnapshotVolumeImpl)element;
                        if (DRRootImpl.getInstance().getPairUsingVolume(snap) == null) {
                            ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().changeElement(ced));
                        }
                    }
                } else if (classId.equals(ClassID.LUN)) {
                    ErrorAssertingListener.listenTo(((LUImpl)element).synchronizeSerialNumber());
                    ErrorAssertingListener.listenTo(((LUImpl)element).readSCSILunElement());
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET) && this.isDiscoverCompleted()) {
                    fromVSwitch = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
                    VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
                    ErrorAssertingListener.listenTo(this.setRemoteTargetAliasIfCreatedByVSwitch((ISCSIRemoteTargetImpl)element, vswitch));
                    this.fireISCSIRemoteTargetChanged((ISCSIRemoteTargetImpl)element);
                    ISCSIInitiatorImpl initiator = ((ISCSIRemoteTargetImpl)element).getInitiator(vswitch);
                    if (initiator == null) {
                        theLogger.error(SrLogCategories.LEGACY, "ERROR! ClusterImpl = ", this.getAlias(), "; New remote target , AlreadyKnownByVSwitch = ", ((ISCSIRemoteTargetImpl)element).getName(), "; Parent Initiator in null!!!");
                    } else {
                        this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(initiator);
                    }
                } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
                    ISCSIRemoteTargetPortalImpl elem = (ISCSIRemoteTargetPortalImpl)element;
                    ISCSIRemoteTargetImpl remoteTargetElem = (ISCSIRemoteTargetImpl)elem.getRemoteTarget();
                    remoteTargetElem.removePendingCreatedRemotePortalIfNeeded(elem, this.getVSwitch(aCED).getCommKeyClassId());
                    this.fireISCSIRemoteTargetPortalChanged(elem);
                } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL) && this.isDiscoverCompleted()) {
                    fromVSwitch = (CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID);
                    VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
                    ISCSIInitiator initiator = vswitch.getISCSIInitiators()[0];
                    HashMap<ParameterCode, HashMap> map = new HashMap<ParameterCode, HashMap>();
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, ((ISCSIRemotePortalDiscovery)((Object)element)).getLastFailureType());
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, ((ISCSIRemotePortalDiscovery)((Object)element)).getLastSuccessfulDiscovery());
                    map.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, ((ISCSIRemotePortalDiscovery)((Object)element)).getNextPlannedDiscovery());
                    ElementEventImpl elementEvent = new ElementEventImpl(this, element, map);
                    LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
                    this.fireISCSIInitiatorChangedDueToRemotePortalChange((ISCSIInitiatorImpl)initiator);
                } else if (classId.equals(ClassID.ISCSI_TARGET) || classId.equals(ClassID.ISCSI_INITIATOR)) {
                    this.addSCSIiSCSIMap(vSwitch, (SCSIDeviceImpl)element);
                    if (classId.equals(ClassID.ISCSI_TARGET)) {
                        this.storage.getTargetListMgr().updateVswitch(vSwitch);
                    }
                }
                if (element instanceof Synchronizeable) {
                    theLogger.trace(SrLogCategories.LEGACY, "Element Synchronizeable create", element.toString());
                    if (((SynchronizeableImpl)element).isSynchronizePending()) {
                        theLogger.trace(SrLogCategories.LEGACY, "Element Synchronizeable is Pending", element);
                        ((SynchronizeableImpl)element).syncDataWasChanged();
                    }
                }
                if (!SystemRootImpl.getInstance().isDiscoverCompleted() || !(element instanceof SitesSynchronizeable)) break block165;
                this.synchronizeNewElementBetweenSites(element, vSwitch, true);
            }
        }
        if (element != null) {
            element.clearDeletionStatus();
        }
        if (this.isDiscoverCompleted() && element instanceof GeneralSCSIDeviceImpl) {
            AliasSynchronizer synchronizer = new AliasSynchronizer(ALIAS_PREFIX);
            ErrorAssertingListener.listenTo(synchronizer.sync((GeneralSCSIDeviceImpl)element));
        }
        return element;
    }

    private SrFuture<Void> synchronizeNewElementBetweenSites(LogicObject element, VSwitchImpl vSwitch, boolean isBecauseOfAlreadyKnownCase) throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.synchronizeNewElementBetweenSites");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (isBecauseOfAlreadyKnownCase && element instanceof ISCSITargetImpl) {
            retFuture.set(null);
            return retFuture;
        }
        ArrayList<ClusterImpl> clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
        for (int index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
            ClusterImpl remoteCluster = clustersInOtherSites.get(index2);
            if (element instanceof ISCSIRemoteTargetImpl) {
                VSwitchImpl[] createOnVSwitches = new VSwitchImpl[]{vSwitch};
                midFutures.add(((ISCSIRemoteTargetImpl)element).synchronizeNewElementOnRemoteCluster(remoteCluster, createOnVSwitches));
                continue;
            }
            midFutures.add(((SitesSynchronizeable)((Object)element)).synchronizeNewElementOnRemoteCluster(remoteCluster));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public StoragePool getStoragePool() {
        return this.storage.getStoragePool();
    }

    public StoragePoolMgr getStoragePoolMgr() {
        return this.storage.getStoragePoolMgr();
    }

    public TargetList getTargetListMgr() {
        return this.storage.getTargetListMgr();
    }

    public RemoteTargetList getRemoteTargetListMgr() {
        return this.storage.getRemoteTargetListMgr();
    }

    public IdentitiesList getIdentitiesList() {
        return this.identities;
    }

    public Vector<IdentityImpl> getAllIdentities() throws RemoteException {
        return this.identities.getAllIdentities();
    }

    public ExternalServerList getRadiusServersList() {
        return this.radiusServerList;
    }

    public ExternalServerList getISNSServersList() {
        return this.isnsServerList;
    }

    public Vector<ExternalServerImpl> getAllRadiusServers() {
        return this.radiusServerList.getAllServers();
    }

    public Vector<ExternalServerImpl> getAllISNSServers() {
        return this.isnsServerList.getAllServers();
    }

    public VolumeManager getVolumeMgr() {
        return this.storage.getVolumeMgr();
    }

    private HashMap elementChanged(LogicObjectImpl element, ConfigElementData aCED, SrPostponedExecutor aPostEventExecutor) throws RemoteException, IllegalValueException, InvalidElementException {
        SrString userName;
        ElementEventImpl elementEvent;
        String ip;
        VSwitchImpl neighborVSwitch;
        NeighborImpl neighbor;
        if (element == null) {
            this.myCorruptionMgr.elementChanged(aCED, aPostEventExecutor);
            return new HashMap();
        }
        Object lastUpdate = aCED.getValue(ParameterCode.LAST_UPDATE);
        VSwitchImpl vSwitch = this.getVSwitch(element.getClassId(), element.getCommKeys(), aCED);
        if (lastUpdate != null && !element.isNewer((SrTimeTicks)lastUpdate, vSwitch)) {
            return new HashMap();
        }
        ClassID classId = element.getClassId();
        if (classId.equals(ClassID.VSWITCH)) {
            Object coldStart = aCED.getValue(ParameterCode.VSWITCH_COLD_START);
            if (coldStart != null) {
                return new HashMap();
            }
            if (aCED.containsParameter(ParameterCode.VSWITCH_TAKE_OVER_STATE) && vSwitch != null) {
                LogicMgrAOImpl.getInstance().__elementChanged(new ElementEventImpl(this, this, aCED.getParametersList()));
                ErrorAssertingListener.listenTo(vSwitch.readIPsState());
            }
        }
        HashMap changedValues = element.changeParameterList(aCED);
        if (classId.equals(ClassID.NEIGHBORE) && this.isDiscoverCompleted() && ((neighbor = (NeighborImpl)element).isDead() || neighbor.isAlive()) && (neighborVSwitch = this.getVSwitchByIPAddress(ip = neighbor.getIPAddress())) != null) {
            neighborVSwitch.getDateAndTime();
        }
        if (classId.isDRClassId()) {
            if (element instanceof DRClusterLogicObjectImpl) {
                SrBITSConstant replicationState = (SrBITSConstant)element.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE);
                if (DRRoleConstant.REMOTE.equals(((DRClusterLogicObjectImpl)element).getRole()) && element.getActiveVswitch().equals(vSwitch) && !element.getClassId().equals(ClassID.ASYNC_PAIR)) {
                    if (replicationState.contains(DRReplicationStateConstant.FALLBACK)) {
                        if (!((DRClusterLogicObjectImpl)element).isInSwitchProcess() && (element.getClassId().equals(ClassID.SYNC_PAIR) || aCED.containsParameter(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS) && ((SrGauge)aCED.getValue(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS)).equals(0)) && element.isParameterEqual(new MasterParameter(element.getParameterCode(MasterParameterCode.DR_INITIAL_SYNC_STATE), DRInitialSyncStateConstant.OK), element.getActiveVswitch())) {
                            ((DRClusterLogicObjectImpl)element).setInSwitchProcess(true);
                        }
                    } else {
                        ((DRClusterLogicObjectImpl)element).setInSwitchProcess(false);
                    }
                }
            }
            elementEvent = new ElementEventImpl((Object)element, element);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(changedValues);
            if (!changedValues.isEmpty() && this.isDiscoverCompleted()) {
                this.sendDREvent(elementEvent, 2);
            }
            if (classId.equals(ClassID.CONSISTENCY_GROUP) && element.getConnectedVSwitches().length == 1 && changedValues.containsKey(ParameterCode.DR_VIRT_GROUP_ALIAS) && ((DRClusterAbstractConsistencyGroupImpl)element).isEmpty()) {
                this.drManager.rematchEmptyGroupWithNoPairs((DRClusterAbstractConsistencyGroupImpl)element, aPostEventExecutor);
            }
            return changedValues;
        }
        if (classId.equals(ClassID.POLICY_START) || classId.equals(ClassID.POLICY_PARAMS)) {
            PoliciesManager.getInstance().changePolicyElement(element);
        } else if (classId.equals(ClassID.IDENTITY) && this.isDiscoverCompleted()) {
            IdentityImpl identity = (IdentityImpl)element;
            this.identities.changeEntryKey(identity);
        } else if (classId.equals(ClassID.IDENTITY_NAME) && this.isDiscoverCompleted()) {
            boolean isLocalInitiatorIdentity;
            IdentityNameImpl identityName = (IdentityNameImpl)element;
            IdentityImpl identity = identityName.getIdentityParent();
            if (identity != null && (isLocalInitiatorIdentity = identity.getAlias().startsWith("SELF"))) {
                this.identities.changeEntryKey(identity, identityName.getName());
            }
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            if (changedValues.containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON)) {
                VSwitchImpl otherVSwitch = this.getOtherVSwitch(vSwitch);
                if (otherVSwitch != null && otherVSwitch.isDeletionPending()) {
                    ErrorAssertingListener.listenTo(otherVSwitch.deleteElement());
                }
                Vector allSnapshotSources = ((TargetImpl)element).getAllSnapshotVolumeSources();
                Enumeration e = allSnapshotSources.elements();
                while (e.hasMoreElements()) {
                    VolumeNodeImpl volumeNodeImpl = (VolumeNodeImpl)e.nextElement();
                    this.generateAlarms(2, volumeNodeImpl, vSwitch);
                }
            }
        } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
            CHAPCredentialsImpl chapCredElement;
            IdentityImpl identityParent;
            userName = (SrString)changedValues.get(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
            if (userName != null && this.isDiscoverCompleted() && !(identityParent = (chapCredElement = (CHAPCredentialsImpl)element).getIdentityParent()).isPurposeUnknown()) {
                SynchronizeableImpl synchronizeableImpl = ((CHAPCredentialsImpl)element).getISCSIDevice();
                ParameterCode codeToChange = ParameterCode.ISCSI_TARGET_USER_NAME;
                if (ClassID.ISCSI_REMOTE_TARGET.equals(synchronizeableImpl.getClassId())) {
                    codeToChange = ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME;
                } else if (ClassID.ISCSI_INITIATOR.equals(synchronizeableImpl.getClassId())) {
                    codeToChange = ParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME;
                }
                ElementEventImpl elementEvent2 = new ElementEventImpl((Object)this, synchronizeableImpl);
                HashMap<ParameterCode, SrString> map = new HashMap<ParameterCode, SrString>();
                map.put(codeToChange, userName);
                elementEvent2.setParameterList(map);
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent2);
            }
        } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
            userName = (SrString)changedValues.get(ParameterCode.SRP_CREDENTIALS_USER_NAME);
            if (userName != null) {
                ElementEventImpl elementEvent3 = new ElementEventImpl((Object)this, (SRPCredentialsImpl)element);
                HashMap<ParameterCode, SrString> map = new HashMap<ParameterCode, SrString>();
                map.put(ParameterCode.ISCSI_INITIATOR_SRP_USER_NAME, userName);
                elementEvent3.setParameterList(map);
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent3);
            }
        } else if (classId.isVolumeNode()) {
            SnapshotActivateTypeConstants activate;
            VolumeImpl parent;
            CommKeyClassId parentVol = (CommKeyClassId)changedValues.get(ParameterCode.VIRTUAL_VOLUME_PARENT);
            if (parentVol != null && this.isDiscoverCompleted() && (parent = (VolumeImpl)SystemRootImpl.getInstance().getRefByStub(parentVol)) != null) {
                this.generateAlarms(2, parent, vSwitch);
            }
            if (classId.equals(ClassID.SNAPSHOT_VOLUME) && changedValues.containsKey(ParameterCode.SNAPSHOT_ACTIVATE) && (activate = (SnapshotActivateTypeConstants)changedValues.get(ParameterCode.SNAPSHOT_ACTIVATE)) != null && activate.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                ((SnapshotVolumeImpl)element).syncDataWasChanged();
            }
            if (classId.isSCSIDevice()) {
                this.getStoragePool().storageChanged((GeneralSCSIDeviceImpl)element);
            }
        } else if (classId.isInterface() && changedValues.containsKey(ParameterCode.IF_OPER_STAT)) {
            this.generateAlarms(2, vSwitch, vSwitch);
        }
        if (!changedValues.isEmpty() || element.getClassId().isStatisticsClassId()) {
            if (element.getClassId().equals(ClassID.COPY_OPERATION) && ((CopyOperationImpl)element).getCopyType().isRestore()) {
                this.generateAlarms(2, ((CopyOperationImpl)element).getCopySrcNode(), vSwitch);
                this.generateAlarms(2, ((CopyOperationImpl)element).getCopyDstNode(), vSwitch);
            }
            elementEvent = new ElementEventImpl((Object)element, element);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(changedValues);
            if (element.getClassId().isStatisticsClassId()) {
                HashMap clientRatesMap = ((StatisticsImpl)element).getClientRates();
                elementEvent.getParameterList().putAll(clientRatesMap);
            }
            if (this.isDiscoverCompleted()) {
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
            }
            StringBuffer debugMsg = new StringBuffer(element.getClassId().toString());
            debugMsg.append(" ");
            debugMsg.append(element);
            for (ParameterCode parameterCode : aCED.keySet()) {
                if (parameterCode.equals(ParameterCode.VSWITCH_ID)) continue;
                debugMsg.append(" [");
                debugMsg.append(parameterCode);
                debugMsg.append(" (");
                debugMsg.append(aCED.getValue(parameterCode));
                debugMsg.append(")];");
            }
            debugMsg.append(" was changed on " + ClassID.VSWITCH + " ");
            if (vSwitch != null) {
                debugMsg.append(vSwitch.getMgmIPAddr());
            }
            theLogger.trace(SrLogCategories.LEGACY, debugMsg);
        }
        if (element.getClassId().equals(ClassID.VSWITCH)) {
            ((VSwitchImpl)element).setConnected(true);
            if (changedValues.containsKey(ParameterCode.VSWITCH_SWITCH_ID)) {
                ErrorAssertingListener.listenTo(((VSwitchImpl)element).changeRemotetargetPortalsIfNeeded());
            }
            if (changedValues.containsKey(ParameterCode.VSWITCH_CAPABILITY)) {
                this.updateCapability();
            }
        } else if (vSwitch != null) {
            if (element.getClassId().equals(ClassID.VSWITCH) && (changedValues.containsKey(ParameterCode.VSWITCH_TRAP_UDP_PORT) || changedValues.containsKey(ParameterCode.VSWITCH_READ_COMMUNITY) || changedValues.containsKey(ParameterCode.VSWITCH_WRITE_COMMUNITY))) {
                return changedValues;
            }
            vSwitch.setConnected(true);
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS)) {
            this.fireAccessibleSpaceChanged();
        }
        if (!changedValues.isEmpty() && SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            ArrayList<ClusterImpl> clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (int index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                ClusterImpl remoteCluster = clustersInOtherSites.get(index2);
                ((SitesSynchronizeable)((Object)element)).synchronizeChangeElementOnRemoteCluster(remoteCluster, changedValues);
            }
        }
        return changedValues;
    }

    public void elementEvent(EventObject e) {
        theLogger.trace(SrLogCategories.LEGACY, e, " was received to cluster");
        EventQueueElement eventQueueElement = null;
        if (e instanceof SrEvent) {
            eventQueueElement = new EventQueueElement(e, ((SrEvent)e).getType(), ((SrEvent)e).getEventTypeName());
        } else if (e instanceof DREvent) {
            eventQueueElement = new EventQueueElement(e, ((DREvent)e).getType(), "");
        } else if (e instanceof ErrorEvent) {
            eventQueueElement = new EventQueueElement(e, -1, null);
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, e, "elementEvent: cluster ", this, " received unrecognized event ");
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, eventQueueElement != null, new Object[]{"The given event is of an invalid type."});
        if (eventQueueElement != null) {
            this.processEvent(eventQueueElement);
        }
        if (!this.isDiscoverCompleted()) {
            SystemRootImpl.addToStatusMessage(".");
        }
    }

    public static boolean debugAlertOnEvent(EventObject e, ClassID classId, int srEventType) {
        ConfigElementDataList elements;
        SrElementEvent srEvt;
        boolean alert = false;
        if (e instanceof SrElementEvent && (srEvt = (SrElementEvent)e).getType() == srEventType && (elements = srEvt.getElements()) != null && !elements.isEmpty() && (classId == null || elements.getElementDataAt(0).getClassId().equals(classId))) {
            alert = true;
        }
        if (alert) {
            ((SrElementEvent)e).printStackTrace(System.err);
        }
        return alert;
    }

    public void changeElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    public void changeElement(ConfigElementDataList cedList) {
        throw new UnsupportedOperationException();
    }

    public void readElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    public void readElement(ConfigElementDataList ced) {
        throw new UnsupportedOperationException();
    }

    private SrFuture<Void> removeElementByEvent(LogicObjectImpl element, ConfigElementData aCED, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        if (element == null) {
            this.myCorruptionMgr.elementRemoved(aCED.getCommKeyClassId());
            return new CompleteFuture<Void>("ClusterImpl.removeElementByEvent");
        }
        ClassID classId = element.getClassId();
        VSwitchImpl vSwitch = this.getVSwitch(classId, element.getCommKeys(), aCED);
        SrFuture<Void> retFuture = this.elementRemoved(element, vSwitch, vSwitch.getMgmIPAddr(), aEventMonitor);
        if (classId.equals(ClassID.VSWITCH)) {
            VSwitchClusterMap.getInstance().remove((CommKeyClassId)aCED.getValue(ParameterCode.VSWITCH_ID));
        }
        return retFuture;
    }

    public SrFuture<Void> removeElement(LogicObjectImpl element, VSwitchImpl vSwitch, SrPostponedExecutor aEventMonitor, String aVsIp) throws RemoteException, InvalidElementException {
        return this.elementRemoved(element, vSwitch, aVsIp, aEventMonitor);
    }

    private SrFuture<Void> elementRemoved(LogicObjectImpl element, VSwitchImpl vSwitch, String vSwitchIp, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        CredentialsImpl cred;
        ClusterImpl remoteCluster;
        int index2;
        ArrayList<ClusterImpl> clustersInOtherSites;
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.removeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (element == null) {
            return new CompleteFuture<Void>("ClusterImpl.removeElement");
        }
        element.setDeletionProcessStarted();
        ClassID classId = element.getClassId();
        VolumeNodeImpl snapshotSource = null;
        DirectAccessDeviceImpl parentDisk = null;
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                remoteCluster = clustersInOtherSites.get(index2);
                ErrorAssertingListener.listenTo(((SitesSynchronizeable)((Object)element)).synchronizePreRemoveElementOnRemoteCluster(remoteCluster));
            }
        }
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            element = this.storage.removeDirectAccessDevice((DirectAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE)) {
            element = this.storage.removeSequentialAccessDevice((SequentialAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.GENERAL_SCSI_DEVICE)) {
            element = this.storage.removeGeneralSCSIDevice((GeneralSCSIDeviceImpl)element);
        } else if (classId.isVolume()) {
            if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
                snapshotSource = ((SnapshotVolumeImpl)element).getSourceVolume();
            }
            element = this.storage.removeVolume((VolumeImpl)element, vSwitch);
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            element = this.storage.removeTarget((TargetImpl)element);
            this.getPolicyManager().removeAcl((Target)((Object)element));
            cred = ((ISCSITargetImpl)element).getCredentials();
            if (cred != null) {
                IdentityImpl identity = cred.getIdentityParent();
                if (identity != null) {
                    identity.removeCredentials(cred);
                    this.getCommKeyRefMap().removeCommKeyClassIdAndRef(identity.getCommKeyClassId());
                }
                this.getCommKeyRefMap().removeCommKeyClassIdAndRef(cred.getCommKeyClassId());
            } else {
                theLogger.warn(SrLogCategories.LEGACY, "Credentials is null in removeElement ", element.getClassId(), " ", element);
            }
            CommKeyClassId iscsiTargetCommKeyClassId = element.getCommKeyClassId();
            this.m_scsiDeviceIscsiNodeMap.removeEntryFromMap(iscsiTargetCommKeyClassId);
        } else if (classId.equals(ClassID.ISCSI_INITIATOR)) {
            CommKeyClassId iscsiInitiatorCommKeyClassId = element.getCommKeyClassId();
            this.m_scsiDeviceIscsiNodeMap.removeEntryFromMap(iscsiInitiatorCommKeyClassId);
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
            ISCSIRemoteTargetImpl elem = (ISCSIRemoteTargetImpl)(element = this.storage.removeRemoteTarget((ISCSIRemoteTargetImpl)element));
            if (elem.getConnectedVSwitchCounter() == 1) {
                ISCSIInitiator[] initiatorsImpl = elem.getAllConnectedInitiators();
                for (int index = 0; index < initiatorsImpl.length; ++index) {
                    ISCSIInitiatorImpl initiatorImpl = (ISCSIInitiatorImpl)initiatorsImpl[index];
                    initiatorImpl.removeRemoteTarget(elem);
                    this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(initiatorImpl);
                }
            } else {
                ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)vSwitch.getISCSIInitiators()[0];
                initiator.removeRemoteTarget(elem);
                this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(initiator);
            }
            CHAPCredentialsImpl chapCred = ((ISCSIRemoteTargetImpl)element).getCHAPCredentials();
            if (chapCred != null) {
                IdentityImpl identity = chapCred.getIdentityParent();
                if (identity != null) {
                    identity.removeCredentials(chapCred);
                    ErrorAssertingListener.listenTo(this.elementRemoved(chapCred, vSwitch, vSwitchIp, aEventMonitor), this.elementRemoved(identity, vSwitch, vSwitchIp, aEventMonitor));
                }
            } else {
                theLogger.warn(SrLogCategories.LEGACY, "Credentials is null in removeElement ", element.getClassId(), " ", element);
            }
            ISCSIRemoteTargetPortal[] portals = ((ISCSIRemoteTargetImpl)element).getISCSIPortals();
            for (int index = 0; index < portals.length; ++index) {
                ISCSIRemoteTargetPortalImpl portal = (ISCSIRemoteTargetPortalImpl)portals[index];
                midFutures.add(this.elementRemoved(portal, vSwitch, vSwitchIp, aEventMonitor));
            }
            ISCSISession[] sessions = ((ISCSIRemoteTargetImpl)element).getISCSISessions();
            for (int index = 0; index < sessions.length; ++index) {
                ISCSISessionImpl session = (ISCSISessionImpl)sessions[index];
                midFutures.add(this.elementRemoved(session, vSwitch, vSwitchIp, aEventMonitor));
            }
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
            element = this.storage.removeRemoteTargetPortal((ISCSIRemoteTargetPortalImpl)element);
        } else if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL)) {
            ISCSIRemotePortalDiscoveryImpl remoteDiscoveryPortal = (ISCSIRemotePortalDiscoveryImpl)element;
            VSwitchImpl[] connectedVSwitches = remoteDiscoveryPortal.getConnectedVSwitches();
            ISCSIInitiatorImpl connectedInitiator = null;
            if (connectedVSwitches.length == 1) {
                connectedInitiator = (ISCSIInitiatorImpl)connectedVSwitches[0].getISCSIInitiators()[0];
                connectedInitiator.removeRemoteDiscoveryPortal(remoteDiscoveryPortal);
            } else {
                connectedInitiator = (ISCSIInitiatorImpl)vSwitch.getISCSIInitiators()[0];
                connectedInitiator.removeRemoteDiscoveryPortal(remoteDiscoveryPortal);
            }
            this.fireISCSIInitiatorChangedDueToRemoteTargetRemove(connectedInitiator);
        } else if (classId.equals(ClassID.LUN)) {
            element = this.storage.luRemoved((LUImpl)element);
        } else if (classId.equals(ClassID.SCSI_LUN)) {
            element = this.storage.removeSCSILun((SCSILunImpl)element);
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            parentDisk = ((SubDirectAccessDeviceImpl)element).getDirectAccessDeviceParent();
            element = this.storage.removeSubDirectAccessDevice((SubDirectAccessDeviceImpl)element);
        } else if (classId.equals(ClassID.ISCSI_SESSION)) {
            ISCSISessionImpl iscsiSession = (ISCSISessionImpl)element;
            iscsiSession.removeFromAll();
            Vector<ISCSIConnectionImpl> connections = iscsiSession.getConnections();
            for (ISCSIConnectionImpl connection : connections) {
                midFutures.add(this.removeElement(connection, vSwitch, aEventMonitor, vSwitchIp));
            }
            element = this.removeTabelRow((TableRowImpl)element);
            CommKeyClassId sessionStatisticsCommKeyClassId = new CommKeyClassId(iscsiSession.getCommKeys(), ClassID.ISCSI_SESSION_STATISTICS);
            ISCSISessionStatisticsImpl elementToRemove = (ISCSISessionStatisticsImpl)SystemRootImpl.getInstance().getRefByStub(sessionStatisticsCommKeyClassId);
            midFutures.add(this.removeElement(elementToRemove, vSwitch, aEventMonitor, vSwitchIp));
        } else if (classId.equals(ClassID.ISCSI_CONNECTION)) {
            ISCSIConnectionImpl iscsiConnection = (ISCSIConnectionImpl)element;
            ISCSISessionImpl iscsiSession = iscsiConnection.getSessionParent();
            if (iscsiSession != null) {
                iscsiSession.removeConnection(iscsiConnection);
            }
        } else if (classId.equals(ClassID.NETWORK_CONFIGURATION) || classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.STATISTIC_INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE) || classId.equals(ClassID.PORTAL) || classId.equals(ClassID.IP_ROUTE) || classId.equals(ClassID.NEIGHBORE) || classId.equals(ClassID.ISCSI_SESSION_STATISTICS) || classId.equals(ClassID.ISCSI_INSTANCE) || classId.equals(ClassID.STATISTIC_UDP_LISTENER) || classId.equals(ClassID.STATISTIC_TCP_CONNECTION) || classId.equals(ClassID.SNMP_MANAGER)) {
            element = this.removeTabelRow((TableRowImpl)element);
        } else if (classId.equals(ClassID.VSWITCH)) {
            this.generateAlarms(3, element, null);
            this.myVSwitches.remove(element);
            ((VSwitchImpl)element).unregisterBean();
            ((VSwitchImpl)element).clear();
            this.updateCapability();
            if (!((VSwitchImpl)element).isDeletedFromDatabaseOnly()) {
                if (!this.myVSwitches.isEmpty()) {
                    ErrorAssertingListener.listenTo(this.myVSwitches.get(0).setAllIPsActive());
                }
                ErrorAssertingListener.listenTo(this.removeNeighbor(((VSwitch)((Object)element)).getMgmIPAddr()));
            } else {
                theLogger.logAndAssert(SrLogCategories.DEBUG, "The move VS code has been reached through the following stacktrace: ", Thread.currentThread().getStackTrace());
                VSwitchImpl vSwitchImpl = (VSwitchImpl)element;
                if (vSwitchImpl.isPendingMovingToCluster()) {
                    try {
                        ClusterImpl cluster = (ClusterImpl)vSwitchImpl.getWatingMovingCluster();
                        ErrorAssertingListener.listenTo(cluster.addVSwitch(vSwitchImpl));
                    }
                    catch (IllegalValueException ive) {
                        theLogger.warn(SrLogCategories.LEGACY, ive);
                    }
                }
            }
        } else if (classId.equals(ClassID.IDENTITY)) {
            element = this.identities.removeIdentity((IdentityImpl)element);
        } else if (classId.equals(ClassID.IDENTITY_NAME)) {
            IdentityNameImpl identityName = (IdentityNameImpl)element;
            IdentityImpl identity = identityName.getIdentityParent();
            identity.removeName(identityName);
        } else if (classId.equals(ClassID.SRP_CREDENTIALS) || classId.equals(ClassID.CHAP_CREDENTIALS)) {
            cred = (CredentialsImpl)element;
            IdentityImpl parent = cred.getIdentityParent();
            if (parent != null) {
                parent.removeCredentials(cred);
            }
        } else if (classId.equals(ClassID.RADIUS_SERVER)) {
            this.radiusServerList.removeExternalServer((RadiusServerImpl)element);
        } else if (classId.equals(ClassID.ISNS_SERVER)) {
            this.isnsServerList.removeExternalServer((ISNSServerImpl)element);
        } else if (!classId.equals(ClassID.ACL_ENTRY)) {
            if (classId.equals(ClassID.COPY_OPERATION)) {
                this.copyOperMgr.removeCopyOper((CopyOperationImpl)element);
            } else if (classId.isDRClassId()) {
                if (this.isDiscoverCompleted()) {
                    if (element.getConnectedVSwitchCounter() == 1) {
                        this.sendDREvent(element, 3);
                    } else {
                        DRLogicObjectImpl drElement = DRRootImpl.getInstance().findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element);
                        DrAlarmMgrImpl.getInstance().generateAlarms(3, drElement, vSwitch);
                    }
                }
                this.drManager.removeElement(element, vSwitch, aEventMonitor);
            } else if (classId.isPolicyClassId()) {
                PoliciesManager.getInstance().removePolicyElement(element);
            } else if (classId.equals(ClassID.ISCSI_TARGET_QOS_GROUP)) {
                this.myTargetQosMgr.removeISCSITargetQosGroup((TargetQosGroupImpl)element);
            } else if (classId.equals(ClassID.ATTACHED_RAID)) {
                this.myAttachedRaidMgr.removeAttachedRaid((AttachedRaidImpl)element);
            } else if (classId.equals(ClassID.SNAPSHOT_SCHEDULER)) {
                this.mySnapshotSchedulerMgr.removeSnapshotScheduler((SnapshotSchedulerImpl)element);
            } else {
                theLogger.warn(SrLogCategories.LEGACY, "Class id ", classId, " not found in ", this.getClass(), "::removeElement()");
            }
        }
        if (element != null) {
            this.removeElementCompleted(element, vSwitch, aEventMonitor);
            element.setDeletionProcessCompleted();
        } else {
            theLogger.error(SrLogCategories.LEGACY, "Error in remove element ", classId);
        }
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            this.fireTotalCapacityChanged();
        } else if (classId.equals(ClassID.LUN)) {
            this.fireAccessibleSpaceChanged();
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
            ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)element;
            if (remoteTarget.getConnectedVSwitchCounter() == 1 && !remoteTarget.isInDeletionProcess()) {
                this.fireISCSIRemoteTargetChanged(remoteTarget);
            }
        } else if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
            ISCSIRemoteTargetPortalImpl remotePortal = (ISCSIRemoteTargetPortalImpl)element;
            if (remotePortal.getConnectedVSwitchCounter() == 1) {
                this.fireISCSIRemoteTargetPortalChanged(remotePortal);
                ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)remotePortal.getRemoteTarget();
                if (!remoteTarget.isInDeletionProcess()) {
                    this.fireISCSIRemoteTargetChanged(remoteTarget);
                }
            }
        } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
            try {
                this.checkSnapshotConsistencyWithSourceExposedOn(snapshotSource, vSwitch);
            }
            catch (IllegalValueException ive) {
                theLogger.trace(SrLogCategories.LEGACY, ive);
            }
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE) && vSwitch != null) {
            this.generateAlarms(2, parentDisk, vSwitch);
        }
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && element instanceof SitesSynchronizeable) {
            clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            for (index2 = 0; index2 < clustersInOtherSites.size(); ++index2) {
                remoteCluster = clustersInOtherSites.get(index2);
                ((SitesSynchronizeable)((Object)element)).synchronizePostRemoveElementOnRemoteCluster(remoteCluster);
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private void checkSnapshotConsistencyWithSourceExposedOn(VolumeNodeImpl snapshotSource, VSwitchImpl vSwitch) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted() && snapshotSource != null) {
            this.generateAlarms(2, snapshotSource, vSwitch);
        }
    }

    private void fireTotalCapacityChanged() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
            HashMap<ClientParameterCode, BigInteger> parameterList = new HashMap<ClientParameterCode, BigInteger>();
            parameterList.put(ClientParameterCode.CLUSTER_TOTAL_CAPACITY, this.getTotalCapacity());
            elementEvent.setParameterList(parameterList);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
    }

    private void fireAccessibleSpaceChanged() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
            HashMap<ClientParameterCode, BigInteger> parameterList = new HashMap<ClientParameterCode, BigInteger>();
            parameterList.put(ClientParameterCode.CLUSTER_ACCESSIBLE_SPACE, this.getAccessibleSpace());
            elementEvent.setParameterList(parameterList);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
    }

    private void fireISCSIInitiatorChangedDueToRemotePortalChange(ISCSIInitiatorImpl initiator) throws RemoteException {
        HashMap<ParameterCode, ISCSIRemotePortalDiscovery[]> map = new HashMap<ParameterCode, ISCSIRemotePortalDiscovery[]>();
        map.put(ParameterCode.ISCSI_INITIATOR_REMOTE_DISCOVERY_PORTALS, initiator.getISCSIRemoteDiscoveryPortals());
        ElementEventImpl elementEvent = new ElementEventImpl(this, initiator, map);
        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
    }

    private void fireISCSIInitiatorChangedDueToRemoteTargetRemove(ISCSIInitiatorImpl initiator) throws RemoteException {
        HashMap<ParameterCode, ISCSIRemoteTarget[]> map = new HashMap<ParameterCode, ISCSIRemoteTarget[]>();
        map.put(ParameterCode.ISCSI_INITIATOR_REMOTE_TARGETS, initiator.getISCSIRemoteTargets());
        ElementEventImpl elementEvent = new ElementEventImpl(this, initiator, map);
        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
    }

    private void fireISCSIRemoteTargetChanged(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        HashMap<ParameterCode, HashMap> map = new HashMap<ParameterCode, HashMap>();
        map.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, remoteTarget.getLoginStatus());
        map.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, remoteTarget.getFailureType());
        ElementEventImpl elementEvent = new ElementEventImpl(this, remoteTarget, map);
        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
    }

    private void fireISCSIRemoteTargetPortalChanged(ISCSIRemoteTargetPortalImpl remotePortal) {
        HashMap<ParameterCode, VSwitch[]> map = new HashMap<ParameterCode, VSwitch[]>();
        map.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_CONNECTED_VSWITCHES, remotePortal.getConnectedVSwitchesList());
        try {
            ElementEventImpl elementEvent = new ElementEventImpl(this, remotePortal, map);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
    }

    private void fireISCSITargetCredentialsChanged(ISCSITargetImpl target) {
        HashMap<ParameterCode, String> map = new HashMap<ParameterCode, String>();
        map.put(ParameterCode.ISCSI_TARGET_USER_NAME, target.getUserName());
        try {
            ElementEventImpl elementEvent = new ElementEventImpl(this, target, map);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
    }

    private void fireISCSIRemoteTargetCredentialsChanged(ISCSIRemoteTargetImpl remoteTarget) {
        HashMap<ParameterCode, String> map = new HashMap<ParameterCode, String>();
        map.put(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, remoteTarget.getCHAPUserName());
        try {
            ElementEventImpl elementEvent = new ElementEventImpl(this, remoteTarget, map);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
    }

    private void removeElementCompleted(LogicObjectImpl element, VSwitchImpl vSwitch, SrPostponedExecutor aPostEventExecutor) throws RemoteException, InvalidElementException {
        AclEntryImpl entry;
        IdentityImpl identityParent;
        LUImpl lu0;
        LUImpl lu;
        ClassID classId = element.getClassId();
        ElementEventImpl elementEvent = new ElementEventImpl((Object)element, element);
        String vSwitchIp = null;
        if (vSwitch != null) {
            vSwitchIp = vSwitch.getMgmIPAddr();
        }
        elementEvent.setVSwitchIp(vSwitchIp);
        if (element != null && element.getConnectedVSwitchCounter() == 1) {
            this.generateAlarms(3, element, null);
        }
        boolean vSwitchDeletedFromDB = classId.equals(ClassID.VSWITCH) && ((VSwitchImpl)element).isDeletedFromDatabaseOnly();
        boolean isVswitchOrNeighbor = classId.equals(ClassID.VSWITCH) || classId.equals(ClassID.NEIGHBORE);
        boolean isAboutToBeRemoved = !isVswitchOrNeighbor && element.getConnectedVSwitchCounter() == 1;
        boolean isGdrElement = classId.isDRClassId();
        if (!isGdrElement && (isAboutToBeRemoved || isVswitchOrNeighbor || !vSwitchDeletedFromDB && this.isDiscoverCompleted())) {
            this.myDependencyMgr.publishDeletedElementOrPostpone(element);
        }
        int vSwitchCount = 0;
        CommKey[] removedCommKey = null;
        if (!classId.equals(ClassID.VSWITCH) && vSwitch != null) {
            removedCommKey = element.removeFromVSwitch(vSwitch);
            vSwitchCount = element.getConnectedVSwitchCounter();
            vSwitch.setConnected(true);
        } else {
            removedCommKey = element.getCommKeys();
        }
        if (vSwitchCount == 0) {
            element.unregisterToPropagatedStateChange();
            this.removePropagationStateDependentObjectAndListener(element);
            if (classId.equals(ClassID.ACL_ENTRY)) {
                AclEntryImpl entry2 = (AclEntryImpl)element;
                AclImpl acl = entry2.getAclParent();
                ErrorAssertingListener.listenTo(acl.removeAclEntry(entry2));
            }
        } else if (classId.isDRGroup()) {
            try {
                this.drManager.rematchEmptyGroupWithNoPairs((DRClusterAbstractConsistencyGroupImpl)element, aPostEventExecutor);
            }
            catch (IllegalValueException ive) {
                theLogger.error(SrLogCategories.LEGACY, ive, new Object[0]);
            }
        }
        StringBuffer debugMsg = new StringBuffer(classId.toString());
        debugMsg.append(" ");
        debugMsg.append(element);
        debugMsg.append(" was removed");
        if (!classId.equals(ClassID.VSWITCH)) {
            debugMsg.append(" from " + ClassID.VSWITCH + " ");
            debugMsg.append(vSwitchIp);
        }
        theLogger.trace(SrLogCategories.LEGACY, debugMsg);
        if (removedCommKey != null) {
            this.getCommKeyRefMap().removeCommKeyClassIdAndRef(removedCommKey, classId);
            if (classId.equals(ClassID.VSWITCH)) {
                InterfacesGroupStatisticsImpl statGroup = ((VSwitchImpl)element).getInterfacesGroupStatistics();
                this.getCommKeyRefMap().removeCommKeyClassIdAndRef(statGroup.getCommKeys(), statGroup.getClassId());
                if (!vSwitchDeletedFromDB) {
                    Vector allRefs = this.getCommKeyRefMap().getAllRefs();
                    Enumeration e = allRefs.elements();
                    while (e.hasMoreElements()) {
                        LogicObjectImpl elementRef = (LogicObjectImpl)e.nextElement();
                        if (!elementRef.isKnownByVSwitch(vSwitch)) continue;
                        if (elementRef.getConnectedVSwitchCounter() == 1) {
                            ErrorAssertingListener.listenTo(this.elementRemoved(elementRef, null, vSwitch.getMgmIPAddr(), aPostEventExecutor));
                        }
                        elementRef.removeFromVSwitch(vSwitch);
                    }
                } else {
                    this.clearPolicies();
                    this.getCommKeyRefMap().clear();
                }
            } else if (classId.equals(ClassID.ISCSI_TARGET)) {
                if (vSwitch != null) {
                    this.storage.getTargetListMgr().updateVswitch(vSwitch);
                } else {
                    theLogger.info(SrLogCategories.ERROR, "The given VS is null. element = ", element);
                }
            }
        }
        if (element.getClassId().equals(ClassID.LUN) && element.getConnectedVSwitchCounter() == 0 && (lu = (LUImpl)element).getLUN() != 0 && (lu0 = lu.getParentTarget().getLU(0)) != null && lu0.isDeletionPending()) {
            try {
                ErrorAssertingListener.listenTo(lu0.deleteElement());
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive, "When trying to re-delete lu0 of target ", lu.getParentTarget(), " ");
            }
        }
        if (classId.equals(ClassID.ACL_ENTRY) && (identityParent = (entry = (AclEntryImpl)element).getIdentity()) != null && identityParent.isDeletionPending()) {
            try {
                ErrorAssertingListener.listenTo(identityParent.deleteElement());
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, "When trying to re-delete identity ", ive, identityParent.getAlias(), " ");
            }
        }
    }

    public void removeElement(ConfigElementData ced) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getAlias();
        this.m_scsiDeviceIscsiNodeMap.setClusterName(this.getAlias());
        if (this.myBean == null) {
            this.myBean = new ClusterImplJmx(this);
        }
        return changedValues;
    }

    private void setVSwitcNameIfDisconnected() throws RemoteException, InvalidElementException {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            Vector<NeighborImpl> neighbors;
            VSwitchImpl neighbor;
            if (vSwitch.isConnected() || (neighbor = this.getMyNeighbor(vSwitch.getMgmIPAddr())) == null || (neighbors = neighbor.getNeighborTable()) == null || neighbors.isEmpty()) continue;
            String name = neighbors.firstElement().getName();
            ConfigElementData tmpCed = new ConfigElementData(vSwitch.getCommKeyClassId());
            tmpCed.addParameter(new Parameter(ParameterCode.VSWITCH_NAME, new SrString(name)));
            try {
                vSwitch.changeParameterList(tmpCed);
                if (!this.isDiscoverCompleted()) continue;
                ElementEventImpl elementEvent = new ElementEventImpl((Object)vSwitch, vSwitch);
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
                elementEvent.setParameterList(tmpCed.getParametersList());
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
            }
        }
    }

    private void generateAlarms(int eventType, GeneralLogicObjectImpl source, VSwitchImpl vSwitch) throws RemoteException {
        if (source instanceof DRLogicObjectImpl) {
            this.drAlarmMgr.generateAlarms(null, eventType, source, vSwitch);
        } else {
            this.alarmMgr.generateAlarms(this, eventType, source, vSwitch);
        }
    }

    private void discoverCompleted() throws RemoteException, InvalidElementException {
        if (this.isDiscoverCompleted()) {
            VSwitchImpl vSwitch;
            if (this.myVSwitches.size() == 1 && !(vSwitch = this.myVSwitches.get(0)).getNeighborTable().isEmpty() && vSwitch.isNeighborValid()) {
                return;
            }
            this.updateCapability();
            for (VSwitchImpl vSwitch2 : this.myVSwitches) {
                ErrorAssertingListener.listenTo(vSwitch2.changeRemotetargetPortalsIfNeeded());
                InterfacesGroupStatisticsImpl statGroup = vSwitch2.getInterfacesGroupStatistics();
                this.myCommKeyRefMap.addCommKeyClassIdAndRef(statGroup.getCommKeys(), statGroup.getClassId(), statGroup);
            }
            this.setVSwitcNameIfDisconnected();
            SrPostponedExecutor eventMonitor = new SrPostponedExecutor();
            this.setPendingNewElements(eventMonitor);
            eventMonitor.perform();
            ArrayList<GeneralSCSIDeviceImpl> devices = new ArrayList<GeneralSCSIDeviceImpl>();
            for (Object curStor : this.getStorage().getStorageDevices()) {
                if (!(curStor instanceof GeneralSCSIDeviceImpl)) continue;
                devices.add((GeneralSCSIDeviceImpl)curStor);
            }
            AliasSynchronizer synchronizer = new AliasSynchronizer(ALIAS_PREFIX);
            ErrorAssertingListener.listenTo(synchronizer.sync(devices));
            this.alarmMgr.generateAlarms(this);
            this.alarmMgr.clearPendingAlarms(this);
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
            LogicMgrAOImpl.getInstance().__discoverCompleted(elementEvent);
            theLogger.info(SrLogCategories.LEGACY, ClassID.VSWITCH, " & Virtualization discovery is completed for Cluster ", this.getAlias());
            ErrorAssertingListener.listenTo(SystemRootImpl.getInstance().notifyClusterDiscoveryCompleted(this));
            this.sendDREvent(this, 5);
            for (VSwitchImpl vs : this.myVSwitches) {
                ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().startPollingProcess(vs.getCommKeyClassId()));
            }
            if (this.getNotRemovableVswitch() == null && this.getVSwitchesCount() == 1) {
                this.setNotRemovableVswitch(this.getVSwitches().get(0).getMgmIPAddr());
            }
            if (this.getVSwitchesCount() == 1) {
                this.setNotRemovableVswitch(this.getVSwitches().get(0).getMgmIPAddr());
            }
            if (this.myIsAddNeighborContext) {
                theLogger.info(SrLogCategories.INFORMATIVE, "Setting the neighbors before discovery complete for cluster: ", this.getAlias());
                NeighborUpdater updater = new NeighborUpdater(this, "Neighbor updater for cluster: " + this.getAlias() + " instantiated from ClusterImpl.discoverComplete");
                theLogger.logAndAssert(SrLogCategories.NEIGHBOR_DB, this.getVSwitchesCount() > 1, new Object[]{"The cluster ", this, " is in add-neighbor-context=true but the there is only one V-Switch list: ", this.myVSwitches});
                updater.discoverComplete(this);
                this.myIsAddNeighborContext = false;
            } else if (this.getConnectedVSwitches().length > 1) {
                LogicMgrAOImpl.getInstance().updateDB(LogicMgrAOImpl.DB_UPDATE_DELAY, this);
            }
        }
    }

    public boolean isDRInvolved() {
        return this.drManager.isDRExist();
    }

    private boolean isClusterDiscoveryCompleted() {
        return this.clusterDiscoveryCompleted;
    }

    private void setClusterDiscoveryCompleted(boolean state) {
        this.clusterDiscoveryCompleted = state;
    }

    @Override
    public SrFuture<Void> manualDiscover() throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("Site.manualDiscover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (!vSwitch.isConnected()) continue;
            midFutures.add(vSwitch.manualDiscover());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> reset() throws RemoteException {
        theLogger.info(SrLogCategories.LEGACY, "Start reset Cluster");
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.reset");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            midFutures.add(vSwitch.reset());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public synchronized SrFuture<Void> rediscover() throws RemoteException {
        if (this.getRediscoverFuture() == null) {
            this.setRediscoverFuture(new SrFuture<Void>("ClusterImpl.rediscover, the real future"));
            this.rediscoverBypassFutures();
        }
        return this.getRediscoverFuture();
    }

    private synchronized void rediscoverBypassFutures() throws RemoteException {
        this.myIsNeedRestartRediscovery = false;
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        theLogger.info(SrLogCategories.LEGACY, "Start ", ClassID.VSWITCH, " & Virtualization discovery...");
        SystemRootImpl.setStatusInProcess("Discovering " + ClassID.VSWITCH + " & Virtualization...");
        this.synchronizeClusterParametersDone = false;
        this.sendDREvent(this, 21);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
        LogicMgrAOImpl.getInstance().__startDiscovering(elementEvent);
        this.setStateSeverity(AlarmSeverity.OK);
        this.clearPropagationStateDependentObject();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            vSwitch.clearPropagatedStateOf();
        }
        this.addPropagationStateDependentObject(this.myVSwitches);
        this.clearPropagatedStateOf();
        this.drManager.discoveryStarted();
        this.clearPolicies();
        this.drAlarmMgr.takePendingAlarmList(null);
        this.alarmMgr.takePendingAlarmList(this);
        this.identities.removeAll();
        this.radiusServerList.clear();
        this.isnsServerList.clear();
        this.getCommKeyRefMap().clear();
        this.getPolicyManager().clear();
        this.storage.clear();
        this.copyOperMgr.clear();
        this.pendingNewElements.clear();
        this.m_scsiDeviceIscsiNodeMap.clearAllEntries();
        this.myCorruptionMgr.clear();
        this.myDependencyMgr.clear();
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            vSwitch.setDiscoverCompleted(false);
        }
        if (this.myVSwitches.isEmpty()) {
            try {
                this.discoverCompleted();
            }
            catch (InvalidElementException e1) {
                throw new IllegalStateException("Shouldn't get here, this could be caused if as a result to calling the AO termination, a new element would be created synchroneously, which is illogical.", e1);
            }
        } else {
            for (VSwitchImpl vSwitch : this.myVSwitches) {
                midFutures.add(vSwitch.rediscover());
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().waitForFuturesAndUpdateFromCallable(midFutures, ClusterImpl.this.getRediscoverFuture(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ClusterImpl.this.rediscoverFinished();
                        return null;
                    }
                });
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
    }

    private void rediscoverFinished() throws RemoteException {
        if (this.myIsNeedRestartRediscovery) {
            this.rediscoverBypassFutures();
        } else {
            this.getRediscoverFuture().set(null);
            this.setRediscoverFuture(null);
        }
    }

    @Override
    public ClusterImpl getCluster() {
        return this;
    }

    public void notifyClusterDBReadingCompleted() throws RemoteException, InvalidElementException {
        this.setClusterDiscoveryCompleted(true);
        if (this.myVSwitches.isEmpty()) {
            theLogger.info(SrLogCategories.LEGACY, "Cluster ", this, " discovery is completed - no ", ClassID.VSWITCH, " was found");
            this.alarmMgr.generateAlarms(this);
            this.alarmMgr.clearPendingAlarms(this);
            ErrorAssertingListener.listenTo(SystemRootImpl.getInstance().notifyClusterDiscoveryCompleted(this));
            this.sendDREvent(this, 5);
        } else {
            theLogger.info(SrLogCategories.LEGACY, "Cluster ", this, " discovery is completed");
            SrFuture<Void> rediscoverFuture = this.rediscover();
            ErrorAssertingListener.listenTo(rediscoverFuture);
            Runnable updateRaidCtrlRun = new Runnable(){

                @Override
                public void run() {
                    for (VSwitchImpl vs : ClusterImpl.this.getVSwitches()) {
                        vs.updateRaidControl();
                    }
                }
            };
            DefaultFutureListener.listenTo(updateRaidCtrlRun, rediscoverFuture);
        }
    }

    private boolean isVSwitchesDiscoverCompleted() {
        for (VSwitchImpl vSwitch : this.myVSwitches) {
            if (vSwitch.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    private SrFuture<Void> setManager(VSwitchImpl vSwitch) throws RemoteException {
        return vSwitch.addManagerIfNoManagerIsDefinedYet();
    }

    public void vSwitchDiscoverCompleted(VSwitchImpl vSwitch) throws RemoteException, InvalidElementException {
        if (!vSwitch.isDiscoverCompleted()) {
            theLogger.trace(SrLogCategories.LEGACY, ClassID.VSWITCH, " discover completed - managed ", ClassID.VSWITCH, " ip is: ", vSwitch.getMgmIPAddr());
            vSwitch.setDiscoverCompleted(true);
            ErrorAssertingListener.listenTo(this.setManager(vSwitch));
            this.discoverCompleted();
        }
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        AlarmMgrImpl.getInstance().removeClustersSilencedAlarms(this);
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.deleteElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.canBeDeleted() == null) {
            ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>(this.myVSwitches);
            for (VSwitchImpl vSwitch : vSwitches) {
                midFutures.add(vSwitch.deleteFromDatabase());
            }
        }
        final Callable<Void> followRun = new Callable<Void>(){

            @Override
            public Void call() throws RemoteException, IllegalValueException {
                final SrFuture followUpFuture = ClusterImpl.this.deleteElementFollowUp();
                DefaultFutureListener.listenTo(new Runnable(){

                    @Override
                    public void run() {
                        LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(followUpFuture, retFuture);
                    }
                }, followUpFuture);
                return null;
            }
        };
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().waitForFuturesAndUpdateFromCallable(midFutures, retFuture, followRun);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> deleteElementFollowUp() throws RemoteException, IllegalValueException {
        return super.deleteElement();
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        CommKeyClassId parentSiteCommKeyClassId;
        String alias = (String)parameterList.get(ClientParameterCode.CLUSTER_ALIAS);
        if (alias != null) {
            if (alias.equals("")) {
                alias = "$cl$" + System.currentTimeMillis();
            }
            parameterList.put(ClientParameterCode.CLUSTER_ALIAS, new SrString(alias));
        }
        if ((parentSiteCommKeyClassId = (CommKeyClassId)parameterList.get(ClientParameterCode.PARENT_SITE)) != null) {
            SiteImpl dst = (SiteImpl)SystemRootImpl.getInstance().getRefByStub(parentSiteCommKeyClassId);
            if (dst.equals(this.getParentSite())) {
                return "You are trying to move " + ClassID.CLUSTER + " " + this + " to its parent site " + dst;
            }
            if (this.isInvolvedInDR()) {
                return ClassID.CLUSTER + " " + this + " involved in DR process. You cannot move it until you abort the DR process";
            }
        }
        return null;
    }

    private boolean isInvolvedInDR() {
        return false;
    }

    private void handleErrorEvent(ErrorEvent event) throws RemoteException {
        switch (event.getErrorType()) {
            case 2: {
                this.handleSnmpError((SnmpErrorEvent)event);
                break;
            }
            case 1: {
                this.handleSnmpTimeoutError((SnmpErrorEvent)event);
                break;
            }
            case 3: {
                this.handleConfigurationError(event);
                break;
            }
            case 4: {
                this.handleFatalConfigurationError(event);
            }
        }
    }

    private void handleFatalConfigurationError(ErrorEvent e) throws RemoteException {
        CommKeyClassId source = (CommKeyClassId)e.getSource();
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
        theLogger.fatal(SrLogCategories.LEGACY, "Snmp Configuration Error: ", e.getMessage());
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
        elementEvent.setErrorMesaage(e.getMessage());
        elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
        LogicMgrAOImpl.getInstance().__fatalConfigurationError(elementEvent);
    }

    private void handleConfigurationError(ErrorEvent e) throws RemoteException {
        CommKeyClassId source = (CommKeyClassId)e.getSource();
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
        String ip = vSwitch.getMgmIPAddr();
        theLogger.error(SrLogCategories.LEGACY, "Snmp Configuration Error on ", ClassID.VSWITCH, " ", ip, " ", e.getMessage());
        ElementEventImpl elementEvent = new ElementEventImpl((Object)vSwitch, vSwitch);
        elementEvent.setErrorMesaage(e.getMessage());
        elementEvent.setVSwitchIp(ip);
        LogicMgrAOImpl.getInstance().__configurationError(elementEvent);
    }

    private void handleSnmpError(SnmpErrorEvent e) throws RemoteException {
        CommKeyClassId source = e.getVSwitchData();
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
        String ip = vSwitch.getMgmIPAddr();
        theLogger.error(SrLogCategories.LEGACY, "SNMP error on ", ClassID.VSWITCH, " ", ip, " ", e.getMessage());
    }

    private void handleSnmpTimeoutError(SnmpErrorEvent e) throws RemoteException {
        CommKeyClassId source = e.getVSwitchData();
        if (source == null) {
            return;
        }
        VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(source);
        if (vSwitch == null) {
            return;
        }
        String ip = vSwitch.getMgmIPAddr();
        vSwitch.setConnected(false);
        this.handleSyncConfigurationError(e.getEventElement());
    }

    public SrFuture<Void> deleteObjects(CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException {
        LogicObjectImpl logicObject = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
        return logicObject.deleteElement();
    }

    @Override
    public SrFuture<Void> deleteObjects(CommKeyClassId[] commKeyClassId) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.deleteObjects");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        CommKey[][] commKeys = new CommKey[commKeyClassId.length][];
        ClassID[] classId = new ClassID[commKeyClassId.length];
        for (int i = 0; i < commKeyClassId.length; ++i) {
            commKeys[i] = commKeyClassId[i].getCommKeys();
            classId[i] = commKeyClassId[i].getClassID();
        }
        StringBuffer errMsg = new StringBuffer("Deletion error:\n");
        boolean errOccured = false;
        for (int i = 0; i < classId.length; ++i) {
            LogicObjectImpl source;
            if (classId[i].equals(ClassID.CLUSTER)) {
                source = this;
            } else {
                source = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(commKeys[i], classId[i]);
                if (classId[i].equals(ClassID.IDENTITY) && this.getPolicyManager().isConnectedToTarget((IdentityImpl)source)) {
                    source.setDeletionPending();
                    midFutures.add(this.getPolicyManager().deleteCorrespondingAclEntries((IdentityImpl)source));
                    continue;
                }
            }
            try {
                if (source != null) {
                    midFutures.add(source.deleteElement());
                    continue;
                }
                errMsg.append("source is null.");
                errOccured = true;
                continue;
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, ive);
                errMsg.append(ive.getMessage());
                errMsg.append(".\n");
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> createElement(ConfigElementData element, ClassID classId, String details, List<VSwitchImpl> vSwitches) {
        return this.createElement(element, "Trying to create " + classId + " " + details, vSwitches);
    }

    public SrFuture<Void> createElement(ConfigElementData element, ClassID classId, String details) {
        return this.createElement(element, classId, details, this.getVSwitches());
    }

    public SrFuture<Void> createElement(ConfigElementDataList elementList, String details, List<VSwitchImpl> vSwitches) {
        for (int i = 0; i < elementList.size(); ++i) {
            this.prepareVSwitchIDs(elementList.getElementDataAt(i), details, vSwitches);
        }
        return DataMgrAdapter.getInstance().createElement(elementList);
    }

    public SrFuture<Void> configureElements(ConfigElementDataList aElementList, List<VSwitchImpl> aVSwitches) {
        for (int i = 0; i < aElementList.size(); ++i) {
            this.prepareVSwitchIDs(aElementList.getElementDataAt(i), "configureElements: " + aElementList, aVSwitches);
        }
        return DataMgrAdapter.getInstance().configureElements(aElementList);
    }

    public int getVSwitchesCount() {
        return this.myVSwitches.size();
    }

    public SrFuture<Void> createElement(ConfigElementData element, String details, List<VSwitchImpl> vSwitches) {
        if (this.getConnectedVSwitchCounter() > 0 || element.getClassId().equals(ClassID.VSWITCH)) {
            this.prepareVSwitchIDs(element, details, vSwitches);
            return DataMgrAdapter.getInstance().createElement(element);
        }
        this.handleSyncConfigurationError(element);
        return new CompleteFuture<Void>("ClusterImpl.createElement");
    }

    public void prepareVSwitchIDs(ElementData element, String details, List<VSwitchImpl> vSwitches) {
        CommKeyClassId[] vSwitchestoSet = element.getVswitchIds();
        if (vSwitchestoSet == null || vSwitchestoSet.length == 0) {
            if (vSwitches == null) {
                vSwitches = new ArrayList<VSwitchImpl>();
                for (VSwitchImpl vSwitch : this.getVSwitches()) {
                    if (!vSwitch.isConnected()) continue;
                    vSwitches.add(vSwitch);
                }
            }
            SrType[] vSwitchCommKeyClassId = new CommKeyClassId[vSwitches.size()];
            int i = 0;
            for (VSwitchImpl vSwitch : vSwitches) {
                theLogger.trace(SrLogCategories.LEGACY, ClassID.VSWITCH, " ", vSwitch.getMgmIPAddr(), " - ", details);
                vSwitchCommKeyClassId[i++] = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
            }
            element.setValues(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId);
        }
        for (ParameterCodes key : element.hiddenKeySet()) {
            Object value = element.getValue(key);
            if (value instanceof ConfigElementData) {
                this.prepareVSwitchIDs((ConfigElementData)value, details, vSwitches);
                continue;
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            for (ElementData ced : (ConfigElementDataList)value) {
                this.prepareVSwitchIDs(ced, details, vSwitches);
            }
        }
    }

    public SrFuture<Void> executeOperations(ElementOperationList operationsList, List<VSwitchImpl> vSwitchesToExcute) throws RemoteException {
        if (vSwitchesToExcute == null) {
            vSwitchesToExcute = new Vector<VSwitchImpl>();
            for (VSwitchImpl vSwitch : this.getVSwitches()) {
                if (!vSwitch.isConnected()) continue;
                vSwitchesToExcute.add(vSwitch);
            }
        } else {
            for (VSwitchImpl vSwitch : vSwitchesToExcute) {
                if (vSwitch.isConnected()) continue;
                vSwitchesToExcute.remove(vSwitch);
            }
        }
        if (!vSwitchesToExcute.isEmpty()) {
            for (ElementOperation operation : operationsList) {
                HashMap<ParameterCodes, Object> parameterList = operation.getElement().getParametersList();
                Iterator<ParameterCodes> iter = parameterList.keySet().iterator();
                while (iter.hasNext()) {
                    Object value = parameterList.get(iter.next());
                    if (!(value instanceof CommKeyClassId)) continue;
                    LogicObjectImpl element = (LogicObjectImpl)this.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)value);
                    for (VSwitchImpl vs : vSwitchesToExcute) {
                        if (element.isKnownByVSwitch(vs)) continue;
                        vSwitchesToExcute.remove(vs);
                    }
                }
                CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[vSwitchesToExcute.size()];
                int i = 0;
                for (VSwitch vSwitch : vSwitchesToExcute) {
                    vSwitchCommKeyClassId[i++] = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
                }
                operation.getElement().addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
            }
            if (!operationsList.isEmpty()) {
                return DataMgrAdapter.getInstance().executeOperations(operationsList);
            }
        }
        return new CompleteFuture<Void>("ClusterImpl.executeOperations");
    }

    public boolean isEmpty() {
        return this.getVSwitchesCount() == 0;
    }

    @Override
    public boolean isRedundant() {
        return this.isEmpty() || this.isSingleVSwitchMode() || this.getVSwitchesCount() == 2;
    }

    public String[] getVSwitchesNamesAndIPs() throws RemoteException {
        String[] names = new String[this.getVSwitchesCount()];
        for (int i = 0; i < names.length; ++i) {
            VSwitch vSwitch = this.getVSwitches().get(i);
            names[i] = vSwitch.getName() + " (ip " + vSwitch.getMgmIPAddr() + ")";
        }
        return names;
    }

    public boolean areVSwitchesNeighbors() throws RemoteException {
        if (this.isEmpty() || this.isSingleVSwitchMode()) {
            return true;
        }
        if (this.isRedundant()) {
            VSwitchImpl secondVSwitch;
            VSwitchImpl firstVSwitch = this.myVSwitches.get(0);
            return firstVSwitch.isNeighborOf(secondVSwitch = this.myVSwitches.get(1)) && secondVSwitch.isNeighborOf(firstVSwitch);
        }
        return true;
    }

    public SrFuture<Void> createElement(ConfigElementData element, String details) throws RemoteException, IllegalValueException {
        return this.createElement(element, details, this.getVSwitches());
    }

    @Override
    public void clear() throws RemoteException {
        this.clearPolicies();
        LogicMgrAOImpl.getInstance().removeAllEventsListener(this.drAlarmMgr);
        this.drAlarmMgr.clearPendingAlarms(null);
        this.radiusServerList.clear();
        this.isnsServerList.clear();
        this.getPolicyManager().clear();
        this.storage.clear();
        this.copyOperMgr.clear();
        this.pendingNewElements.clear();
        this.m_scsiDeviceIscsiNodeMap.clearAllEntries();
        this.identities.removeAll();
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int i = 0; i < vswitches.size(); ++i) {
            vswitches.get(i).clear();
        }
        this.myCorruptionMgr.clear();
        this.myDependencyMgr.clear();
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.CLUSTER_FAULTY_INTERVAL, this.getFaultyInterval());
        parameterList.put(ClientParameterCode.CLUSTER_KEEP_ALIVE, this.getKeepAlive());
        parameterList.put(ClientParameterCode.CLUSTER_SUSPICIOUS_INTERVAL, this.getSuspiciousInterval());
        parameterList.put(ClientParameterCode.CLUSTER_FAILOVER_ENABLE, this.isFailoverEnable());
        parameterList.put(ClientParameterCode.CLUSTER_TAKEOVER_STATE, this.getTakeoverState());
        parameterList.put(ClientParameterCode.CLUSTER_CAPABILITY, this.getCapability());
        return parameterList;
    }

    @Override
    public BigInteger getAccessibleSpace() {
        return this.getTargetListMgr().getAccessibleSpace();
    }

    @Override
    public BigInteger getTotalCapacity() {
        return this.getStoragePool().getTotalCapacity();
    }

    @Override
    public Integer getKeepAlive() {
        VSwitchImpl vSwitch = this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getKeepAliveInterval();
        }
        return null;
    }

    @Override
    public Integer getSuspiciousInterval() {
        VSwitchImpl vSwitch = this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getSuspiciousInterval();
        }
        return null;
    }

    @Override
    public Integer getFaultyInterval() {
        VSwitchImpl vSwitch = this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getFaultyInterval();
        }
        return null;
    }

    @Override
    public Boolean isFailoverEnable() {
        VSwitchImpl vSwitch = this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.isFailoverEnable();
        }
        return null;
    }

    @Override
    public SDTakeOverStateConstant getTakeoverState() {
        VSwitchImpl vSwitch = this.getAnyConnectedVSwitch();
        if (vSwitch != null) {
            return vSwitch.getTakeOverState();
        }
        return null;
    }

    @Override
    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlias() {
        return (String)this.getValueOf(null, ParameterCode.CLUSTER_ALIAS);
    }

    public boolean isStorageComparison3() {
        Integer storageComparison = (Integer)this.getValueOf(null, ParameterCode.CLUSTER_STORAGE_COMPARISON);
        if (storageComparison != null) {
            return storageComparison == 3;
        }
        return false;
    }

    @Override
    public boolean isSingleVSwitchMode() {
        return this.getVSwitchesCount() == 1;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int retVal = 0;
        this.radiusServerList.synchronize();
        this.isnsServerList.synchronize();
        int tmpRetVal = this.storage.synchronize();
        if (tmpRetVal > retVal) {
            retVal = tmpRetVal;
            theLogger.trace(SrLogCategories.DEFAULT, "step 1: the value of sync " + retVal);
        }
        this.identities.synchronize();
        tmpRetVal = this.policyMgr.synchronize();
        if (tmpRetVal > retVal) {
            retVal = tmpRetVal;
            theLogger.trace(SrLogCategories.DEFAULT, "step 2: the value of sync " + retVal);
        }
        return retVal;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ClusterAlarmGenerator.getInstance();
    }

    @Override
    public PolicyManagerImpl getPolicyManager() {
        return this.policyMgr;
    }

    @Override
    public CopyOperationManagerImpl getCopyOperManager() {
        return this.copyOperMgr;
    }

    public boolean isVSwitchManaged(String ip) throws RemoteException {
        for (VSwitchImpl vSwitch : this.getVSwitches()) {
            if (!vSwitch.getMgmIPAddr().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> setNeighborsInCluster() throws RemoteException {
        int otherID;
        if (this.getConnectedVSwitchCounter() < 2) {
            return new CompleteFuture<Void>("ClusterImpl.setNeighborsInCluster");
        }
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.setNeighborsInCluster");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        VSwitchImpl invoker = this.getVSwitches().get(0);
        VSwitchImpl other = this.getOtherVSwitch(invoker);
        Integer tempID = invoker.getSwitchID();
        int invokerID = tempID != null ? tempID : -1;
        tempID = other.getSwitchID();
        int n = otherID = tempID != null ? tempID : -1;
        if (invokerID != -1) {
            otherID = this.getComplementarySwitchId(invokerID);
        } else if (otherID != -1) {
            invokerID = this.getComplementarySwitchId(otherID);
        } else {
            invokerID = 0;
            otherID = 1;
        }
        if (invoker.isConnected() && invoker.getNeighborTable().isEmpty()) {
            midFutures.add(this.setNeighborAndSwitchID(invoker, other, invokerID));
        }
        if (other.isConnected() && other.getNeighborTable().isEmpty()) {
            midFutures.add(this.setNeighborAndSwitchID(other, invoker, otherID));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> setNeighborAndSwitchID(VSwitchImpl aVSwitch, VSwitchImpl aNeighbor, int aSwitchId) {
        ConfigElementDataList setNeighborCedList = new ConfigElementDataList();
        ConfigElementData setSwitchIDCed = new ConfigElementData(aVSwitch.getCommKeyClassId(), ConfigOperation.CHANGE);
        setSwitchIDCed.setValue(ParameterCode.VSWITCH_SWITCH_ID, new SrInteger(aSwitchId));
        setNeighborCedList.add(setSwitchIDCed);
        if (aVSwitch.getNeighbor(aNeighbor) == null) {
            ConfigElementData addNeighborCed = aVSwitch.getCEDForAddNeighbor(aNeighbor);
            if (addNeighborCed == null) {
                String msg = "Failed to create a CED for adding the neighbor " + aNeighbor + " to V-Switch " + aVSwitch + ". V-Switch name - " + aVSwitch.getName() + ", neighbor name - " + aNeighbor.getName();
                return new FailedFuture<Void>(new IllegalValueException(msg), msg);
            }
            setNeighborCedList.add(addNeighborCed);
        }
        return DataMgrAdapter.getInstance().configureElements(setNeighborCedList);
    }

    private Integer getComplementarySwitchId(Integer switchId) {
        return new Integer((switchId + 1) % 2);
    }

    private void handleSyncConfigurationError(LogicObjectImpl logicObject) {
        SynchronizeableImpl syncElem;
        if (logicObject instanceof SynchronizeableImpl && (syncElem = (SynchronizeableImpl)logicObject).isSynchronizePending()) {
            syncElem.errorInSynchronizing();
        }
    }

    private void handleSyncConfigurationError(ConfigElementData element) {
        CommKeyClassId operationInvoker;
        if (element != null && (operationInvoker = element.getOperationInvoker()) != null) {
            LogicObjectImpl logicObject = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(operationInvoker);
            this.handleSyncConfigurationError(logicObject);
        }
    }

    private StringBuffer getMsgForElement(ConfigElementData ced, VSwitch vSwitch) throws RemoteException {
        ClassID classId = ced.getClassId();
        HashMap<ParameterCodes, Object> parameterList = ced.getParametersList();
        StringBuffer msg = new StringBuffer(classId.toString());
        msg.append(" ");
        if (classId.equals(ClassID.CONCAT_VOLUME) || classId.equals(ClassID.CUBE_VOLUME) || classId.equals(ClassID.TRANSPARENT_VOLUME) || classId.equals(ClassID.MIRROR_VOLUME) || classId.equals(ClassID.STRIPE_VOLUME)) {
            VolumeNodeImpl vol;
            Object alias = parameterList.get(ParameterCode.VOLUME_ALIAS);
            if (alias == null && (vol = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(ced.getCommKey(), ced.getClassId())) != null) {
                alias = vol.getAlias();
            }
            msg.append(alias);
        } else if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            msg.append(parameterList.get(ParameterCode.PHYSICAL_STORAGE_ALIAS));
        } else if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            msg.append(parameterList.get(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS));
        } else if (classId.equals(ClassID.ISCSI_TARGET)) {
            msg.append(parameterList.get(ParameterCode.ISCSI_TARGET_ALIAS));
        } else if (classId.equals(ClassID.LUN)) {
            msg.append(parameterList.get(ParameterCode.LU_LUN_NUMBER));
        } else if (classId.equals(ClassID.SCSI_LUN)) {
            msg.append(parameterList.get(ParameterCode.SCSI_LUN_LU_NUMBER));
        } else if (classId.equals(ClassID.VSWITCH)) {
            msg.append(parameterList.get(ParameterCode.VSWITCH_IP_ADDRESS));
        } else if (classId.equals(ClassID.NETWORK_CONFIGURATION)) {
            msg.append(parameterList.get(ParameterCode.NETWORK_CONFIG_IP_ADDRESS));
        } else if (classId.equals(ClassID.INTERFACE) || classId.equals(ClassID.FC_INTERFACE) || classId.equals(ClassID.PSCSI_INTERFACE) || classId.equals(ClassID.ETHERNET_INTERFACE)) {
            msg.append(parameterList.get(ParameterCode.IF_ALIAS));
        } else if (classId.equals(ClassID.PORTAL)) {
            msg.append(parameterList.get(ParameterCode.ISCSI_PORTAL_IP_ADDRESS));
            msg.append(":");
            msg.append(parameterList.get(ParameterCode.ISCSI_PORTAL_PORT));
        } else if (classId.equals(ClassID.IP_ROUTE)) {
            msg.append(parameterList.get(ParameterCode.IP_ROUTE_DESTINATION_IP));
        } else if (classId.equals(ClassID.NEIGHBORE)) {
            msg.append(parameterList.get(ParameterCode.NEIGHBOR_IP_ADDRESS));
        } else if (classId.equals(ClassID.SNMP_MANAGER)) {
            msg.append(parameterList.get(ParameterCode.MANAGER_IP_ADDRESS));
        } else if (classId.equals(ClassID.IDENTITY)) {
            msg.append(parameterList.get(ParameterCode.IDENTITY_ALIAS));
        } else if (classId.equals(ClassID.IDENTITY_NAME)) {
            msg.append(parameterList.get(ParameterCode.IDENTITY_NAME_VALUE));
        } else if (classId.equals(ClassID.SRP_CREDENTIALS)) {
            msg.append(parameterList.get(ParameterCode.CREDENTIALS_AUTH_METHOD));
        } else if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
            msg.append(parameterList.get(ParameterCode.CREDENTIALS_AUTH_METHOD));
        } else if (classId.equals(ClassID.ACL_ENTRY)) {
            msg.append(parameterList.get(ParameterCode.ACL_ENTRY_ACCESS));
            msg.append(":");
            msg.append(parameterList.get(ParameterCode.ACL_ENTRY_IDENTITY));
        } else if (classId.equals(ClassID.COPY_OPERATION)) {
            msg.append(parameterList.get(ParameterCode.COPY_OPERATION_TYPE));
        } else if (classId.equals(ClassID.RADIUS_SERVER)) {
            msg.append("Radius Server-");
            msg.append(parameterList.get(ParameterCode.RADIUS_SERVER_IP_ADDRESS));
        } else if (classId.equals(ClassID.ISNS_SERVER)) {
            msg.append("ISNS Server-");
            msg.append(parameterList.get(ParameterCode.ISNS_SERVER_IP_ADDRESS));
        } else if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
            msg.append(parameterList.get(ParameterCode.VOLUME_ALIAS));
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "Undefined ", classId, " in getMsgForElement()");
            msg.append(classId);
        }
        msg.append(" on " + ClassID.VSWITCH + " ");
        msg.append(vSwitch);
        return msg;
    }

    public VSwitchImpl getAnyConnectedVSwitch() {
        for (VSwitchImpl vSwitch : this.getVSwitches()) {
            if (!vSwitch.isConnected()) continue;
            return vSwitch;
        }
        return null;
    }

    public IdentityImpl getIdentityUsingRADIUS(RadiusServerImpl radSrv) {
        return this.identities.getIdentityUsingRADIUS(radSrv);
    }

    private SrFuture<Void> checkForElementsDeletion(SrCheckListEvent event, SrPostponedExecutor aEventMonitor) throws RemoteException, InvalidElementException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.checkForElementsDeletion");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        CheckListConfigElementData checkListElement = event.getCheckListElement();
        CommKeyClassId vSwitchData = event.getVSwitchData();
        VSwitchImpl vSwitch = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub(vSwitchData);
        ClassID classId = checkListElement.getClassId();
        Vector elementsInMap = null;
        elementsInMap = checkListElement.isGeneralTableElementList() ? this.getParentSite().getListCommKeysSameTypeOf(classId, vSwitchData) : this.getParentSite().getListOfCommKeys(classId, vSwitchData);
        if (elementsInMap != null) {
            if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
                ArrayList<CommKeyClassId> iscsiList = new ArrayList<CommKeyClassId>();
                for (CommKeyClassId scsiCKID : checkListElement.getCheckList()) {
                    if (ClassID.SCSI_REMOTE_TARGET.equals(scsiCKID.getClassID())) {
                        iscsiList.add(new CommKeyClassId(scsiCKID.getCommKeys(), ClassID.ISCSI_REMOTE_TARGET));
                        continue;
                    }
                    iscsiList.add(scsiCKID);
                }
                checkListElement.setCheckList(iscsiList);
            }
            Vector elementsDataToRemove = ClusterImpl.getElementsToRemoveByCheckList(elementsInMap, checkListElement);
            CommKeyClassId elementData = null;
            for (int index = 0; index < elementsDataToRemove.size(); ++index) {
                elementData = (CommKeyClassId)elementsDataToRemove.elementAt(index);
                LogicObjectImpl elementToRemove = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(elementData);
                if (elementToRemove == null) continue;
                midFutures.add(this.removeElement(elementToRemove, vSwitch, aEventMonitor, vSwitch.getMgmIPAddr()));
                this.generateAlarms(3, elementToRemove, vSwitch);
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitchImpl vSwitch) {
        SrInteger interval = super.getIntervalValue(pollIntervalParam, vSwitch);
        if (interval == null) {
            interval = this.getParentSite().getIntervalValue(pollIntervalParam, vSwitch);
        }
        return interval;
    }

    public Vector getAllRemoteInitiators() {
        return null;
    }

    private void setPendingNewElements(SrPostponedExecutor aEventMonitor) throws InvalidElementException, RemoteException {
        for (Map.Entry<CommKeyClassId, ConfigElementData> entry : this.pendingNewElements.entrySet()) {
            CommKeyClassId key = entry.getKey();
            ConfigElementData ced = entry.getValue();
            try {
                LogicObject element = this.elementCreated(ced, aEventMonitor);
                if (element == null) {
                    theLogger.error(SrLogCategories.LEGACY, "Failed to create ", key.getClassID(), " on second try");
                    continue;
                }
                theLogger.info(SrLogCategories.LEGACY, key.getClassID(), " ", element, " was created on second try");
            }
            catch (IllegalValueException ive) {
                theLogger.error(SrLogCategories.LEGACY, ive, new Object[0]);
            }
        }
    }

    private void addSCSIiSCSIMap(VSwitchImpl vSwitch, SCSIDeviceImpl element) throws RemoteException {
        CommKeyClassId iscsiCommKeyClassId = CommKeyUtil.getSpecificCommKeyClassId(element.getCommKeyClassId(), vSwitch.getCommKeyClassId());
        CommKeyClassId scsiCommKeyClassId = element.getSCSIDeviceId(vSwitch);
        this.m_scsiDeviceIscsiNodeMap.addEntryToMap(scsiCommKeyClassId, iscsiCommKeyClassId);
    }

    public CommKeyClassId getISCSIId(CommKeyClassId scsiKey) {
        return this.m_scsiDeviceIscsiNodeMap.getISCSIId(scsiKey);
    }

    public CommKeyClassId getSCSIId(CommKeyClassId iscsiKey) {
        return this.m_scsiDeviceIscsiNodeMap.getSCSIId(iscsiKey);
    }

    public String getPrintableSCSIISCSIDeviceMap() {
        return this.m_scsiDeviceIscsiNodeMap.toString();
    }

    @Override
    public SrFuture<Void> moveToSite(CommKeyClassId destination) throws RemoteException, IllegalValueException {
        return this.changeElement(ClientParameterCode.PARENT_SITE, destination);
    }

    public ArrayList<String> getLocalInitiatorNames() throws RemoteException {
        List<VSwitchImpl> clusterVSwitches = this.getVSwitches();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int index1 = 0; index1 < clusterVSwitches.size(); ++index1) {
            VSwitch vswitch = clusterVSwitches.get(index1);
            ISCSIInitiator[] vswitchInitiators = vswitch.getISCSIInitiators();
            for (int index2 = 0; index2 < vswitchInitiators.length; ++index2) {
                ISCSIInitiator localInitiator = vswitchInitiators[index2];
                arrayList.add(localInitiator.getName());
            }
        }
        return arrayList;
    }

    public SrFuture<Void> updateTargetACLWithRemoteInitiatorNames(Target localTarget, ArrayList existedInitiatorNames, ArrayList addedRemoteInitiatorNames) throws RemoteException, IllegalValueException {
        final TargetImpl localTargetImpl = (TargetImpl)localTarget;
        final VSwitchImpl[] targetConnectedVSwitches = localTargetImpl.getConnectedVSwitches();
        Vector<VSwitchImpl> vswitchesToUpdate = new Vector<VSwitchImpl>(targetConnectedVSwitches.length);
        for (int index = 0; index < targetConnectedVSwitches.length; ++index) {
            vswitchesToUpdate.add(targetConnectedVSwitches[index]);
        }
        IdentityImpl knownIdentity = this.getIdentitiesList().getDRIdentityByRemoteInitiatorNames(existedInitiatorNames);
        if (knownIdentity == null) {
            String identityAliasPrefix = IdentityPurposeConstant.REMOTE_INITIATOR_DR.getDescriptionName();
            return this.createIdentity(identityAliasPrefix, identityAliasPrefix, vswitchesToUpdate, IdentityPurposeConstant.REMOTE_INITIATOR_DR, existedInitiatorNames, localTarget);
        }
        final IdentityImpl knownIdentityImpl = knownIdentity;
        SrFuture idenFuture = new CompleteFuture("ClusterImpl.updateTargetACLWithRemoteInitiatorNames");
        if (!this.getIdentitiesList().isDrIdentityOnPendingCreateForInitiatorNames(existedInitiatorNames)) {
            idenFuture = knownIdentityImpl.createUnknownIdentityNames(existedInitiatorNames, vswitchesToUpdate);
        }
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.updateTargetACLWithRemoteInitiatorNames");
        final ClusterImpl locInstance = this;
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateTargetACLWithRemoteInitiatorNamesFollowup(retFuture, locInstance, localTargetImpl, knownIdentityImpl, targetConnectedVSwitches);
            }
        }, idenFuture);
        return retFuture;
    }

    public SrFuture<Void> updateTargetACLWithRemoteInitiatorNamesFollowUp(TargetImpl aLocalTargetImpl, IdentityImpl aKnownIden, VSwitch[] aTargetConnectedVSwitches) throws RemoteException {
        AclImpl targetACL = aLocalTargetImpl.getAclForTarget();
        if (targetACL != null && !targetACL.isTargetConnected(aKnownIden)) {
            CommKeyClassId[] vsData = new CommKeyClassId[aTargetConnectedVSwitches.length];
            int i = aTargetConnectedVSwitches.length;
            while (i-- > 0) {
                CommKeyClassId vswitchId = aTargetConnectedVSwitches[i].getCommKeyClassId();
                if (!aKnownIden.isKnownByVSwitch((VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vswitchId))) continue;
                vsData[i] = vswitchId;
            }
            ConfigElementData identityElement = new ConfigElementData(aKnownIden.getCommKeyClassId());
            identityElement.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vsData));
            return DataMgrAdapter.getInstance().attachIdentityToTargetACL(identityElement, aLocalTargetImpl.getCommKeyClassId());
        }
        return new CompleteFuture<Void>("ClusterImpl.updateTargetACLWithRemoteInitiatorNamesFollowUp");
    }

    public SrFuture<Void> removeInitiatorNamesFromTargetACL(Target localTarget, ArrayList remoteInitiatorNames) throws RemoteException, IllegalValueException {
        TargetImpl localTargetImpl = (TargetImpl)localTarget;
        IdentityImpl identity = localTargetImpl.getIdentityOfInitiatorNames(IdentityPurposeConstant.REMOTE_INITIATOR_DR, remoteInitiatorNames);
        return identity.deleteNames(remoteInitiatorNames);
    }

    public SrFuture<Void> synchronizeForDRPurpose() throws RemoteException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.synchronizeForDRPurpose");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ArrayList<PortalTableRowImpl> allTargetPortalsInCluster = this.getAllClusterTargetPortals();
        ArrayList<ClusterImpl> clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
        for (ClusterImpl remoteCluster : clustersInOtherSites) {
            for (PortalTableRowImpl portal : allTargetPortalsInCluster) {
                midFutures.add(portal.synchronizeDiscoveryElementOnRemoteCluster(remoteCluster));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public ISCSIRemoteTargetImpl findLocalTargetInRemoteCluster(ClusterImpl remoteCluster, String targetName) {
        boolean findForRemoteElement = false;
        ArrayList remoteTargets = this.findEquivalentTargetInRemoteCluster(remoteCluster, targetName, findForRemoteElement);
        if (remoteTargets.size() > 0) {
            return (ISCSIRemoteTargetImpl)remoteTargets.get(0);
        }
        return null;
    }

    public ISCSITargetImpl findEquivLocalTargetOfRemoteTargetInRemoteClusters(ArrayList clustersInOtherSites, String remoteTargetName) {
        boolean findForRemoteElement = true;
        for (int index = 0; index < clustersInOtherSites.size(); ++index) {
            ClusterImpl remoteCluster = (ClusterImpl)clustersInOtherSites.get(index);
            ArrayList localTargets = this.findEquivalentTargetInRemoteCluster(remoteCluster, remoteTargetName, findForRemoteElement);
            if (localTargets.size() <= 0) continue;
            return (ISCSITargetImpl)localTargets.get(0);
        }
        return null;
    }

    private ArrayList findEquivalentTargetInRemoteCluster(ClusterImpl remoteCluster, String targetName, boolean findForRemoteElement) {
        ArrayList<ISCSITargetImpl> equivalentTargetsInRemoteClusters = new ArrayList<ISCSITargetImpl>();
        SynchronizeableImpl obj = null;
        obj = findForRemoteElement ? remoteCluster.getTargetListMgr().getTargetByName(targetName) : remoteCluster.getRemoteTargetListMgr().getRemoteTargetByName(targetName);
        if (obj != null) {
            equivalentTargetsInRemoteClusters.add((ISCSITargetImpl)obj);
        }
        return equivalentTargetsInRemoteClusters;
    }

    public ArrayList<PortalTableRowImpl> getAllClusterTargetPortals() throws RemoteException {
        ArrayList<PortalTableRowImpl> allTargetsPortals = new ArrayList<PortalTableRowImpl>();
        Vector<ISCSITargetImpl> localTargets = this.storage.getTargetList();
        for (ISCSITargetImpl target : localTargets) {
            VSwitchImpl vswitch = target.getExposedOnVSwitchObject();
            ArrayList<PortalTableRowImpl> targetPortals = this.getAllTargetPortals(vswitch);
            for (PortalTableRowImpl portal : targetPortals) {
                if (allTargetsPortals.contains(portal)) continue;
                allTargetsPortals.add(portal);
            }
        }
        return allTargetsPortals;
    }

    public ArrayList<PortalTableRowImpl> getAllTargetPortals(VSwitchImpl vswitch) {
        ArrayList<PortalTableRowImpl> targetPortals = new ArrayList<PortalTableRowImpl>();
        if (vswitch != null) {
            Integer vswitchId = vswitch.getSwitchID();
            targetPortals.addAll(this.getVSwitchTargetPortals(vswitch, vswitchId));
        }
        return targetPortals;
    }

    private List<PortalTableRowImpl> getVSwitchTargetPortals(VSwitchImpl vswitch, Integer vswitchId) {
        ArrayList<PortalTableRowImpl> portals = new ArrayList<PortalTableRowImpl>();
        if (vswitch.isConnected() && !SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER.equals(vswitch.getTakeOverState())) {
            Vector<PortalTableRowImpl> vswitchPortals = vswitch.getPortalTable();
            for (int index = 0; index < vswitchPortals.size(); ++index) {
                PortalTableRowImpl portal = vswitchPortals.get(index);
                Integer tag = portal.getTag();
                if (tag == null || !portal.isTargetRole() || !tag.equals(vswitchId)) continue;
                portals.add(portal);
            }
        } else if (!vswitch.isConnected() && SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER.equals(this.getTakeoverState())) {
            VSwitchImpl otherVswitch = this.getOtherVSwitch(vswitch);
            Vector<PortalTableRowImpl> vswitchPortals = otherVswitch.getPortalTable();
            for (int index = 0; index < vswitchPortals.size(); ++index) {
                PortalTableRowImpl portal = vswitchPortals.get(index);
                Integer tag = portal.getTag();
                if (tag == null || !portal.isTargetRole() || tag.equals(otherVswitch.getSwitchID())) continue;
                portals.add(portal);
            }
        } else {
            theLogger.error(SrLogCategories.ERROR, "Couldn't get Target Portals of V-Switch ", vswitch, " because its connected state is ", vswitch.isConnected(), " and the cluster take-over state is ", this.getTakeoverState());
        }
        return portals;
    }

    private SrFuture<Void> setRemoteTargetAliasIfCreatedByVSwitch(ISCSIRemoteTargetImpl remoteTarget, VSwitchImpl vswitch) throws RemoteException {
        if (remoteTarget.getAlias(vswitch).startsWith("X")) {
            ISCSITargetImpl localTarget = remoteTarget.getConfiguredAsLocalTargetOnSameCluster();
            ArrayList<ClusterImpl> clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getParentSite());
            if (localTarget != null || (localTarget = this.findEquivLocalTargetOfRemoteTargetInRemoteClusters(clustersInOtherSites, remoteTarget.getName())) != null) {
                HashMap<ClientParameterCode, String> changedValues = new HashMap<ClientParameterCode, String>();
                String localTargetAlias = localTarget.getAlias();
                changedValues.put(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS, localTargetAlias);
                try {
                    return remoteTarget.changeElement(changedValues);
                }
                catch (IllegalValueException ive) {
                    // empty catch block
                }
            }
        }
        return new CompleteFuture<Void>("ClusterImpl.setRemoteTargetAliasIfCreatedByVSwitch");
    }

    @Override
    public SrFuture<Void> createRemoteDiscoveryPortal(String ipAddress, Integer port) throws RemoteException, IllegalValueException {
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        final SrFuture<Void> retFuture = new SrFuture<Void>("ClusterImpl.createRemoteDiscoveryPortal");
        List<VSwitchImpl> clusterVswitches = this.getVSwitches();
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitch vswitch = clusterVswitches.get(index);
            ISCSIInitiator[] inits = vswitch.getISCSIInitiators();
            if (inits.length == 0) {
                theLogger.warn(SrLogCategories.INFORMATIVE, "The VS ", vswitch, " in cluster ", this, " has no initiators, therefore the remote discovery portal ", ipAddress, ":", port, " could not be created");
                continue;
            }
            ISCSIInitiatorImpl vswitchInitiator = (ISCSIInitiatorImpl)inits[0];
            midFutures.add(vswitchInitiator.createRemoteDiscoveryPortal(ipAddress, port));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    private void sendDREvent(RemoteObjectImpl element, int eventType) throws RemoteException {
        if (element == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters should not be null.");
        }
        DRRootImpl.getInstance().processEvent(element, eventType);
    }

    @Override
    public VSwitchImpl[] getConnectedVSwitches() {
        ArrayList<VSwitchImpl> connectedVSwitches = new ArrayList<VSwitchImpl>();
        for (VSwitchImpl currVSwitch : this.myVSwitches) {
            if (!currVSwitch.isConnected()) continue;
            connectedVSwitches.add(currVSwitch);
        }
        VSwitchImpl[] vswitches = new VSwitchImpl[connectedVSwitches.size()];
        return connectedVSwitches.toArray(vswitches);
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            // empty if block
        }
        return null;
    }

    public String getClusterDebugInfo() {
        StringBuffer info = new StringBuffer();
        info.append("\tCluster: ").append(this).append('\n');
        info.append("\tRunning event in cluster:").append('\n');
        info.append("\t\t");
        SrEventObject event = this.myDebugObj.getRunningEvent();
        if (event != null) {
            info.append(event).append('\n');
            info.append("\tRunning event stack trace:");
            info.append(SrLogger.getThrowableOutput(event.getStackTrace()));
        } else if (this.myDebugObj.getRunningObject() != null) {
            info.append(this.myDebugObj.getRunningObject()).append('\n');
        } else {
            info.append("null").append('\n');
        }
        return info.toString();
    }

    public boolean isIPExistedAsISNSServer(String ip) {
        Vector<ExternalServerImpl> isnsServersTable = this.getAllISNSServers();
        for (int index = 0; index < isnsServersTable.size(); ++index) {
            ISNSServerImpl server = (ISNSServerImpl)isnsServersTable.get(index);
            if (!server.getServerIP().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRadiusServer(String ip) {
        Vector<ExternalServerImpl> radiusServersTable = this.getAllRadiusServers();
        for (int index = 0; index < radiusServersTable.size(); ++index) {
            RadiusServerImpl server = (RadiusServerImpl)radiusServersTable.get(index);
            if (!server.getServerIP().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalIP(String ip) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalIP(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRoutIP(String ip) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsRoutIP(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalPortal(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip, int port) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsLocalPortal(ip, port)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsSNMPManager(String ip) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsSNMPManager(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsNeighbor(String ip) throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            VSwitchImpl vswitch = vswitches.get(index);
            if (!vswitch.isIPExistedAsNeighbor(ip)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SrBITSConstant getCapability() throws RemoteException {
        return this.m_capability;
    }

    private SrBITSConstant calculateCapability() throws RemoteException {
        List<VSwitchImpl> vswitches = this.getVSwitches();
        SrBITSConstant[] capabilities = new SrBITSConstant[vswitches.size()];
        int i = capabilities.length;
        while (i-- > 0) {
            capabilities[i] = vswitches.get(i).getActualCapability();
        }
        SrBITSConstant candidate = null;
        int i2 = capabilities.length;
        while (i2-- > 0) {
            if (candidate == null) {
                candidate = capabilities[i2];
            }
            if (candidate == null || capabilities[i2] == null || VSwitchCapabilityConstant.compare(candidate, capabilities[i2]) >= 0) continue;
            candidate = capabilities[i2];
        }
        return candidate != null ? candidate : VSwitchCapabilityConstant.getMinimalCapability();
    }

    private void updateCapability() throws RemoteException {
        SrBITSConstant currCapability = this.calculateCapability();
        ElementEventImpl event = null;
        if (this.m_capability != null && !this.m_capability.equals(currCapability) || this.m_capability == null && currCapability != null) {
            HashMap<ClientParameterCode, SrBITSConstant> params = new HashMap<ClientParameterCode, SrBITSConstant>();
            params.put(ClientParameterCode.CLUSTER_CAPABILITY, currCapability);
            event = new ElementEventImpl((Object)this, this);
            event.setParameterList(params);
        }
        this.m_capability = currCapability;
        if (event != null) {
            LogicMgrAOImpl.getInstance().__elementChanged(event);
        }
    }

    private void clearPolicies() throws RemoteException {
        Vector refs = this.getCommKeyRefMap().getAllRefs();
        int i = refs.size();
        while (i-- > 0) {
            LogicObjectImpl currObj = (LogicObjectImpl)refs.elementAt(i);
            if (!currObj.getClassId().isPolicyClassId()) continue;
            PoliciesManager.getInstance().removePolicyElement(currObj);
        }
    }

    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return null;
    }

    private static Vector getElementsToRemoveByCheckList(Vector commKeysElements, CheckListConfigElementData checkListelement) {
        List<CommKeyClassId> checkList = checkListelement.getCheckList();
        Vector<CommKeyClassId> superCheckList = checkListelement.getSuperTblCheckList();
        Vector<CommKeyClassId> commKeysToRemove = new Vector<CommKeyClassId>();
        if (superCheckList != null) {
            for (int index1 = 0; index1 < superCheckList.size(); ++index1) {
                CommKeyClassId currSuperCheckListCommKey = superCheckList.elementAt(index1);
                for (int index2 = 0; index2 < commKeysElements.size(); ++index2) {
                    CommKeyClassId currExistedCommKey = (CommKeyClassId)commKeysElements.elementAt(index2);
                    if (!currExistedCommKey.startsWith(currSuperCheckListCommKey) || checkList.contains(currExistedCommKey)) continue;
                    commKeysToRemove.add(currExistedCommKey);
                }
            }
        } else {
            for (int index = 0; index < commKeysElements.size(); ++index) {
                CommKeyClassId currExistedCommKey = (CommKeyClassId)commKeysElements.elementAt(index);
                if (checkList.size() != 0 && checkList.contains(currExistedCommKey)) continue;
                commKeysToRemove.add(currExistedCommKey);
            }
        }
        return commKeysToRemove;
    }

    private SrFuture<Void> getRediscoverFuture() {
        return this.myRediscoverFuture;
    }

    private void setRediscoverFuture(SrFuture<Void> aFutureToSet) {
        if (this.myRediscoverFuture != null && aFutureToSet != null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Can not change the rediscover future until it is reset to null");
            return;
        }
        this.myRediscoverFuture = aFutureToSet;
    }

    public void generateAlarms() {
        try {
            this.alarmMgr.generateAlarms(this);
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "A remote exception has occured inside a server context.");
        }
    }

    public String getRemovedInconsistentNeighborName() {
        return this.myRemovedInconsistentNeighborName;
    }

    public void setRemovedInconsistentNeighborName(String aRemovedInconsistentNeighborName) {
        this.myRemovedInconsistentNeighborName = aRemovedInconsistentNeighborName;
    }

    private SrFuture<Void> removeRedundantVS(VSwitchImpl aVS) throws RemoteException, IllegalValueException {
        VSwitchImpl remVS;
        if (aVS == null) {
            throw new IllegalArgumentException("The parameters should not be null. aVS = " + aVS);
        }
        for (VSwitchImpl stateVs : this.getVSwitches()) {
            stateVs.setAlwaysEnableDeletion(true);
        }
        VSwitchImpl retainVS = aVS;
        String notRemovableVsIp = this.getNotRemovableVswitch();
        if (notRemovableVsIp != null) {
            for (VSwitchImpl curVS : this.getVSwitches()) {
                if (!notRemovableVsIp.equals(curVS.getMgmIPAddr())) continue;
                retainVS = curVS;
                break;
            }
        }
        if ((remVS = this.getOtherVSwitch(retainVS)) == null) {
            throw new IllegalStateException("The cluster " + this + " contains only one VS, and we tried to remove an inconsistent neighbor.");
        }
        this.setRemovedInconsistentNeighborName(remVS.getName());
        theLogger.info(SrLogCategories.INFORMATIVE, "Setting removed inconsistent neighbor name = ", remVS.getName());
        retainVS.setInconsistentNeighborToRemove(remVS);
        this.setNotRemovableVswitch(retainVS.getMgmIPAddr());
        theLogger.info(SrLogCategories.INFORMATIVE, "Deleting VS ", remVS);
        return remVS.deleteElement();
    }

    private String getNotRemovableVswitch() {
        return this.myNotRemovableIP;
    }

    private void setNotRemovableVswitch(String aNotRemovableVswitch) {
        this.myNotRemovableIP = aNotRemovableVswitch;
    }

    public SrFuture<Void> findAndRemoveRedundantVS(List<String> aVsIPs) {
        if (aVsIPs == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        CompleteFuture<Void> retFuture = new CompleteFuture<Void>("ClusterImpl__findAndRemoveRedundantVS");
        try {
            for (VSwitchImpl curVs : this.getVSwitches()) {
                if (!curVs.isConnected()) {
                    theLogger.info(SrLogCategories.NEIGHBOR_DB, "Neighbor inconsistency correction was not executed for cluster ", this, " because VS ", curVs, " is disconnected.");
                    return retFuture;
                }
                if (!SDTakeOverStateConstant.SD_TAKE_OVER_STATE_STANDING.equals(curVs.getTakeOverState())) continue;
                theLogger.info(SrLogCategories.NEIGHBOR_DB, "Neighbor inconsistency correction was not executed for cluster ", this, " because VS ", curVs, " is in initializing state.");
                return retFuture;
            }
            for (VSwitchImpl curVs : this.getVSwitches()) {
                Vector<NeighborImpl> allNeighbors = curVs.getNeighborTable();
                theLogger.info(SrLogCategories.INFORMATIVE, "The neighbors for VS ", curVs, " are: ", allNeighbors);
                if (allNeighbors.isEmpty() && aVsIPs.size() > 1) {
                    return this.removeRedundantVS(curVs);
                }
                NeighborImpl neighbor = (NeighborImpl)allNeighbors.get(0);
                if (aVsIPs.contains(neighbor.getIPAddress())) continue;
                return this.removeRedundantVS(curVs);
            }
        }
        catch (RemoteException exp) {
            return new FailedFuture<Void>(exp, "LogicMgrAOImpl__updateDBFollowUp");
        }
        catch (IllegalValueException exp) {
            return new FailedFuture<Void>(exp, "LogicMgrAOImpl__updateDBFollowUp");
        }
        return retFuture;
    }

    public void unregisterBean() {
        this.myBean.unregister();
    }

    public void setAddNeighborContext() {
        this.myIsAddNeighborContext = true;
    }

    @Override
    public List<TargetQosGroup> getIscsiTargetQosGroups() throws RemoteException {
        return Util.convertListType(this.myTargetQosMgr.getGroups());
    }

    public TargetQosMgr getTargetQosMgr() {
        return this.myTargetQosMgr;
    }

    @Override
    public List<AttachedRaid> getAttachedRaids() throws RemoteException {
        return Util.convertListType(this.myAttachedRaidMgr.getAllAttachedRaids());
    }

    public AttachedRaidsMgr getAttachedRaidsMgr() {
        return this.myAttachedRaidMgr;
    }

    @Override
    public List<SnapshotScheduler> getSnapshotSchedulers() throws RemoteException {
        return Util.convertListType(this.mySnapshotSchedulerMgr.getSnapshotSchedulers());
    }

    public SnapshotSchedulerMgr getSnapshotSchedulerMgr() {
        return this.mySnapshotSchedulerMgr;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.CLUSTER_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PARENT_SITE_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CLUSTER_STORAGE_COMPARISON, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.GENERAL_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ACL_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NET_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.STATISTIC_POLL_INTERVAL, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }

    private class ClusterDebugObject {
        private SrEventObject runningEvent;
        private Object runningObject;
        private String myName = null;

        ClusterDebugObject(String aName) {
            this.myName = aName;
        }

        private SrEventObject getRunningEvent() {
            return this.runningEvent;
        }

        private void setRunningEvent(SrEventObject runningEvent) {
            this.runningEvent = runningEvent;
        }

        private Object getRunningObject() {
            return this.runningObject;
        }

        private void setRunningObject(Object runningObject) {
            this.runningObject = runningObject;
        }
    }
}

