/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.acl.PolicyManager;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.logic.srv.ExternalServer;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.target.TargetQosGroup;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManager;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotScheduler;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public interface Cluster
extends VSwitchGroup {
    public Storage getStorage() throws RemoteException;

    @Override
    public boolean isDiscoverCompleted() throws RemoteException;

    public SrFuture<Void> addVSwitch(String var1, String var2, int var3, int var4, String var5, String var6, long var7, int var9, SnmpVersion var10) throws RemoteException, IllegalValueException;

    public boolean isDBCorrupted() throws RemoteException;

    public List<? extends VSwitch> getVSwitches() throws RemoteException;

    public List<? extends Neighbor> getNeighbors() throws RemoteException;

    public SrFuture<Void> manualDiscover() throws RemoteException;

    public BigInteger getTotalCapacity() throws RemoteException;

    public BigInteger getAccessibleSpace() throws RemoteException;

    public Integer getKeepAlive() throws RemoteException;

    public Integer getSuspiciousInterval() throws RemoteException;

    public Integer getFaultyInterval() throws RemoteException;

    public SrFuture<Void> createIdentity(String var1, String var2) throws RemoteException, IllegalValueException;

    public Vector<? extends Identity> getAllIdentities() throws RemoteException;

    public Vector<? extends ExternalServer> getAllRadiusServers() throws RemoteException;

    public Vector<? extends ExternalServer> getAllISNSServers() throws RemoteException;

    public PolicyManager getPolicyManager() throws RemoteException;

    public boolean isSingleVSwitchMode() throws RemoteException;

    public CopyOperationManager getCopyOperManager() throws RemoteException;

    public SrFuture<Void> deleteObjects(CommKeyClassId[] var1) throws RemoteException, IllegalValueException;

    public SrFuture<Void> createRadiusServer(String var1, String var2, String var3) throws RemoteException, IllegalValueException;

    public SrFuture<Void> createISNSServer(String var1) throws RemoteException, IllegalValueException;

    public Boolean isFailoverEnable() throws RemoteException;

    public SDTakeOverStateConstant getTakeoverState() throws RemoteException;

    public SrFuture<Void> moveToSite(CommKeyClassId var1) throws RemoteException, IllegalValueException;

    public SrFuture<Void> createRemoteDiscoveryPortal(String var1, Integer var2) throws RemoteException, IllegalValueException;

    public SrBITSConstant getCapability() throws RemoteException;

    public VSwitch getOtherVSwitch(VSwitch var1) throws RemoteException;

    public List<TargetQosGroup> getIscsiTargetQosGroups() throws RemoteException;

    public List<AttachedRaid> getAttachedRaids() throws RemoteException;

    public List<SnapshotScheduler> getSnapshotSchedulers() throws RemoteException;
}

