/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AclEntryImpl
extends SynchronizeableImpl
implements AclEntry {
    private static final int DR_DEF_ALL_POSITION = 2147482647;
    private static final int DEF_ALL_POSITION = 0;
    private AclImpl aclParent;
    private IdentityImpl myIdentity;
    private Integer position = null;
    private Permission permission;
    private boolean changePosition = false;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public AclEntryImpl(ClusterImpl cluster, ClassID classId, Acl aclParent, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.aclParent = (AclImpl)aclParent;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        Object access = parameterList.get(ClientParameterCode.ACL_ENTRY_ACCESS);
        if (access != null) {
            SrInteger permission = new SrInteger(((Permission)access).intValue());
            parameterList.put(ClientParameterCode.ACL_ENTRY_ACCESS, permission);
        }
        return super.changeElement(parameterList);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        VSwitchImpl vswitch = this.getExposedOnVswitch();
        if (this.isKnownByVSwitch(vswitch)) {
            this.myIdentity = this.getIdentity(vswitch);
            this.position = this.getPosition(vswitch);
            this.permission = this.getPermission(vswitch);
        } else {
            this.myIdentity = this.getIdentity(null);
            this.position = this.getPosition(null);
            this.permission = this.getPermission(null);
        }
        if (this.myIdentity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity on ");
            sberr.append(ClassID.VSWITCH.toString());
            sberr.append(" ");
            sberr.append(vswitch.getName());
            sberr.append(" is NULL!!!");
            theLogger.error(SrLogCategories.LEGACY, sberr);
        } else if (!this.myIdentity.isOfRemoteInitiatorDR()) {
            this.aclParent.setHighestPostionIfHighest(this.position);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (this.getIdentity() != null) {
            sb.append(this.getIdentity().getAlias());
        }
        sb.append("][");
        sb.append(this.getPermission().toString());
        sb.append("][");
        sb.append(this.getPosition());
        sb.append("]");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    public boolean isRelevantForExposedTarget() throws RemoteException {
        VSwitchImpl vswitch = this.getExposedOnVswitch();
        return this.isKnownByVSwitch(vswitch);
    }

    protected VSwitchImpl getExposedOnVswitch() throws RemoteException {
        String vswitch = this.aclParent.getTargetParent().getExposedOnVSwitch();
        return this.cluster.getVSwitchByName(vswitch);
    }

    @Override
    public IdentityImpl getIdentity() {
        return this.myIdentity;
    }

    public IdentityImpl getIdentity(VSwitchImpl vSwitch) {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.ACL_ENTRY_IDENTITY, vSwitch == null);
        IdentityImpl identity = (IdentityImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    public TargetImpl getTargetParent() throws RemoteException {
        return this.getTargetParent(null);
    }

    public TargetImpl getTargetParent(VSwitchImpl vSwitch) {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.ACL_ENTRY_TARGET_PARENT, vSwitch == null);
        TargetImpl target = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        return target;
    }

    @Override
    public AclImpl getAclParent() throws RemoteException {
        return this.aclParent;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    public Integer getPosition(VSwitchImpl vSwitch) {
        Integer pos = (Integer)this.getValueOf(vSwitch, ParameterCode.ACL_ENTRY_POSITION, vSwitch == null);
        return pos;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public Permission getPermission(VSwitchImpl vSwitch) {
        Integer permissionIntVal = (Integer)this.getValueOf(vSwitch, ParameterCode.ACL_ENTRY_ACCESS, vSwitch == null);
        return Permission.getPermission(permissionIntVal);
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        boolean isTargetSynchronized;
        boolean bl = isTargetSynchronized = !this.getTargetParent().isNeedToSynchronize();
        if (isTargetSynchronized) {
            boolean isIdentitySynchronized;
            boolean bl2 = isIdentitySynchronized = !this.getIdentity().isNeedToSynchronize();
            if (isIdentitySynchronized) {
                return null;
            }
            return "cannot synchronize ACLEntry: identity not synchronized yet";
        }
        return "cannot synchronize ACLEntry: target not synchronized yet";
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return this.synchronizeMe();
        }
        return 2;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            this.aclParent.createAclEntry(this, this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefAll() {
        return this.getPosition() != null && this.getPosition() == 0;
    }

    public boolean isDRDefAll() {
        return this.getPosition() != null && this.getPosition() == 2147482647;
    }

    public boolean isRemoteInitiatorDR() throws RemoteException {
        IdentityImpl entryIdentity = this.getIdentity();
        return entryIdentity.isOfRemoteInitiatorDR();
    }

    public void setChangePosition(boolean change) {
        this.changePosition = change;
    }

    public boolean isChangePosition() {
        return this.changePosition;
    }

    @Override
    public boolean isRedundant() {
        if (!this.isDefAll() && !this.isDRDefAll()) {
            return super.isRedundant();
        }
        return true;
    }

    @Override
    public boolean isEntryForDRIdentityAll() {
        IdentityImpl entryIdentity = this.getIdentity();
        if (this.myIdentity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity is NULL!!!");
            theLogger.error(SrLogCategories.LEGACY, sberr);
        }
        return entryIdentity.isDRIdentityAll();
    }

    public boolean isEntryForDRRemoteInitiator() {
        IdentityImpl entryIdentity = this.getIdentity();
        if (this.myIdentity == null) {
            StringBuffer sberr = new StringBuffer("Error!!! ACL entry CommkeyClassid = ");
            sberr.append(this.getCommKeyClassId());
            sberr.append(" ; Entry Identity is NULL!!!");
            theLogger.error(SrLogCategories.LEGACY, sberr);
        }
        return entryIdentity.isOfRemoteInitiatorDR();
    }

    @Override
    public void setSynchronizePending(boolean pending) {
        super.setSynchronizePending(pending);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.ACL_ENTRY_ACCESS);
        params.add(ParameterCode.ACL_ENTRY_POSITION);
        params.add(ParameterCode.ACL_ENTRY_IDENTITY);
        params.add(ParameterCode.ACL_ENTRY_TARGET_PARENT);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ACL_ENTRY_IDENTITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ACL_ENTRY_ACCESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ACL_ENTRY_POSITION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ACL_ENTRY_TARGET_PARENT, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

