/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class VSwitchGroupValidator
extends LogicObjectValidator {
    private SiteImpl m_parent;
    private String m_alias;
    private static final int ALIAS_MAX_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH));

    protected VSwitchGroupValidator(SiteImpl parent, String alias) {
        this.m_parent = parent;
        this.m_alias = alias;
    }

    protected abstract ArrayList getPotentialSiblings() throws RemoteException;

    @Override
    protected boolean isValid() throws RemoteException {
        if (this.getAlias().length() > ALIAS_MAX_LENGTH) {
            this.setErrorMsg("Maximum allowed length for alias is " + ALIAS_MAX_LENGTH + " characters");
            return false;
        }
        for (VSwitchGroup vSwitchGroup : this.getPotentialSiblings()) {
            if (!vSwitchGroup.getAlias().equals(this.getAlias())) continue;
            StringBuffer msg = new StringBuffer(vSwitchGroup.getClassId().toString());
            msg.append(" with alias ");
            msg.append(this.getAlias());
            msg.append(" is already exists in ");
            if (!(this.getParent() instanceof SystemRoot)) {
                msg.append(this.getParent().getClassId());
                msg.append(" ");
            }
            msg.append(this.getParent());
            msg.append(". Please select another alias");
            this.setErrorMsg(msg.toString());
            return false;
        }
        return true;
    }

    protected SiteImpl getParent() {
        return this.m_parent;
    }

    protected String getAlias() {
        return this.m_alias;
    }
}

