/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.logic.BasicLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.PollingElement;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class VSwitchGroupImpl
extends BasicLogicObjectImpl
implements VSwitchGroup,
PollingElement {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private SiteImpl m_siteParent;

    protected VSwitchGroupImpl(ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getAlias();
        CommKeyClassId siteCommKeyClassId = (CommKeyClassId)changedValues.get(ParameterCode.PARENT_SITE_ID);
        if (siteCommKeyClassId != null && !this.equals(SystemRootImpl.getInstance())) {
            SiteImpl newParentSite = (SiteImpl)SystemRootImpl.getInstance().getRefByStub(siteCommKeyClassId);
            ErrorAssertingListener.listenTo(this.setParentSite(newParentSite));
        }
        return changedValues;
    }

    @Override
    public Integer getVSwitchGroupId() {
        return (Integer)this.getSrValueOf(null, ParameterCode.VSWITCH_GROUP_ID).value();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String canBeSynchronized() throws RemoteException {
        return null;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException();
    }

    private SrFuture<Void> setParentSite(SiteImpl site) throws RemoteException {
        if (this.m_siteParent != null) {
            this.m_siteParent.vswitchGroupMoved(this);
        }
        this.m_siteParent = site;
        return this.m_siteParent.addVSwitchGroup(this);
    }

    @Override
    public SiteImpl getParentSite() {
        return this.m_siteParent;
    }

    @Override
    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitchImpl vSwitch) {
        SrInteger interval;
        Parameter pollInterval = this.getParameter((VSwitch)null, pollIntervalParam);
        if (pollInterval != null && (interval = (SrInteger)pollInterval.getValue()) != null && !interval.equals(0)) {
            return interval;
        }
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.m_siteParent.addPropagationStateDependentObjectAndListener(this);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VSWITCH_GROUP_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.PARENT_SITE_ID, new ParameterCode.Flags(true, true));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

