/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.ForceStateSyncConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class SynchronizeableImpl
extends AliasObjectImpl
implements Synchronizeable {
    private static SrLogger theLogger = SrLogger.getLogger();
    private Vector listeners = new Vector();
    private boolean synchronizePending = false;
    public static final int SYNC_STATUS_END_OK = 0;
    public static final int SYNC_STATUS_ALREADY_SYNCHING = 1;
    public static final int SYNC_STATUS_WAITING_TO_SNMP_COMPLETION = 2;
    public static final int SYNC_STATUS_ERROR = 3;
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected SynchronizeableImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    public void addSynchronizeListener(SynchronizeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeSynchronizeListener(SynchronizeListener listener) {
        this.listeners.removeElement(listener);
    }

    public boolean isSynchronizePending() {
        return this.synchronizePending;
    }

    protected void setSynchronizePending(boolean pending) {
        this.synchronizePending = pending;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        theLogger.info(SrLogCategories.LEGACY, "syncDataWasChanged called  ", this.toString());
        this.doneSynchronizing();
    }

    public void doneSynchronizing() throws RemoteException {
        this.setSynchronizePending(false);
        this.setSynchronizingMode(false);
        this.fireSynchronizeCompleted();
    }

    protected void fireSynchronizeCompleted() throws RemoteException {
        theLogger.trace(SrLogCategories.LEGACY, this.getClassId(), " ", this, " has completed synchronizing");
        if (!this.listeners.isEmpty()) {
            SynchronizeEvent event = new SynchronizeEvent(this);
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((SynchronizeListener)e.nextElement()).synchronizingCompleted(event);
            }
        }
    }

    public void errorInSynchronizing() {
        if (this.isSynchronizePending()) {
            this.setSynchronizePending(false);
            try {
                this.fireSynchronizeError();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, "Failed to Fire Sync Error");
            }
        }
    }

    protected void fireSynchronizeError() throws RemoteException {
        theLogger.trace(SrLogCategories.LEGACY, this.getClassId(), " ", this, " has Error while synchronizing");
        if (!this.listeners.isEmpty()) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((SynchronizeListener)e.nextElement()).errorInSynchronizing();
            }
        }
    }

    public boolean isNeedToSynchronize() throws RemoteException {
        boolean allVsConnected = true;
        for (VSwitchImpl curVS : this.cluster.getVSwitches()) {
            if (curVS.isConnected()) continue;
            allVsConnected = false;
        }
        boolean definedInAllVs = this.cluster.getVSwitches().size() > this.getConnectedVSwitchCounter();
        return allVsConnected && definedInAllVs;
    }

    protected abstract int synchronizeMe() throws RemoteException, IllegalValueException;

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        return null;
    }

    public synchronized void internalSynchronize() throws RemoteException, IllegalValueException {
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Checking synchronizing for ", this.getClassId(), " ", this.toString());
        if (this.isNeedToSynchronize()) {
            if (!this.isSynchronizePending()) {
                this.setSynchronizePending(true);
                String msg = this.canBeSynchronized();
                if (msg == null) {
                    theLogger.trace(SrLogCategories.LEGACY, "Begin synchronizing ", this.getClassId(), " ", this.toString());
                    int syncMeRetVal = this.synchronizeMe();
                    if (syncMeRetVal == 3) {
                        this.setSynchronizePending(false);
                    }
                    return syncMeRetVal;
                }
                theLogger.trace(SrLogCategories.LEGACY, msg);
                this.setSynchronizePending(false);
                return 3;
            }
            return 1;
        }
        return 0;
    }

    protected final ConfigElementData buildCEDForSynchronization(ConfigElementDataList list, Map<CommKeyClassId, ConfigElementData> accumulator) throws RemoteException, IllegalValueException {
        CommKeyClassId myCommKeyClassId = this.getCommKeyClassId();
        if (this.isRedundant()) {
            ConfigElementData elem = new ConfigElementData(myCommKeyClassId);
            return elem;
        }
        if (accumulator.containsKey(myCommKeyClassId)) {
            ConfigElementData elem = accumulator.get(myCommKeyClassId);
            return elem;
        }
        ConfigElementData element = new ConfigElementData(myCommKeyClassId.getClassID());
        accumulator.put(myCommKeyClassId, element);
        ArrayList<ParameterCode> paramsForCreation = this.getParamsForCreation();
        for (ParameterCode currCode : paramsForCreation) {
            Object currValue = this.getParameter(this.getActiveVswitch(), currCode).getValue();
            if (currValue == null) continue;
            if (currValue instanceof CommKeyClassId[]) {
                CommKeyClassId[] commKeyClassIds = (CommKeyClassId[])currValue;
                ConfigElementDataList cedl = new ConfigElementDataList();
                for (int j = 0; j < commKeyClassIds.length; ++j) {
                    CommKeyClassId currCKCI = commKeyClassIds[j];
                    SynchronizeableImpl currLogicObj = (SynchronizeableImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(currCKCI);
                    if (currLogicObj != null) {
                        cedl.add(currLogicObj.buildCEDForSynchronization(list, accumulator));
                        continue;
                    }
                    theLogger.logAndAssert(SrLogCategories.ERROR, "If there is a CKCID, there must be a reference, no reference, no ID... (1)");
                }
                element.addParameter(new Parameter(currCode, cedl));
                continue;
            }
            if (currValue instanceof CommKeyClassId) {
                CommKeyClassId commKeyClassId = (CommKeyClassId)currValue;
                SynchronizeableImpl currLogicObj = (SynchronizeableImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(commKeyClassId);
                if (currLogicObj != null) {
                    element.addParameter(new Parameter(currCode, currLogicObj.buildCEDForSynchronization(list, accumulator)));
                    continue;
                }
                theLogger.logAndAssert(SrLogCategories.ERROR, "If there is a CKCID, there must be a reference, no reference, no ID...(2)");
                continue;
            }
            if (currValue instanceof SrType) {
                element.addParameter(new Parameter(currCode, ((SrType)currValue).getValueForSync()));
                continue;
            }
            throw new IllegalStateException("Illegal type in the " + this.getClass().getName() + ".getParamsForCreation(). currCode: " + currCode + "; currValue.class: " + currValue.getClass().getName() + "; currValue: " + currValue);
        }
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, this.getCluster().getOtherVSwitch(this.getFirstVSwitch()).getCommKeyClassId()));
        this.buildAdditionalDependantObjectsForSynchronization(list, accumulator);
        return element;
    }

    protected abstract ArrayList<ParameterCode> getParamsForCreation() throws RemoteException;

    protected ArrayList getAdditionalDependantObjectsForSynchronization() throws RemoteException {
        return new ArrayList();
    }

    private void buildAdditionalDependantObjectsForSynchronization(ConfigElementDataList list, Map<CommKeyClassId, ConfigElementData> accumulator) throws RemoteException, IllegalValueException {
        ArrayList additionalObjectsForSynchronization = this.getAdditionalDependantObjectsForSynchronization();
        for (SynchronizeableImpl currObj : additionalObjectsForSynchronization) {
            ConfigElementData elem = currObj.buildCEDForSynchronization(list, accumulator);
            list.add(elem);
        }
    }

    public static ConfigElementData createCedForForceStateSync(VSwitch activeVswitch) throws RemoteException {
        ConfigElementData elem = new ConfigElementData(activeVswitch.getCommKeyClassId());
        elem.addParameter(new Parameter(ParameterCode.FORCE_STATE_SYNC, ForceStateSyncConstant.ACTIVATE));
        return elem;
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

