/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventListener;
import com.sanrad.nms.server.event.SrRemoveElementEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.SrDebugLogObject;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class LogicObjectImpl
extends GeneralLogicObjectImpl
implements LogicObject,
PropagatedStateEventListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected static final int INT_NOT_SET = -1;
    protected static final String NO_VAL = "N/A";
    private volatile short connectedVSwitchCounter = 1;
    private CommKey[] commKeys = null;
    private HashMap<ParameterCode, Parameter> parameters = new HashMap();
    private HashMap<VSwitchImpl, HashMap<ParameterCode, Parameter>> parameterVSwitchList = new HashMap();
    protected ClusterImpl cluster;
    protected volatile boolean synchronizingMode = false;
    protected volatile boolean neighborCreatingMode = false;
    protected String toStringValue = null;
    private boolean deletionPending = false;
    private boolean inconsistencyWithTheVSwitch = false;
    private boolean deleteFromDatabase = false;
    private boolean isMerged = false;
    private ArrayList<LogicObjectImpl> mergeListeners = new ArrayList();
    private ArrayList<LogicObjectImpl> mergeNotifiers = new ArrayList();

    protected LogicObjectImpl(ClusterImpl aCluster, ClassID aClassID, ConfigElementData aCED) throws RemoteException, IllegalValueException {
        super(aClassID);
        this.cluster = aCluster;
        if (aCED == null) {
            throw new IllegalArgumentException("the creation CED must not be null.");
        }
        assert (aCED.getClassId().equals(aClassID)) : "passed in a CED with a different class ID than the class ID argument. CED's class ID: " + aCED.getClassId() + "; arg class ID: " + aClassID;
        this.setCommKeys(aCED.getCommKey());
    }

    protected LogicObjectImpl(ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException {
        this(null, classId, aCED);
    }

    protected final void validateAndInit(ConfigElementData aCED, Map<ParameterCode, ParameterCode.Flags> aParameterCodeFlagsMap) throws InvalidElementException {
        this.validateParameters(aCED, aParameterCodeFlagsMap);
        this.addSelfParameters(aParameterCodeFlagsMap);
    }

    protected final void addSelfParameters(Map<ParameterCode, ParameterCode.Flags> aParameterCodeFlagsMap) {
        for (ParameterCode parameterCode : aParameterCodeFlagsMap.keySet()) {
            this.addParameterCode(parameterCode);
        }
    }

    protected final void validateParameters(ConfigElementData aCED, Map<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap) throws InvalidElementException {
        if (aCED == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The aCED must not be null.");
            return;
        }
        HashMap<ParameterCodes, Object> parametersMap = aCED.getParametersList();
        for (Map.Entry<ParameterCode, ParameterCode.Flags> entry : parameterCodeFlagsMap.entrySet()) {
            String msg;
            ParameterCode parameterCode = entry.getKey();
            ParameterCode.Flags pcFlags = entry.getValue();
            if (pcFlags.isMandatoryForDiscovery() && !parametersMap.containsKey(parameterCode)) {
                msg = "The mandatory parameterCode '" + parameterCode + "' is missing. The flags map: " + Util.getMapAsString(parameterCodeFlagsMap, 0, new StringBuffer());
            }
            if (pcFlags.isNullable() || !parametersMap.containsKey(parameterCode) || parametersMap.get(parameterCode) != null) continue;
            msg = "The parameterCode '" + parameterCode + "' must not be null. The flags map: " + Util.getMapAsString(parameterCodeFlagsMap, 0, new StringBuffer());
        }
    }

    public void clearParameterListExceptForVSwitchID(VSwitchImpl vSwitch) throws RemoteException {
        HashMap<ParameterCode, Parameter> parameterListValues = this.getParameterListValuesMap(vSwitch);
        for (ParameterCode currParam : parameterListValues.keySet()) {
            if (currParam == ParameterCode.VSWITCH_ID) continue;
            Parameter param = this.getParameter(vSwitch, currParam);
            param.setValue(null);
        }
    }

    public boolean isNewer(SrTimeTicks newTimestamp, VSwitchImpl vSwitch) throws RemoteException {
        SrType lastUpdate = this.getSrValueOf(vSwitch, ParameterCode.LAST_UPDATE);
        if (lastUpdate != null) {
            return newTimestamp.compareTo(lastUpdate) >= 0;
        }
        return true;
    }

    protected void addParameterCode(ParameterCode code) {
        this.parameters.put(code, new Parameter(code));
    }

    protected Parameter getParameter(VSwitch vSwitch, ParameterCode code) {
        HashMap<ParameterCode, Parameter> parameterListValues;
        if (vSwitch == null) {
            vSwitch = this.getActiveVswitch();
        }
        if ((parameterListValues = this.parameterVSwitchList.get(vSwitch)) != null) {
            return this.getParameter(parameterListValues, code);
        }
        return this.getParameter(this.parameters, code);
    }

    protected VSwitchImpl getFirstVSwitch() {
        VSwitchImpl disconnectVswitch = null;
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        for (int i = 0; i < vswitches.length; ++i) {
            if (vswitches[i].isConnected()) {
                return vswitches[i];
            }
            disconnectVswitch = vswitches[i];
        }
        if (disconnectVswitch == null) {
            // empty if block
        }
        return disconnectVswitch;
    }

    @Override
    public final VSwitchImpl getActiveVswitch() {
        VSwitchImpl vswitch = this.getDominantVswitch();
        if (vswitch != null && this.isKnownByVSwitch(vswitch)) {
            return vswitch;
        }
        return this.getFirstVSwitch();
    }

    public VSwitchImpl getDominantVswitch() {
        return null;
    }

    @Override
    public VSwitchImpl getInactiveVSwitch() {
        if (this.getConnectedVSwitchCounter() < 2) {
            return this.getFirstVSwitch();
        }
        if (!this.getConnectedVSwitches()[0].equals(this.getActiveVswitch())) {
            return this.getConnectedVSwitches()[0];
        }
        return this.getConnectedVSwitches()[1];
    }

    protected final Parameter getParameter(HashMap<ParameterCode, Parameter> aParameters, ParameterCode code) {
        return aParameters.get(code);
    }

    private void setCommKeys(CommKey[] commKeys) {
        this.commKeys = commKeys;
    }

    @Override
    public CommKey[] getCommKeys() {
        return this.commKeys;
    }

    @Override
    public CommKeyClassId getCommKeyClassId() {
        return new CommKeyClassId(this.getCommKeys(), this.getClassId());
    }

    public void addCommKeys(CommKey[] commKeys) {
        this.commKeys = CommKeyUtil.mergerCommKeyLists(this.commKeys, commKeys);
        this.incrementConnectedVSwitchCounter();
    }

    protected SrFuture<Void> deleteElement(ConfigElementData ced) throws IllegalValueException {
        String msg = this.canBeDeleted();
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        if (this.isInDeletionProcess()) {
            theLogger.trace(SrLogCategories.LEGACY, "Delete in process for ", this.getClassId(), " ", this.toString());
            return this.getInDeletionFuture();
        }
        SrFuture<Void> deletionFuture = this.deleteElementFromDataMgr(ced);
        theLogger.logAndAssert(SrLogCategories.ERROR, deletionFuture != null, new Object[]{"The future returned from the DM is null"});
        this.setInDeletionProcess(deletionFuture);
        return deletionFuture;
    }

    protected SrFuture<Void> deleteElementFromDataMgr(ConfigElementData ced) {
        theLogger.trace(SrLogCategories.LEGACY, "Trying to delete ", this.getClassId(), " ", this.toString());
        return DataMgrAdapter.getInstance().removeElement(ced);
    }

    protected SrFuture<Void> deleteElement(ConfigElementDataList cedList) throws RemoteException, IllegalValueException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("LogicObjectImpl.deleteElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        String msg = this.canBeDeleted();
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        theLogger.trace(SrLogCategories.LEGACY, "Trying to delete ", this.getClassId(), " ", this.toString());
        for (ElementData curElem : cedList) {
            theLogger.logAndAssert(SrLogCategories.ERROR, curElem instanceof ConfigElementData, new Object[]{"The CED list contains an instance of " + curElem.getClass()});
            midFutures.add(DataMgrAdapter.getInstance().removeElement((ConfigElementData)curElem));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public VSwitchImpl getVSwitch(ConfigElementData aCED) {
        Object vSwitchObj = aCED.getValue(ParameterCode.VSWITCH_ID);
        if (vSwitchObj != null) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            VSwitchImpl vSwitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        return null;
    }

    private HashMap<ParameterCode, Parameter> getParameterListValuesEmptyMap(HashMap<ParameterCode, Parameter> aParameters) {
        HashMap<ParameterCode, Parameter> parameterListValuesEmptyMap = new HashMap<ParameterCode, Parameter>(aParameters.size());
        Set<ParameterCode> keys = aParameters.keySet();
        for (ParameterCode code : keys) {
            parameterListValuesEmptyMap.put(code, new Parameter(code));
        }
        return parameterListValuesEmptyMap;
    }

    protected HashMap<ParameterCode, Parameter> getParameterListValuesMap(VSwitchImpl vSwitch) {
        HashMap<ParameterCode, Parameter> parameterListValues = null;
        if (!this.getClassId().equals(ClassID.VSWITCH) && vSwitch != null && (parameterListValues = this.parameterVSwitchList.get(vSwitch)) == null) {
            parameterListValues = this.getParameterListValuesEmptyMap(this.parameters);
            this.parameterVSwitchList.put(vSwitch, parameterListValues);
        }
        if (parameterListValues != null) {
            return parameterListValues;
        }
        return this.parameters;
    }

    public HashMap<ParameterCode, Object> getParameterListValues(VSwitchImpl vSwitch) {
        HashMap<ParameterCode, Parameter> parameterListValuesMap = this.getParameters(vSwitch);
        HashMap<ParameterCode, Object> parameterListValues = new HashMap<ParameterCode, Object>();
        for (ParameterCode currParam : parameterListValuesMap.keySet()) {
            Parameter currValue = parameterListValuesMap.get(currParam);
            parameterListValues.put(currParam, currValue.getValue());
        }
        return parameterListValues;
    }

    public HashMap<ParameterCode, Parameter> getParameters(VSwitchImpl vSwitch) {
        HashMap<ParameterCode, Parameter> parameterListValues = null;
        if (!this.getClassId().equals(ClassID.VSWITCH) && vSwitch != null) {
            parameterListValues = this.parameterVSwitchList.get(vSwitch);
        }
        if (parameterListValues != null) {
            return parameterListValues;
        }
        return this.parameters;
    }

    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        this.getParameterListValuesMap(vSwitch);
        HashMap changedValues = new HashMap();
        HashMap<ParameterCodes, Object> parameterList = aCED.getParametersList();
        Set keys = parameterList.keySet();
        for (ParameterCode key : keys) {
            Parameter param = this.getParameter(vSwitch, key);
            if (param != null) {
                Object value = aCED.getValue(key);
                if (value == null && (!key.isNullable() || key.isNullable() && !parameterList.containsKey(key))) {
                    theLogger.trace(SrLogCategories.LEGACY, new SrDebugLogObject("Value for \"" + key + "\" is NULL in " + this.getClass() + "::changeParameterList()", aCED));
                    continue;
                }
                Object oldValue = param.getValue();
                if ((oldValue == null || oldValue.equals(value)) && (oldValue != null || value == null) || oldValue instanceof Object[] && value instanceof Object[] && Arrays.equals((Object[])oldValue, (Object[])value)) continue;
                param.setValue(value);
                changedValues.put(key, value);
                continue;
            }
            if (key.equals(ParameterCode.VSWITCH_ID)) continue;
            theLogger.trace(SrLogCategories.LEGACY, "Parameter \"", key, "\" is not known in ", this.getClass(), "::changeParameterList()");
        }
        return changedValues;
    }

    public boolean setOneParameter(ParameterCode code, Object value, VSwitchImpl vSwitch) throws IllegalValueException {
        Parameter val;
        HashMap<ParameterCode, Parameter> parameterListValues = this.getParameterListValuesMap(vSwitch);
        if (parameterListValues.containsKey(code) && Util.equalsWithNull(val = parameterListValues.get(code), value)) {
            return false;
        }
        parameterListValues.put(code, new Parameter(code, value));
        return true;
    }

    public boolean setOneParameter(Parameter param, VSwitchImpl vSwitch) throws IllegalValueException {
        return this.setOneParameter(param.getCode(), param.getValue(), vSwitch);
    }

    public void setParametersBadValue(VSwitch vSwitch, ParameterCode[] badValues) throws RemoteException {
        for (int i = 0; i < badValues.length; ++i) {
            SrType value = this.getSrValueOf(vSwitch, badValues[i]);
            value.setBadValue(true);
        }
    }

    public List<Parameter> getParametersBadValue(VSwitchImpl vSwitch) {
        ArrayList<Parameter> badValues = null;
        HashMap<ParameterCode, Parameter> parameterList = this.parameterVSwitchList.get(vSwitch);
        if (parameterList == null) {
            parameterList = this.parameters;
        }
        Iterator<ParameterCode> i = parameterList.keySet().iterator();
        while (i.hasNext()) {
            Parameter parameter = parameterList.get(i.next());
            SrType value = (SrType)parameter.getValue();
            if (value == null || !value.isBadValue()) continue;
            if (badValues == null) {
                badValues = new ArrayList<Parameter>();
            }
            badValues.add(parameter);
        }
        return badValues;
    }

    @Override
    public boolean isRedundant() {
        int connectedVSwitchCounter = this.getConnectedVSwitchCounter();
        return this.cluster.getVSwitchesCount() == connectedVSwitchCounter || connectedVSwitchCounter == 0;
    }

    public boolean isKnownByVSwitch(VSwitchImpl vSwitch) {
        return this.parameterVSwitchList.get(vSwitch) != null;
    }

    public void clear() throws RemoteException {
        this.connectedVSwitchCounter = 1;
    }

    private Object getParameterSrValueOf(VSwitch vSwitch, ParameterCode code) {
        Parameter param = this.getParameter(vSwitch, code);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    protected SrType getSrValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) {
        if (anyVSwitch) {
            return this.getSrValueOf(code);
        }
        return this.getSrValueOf(vSwitch, code);
    }

    protected SrType getSrValueOf(VSwitch vSwitch, ParameterCode code) {
        return (SrType)this.getParameterSrValueOf(vSwitch, code);
    }

    protected SrType getSrValueOf(ParameterCode code) {
        SrType srValue;
        VSwitchImpl activeVSwitch = this.getActiveVswitch();
        if (activeVSwitch != null && (srValue = this.getSrValueOf(activeVSwitch, code)) != null) {
            return srValue;
        }
        for (VSwitchImpl vSwitch : this.parameterVSwitchList.keySet()) {
            SrType srValue2;
            if (vSwitch == null || !this.isKnownByVSwitch(vSwitch) || (srValue2 = this.getSrValueOf(vSwitch, code)) == null) continue;
            return srValue2;
        }
        return null;
    }

    public SrType getSrValueOf(MasterParameterCode mCode) {
        ParameterCode pCode = this.getParameterCode(mCode);
        return this.getSrValueOf(pCode);
    }

    protected CommKeyClassId getCommKeyClassIdValueOf(ParameterCode code) {
        CommKeyClassId srValue = null;
        for (VSwitchImpl vSwitch : this.parameterVSwitchList.keySet()) {
            if (vSwitch == null || !this.isKnownByVSwitch(vSwitch)) continue;
            CommKeyClassId nextCommKey = (CommKeyClassId)this.getSrValueOf(vSwitch, code);
            if (srValue != null && nextCommKey != null) {
                srValue = CommKeyUtil.mergeCommKeyClassIDs(srValue, nextCommKey);
                continue;
            }
            srValue = nextCommKey;
        }
        return srValue;
    }

    protected SrType[] getSrArrayValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) {
        if (anyVSwitch) {
            return this.getSrArrayValueOf(code);
        }
        return this.getSrArrayValueOf(vSwitch, code);
    }

    public SrType[] getSrArrayValueOf(VSwitch vSwitch, ParameterCode code) {
        SrType[] value = (SrType[])this.getParameterSrValueOf(vSwitch, code);
        if (value == null) {
            theLogger.trace(SrLogCategories.LEGACY, "Value of ", code, " is null");
            return null;
        }
        return value;
    }

    protected SrType[] getSrArrayValueOf(ParameterCode code) {
        for (VSwitch vSwitch : this.parameterVSwitchList.keySet()) {
            Parameter param;
            if (vSwitch == null || (param = this.getParameter(vSwitch, code)) == null) continue;
            SrType[] value = (SrType[])param.getValue();
            return value;
        }
        return null;
    }

    protected Object getValueOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) {
        if (anyVSwitch) {
            return this.getValueOf(code);
        }
        return this.getValueOf(vSwitch, code);
    }

    protected Object getValueOf(VSwitch vSwitch, ParameterCode code) {
        SrType value = this.getSrValueOf(vSwitch, code);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    public Object getValueOf(ParameterCode code) {
        SrType value = this.getSrValueOf(code);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    protected String getDisplayStringOf(VSwitch vSwitch, ParameterCode code, boolean anyVSwitch) {
        SrType value = this.getSrValueOf(vSwitch, code, anyVSwitch);
        if (value == null) {
            return null;
        }
        return value.toDisplayString();
    }

    protected String getDisplayStringOf(VSwitch vSwitch, ParameterCode code) {
        SrType value = this.getSrValueOf(vSwitch, code);
        if (value == null) {
            return null;
        }
        return value.toDisplayString();
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        AlarmMgrImpl.getInstance().removeAlarmsFromSilencedList(this);
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        return this.deleteElement(ced);
    }

    @Override
    public final List<SrFuture<Void>> deleteElementTree() throws IllegalValueException {
        String msg = this.canBeDeleted();
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        ConfigElementDataList deletionList = this.getTreeDeletionCedList();
        SrFuture<Void> future = DataMgrAdapter.getInstance().configureElements(deletionList);
        return Collections.singletonList(future);
    }

    public ConfigElementDataList getTreeDeletionCedList() {
        ConfigElementDataList deletionCeds = new ConfigElementDataList(ConfigOperation.DELETE);
        AlarmMgrImpl.getInstance().removeAlarmsFromSilencedList(this);
        deletionCeds.addAll((Collection<? extends ElementData>)this.getCedForDeletion());
        deletionCeds.addAll(this.getDeleteChildrenCedList());
        return deletionCeds;
    }

    protected final ConfigElementDataList getDeleteChildrenCedList() {
        ConfigElementDataList deletionCeds = new ConfigElementDataList(ConfigOperation.DELETE);
        for (LogicObjectImpl child : this.getChildElementsForDeletion()) {
            deletionCeds.addAll(child.getTreeDeletionCedList());
        }
        return deletionCeds;
    }

    public List<ConfigElementData> getCedForDeletion() {
        ArrayList<ConfigElementData> retVal = new ArrayList<ConfigElementData>(1);
        retVal.add(new ConfigElementData(this.getCommKeyClassId(), ConfigOperation.DELETE));
        return retVal;
    }

    protected List<LogicObjectImpl> getChildElementsForDeletion() {
        return new ArrayList<LogicObjectImpl>();
    }

    @Override
    public SrFuture<Void> changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        HashMap<ClientParameterCode, Object> parameterList = new HashMap<ClientParameterCode, Object>();
        parameterList.put(code, value);
        return this.changeElement(parameterList);
    }

    public ConfigElementData createCED(HashMap parameterList) throws IllegalValueException {
        Set keys = parameterList.keySet();
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        for (ClientParameterCode clientParameterCode : keys) {
            Object value = parameterList.get(clientParameterCode);
            ParameterCode parameterCode = clientParameterCode.getParameterCode();
            if (parameterCode == null) {
                theLogger.trace(SrLogCategories.LEGACY, clientParameterCode, " is not a \"server\" parameter in ", this.getClass(), "::changeElement()");
                continue;
            }
            Parameter parameter = new Parameter(parameterCode, value);
            element.addParameter(parameter);
        }
        this.setVswitchesToPerformOperation(element, parameterList);
        return element;
    }

    protected SrFuture<Void> innerChangeElement(ConfigElementData element) throws IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Trying to change element ", this.getClassId(), " ", this.toString());
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    protected SrFuture<Void> innerChangeElement(ConfigElementDataList elementList) throws IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, "Trying to change element ", this.getClassId(), " ", this.toString(), "; elements: ", elementList);
        final SrFuture<Void> retFuture = new SrFuture<Void>("LogicObjectImpl.innerChangeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (ElementData curCED : elementList) {
            midFutures.add(DataMgrAdapter.getInstance().changeElement((ConfigElementData)curCED));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    public ConfigElementData validateChangeAndCreateCED(HashMap parameterList) throws IllegalValueException {
        String msg = this.isValid(parameterList);
        if (msg != null) {
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        ConfigElementData element = this.createCED(parameterList);
        return element;
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        ConfigElementData element = this.validateChangeAndCreateCED(parameterList);
        return this.innerChangeElement(element);
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws IllegalValueException {
    }

    @Override
    public int getConnectedVSwitchCounter() {
        return this.getConnectedVSwitches().length;
    }

    private int incrementConnectedVSwitchCounter() {
        this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter + 1);
        this.setSynchronizingMode(false);
        this.neighborCreatingMode = false;
        return this.connectedVSwitchCounter;
    }

    public int decrementConnectedVSwitchCounter(CommKey[] vSwitchCommKeys) throws RemoteException {
        Vector<CommKey> commKeysVec = new Vector<CommKey>(this.commKeys.length);
        for (int i = 0; i < this.commKeys.length; ++i) {
            commKeysVec.addElement(this.commKeys[i]);
        }
        boolean result = CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitchCommKeys);
        if (result) {
            this.commKeys = new CommKey[commKeysVec.size()];
            commKeysVec.toArray(this.commKeys);
            if (this.connectedVSwitchCounter == 0) {
                theLogger.trace(SrLogCategories.LEGACY, "connectedVSwitchCounter cannot be negative for ", this.getClassId() + " " + this.toString());
            } else {
                this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter - 1);
            }
        }
        return this.connectedVSwitchCounter;
    }

    public List<VSwitchImpl> getVSwitches() {
        CommKeyClassId[] vSwitchCommKeyClassIDs = CommKeyUtil.getVSwitchCommKeyClassIDs(this.commKeys);
        ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>();
        for (int i = 0; i < vSwitchCommKeyClassIDs.length; ++i) {
            VSwitchImpl vSwitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassIDs[i]);
            vSwitches.add(vSwitch);
        }
        return vSwitches;
    }

    protected void setSynchronizingMode(boolean mode) {
        this.synchronizingMode = mode;
    }

    public boolean isInSynchronizingMode() {
        return this.synchronizingMode;
    }

    @Override
    public ClusterImpl getCluster() {
        return this.cluster;
    }

    public CommKey[] getCommKeysOfVSwitch(VSwitch vSwitch) throws RemoteException {
        return this.getCommKeysOfVSwitch(vSwitch, null);
    }

    public CommKey[] getCommKeysOfVSwitch(VSwitch vSwitch, Vector commKeysVec) throws RemoteException {
        CommKey[] removedCommKey = null;
        Vector<CommKey> removedCommKeyVec = null;
        if (commKeysVec == null) {
            commKeysVec = new Vector<CommKey>(this.commKeys.length);
        }
        for (int i = 0; i < this.commKeys.length; ++i) {
            commKeysVec.addElement(this.commKeys[i]);
        }
        boolean result = CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitch.getCommKeys());
        if (result) {
            removedCommKeyVec = new Vector<CommKey>(this.commKeys.length - commKeysVec.size());
            for (int i = 0; i < this.commKeys.length; ++i) {
                if (commKeysVec.contains(this.commKeys[i])) continue;
                removedCommKeyVec.addElement(this.commKeys[i]);
            }
            removedCommKey = new CommKey[removedCommKeyVec.size()];
            removedCommKeyVec.toArray(removedCommKey);
        }
        return removedCommKey;
    }

    public CommKey[] removeFromVSwitch(VSwitch vSwitch) throws RemoteException {
        Vector commKeysVec = new Vector(this.commKeys.length);
        CommKey[] removedCommKey = this.getCommKeysOfVSwitch(vSwitch, commKeysVec);
        this.commKeys = new CommKey[commKeysVec.size()];
        commKeysVec.toArray(this.commKeys);
        if (this.parameterVSwitchList.remove(vSwitch) != null) {
            this.connectedVSwitchCounter = (short)(this.connectedVSwitchCounter - 1);
        }
        return removedCommKey;
    }

    @Override
    public VSwitch[] getConnectedVSwitchesList() {
        ArrayList<VSwitch> vSwitches = new ArrayList<VSwitch>();
        for (VSwitchImpl obj : this.parameterVSwitchList.keySet()) {
            if (this.parameterVSwitchList.get(obj) == null) continue;
            vSwitches.add(obj);
        }
        return vSwitches.toArray(new VSwitch[vSwitches.size()]);
    }

    public VSwitchImpl[] getNetworkConnectedVSwitches() {
        return this.cluster.getConnectedVSwitches();
    }

    @Override
    public VSwitchImpl[] getConnectedVSwitches() {
        ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>();
        for (VSwitchImpl obj : this.parameterVSwitchList.keySet()) {
            if (this.parameterVSwitchList.get(obj) == null) continue;
            vSwitches.add(obj);
        }
        return vSwitches.toArray(new VSwitchImpl[vSwitches.size()]);
    }

    public List<VSwitchImpl> getConnectedVSwitchesAsList() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        return new ArrayList<VSwitchImpl>(Arrays.asList(vSwitches));
    }

    public CommKeyClassId[] getConnectedVswitchesData() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.length];
        for (int i = 0; i < vSwitches.length; ++i) {
            vSwitchesData[i] = new CommKeyClassId(vSwitches[i].getCommKeys(), vSwitches[i].getClassId());
        }
        return vSwitchesData;
    }

    public VSwitchImpl getOtherVSwitch(VSwitchImpl vSwitch) {
        VSwitchImpl otherVSwitch2 = null;
        for (VSwitchImpl otherVSwitch2 : this.parameterVSwitchList.keySet()) {
            if (otherVSwitch2.equals(vSwitch)) continue;
            return otherVSwitch2;
        }
        return otherVSwitch2;
    }

    protected VSwitchImpl getOtherVSwitchFromCluster(VSwitch vSwitch) {
        for (VSwitchImpl otherVSwitch : this.cluster.getVSwitches()) {
            if (otherVSwitch.equals(vSwitch)) continue;
            return otherVSwitch;
        }
        return null;
    }

    protected boolean isInArray(Object value, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isArraysEqual(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (this.isInArray(array1[i], array2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isConsistentValues(Object[] values) {
        Object value = values[0];
        boolean valueIsArray = value instanceof Object[];
        if (value != null) {
            for (int i = 1; i < values.length; ++i) {
                if (!(!valueIsArray ? !value.equals(values[i]) : !this.isArraysEqual((Object[])value, (Object[])values[i]))) continue;
                return false;
            }
        }
        return true;
    }

    private Object getValueFromSrValue(SrType srValue) {
        if (srValue instanceof CommKeyClassId) {
            return this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)srValue);
        }
        return srValue.value();
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            HashMap<ParameterCode, Object[]> inconsistentValues = new HashMap<ParameterCode, Object[]>();
            Iterator<ParameterCode> iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                Object[] values = new Object[vSwitches.length];
                ParameterCode code = iter.next();
                if (!code.isCodeRelevantForConsistencyCheck()) continue;
                for (int i = 0; i < vSwitches.length; ++i) {
                    values[i] = this.getParameterSrValueOf(vSwitches[i], code);
                    if (values[i] == null || values[i] instanceof SrType) {
                        if (values[i] != null) {
                            if (!(values[i] instanceof CommKeyClassId)) continue;
                            values[i] = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)values[i]);
                            continue;
                        }
                        values[i] = "<none>";
                        continue;
                    }
                    if (!(values[i] instanceof SrType[])) continue;
                    SrType[] srValues = (SrType[])values[i];
                    Object[] logicValues = new Object[srValues.length];
                    for (int j = 0; j < srValues.length; ++j) {
                        Object val = this.getValueFromSrValue(srValues[j]);
                        if (val != null) {
                            logicValues[j] = val.toString();
                        }
                        logicValues[j] = val;
                    }
                    values[i] = logicValues;
                }
                if (this.isConsistentValues(values)) continue;
                inconsistentValues.put(code, values);
            }
            return inconsistentValues;
        }
        return null;
    }

    @Override
    public abstract AlarmGenerator getAlarmGenerator();

    public String toString() {
        if (this.toStringValue == null) {
            return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
        }
        return this.toStringValue;
    }

    public void setDeletionPending() {
        this.deletionPending = true;
    }

    public void clearDeletionStatus() {
        this.deletionPending = false;
        this.clearInDeletionProcess();
    }

    public void setInconsistentWithTheVSwitch() {
        this.inconsistencyWithTheVSwitch = true;
    }

    public boolean isInconsistentWithTheVSwitch() {
        return this.inconsistencyWithTheVSwitch;
    }

    public boolean isDeletionPending() {
        return this.deletionPending;
    }

    @Override
    public CommKeyRefMap getCommKeyRefMap() throws RemoteException {
        return this.cluster.getCommKeyRefMap();
    }

    public String getAllObjectDataString() throws RemoteException {
        StringBuffer data = new StringBuffer("Object data: \n ClassID: ");
        data.append(this.getClassId().toString());
        data.append("CommKeys are: ");
        for (int i = 0; i < this.commKeys.length; ++i) {
            data.append(this.commKeys[i].toString());
            data.append("; ");
        }
        data.append("\n Parameters are: \n");
        for (VSwitch vSwitch : this.parameterVSwitchList.keySet()) {
            data.append("VSwitch: ");
            data.append(vSwitch.getCommKeys().toString());
            data.append("  - Params: ");
            data.append(this.parameterVSwitchList.get(vSwitch).toString());
            data.append("\n");
        }
        return data.toString();
    }

    public boolean isDeletedFromDatabaseOnly() {
        return this.deleteFromDatabase;
    }

    public void enableDeleteFromDatabaseOnly() {
        this.deleteFromDatabase = true;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap<ParameterCode, Parameter> parameterList;
        if (this.parameterVSwitchList.isEmpty()) {
            parameterList = this.parameters;
        } else {
            VSwitchImpl activeVS = this.getActiveVswitch();
            parameterList = this.parameterVSwitchList.get(activeVS);
        }
        HashMap clientParams = ElementEventImpl.convertParameterList(parameterList, this);
        clientParams.put(ClientParameterCode.PROPAGATION_STATE, this.getPropagatedState());
        return clientParams;
    }

    protected ConfigElementData buildCedForVswitch(VSwitchImpl vSwitch, ParameterList params) {
        if (vSwitch == null) {
            return null;
        }
        ConfigElementData ced = new ConfigElementData(this.commKeys, this.getClassId());
        ced.addParameter(params.getParamerListToHashMap());
        ced.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitch.getCommKeyClassId()));
        return ced;
    }

    public SrFuture<Void> changeElementInInactiveVswitch(ParameterList params) {
        VSwitchImpl vswitch = this.getInactiveVSwitch();
        if (vswitch == null) {
            return new CompleteFuture<Void>("LogicObjectImpl.changeElementInInactiveVswitch");
        }
        return DataMgrAdapter.getInstance().changeElement(this.buildCedForVswitch(vswitch, params));
    }

    public SrFuture<Void> changeElementForActiveVswitch(ParameterList params) {
        return DataMgrAdapter.getInstance().changeElement(this.buildCedForVswitch(this.getActiveVswitch(), params));
    }

    public SrFuture<Void> changeElementForActiveVswitch(MasterParameter param) {
        ParameterList params = new ParameterList(param);
        return this.changeElementForActiveVswitch(params);
    }

    public SrFuture<Void> changeElementForInactiveVswitch(MasterParameter param) {
        ParameterList params = new ParameterList(param);
        return this.changeElementInInactiveVswitch(params);
    }

    @Override
    public Cluster[] getAllClusters() throws RemoteException {
        Cluster[] clusters = new Cluster[]{this.getCluster()};
        return clusters;
    }

    @Override
    public boolean isParameterCodeExsist(ParameterCode code) {
        return this.parameters.keySet().contains(code);
    }

    @Override
    public boolean isParameterEqual(Parameters param, VSwitchImpl vswitch) {
        return param.getValue().equals(this.getSrValueOf(vswitch, this.getParameterCode(param.getCode())));
    }

    protected SrFuture<Void> refreshFields(ParameterCode[] codes) {
        return this.refreshFields(this.getCommKeyClassId(), codes);
    }

    protected SrFuture<Void> refreshFields(CommKeyClassId elementData, ParameterCode[] codes) {
        VSwitchImpl[] vSwithces = this.getNetworkConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                if (!this.isKnownByVSwitch(vSwithces[i])) continue;
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(this.getClassId());
            int i2 = codes.length;
            while (i2-- > 0) {
                element.setValue(codes[i2], (SrType)null);
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            element.setCommKeyClassId(elementData);
            return this.refreshFields(element);
        }
        return new CompleteFuture<Void>("LogicObjectImpl.refreshFields");
    }

    protected SrFuture<Void> refreshFields(ConfigElementData element) {
        return DataMgrAdapter.getInstance().readElementFields(element);
    }

    @Override
    public SrFuture<Void> refreshFields(ClientParameterCode[] codes) {
        ArrayList<ParameterCode> parameterCodesList = new ArrayList<ParameterCode>();
        int i = codes.length;
        while (i-- > 0) {
            ParameterCode paramCode = codes[i].getParameterCode();
            if (paramCode == null) continue;
            parameterCodesList.add(paramCode);
        }
        if (!parameterCodesList.isEmpty()) {
            return this.refreshFields(parameterCodesList.toArray(new ParameterCode[parameterCodesList.size()]));
        }
        return new CompleteFuture<Void>("LogicObjectImpl.refreshFields");
    }

    @Override
    public SrFuture<Void> refresh() {
        VSwitchImpl[] vSwithces = this.getConnectedVSwitches();
        if (vSwithces != null && vSwithces.length > 0) {
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwithces.length];
            int i = vSwithces.length;
            while (i-- > 0) {
                vSwitchesData[i] = vSwithces[i].getCommKeyClassId();
            }
            ConfigElementData element = new ConfigElementData(this.getClassId());
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            element.setCommKeyClassId(this.getCommKeyClassId());
            return DataMgrAdapter.getInstance().readElement(element);
        }
        return new CompleteFuture<Void>("LogicObjectImpl.refresh");
    }

    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        element.setClassId(this.getClassId());
        CommKeyClassId logicElement = this.getElementIfAlreadyExsist(element, remoteCluster);
        if (logicElement != null) {
            element.setCommKeys(logicElement.getCommKeys());
        }
        Object[] vswitches = remoteCluster.getVSwitches().toArray();
        CommKeyClassId[] vswitchesToSend = new CommKeyClassId[vswitches.length];
        for (int i = 0; i < vswitches.length; ++i) {
            vswitchesToSend[i] = ((VSwitchImpl)vswitches[i]).getCommKeyClassId();
        }
        element.addParameter(ParameterCode.VSWITCH_ID, vswitchesToSend);
    }

    protected CommKeyClassId getElementIfAlreadyExsist(ConfigElementData elem, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        LogicObjectImpl result;
        theLogger.trace(SrLogCategories.LEGACY, "check if element alread exsist", this);
        VolumeNodeImpl element = null;
        if (elem.getFirstChild() != null && elem.getFirstChild().getCommKey() != null) {
            element = (VolumeNodeImpl)remoteCluster.getCommKeyRefMap().getRefByCommKeyClassID(elem.getFirstChild().getCommKeyClassId());
        }
        if ((result = this.findEquivelentElement(remoteCluster, element)) != null) {
            result.setExsistentElementIfNeeded(this);
            return result.getCommKeyClassId();
        }
        return null;
    }

    protected void setExsistentElementIfNeeded(LogicObjectImpl source) throws RemoteException, IllegalValueException {
    }

    protected LogicObjectImpl findEquivelentElement(ClusterImpl remoteCluster, LogicObjectImpl element) throws RemoteException, IllegalValueException {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        try {
            LogicObject compareToObj;
            if (obj instanceof LogicObject && (compareToObj = (LogicObject)obj).getCommKeys() != null && this.getCommKeys() != null) {
                return this.getCommKeyClassId().equals(compareToObj.getCommKeyClassId());
            }
        }
        catch (RemoteException e) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, e, "got a remote exception in the server.");
        }
        return false;
    }

    @Override
    public boolean equalsByCommKey(Object obj) {
        return this.equals(obj);
    }

    public boolean isConsistentBetweenVSwitches(ParameterCode code) throws RemoteException {
        HashMap inconsistentValues = this.checkConsistencyBetweenVSwitches();
        if (inconsistentValues == null) {
            return true;
        }
        return !inconsistentValues.containsKey(code);
    }

    public final void merge(LogicObjectImpl other) {
        if (!other.getClassId().equals(this.getClassId())) {
            throw new IllegalArgumentException("Cannot merge entities with different types");
        }
        Iterator<VSwitchImpl> i = other.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            if (!this.parameterVSwitchList.containsKey(i.next())) continue;
            throw new IllegalArgumentException("This element already contains parameters from the other element");
        }
        Object[] mergeListenersArray = other.mergeListeners.toArray();
        for (int i2 = 0; i2 < mergeListenersArray.length; ++i2) {
            ((LogicObjectImpl)mergeListenersArray[i2]).notifyChildElementsWillBeMerged(other, this);
        }
        this.doMerge(other);
    }

    public boolean canMerge(LogicObjectImpl other) {
        if (other == null) {
            return false;
        }
        if (!other.getClassId().equals(this.getClassId())) {
            return false;
        }
        Iterator<VSwitchImpl> i = other.parameterVSwitchList.keySet().iterator();
        while (i.hasNext()) {
            if (!this.parameterVSwitchList.containsKey(i.next())) continue;
            return false;
        }
        return true;
    }

    public final void addMergeListener(LogicObjectImpl mergeListener) {
        if (!this.mergeListeners.contains(mergeListener)) {
            this.mergeListeners.add(mergeListener);
            mergeListener.addMergeNotifier(this);
        }
    }

    public final void removeMergeListener(LogicObjectImpl mergeListener) {
        this.mergeListeners.remove(mergeListener);
    }

    private void addMergeNotifier(LogicObjectImpl mergeListener) {
        if (!this.mergeNotifiers.contains(mergeListener)) {
            this.mergeNotifiers.add(mergeListener);
        }
    }

    public void clearMergeNotifiers() {
        for (LogicObjectImpl mergeNotifier : this.mergeNotifiers) {
            mergeNotifier.removeMergeListener(this);
        }
        this.mergeNotifiers.clear();
    }

    protected void doMerge(LogicObjectImpl other) {
        CommKey[] otherCommKeys = other.getCommKeys();
        HashMap<VSwitchImpl, HashMap<ParameterCode, Parameter>> otherParamterList = new HashMap<VSwitchImpl, HashMap<ParameterCode, Parameter>>(other.parameterVSwitchList);
        List<VSwitchImpl> vswitchesBeforMerge = this.getConnectedVSwitchesAsList();
        this.cleanMergedElement(other);
        this.addCommKeys(otherCommKeys);
        this.parameterVSwitchList.putAll(otherParamterList);
        this.cluster.getCommKeyRefMap().addCommKeyClassIdAndRef(otherCommKeys, other.getClassId(), this);
        AlarmMgrImpl.getInstance().generateAlarms(this.cluster, 2, this, vswitchesBeforMerge.get(0));
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    private void cleanMergedElement(LogicObjectImpl mergedElement) {
        mergedElement.isMerged = true;
        ClusterImpl cluster = mergedElement.getCluster();
        ConfigElementData elementCED = new ConfigElementData(mergedElement.getCommKeyClassId());
        List<VSwitchImpl> storageVSwitches = mergedElement.getConnectedVSwitchesAsList();
        elementCED.setValue(ParameterCode.VSWITCH_ID, storageVSwitches.get(0).getCommKeyClassId());
        SrRemoveElementEvent removeEvent = new SrRemoveElementEvent((Object)this, elementCED);
        cluster.elementEvent(removeEvent);
    }

    protected void notifyChildElementsWillBeMerged(LogicObjectImpl childElement, LogicObjectImpl mantainedElement) {
    }

    public String getDebugInfo(String title) {
        StringBuffer out = new StringBuffer();
        out.append("Details information for ").append(this.getClass()).append(": ");
        out.append(this.toString()).append('\n');
        if (title != null) {
            out.append("\tTitle:\n\t\t");
            out.append(title).append('\n');
        }
        out.append("\tCommKeyClassID:\n\t\t");
        if (this.getCommKeys() != null) {
            out.append(this.getCommKeyClassId()).append('\n');
        } else {
            out.append("CommKey is null").append('\n');
        }
        out.append("\tParameter list:").append('\n');
        if (!this.parameterVSwitchList.isEmpty()) {
            out.append(Util.getMapAsString(this.parameterVSwitchList, 2, new StringBuffer()));
        } else {
            out.append(Util.getMapAsString(this.parameters, 2, new StringBuffer()));
        }
        out.append("\tCurrent event trace: ");
        out.append(SrLogger.getThrowableOutput(new Exception("Stack trace")));
        if (this.cluster != null) {
            out.append(this.cluster.getClusterDebugInfo());
        } else {
            out.append("\tCluster is null.").append('\n');
        }
        return out.toString();
    }

    public void printDebugInfo(String title) {
        theLogger.trace(SrLogCategories.LEGACY, this.getDebugInfo(title));
    }

    public ParameterCode getParameterCode(ParameterCodes code) {
        return code.getParameterCode(this.parameters);
    }

    public boolean isDeleted() {
        return this.getConnectedVSwitchCounter() == 0;
    }

    @Override
    public String validateChange(Map<ClientParameterCode, Object> aParams) {
        HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>(aParams);
        return this.isValid(params);
    }

    @Override
    public String validateDeletion() {
        return this.canBeDeleted();
    }
}

