/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.SrTestUtils;
import com.sanrad.TestServerEventsListener;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.ServerConnectionException;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.security.StringCodec;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class LogicMgrTest
extends TestCase
implements ServerEventsListener {
    private Class myLogicMgrClass;
    private LogicMgrAOImpl myLogicMgr;
    private Method getLogicObjectCkci;
    private Method getLogicObjectString;
    private static SrTestUtils myTestUtils;
    private static Properties myProps;
    private Semaphore myTargetCreatedSem = null;
    private String myRetEvent;
    private static final Semaphore theLock;
    private static String EVENT_TYPE_CONTROL;
    private static String EVENT_TYPE_DATA;
    private ServerFacade myFacade = null;
    private static SrLogger theLogger;
    private static String CLI_USER;
    private static String CLI_PASSWORD;
    private static final int ALIAS_MAX_LENGTH;
    private static final String CONF_FILE;
    private Properties myTestProperties = new Properties();
    private static final String SITE_1_NAME = "SITE_1_NAME";
    private static final String SITE_2_NAME = "SITE_2_NAME";
    private static final String CLUSTER_1_NAME = "CLUSTER_1_NAME";
    private static final String CLUSTER_2_NAME = "CLUSTER_2_NAME";
    private static final String VS_1_IP = "VS_1_IP";
    private static final String VS_2_IP = "VS_2_IP";
    private static final String TARGET_NAME = "TARGET_NAME";

    public LogicMgrTest() {
        try {
            this.myTestProperties.load(new FileInputStream("test//config//LogicMgrTest.properties"));
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
        this.myLogicMgrClass = LogicMgrAOImpl.class;
        Class[] params = new Class[]{VolumeNodeImpl.class};
        try {
            params = new Class[]{CommKeyClassId.class};
            this.getLogicObjectCkci = this.myLogicMgrClass.getDeclaredMethod("getLogicObject", params);
            this.getLogicObjectCkci.setAccessible(true);
            params = new Class[]{String.class};
            this.getLogicObjectString = this.myLogicMgrClass.getDeclaredMethod("getLogicObject", params);
            this.getLogicObjectString.setAccessible(true);
        }
        catch (SecurityException e) {
            LogicMgrTest.fail((String)"Could not initialize the test.");
        }
        catch (NoSuchMethodException e) {
            LogicMgrTest.fail((String)"Could not initialize the test.");
        }
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
    }

    public static void runMe() {
        TestRunner.run(LogicMgrTest.class);
    }

    public String toString() {
        return "LogicMgrTest [endpoint:[localhost:2](remote)";
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            theLock.acquire();
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"Could not acquire the lock in order to run the test.");
        }
        while (!SystemRootImpl.getInstance().isDiscoverCompleted()) {
            Thread.sleep(500L);
        }
        this.myLogicMgr = LogicMgrAOImpl.getInstance();
        this.myTargetCreatedSem = new Semaphore(0);
        this.myFacade = LogicMgrAOImpl.getInstance().openSession(this);
        this.myRetEvent = "";
    }

    protected void tearDown() throws Exception {
        this.myFacade.closeSession();
        theLock.release();
        super.tearDown();
    }

    private synchronized void setRetEvent(String aType) {
        if (this.myRetEvent.equals("")) {
            this.myRetEvent = aType;
        }
    }

    public synchronized String getRetEvent() {
        return this.myRetEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogicObject1() {
        Site curSite = null;
        try {
            String siteName = myProps.getProperty(SITE_1_NAME);
            curSite = myTestUtils.createSite(siteName);
            String clusterName = myProps.getProperty(CLUSTER_1_NAME);
            ClusterImpl curCluster = myTestUtils.createCluster(clusterName, curSite);
            String vsIP = myProps.getProperty(VS_1_IP);
            VSwitchImpl curVs = myTestUtils.createDefaultVswitch(curCluster, vsIP);
            LogicMgrTest.assertNotNull((String)("Did not find VS " + vsIP), (Object)curVs);
            List<DirectAccessDeviceImpl> disks = myTestUtils.getAllDisks(curCluster);
            if (disks == null || disks.size() == 0) {
                LogicMgrTest.fail((String)"Could not find any disks.");
            }
            try {
                CommKeyClassId ckci = disks.get(0).getCommKeyClassId();
                Object retObj = this.getLogicObjectCkci.invoke((Object)this.myLogicMgr, ckci);
                LogicMgrTest.assertEquals((String)("The returned object is not the same disk. The disk is: " + disks.get(0) + " and the returned value is: " + retObj), (Object)disks.get(0), (Object)retObj);
            }
            catch (InvocationTargetException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            catch (SecurityException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            catch (IllegalAccessException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
        }
        catch (Throwable throwable) {
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogicObject2() {
        Site curSite = null;
        try {
            String siteName = myProps.getProperty(SITE_1_NAME);
            curSite = myTestUtils.createSite(siteName);
            String clusterName = myProps.getProperty(CLUSTER_1_NAME);
            ClusterImpl curCluster = myTestUtils.createCluster(clusterName, curSite);
            ServerFacade facade = myTestUtils.getServerLogic();
            List<ClusterImpl> clusters = myTestUtils.getClusters();
            if (clusters.size() == 0) {
                LogicMgrTest.fail((String)"Could not find a cluster which is needed for the test.");
            }
            try {
                facade.abortOperation(clusters.get(0).getCommKeyClassId()).get();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("The wrong type of exception was thrown: " + exp));
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)("The wrong type of exception was thrown: " + exp));
            }
            catch (ExecutionException exp) {
                LogicMgrTest.assertTrue((boolean)true);
                if (curSite != null) {
                    myTestUtils.removeSite(curSite);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
            throw throwable;
        }
        LogicMgrTest.fail((String)"A remote exception has not been thrown although a cluster CKCI was used instead of a copy operation CKCI");
        if (curSite != null) {
            myTestUtils.removeSite(curSite);
        }
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject3() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogicObject4() {
        Site curSite = null;
        try {
            String siteName = myProps.getProperty(SITE_1_NAME);
            curSite = myTestUtils.createSite(siteName);
            String clusterName = myProps.getProperty(CLUSTER_1_NAME);
            ClusterImpl curCluster = myTestUtils.createCluster(clusterName, curSite);
            CopyOperationManagerImpl copyMgr = null;
            copyMgr = curCluster.getCopyOperManager();
            try {
                Object retObj = this.getLogicObjectString.invoke((Object)this.myLogicMgr, copyMgr.hashKey());
                LogicMgrTest.assertEquals((String)("The returned object is not the same copy operations manager. The copy operations manager is: " + copyMgr + " and the returned value is: " + retObj), (Object)copyMgr, (Object)retObj);
            }
            catch (InvocationTargetException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            catch (SecurityException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            catch (IllegalAccessException e) {
                LogicMgrTest.fail((String)"Could not invoke the method.");
            }
            catch (RemoteException e) {
                LogicMgrTest.fail((String)"Could not execute the remote method.");
            }
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
        }
        catch (Throwable throwable) {
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogicObject5() {
        Site curSite = null;
        try {
            String siteName = myProps.getProperty(SITE_1_NAME);
            curSite = myTestUtils.createSite(siteName);
            String clusterName = myProps.getProperty(CLUSTER_1_NAME);
            ClusterImpl curCluster = myTestUtils.createCluster(clusterName, curSite);
            ServerFacade facade = myTestUtils.getServerLogic();
            try {
                facade.createGeneralFiberChannelDevice(curCluster.getCopyOperManager().hashKey(), PhysicalStorageTypeConstant.PHYS_STOR_TYPE_CD_ROM_DEVICE, "test", new byte[]{116, 101, 115, 116, 84, 103, 116}, 0, "1").get();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("The wrong type of exception was thrown: " + exp));
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)("The wrong type of exception was thrown: " + exp));
            }
            catch (ExecutionException exp) {
                LogicMgrTest.assertTrue((boolean)true);
                if (curSite != null) {
                    myTestUtils.removeSite(curSite);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (curSite != null) {
                myTestUtils.removeSite(curSite);
            }
            throw throwable;
        }
        LogicMgrTest.fail((String)"A remote exception has not been thrown although a cluster CKCI was used instead of a copy operation CKCI");
        if (curSite != null) {
            myTestUtils.removeSite(curSite);
        }
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject6() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject7() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject8() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject9() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject10() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGetLogicObject11() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testGetLogicObject12() {
        try {
            DRConsistencyGroup[] cgs = DRRootImpl.getInstance().getConsistencyGroups();
            if (cgs.length == 0) {
                LogicMgrTest.fail((String)"Could not find a consistency group needed for the test.");
            }
            Object retObj = this.getLogicObjectString.invoke((Object)this.myLogicMgr, cgs[0].hashKey());
            LogicMgrTest.assertEquals((String)"The returned consistency group should be the same as the original one.", (Object)cgs[0], (Object)retObj);
        }
        catch (RemoteException e) {
            LogicMgrTest.fail((String)"A remote exception occured when querying the CKCI.");
        }
        catch (IllegalArgumentException e) {
            LogicMgrTest.fail((String)"Could not invoke the method required for the test.");
        }
        catch (IllegalAccessException e) {
            LogicMgrTest.fail((String)"Could not invoke the method required for the test.");
        }
        catch (InvocationTargetException e) {
            LogicMgrTest.fail((String)"Could not invoke the method required for the test.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRediscover() {
        ServerFacade curFacade = null;
        IFuture<Void> retFuture = null;
        Site localSite = null;
        ClusterImpl localCluster = null;
        try {
            try {
                String siteName = myProps.getProperty(SITE_1_NAME);
                localSite = myTestUtils.createSite(siteName);
                String clusterName = myProps.getProperty(CLUSTER_1_NAME);
                localCluster = myTestUtils.createCluster(clusterName, localSite);
                String localVsIp = myProps.getProperty(VS_1_IP);
                VSwitchImpl localVs = myTestUtils.createDefaultVswitch(localCluster, localVsIp);
                TestServerEventsListener curListener = new TestServerEventsListener(50);
                curFacade = LogicMgrAOImpl.getInstance().openSession(curListener);
                retFuture = curFacade.rediscover(localCluster.getCommKeyClassId());
            }
            catch (ServerConnectionException exp) {
                LogicMgrTest.fail((String)("The registration could not be completed because of the following exception: " + exp));
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("The registration could not be completed because of the following exception: " + exp));
            }
            LogicMgrTest.assertNotNull((String)"The sync could not be performed, and the returned future is null.", retFuture);
            try {
                retFuture.get();
                LogicMgrTest.assertTrue((String)"The discovery future is done but the cluster is still in discovery ", (boolean)localCluster.isDiscoverCompleted());
            }
            catch (SrExecutionException exp) {
                LogicMgrTest.assertNotNull((String)("The sync could not be performed because of the following error: " + exp), (Object)retFuture);
            }
            catch (RemoteException exp) {
                LogicMgrTest.assertNotNull((String)("The sync could not be performed because of the following error: " + exp), (Object)retFuture);
            }
            catch (InterruptedException exp) {
                LogicMgrTest.assertNotNull((String)("The sync could not be performed because of the following error: " + exp), (Object)retFuture);
            }
            if (localSite != null) {
                myTestUtils.removeSite(localSite);
            }
        }
        catch (Throwable throwable) {
            if (localSite != null) {
                myTestUtils.removeSite(localSite);
            }
            throw throwable;
        }
    }

    public void testTryToRegister1() {
        ServerFacade curFacade = null;
        try {
            TestServerEventsListener curListener = new TestServerEventsListener(50);
            curFacade = LogicMgrAOImpl.getInstance().openSession(curListener);
        }
        catch (ServerConnectionException exp) {
            LogicMgrTest.fail((String)("The registration could not be completed because of the following exception: " + exp));
        }
        LogicMgrTest.assertNotNull((String)"The registration through the server connection manager failed.", (Object)curFacade);
    }

    public void testTryToRegister2() {
    }

    public void testTaskEnqueue1() {
    }

    public void testTaskEnqueue2() {
    }

    public void testDataFlow1Whitebox() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataFlow1Blackbox() {
        Target newTarget = null;
        boolean eventReturned = false;
        try {
            List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
            if (clusters.size() == 0) {
                LogicMgrTest.fail((String)"Could not find a cluster to run the test on.");
            }
            ClusterImpl curCluster = clusters.get(0);
            newTarget = SrTestUtils.getInstance().createNewTarget(curCluster, "testTarget");
            eventReturned = this.myTargetCreatedSem.tryAcquire(60L, TimeUnit.SECONDS);
            if (!eventReturned) {
                LogicMgrTest.fail((String)"The new target created event was not received.");
            }
            if (newTarget != null) {
                SrTestUtils.getInstance().removeTarget(newTarget);
            }
        }
        catch (InterruptedException exp) {
            try {
                LogicMgrTest.fail((String)("The test was interrupted. The associated exception is: " + exp));
                if (newTarget != null) {
                    SrTestUtils.getInstance().removeTarget(newTarget);
                }
            }
            catch (Throwable throwable) {
                if (newTarget != null) {
                    SrTestUtils.getInstance().removeTarget(newTarget);
                }
                throw throwable;
            }
        }
    }

    public void testDataFlow2Blackbox() {
    }

    public void testDataFlow3Blackbox() {
    }

    /*
     * Exception decompiling
     */
    public void testErrorControl1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorControl2() {
        Target newTarget = null;
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() == 0) {
            LogicMgrTest.fail((String)"Could not find a cluster to run the test on.");
        }
        ClusterImpl curCluster = clusters.get(0);
        newTarget = SrTestUtils.getInstance().createNewTarget(curCluster, "testTarget");
        SrFuture<Void> actFuture = LogicMgrAOImpl.getInstance().createSubDirectAccessDevice(newTarget.getCommKeyClassId(), "sub1");
        try {
            actFuture.get();
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The removal execution was interrupted.");
        }
        catch (ExecutionException exp) {
            if (newTarget != null) {
                SrTestUtils.getInstance().removeTarget(newTarget);
            }
            return;
        }
        try {
            LogicMgrTest.fail((String)"The execution exception was not thrown.");
            if (newTarget != null) {
                SrTestUtils.getInstance().removeTarget(newTarget);
            }
        }
        catch (RemoteException exp) {
            try {
                LogicMgrTest.fail((String)("The test could not be completed because of the remote problem: " + exp));
                if (newTarget != null) {
                    SrTestUtils.getInstance().removeTarget(newTarget);
                }
            }
            catch (Throwable throwable) {
                if (newTarget != null) {
                    SrTestUtils.getInstance().removeTarget(newTarget);
                }
                throw throwable;
            }
        }
    }

    public SrFuture<Void> alarmChanged(AlarmEvent aE) {
        return null;
    }

    public SrFuture<Void> alarmClosed(AlarmEvent aE) {
        return null;
    }

    public SrFuture<Void> alarmOpened(AlarmEvent aE) {
        return null;
    }

    public SrFuture<Void> alreadyKnownByVSwitch(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> checkConnectivity() {
        return null;
    }

    public SrFuture<Void> configurationError(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> connectionTimeOut(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> discoverCompleted(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> drDiscoveryCompleted(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> drDiscoveryStarted(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> elementChanged(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> elementCreated(ElementEvent aE) {
        RemoteObject newElement;
        block3: {
            newElement = null;
            try {
                newElement = aE.getElement();
            }
            catch (RemoteException exp) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Could not get the element from the event: " + aE));
            }
        }
        if (newElement instanceof Target) {
            this.setRetEvent(EVENT_TYPE_DATA);
            this.myTargetCreatedSem.release();
        }
        return null;
    }

    public SrFuture<Void> elementRemoved(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> fatalConfigurationError(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> fireElementRemoveFromVSwitch(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> propagatedStateChanged(PropagatedStateEvent aE) {
        return null;
    }

    public SrFuture<Void> serverWasShutdown(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> snmpError(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> startDiscovering(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> startManualDiscovering(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> startReset(ElementEvent aE) {
        return null;
    }

    public SrFuture<Void> systemDiscoveryCompleted(ElementEvent aE) {
        return null;
    }

    @Override
    public String hashKey() {
        return null;
    }

    public void testAlarmHistoryIterator1() {
    }

    public void testAlarmHistoryIterator2() {
    }

    public void testAlarmHistoryIterator3() {
    }

    public void testAlarmHistoryIterator4() {
    }

    public void testAlarmMgr1() {
        try {
            List<Alarm> alarmsVec;
            Collection<List<Alarm>> alarms = AlarmMgrImpl.getInstance().getAllAlarms().values();
            if (alarms.size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            if ((alarmsVec = alarms.iterator().next()).size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            Alarm curAlarm = alarmsVec.get(0);
            Vector<String> alarmsToSilence = new Vector<String>();
            alarmsToSilence.add(curAlarm.hashKey());
            IFuture<Void> actFuture = this.myFacade.silentAlarms(alarmsToSilence);
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The silence operation was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The silence operation throw the following exception: " + exp));
            }
            LogicMgrTest.assertTrue((String)"The alarm has not been silenced.", (boolean)curAlarm.isSilent());
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error has occured while running the test.");
        }
    }

    public void testAlarmMgr2() {
        try {
            List<Alarm> alarmsVec;
            Collection<List<Alarm>> alarms = AlarmMgrImpl.getInstance().getAllAlarms().values();
            if (alarms.size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            if ((alarmsVec = alarms.iterator().next()).size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            Alarm curAlarm = alarmsVec.get(0);
            Vector<Alarm> ackAlarms = new Vector<Alarm>();
            ackAlarms.add(curAlarm);
            if (curAlarm.isAcknowledged()) {
                AlarmMgrImpl.getInstance().unacknowledgeAlarms(ackAlarms);
            }
            IFuture<Void> actFuture = this.myFacade.acknowledgeAlarms(ackAlarms, 1000L, "admin");
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The acknowledge operation was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The acknowledge operation throw the following exception: " + exp));
            }
            LogicMgrTest.assertTrue((String)"The alarm has not been acknowledged.", (boolean)curAlarm.isAcknowledged());
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error has occured while running the test.");
        }
    }

    public void testAlarmMgr3() {
        try {
            Vector alarmsVec;
            Collection<List<Alarm>> alarms = AlarmMgrImpl.getInstance().getAllAlarms().values();
            if (alarms.size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            if ((alarmsVec = (Vector)alarms.iterator().next()).size() == 0) {
                LogicMgrTest.fail((String)"The test could not be run because there were no alarms found.");
            }
            Alarm curAlarm = (Alarm)alarmsVec.get(0);
            Vector<String> ackAlarms = new Vector<String>();
            ackAlarms.add(curAlarm.hashKey());
            Vector<Alarm> unackVec = new Vector<Alarm>();
            unackVec.add(curAlarm);
            if (curAlarm.isAcknowledged()) {
                AlarmMgrImpl.getInstance().unacknowledgeAlarms(unackVec);
            }
            IFuture<Void> actFuture = this.myFacade.acknowledgeAlarms(ackAlarms, 1000L, "admin");
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The acknowledge operation was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The acknowledge operation throw the following exception: " + exp));
            }
            actFuture = this.myFacade.unacknowledgeAlarms(ackAlarms);
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The unacknowledge operation was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The unacknowledge operation throw the following exception: " + exp));
            }
            LogicMgrTest.assertFalse((String)"The alarm has not been unacknowledged.", (boolean)curAlarm.isAcknowledged());
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error has occured while running the test.");
        }
    }

    public void testAlarmMgr4() {
        try {
            List<AlarmType> allTypes = AlarmMgrImpl.getInstance().getAllAlarmTypes();
            IFuture<Void> actFuture = this.myFacade.setEmailEnabledAlarmTypes(new Vector<AlarmType>(allTypes), new Vector());
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The operation of enabling all the types was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The operation of enabling all the types failed because of the following exception: " + exp));
            }
            List currentTypes = AlarmMgrImpl.getInstance().getEmailEnabledAlarmTypes();
            LogicMgrTest.assertEquals((String)"The alarm types were not set correctly.", allTypes, (Object)currentTypes);
            actFuture = this.myFacade.setEmailEnabledAlarmTypes(new Vector(), new Vector<AlarmType>(allTypes));
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The operation of disabling all the types was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The operation of disabling all the types failed because of the following exception: " + exp));
            }
            currentTypes = AlarmMgrImpl.getInstance().getEmailEnabledAlarmTypes();
            LogicMgrTest.assertEquals((String)"The alarm types were not set correctly.", new ArrayList(), (Object)currentTypes);
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error has occured while running the test.");
        }
    }

    public void testAlarmMgr5() {
        try {
            HashMap params = AlarmMgrImpl.getInstance().getEmailContactParameters();
            params.put(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, "Test");
            IFuture<Void> actFuture = this.myFacade.setEmailContactParameters(params);
            try {
                actFuture.get();
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The operation of changing the parameters was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The operation of changing the parameters failed because of the following exception: " + exp));
            }
            HashMap newParams = AlarmMgrImpl.getInstance().getEmailContactParameters();
            LogicMgrTest.assertEquals((String)"The alarm parameters were not set correctly.", (Object)params, (Object)newParams);
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error has occured while running the test.");
        }
    }

    /*
     * Exception decompiling
     */
    public void testCopyOperMgr1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testCopyOperMgr2() {
        List<ClusterImpl> clusters = myTestUtils.getClusters();
        if (clusters.size() == 0) {
            LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
        }
        ClusterImpl curCluster = clusters.get(0);
        try {
            IFuture<Void> actFuture = this.myFacade.refreshCopyTable(curCluster.getCopyOperManager().hashKey());
            actFuture.get();
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"A remote error occured while the test was running.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The test was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The refresh action failed because of the following exception: " + exp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyOperMgr3() {
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        block19: {
            sub1 = null;
            sub2 = null;
            VolumeNode snap = null;
            ClusterImpl curCluster = null;
            try {
                List<DirectAccessDeviceImpl> disks;
                List<ClusterImpl> clusters = myTestUtils.getClusters();
                if (clusters.size() == 0) {
                    LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
                }
                if ((disks = myTestUtils.getUnusedDisks(curCluster = clusters.get(0), 1)) == null) {
                    LogicMgrTest.fail((String)"Could not find the disk needed for the test.");
                }
                if ((snap = myTestUtils.createSnapshot(curCluster, sub1 = myTestUtils.createSubDisk(disks.get(0), "sub1", new BigInteger("1000000")), sub2 = myTestUtils.createSubDisk(disks.get(0), "sub2", new BigInteger("1000000")), "snap1")) == null) {
                    LogicMgrTest.fail((String)"Could not create the snapshot needed for the test.");
                } else {
                    myTestUtils.activateSnapshot(curCluster, snap);
                }
                try {
                    IFuture<Void> actFuture = this.myFacade.restoreSnapshots(curCluster.getCopyOperManager().hashKey(), new CommKeyClassId[]{snap.getCommKeyClassId()});
                    actFuture.get();
                }
                catch (RemoteException exp) {
                    LogicMgrTest.fail((String)"A remote error occured while the test was running.");
                }
                catch (InterruptedException exp) {
                    LogicMgrTest.fail((String)"The test was interrupted.");
                }
                catch (ExecutionException exp) {
                    LogicMgrTest.fail((String)("The refresh action failed because of the following exception: " + exp));
                }
                if (snap == null) break block19;
                myTestUtils.deactivateSnapshot(curCluster, snap);
                myTestUtils.removeSnapshot(curCluster, snap);
            }
            catch (Throwable throwable) {
                if (snap != null) {
                    myTestUtils.deactivateSnapshot(curCluster, snap);
                    myTestUtils.removeSnapshot(curCluster, snap);
                }
                try {
                    if (sub1 != null) {
                        myTestUtils.removeSubDisk(sub1);
                    }
                    if (sub2 != null) {
                        myTestUtils.removeSubDisk(sub2);
                    }
                }
                catch (RemoteException exp) {
                    LogicMgrTest.fail((String)"Could not clean the sub disks.");
                }
                throw throwable;
            }
        }
        try {
            if (sub1 != null) {
                myTestUtils.removeSubDisk(sub1);
            }
            if (sub2 != null) {
                myTestUtils.removeSubDisk(sub2);
            }
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"Could not clean the sub disks.");
        }
    }

    /*
     * Exception decompiling
     */
    public void testDrRoot1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testDrRoot2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testEventService1() {
    }

    public void testEventService2() {
    }

    /*
     * Exception decompiling
     */
    public void testFileInterface1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGeneralLogicObject1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGeneralLogicObject2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testDrLogicObject1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testGeneralSCSIDevice1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCluster1() {
        Site site1 = null;
        Site site2 = null;
        ClusterImpl cluster1 = null;
        try {
            site1 = myTestUtils.createSite("site1");
            site2 = myTestUtils.createSite("site2");
            if (site1 == null || site2 == null) {
                LogicMgrTest.fail((String)"Could not create the sites needed for the test.");
            }
            cluster1 = myTestUtils.createCluster("testCluster", site1);
            try {
                this.myFacade.moveToSite(cluster1.getCommKeyClassId(), site2.getCommKeyClassId()).get();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)"Could not move the cluster because of a remote error.");
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"Could not move the cluster because the action was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("Could not move the cluster because of the following exception: " + exp));
            }
            try {
                LogicMgrTest.assertEquals((String)"The cluster has not been moved.", (Object)site2, (Object)cluster1.getParentSite());
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)"Could not get the site in which the cluster is located.");
            }
            if (cluster1 != null) {
                myTestUtils.removeCluster(cluster1);
            }
            if (site1 != null) {
                myTestUtils.removeSite(site1);
            }
            if (site2 != null) {
                myTestUtils.removeSite(site2);
            }
        }
        catch (Throwable throwable) {
            if (cluster1 != null) {
                myTestUtils.removeCluster(cluster1);
            }
            if (site1 != null) {
                myTestUtils.removeSite(site1);
            }
            if (site2 != null) {
                myTestUtils.removeSite(site2);
            }
            throw throwable;
        }
    }

    public void testCluster2() {
        try {
            this.myFacade.clusterSync().get();
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"The cluster sync failed because of a remote error.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The cluster sync was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The cluster sync failed because of the following error: " + exp));
        }
    }

    /*
     * Exception decompiling
     */
    public void testStorage1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testStorage2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testStorage3() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testStorage4() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStorage5() {
        Object trans1 = null;
        ClusterImpl curCluster = null;
        VolumeNode disk = null;
        try {
            List<DirectAccessDeviceImpl> disks;
            List<ClusterImpl> clusters = myTestUtils.getClusters();
            if (clusters.size() == 0) {
                LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
            }
            if ((disks = myTestUtils.getUnusedDisks(curCluster = clusters.get(0), 1)) == null) {
                LogicMgrTest.fail((String)"Could not find the disk needed for the test.");
            }
            disk = disks.get(0);
            this.myFacade.createTransparentVolume(curCluster.getStorage().hashKey(), "trans1", disk.getCommKeyClassId()).get();
            LogicMgrTest.assertNotNull((String)"The transparent was not created.", (Object)disk.getParentVolume());
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"The test failed because of a remote error.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The test was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The test failed because of the following error; " + exp));
        }
        finally {
            try {
                if (disk.getParentVolume() != null) {
                    myTestUtils.removeVolume(disk.getCluster(), disk.getParentVolume());
                }
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)"Could not clean the transparent.");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void testStorage6() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStorage7() {
        DirectAccessDevice simpleDisk = null;
        Target newTarget = null;
        ClusterImpl curCluster = null;
        try {
            List<DirectAccessDeviceImpl> disks;
            List<ClusterImpl> clusters = myTestUtils.getClusters();
            if (clusters.size() == 0) {
                LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
            }
            if ((disks = myTestUtils.getUnusedDisks(curCluster = clusters.get(0), 1)) == null) {
                LogicMgrTest.fail((String)"Could not find an unused disk.");
            }
            simpleDisk = disks.get(0);
            try {
                newTarget = myTestUtils.createNewTarget(curCluster, "test");
                if (newTarget == null) {
                    LogicMgrTest.fail((String)"A target could not be created");
                }
                this.myFacade.exposeVolume(curCluster.getStorage().hashKey(), 0, simpleDisk.getCommKeyClassId(), newTarget.getCommKeyClassId()).get();
                LogicMgrTest.assertTrue((String)"The disk was not exposed.", (boolean)simpleDisk.isExposed());
            }
            catch (RemoteException e) {
                LogicMgrTest.fail((String)"Could not expose the disk.");
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)"The expose operation was interrupted.");
            }
            catch (ExecutionException exp) {
                LogicMgrTest.fail((String)("The expose operation failed because of the following error: " + exp));
            }
        }
        catch (Throwable throwable) {
            try {
                if (newTarget != null) {
                    myTestUtils.removeTarget(newTarget);
                }
                SubDirectAccessDeviceImpl sub1 = null;
                sub1 = myTestUtils.createSubDisk(simpleDisk, "sub1", new BigInteger("1000000000"));
                if (sub1 != null) {
                    myTestUtils.removeSubDisk(sub1);
                }
            }
            catch (RemoteException e1) {
                LogicMgrTest.fail((String)"Could not create\remove the sub disk.");
            }
            throw throwable;
        }
        try {
            if (newTarget != null) {
                myTestUtils.removeTarget(newTarget);
            }
            SubDirectAccessDeviceImpl sub1 = null;
            sub1 = myTestUtils.createSubDisk(simpleDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 != null) {
                myTestUtils.removeSubDisk(sub1);
            }
        }
        catch (RemoteException e1) {
            LogicMgrTest.fail((String)"Could not create\remove the sub disk.");
        }
    }

    /*
     * Exception decompiling
     */
    public void testStorage8() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testVolumeTree1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testVolumeTree2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUser1() {
        RemoteObject newUser = null;
        try {
            String key = UserManagerImpl.getInstance().getCodecKey();
            String encPassword = StringCodec.encryptString(key, "testuser");
            this.myFacade.addUser("testuser", encPassword).get();
            newUser = myTestUtils.getUser("testuser");
            LogicMgrTest.assertNotNull((String)"The user was not added.", (Object)newUser);
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"The test failed because of a remote error.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The test was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The test failed because of the following error: " + exp));
        }
        finally {
            block21: {
                if (newUser != null) {
                    try {
                        myTestUtils.removeUser(newUser.hashKey());
                    }
                    catch (RemoteException exp) {
                        if ($assertionsDisabled) break block21;
                        throw new AssertionError((Object)"Could not clean up the user.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUser2() {
        RemoteObject newUser = null;
        try {
            String key = UserManagerImpl.getInstance().getCodecKey();
            String encPassword = StringCodec.encryptString(key, "testuser");
            newUser = myTestUtils.addUser("testuser", encPassword);
            LogicMgrTest.assertNotNull((String)"The user required for the test could not be created.", (Object)newUser);
            this.myFacade.removeUser(newUser.hashKey()).get();
            newUser = myTestUtils.getUser("TestUser");
            LogicMgrTest.assertNull((String)"The user was not removed.", (Object)newUser);
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"The test failed because of a remote error.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The test was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The test failed because of the following error: " + exp));
        }
        finally {
            block21: {
                if (newUser != null) {
                    try {
                        myTestUtils.removeUser(newUser.hashKey());
                    }
                    catch (RemoteException exp) {
                        if ($assertionsDisabled) break block21;
                        throw new AssertionError((Object)"Could not clean up the user.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUser3() {
        User firstUser = null;
        User secondUser = null;
        try {
            firstUser = myTestUtils.addUser("TestUser1", "testuser");
            secondUser = myTestUtils.addUser("TestUser2", "testuser");
            LogicMgrTest.assertNotNull((String)"The user required for the test could not be created.", (Object)firstUser);
            LogicMgrTest.assertNotNull((String)"The user required for the test could not be created.", (Object)secondUser);
            Vector<String> usersToRemove = new Vector<String>();
            usersToRemove.add(firstUser.hashKey());
            usersToRemove.add(secondUser.hashKey());
            this.myFacade.removeUsers(usersToRemove).get();
            firstUser = myTestUtils.getUser("TestUser1");
            LogicMgrTest.assertNull((String)"The user was not removed.", (Object)firstUser);
            secondUser = myTestUtils.getUser("TestUser2");
            LogicMgrTest.assertNull((String)"The user was not removed.", (Object)secondUser);
        }
        catch (RemoteException exp) {
            LogicMgrTest.fail((String)"The test failed because of a remote error.");
        }
        catch (InterruptedException exp) {
            LogicMgrTest.fail((String)"The test was interrupted.");
        }
        catch (ExecutionException exp) {
            LogicMgrTest.fail((String)("The test failed because of the following error: " + exp));
        }
        finally {
            block22: {
                try {
                    if (firstUser != null) {
                        myTestUtils.removeUser(firstUser.hashKey());
                    }
                    if (secondUser != null) {
                        myTestUtils.removeUser(secondUser.hashKey());
                    }
                }
                catch (RemoteException exp) {
                    if ($assertionsDisabled) break block22;
                    throw new AssertionError((Object)"Could not clean up the users.");
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void testConsistency1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testConsistency2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVsGroupLength() {
        Site firstSite = null;
        Site secondSite = null;
        ClusterImpl newCluster = null;
        try {
            StringBuffer invalidAlias = new StringBuffer("a");
            for (int index = 0; index < ALIAS_MAX_LENGTH; ++index) {
                invalidAlias.append("a");
            }
            boolean expThrown = false;
            try {
                firstSite = myTestUtils.createSite(invalidAlias.toString());
            }
            catch (AssertionError exp) {
                expThrown = true;
            }
            LogicMgrTest.assertTrue((String)"An exception should have been thrown because of the invalid alias.", (boolean)expThrown);
            expThrown = false;
            try {
                secondSite = myTestUtils.createSite("newTestSite");
                LogicMgrTest.assertNotNull((String)"Could not create the site needed for the test", (Object)secondSite);
                newCluster = myTestUtils.createCluster(invalidAlias.toString(), secondSite);
            }
            catch (AssertionError exp) {
                expThrown = true;
            }
            LogicMgrTest.assertTrue((String)"An exception should have been thrown because of the invalid alias.", (boolean)expThrown);
            if (newCluster != null) {
                myTestUtils.removeCluster(newCluster);
            }
            if (firstSite != null) {
                myTestUtils.removeSite(firstSite);
            }
            if (secondSite != null) {
                myTestUtils.removeSite(secondSite);
            }
        }
        catch (Throwable throwable) {
            if (newCluster != null) {
                myTestUtils.removeCluster(newCluster);
            }
            if (firstSite != null) {
                myTestUtils.removeSite(firstSite);
            }
            if (secondSite != null) {
                myTestUtils.removeSite(secondSite);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCredentialsUserNameLength() {
        Target newTar = null;
        Identity newIden = null;
        CHAPCredentials newCred = null;
        try {
            ClusterImpl curCluster = null;
            if (myTestUtils.getClusters().size() > 0) {
                curCluster = myTestUtils.getClusters().get(0);
            }
            LogicMgrTest.assertNotNull((String)"Could not find a cluster for the test.", curCluster);
            newTar = myTestUtils.createNewTarget(curCluster, "testTarget");
            LogicMgrTest.assertNotNull((String)"Could not create a target needed for the test.", (Object)newTar);
            newIden = myTestUtils.createNewIdentity(curCluster, "testIden", "test");
            StringBuffer invalidAlias = new StringBuffer("a");
            for (int index = 0; index < ALIAS_MAX_LENGTH; ++index) {
                invalidAlias.append("a");
            }
            boolean expThr = false;
            try {
                newCred = myTestUtils.createChapCredential(newIden, invalidAlias.toString(), "testpassword", false);
            }
            catch (AssertionError exp) {
                expThr = true;
            }
            LogicMgrTest.assertTrue((String)"An exception should have been thrown because of the invalid alias.", (boolean)expThr);
            if (newTar != null) {
                myTestUtils.removeTarget(newTar);
            }
            if (newIden != null) {
                myTestUtils.removeIdentity(newIden);
            }
            if (newCred != null) {
                myTestUtils.removeChapCredentials(newCred);
            }
        }
        catch (Throwable throwable) {
            if (newTar != null) {
                myTestUtils.removeTarget(newTar);
            }
            if (newIden != null) {
                myTestUtils.removeIdentity(newIden);
            }
            if (newCred != null) {
                myTestUtils.removeChapCredentials(newCred);
            }
            throw throwable;
        }
    }

    public void testGetOrAddVSwitch1() {
        List<ClusterImpl> allClusters = myTestUtils.getClusters();
        if (allClusters.isEmpty()) {
            LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
        }
        VSwitchImpl curVS = null;
        for (ClusterImpl curCluster : allClusters) {
            List<VSwitchImpl> allCurVSs = curCluster.getVSwitches();
            if (allCurVSs.isEmpty()) continue;
            curVS = allCurVSs.get(0);
            break;
        }
        LogicMgrTest.assertNotNull((String)"Could not find a VS needed for the test.", curVS);
        VSwitch vsFromSearch = null;
        try {
            vsFromSearch = LogicMgrAOImpl.getInstance().getOrAddVSwitch(curVS.getMgmIPAddr(), curVS.getMgmMask(), curVS.getCluster().getAlias(), curVS.getNumberOfRetries(), curVS.getSnmpPort(), curVS.getTrapPort(), curVS.getReadCommunity(), curVS.getWriteCommunity(), curVS.getTimeout(), curVS.getSnmpVersion()).get();
        }
        catch (SrExecutionException e) {
            LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
        }
        catch (InterruptedException e) {
            LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
        }
        LogicMgrTest.assertEquals((String)"The VS from the search should be the same as the original one.", (Object)curVS, vsFromSearch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetOrAddVSwitch2() {
        String newIP = "1.1.1.1";
        String newCluster = "testCluster";
        VSwitch vsFromSearch = null;
        try {
            List<ClusterImpl> allClusters = myTestUtils.getClusters();
            if (allClusters.isEmpty()) {
                LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
            }
            VSwitchImpl curVS = null;
            for (ClusterImpl curCluster : allClusters) {
                List<VSwitchImpl> allCurVSs = curCluster.getVSwitches();
                if (allCurVSs.isEmpty()) continue;
                curVS = allCurVSs.get(0);
                break;
            }
            LogicMgrTest.assertNotNull((String)"Could not find a VS needed for the test.", curVS);
            try {
                vsFromSearch = LogicMgrAOImpl.getInstance().getOrAddVSwitch(newIP, curVS.getMgmMask(), newCluster, curVS.getNumberOfRetries(), curVS.getSnmpPort(), curVS.getTrapPort(), curVS.getReadCommunity(), curVS.getWriteCommunity(), curVS.getTimeout(), curVS.getSnmpVersion()).get();
                LogicMgrTest.assertEquals((String)"The IP of the VS from the search should be the same as the original one.", (String)newIP, (String)vsFromSearch.getMgmIPAddr());
            }
            catch (SrExecutionException e) {
                LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
            }
            catch (InterruptedException e) {
                LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
            }
            catch (RemoteException e) {
                LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
            }
        }
        finally {
            try {
                for (ClusterImpl curCluster : SrTestUtils.getInstance().getClusters()) {
                    if (!curCluster.getAlias().equals(newCluster)) continue;
                    SrTestUtils.getInstance().getServerLogic().deleteElement(curCluster.getCommKeyClassId());
                }
            }
            catch (RemoteException e) {
                System.out.println("Exception during cleanup: ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSnapshotByAlias1() {
        String newIP = "1.1.1.2";
        String newCluster = "testCluster2";
        LogicObjectImpl vsFromSearch = null;
        try {
            List<ClusterImpl> allClusters = myTestUtils.getClusters();
            if (allClusters.isEmpty()) {
                LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
            }
            VSwitchImpl curVS = null;
            for (ClusterImpl curCluster : allClusters) {
                List<VSwitchImpl> allCurVSs = curCluster.getVSwitches();
                if (allCurVSs.isEmpty()) continue;
                curVS = allCurVSs.get(0);
                break;
            }
            LogicMgrTest.assertNotNull((String)"Could not find a VS needed for the test.", curVS);
            try {
                vsFromSearch = (VSwitchImpl)LogicMgrAOImpl.getInstance().getOrAddVSwitch(newIP, curVS.getMgmMask(), newCluster, curVS.getNumberOfRetries(), curVS.getSnmpPort(), curVS.getTrapPort(), curVS.getReadCommunity(), curVS.getWriteCommunity(), curVS.getTimeout(), curVS.getSnmpVersion()).get();
                LogicMgrTest.assertNotNull((String)"The VS which should be created by the test could not be created.", (Object)vsFromSearch);
            }
            catch (SrExecutionException e) {
                LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
            }
            catch (InterruptedException e) {
                LogicMgrTest.fail((String)("The test failed because of the following exception: " + e));
            }
            LogicMgrTest.assertNull((String)"The snapshot should not exist.", (Object)LogicMgrAOImpl.getInstance().getSnapshotByAlias(vsFromSearch.getCluster(), "testSnap"));
        }
        finally {
            try {
                for (ClusterImpl curCluster : SrTestUtils.getInstance().getClusters()) {
                    if (!curCluster.getAlias().equals(newCluster)) continue;
                    SrTestUtils.getInstance().getServerLogic().deleteElement(curCluster.getCommKeyClassId());
                }
            }
            catch (RemoteException e) {
                System.out.println("Exception during cleanup: ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSnapshotByAlias2() {
        VSwitchImpl selectedVS = null;
        DirectAccessDeviceImpl freeDisk = null;
        LogicObjectImpl sourceSub = null;
        LogicObjectImpl targetSub = null;
        GeneralLogicObject newSnapshot = null;
        String snapshotName = "testSnap";
        try {
            List<ClusterImpl> allClusters = myTestUtils.getClusters();
            if (allClusters.isEmpty()) {
                LogicMgrTest.fail((String)"Could not find a cluster needed for the test.");
            }
            for (ClusterImpl curCluster : allClusters) {
                List<DirectAccessDeviceImpl> allFreeDisks = myTestUtils.getUnusedDisks(curCluster, 1);
                if (allFreeDisks == null) continue;
                freeDisk = allFreeDisks.get(0);
                selectedVS = curCluster.getActiveVswitch();
                break;
            }
            LogicMgrTest.assertNotNull((String)"Could not find a VS needed for the test.", selectedVS);
            sourceSub = myTestUtils.createSubDisk(freeDisk, "sourceSub", new BigInteger("100000000"));
            targetSub = myTestUtils.createSubDisk(freeDisk, "targetSub", new BigInteger("100000000"));
            LogicMgrTest.assertNotNull((String)"The creation of the source subdisk needed for this test failed.", (Object)sourceSub);
            LogicMgrTest.assertNotNull((String)"The creation of the target subdisk needed for this test failed.", (Object)targetSub);
            newSnapshot = myTestUtils.createSnapshot(selectedVS.getCluster(), (VolumeNode)((Object)sourceSub), (VolumeNode)((Object)targetSub), snapshotName);
            LogicMgrTest.assertNotNull((String)"The snapshot needed for the test could not be created.", (Object)newSnapshot);
            LogicMgrTest.assertNotNull((String)"The snapshot should exist.", (Object)LogicMgrAOImpl.getInstance().getSnapshotByAlias(sourceSub.getCluster(), snapshotName));
        }
        finally {
            if (newSnapshot != null) {
                try {
                    myTestUtils.removeSnapshot(newSnapshot.getCluster(), (VolumeNode)newSnapshot);
                }
                catch (RemoteException e) {
                    System.out.println("The following exception occured during clean-up: " + e);
                }
            }
            if (sourceSub != null) {
                myTestUtils.removeSnapshot(sourceSub.getCluster(), (VolumeNode)((Object)sourceSub));
            }
            if (targetSub != null) {
                myTestUtils.removeSnapshot(targetSub.getCluster(), (VolumeNode)((Object)targetSub));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNeighborInconsistencyAlarm() {
        String firstVsIp = null;
        String secondVsIp = null;
        try {
            List<Alarm> allAlarms;
            String siteName = SrTestUtils.getInstance().getGeneralProperty("TEST_SITE_NAME");
            Site workingSite = SrTestUtils.getInstance().createSite(siteName);
            LogicMgrTest.assertNotNull((String)"Could not create the site needed for the test.", (Object)workingSite);
            String clusterName = SrTestUtils.getInstance().getGeneralProperty("TEST_CLUSTER_NAME");
            ClusterImpl workingCluster = SrTestUtils.getInstance().createCluster(clusterName, workingSite);
            firstVsIp = this.myTestProperties.getProperty(VS_1_IP);
            LogicMgrTest.assertNotNull((String)"The VS_1_IP property could not be read from the properties file.", (Object)firstVsIp);
            secondVsIp = this.myTestProperties.getProperty(VS_2_IP);
            LogicMgrTest.assertNotNull((String)"The VS_2_IP property could not be read from the properties file.", (Object)secondVsIp);
            String defIpMask = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
            int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
            int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
            int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
            String defWriteComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
            String defReadComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
            int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
            SnmpVersion defVersion = SnmpVersion.V2C;
            try {
                LogicMgrAOImpl.getInstance().addClusterVSwitch(workingCluster.getCommKeyClassId(), firstVsIp, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
                LogicMgrAOImpl.getInstance().addClusterVSwitch(workingCluster.getCommKeyClassId(), secondVsIp, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
            }
            catch (InterruptedException exp1) {
                LogicMgrTest.fail((String)("The test failed because of the exception: " + exp1));
            }
            catch (SrExecutionException exp1) {
                LogicMgrTest.fail((String)("The test failed because of the exception: " + exp1));
            }
            SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            try {
                workingCluster.rediscover();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("A remote exception has occured: " + exp));
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)("The test was interrupted: " + exp));
            }
            boolean alarmExists = false;
            try {
                allAlarms = AlarmMgrImpl.getInstance().getAlarms(workingCluster);
                if (allAlarms == null) {
                    LogicMgrTest.fail((String)"An inconsistent neighbor removed alarm should exist for the cluster.");
                }
                for (Alarm curAlarm : allAlarms) {
                    if (!AlarmType.INCONSISTENT_NEIGHBOR_REMOVED.equals(curAlarm.getType())) continue;
                    alarmExists = true;
                    break;
                }
                LogicMgrTest.assertTrue((String)"An inconsistent neighbor removed alarm should exist for the cluster.", (boolean)alarmExists);
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("Could not retrive the alarms because of a remote exception: " + exp));
            }
            if (firstVsIp != null && secondVsIp != null) {
                SrTestUtils.getInstance().cliSetAsNeighbors(firstVsIp, secondVsIp, CLI_USER, CLI_PASSWORD);
            }
            try {
                workingCluster.rediscover();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("A remote exception has occured: " + exp));
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)("The test was interrupted: " + exp));
            }
            alarmExists = false;
            try {
                allAlarms = AlarmMgrImpl.getInstance().getAlarms(workingCluster);
                if (allAlarms != null) {
                    for (Alarm curAlarm : allAlarms) {
                        if (!AlarmType.INCONSISTENT_NEIGHBOR_REMOVED.equals(curAlarm.getType())) continue;
                        alarmExists = true;
                        break;
                    }
                }
                LogicMgrTest.assertFalse((String)"An inconsistent neighbor removed alarm should not exist for the cluster.", (boolean)alarmExists);
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("Could not retrive the alarms because of a remote exception: " + exp));
            }
            SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            SrTestUtils.getInstance().cliRemoveNeighbor(secondVsIp, CLI_USER, CLI_PASSWORD, firstVsIp);
        }
        catch (Throwable throwable) {
            SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            SrTestUtils.getInstance().cliRemoveNeighbor(secondVsIp, CLI_USER, CLI_PASSWORD, firstVsIp);
            throw throwable;
        }
    }

    public void testNeighborInconsistency1() {
        this.createNeighborInconsistency(false, true);
    }

    public void testNeighborInconsistency2() {
        this.createNeighborInconsistency(true, false);
    }

    public void testNeighborInconsistency3() {
        this.createNeighborInconsistency(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNeighborInconsistency(boolean aFirstVS, boolean aSecondVS) {
        String firstVsIp = null;
        String secondVsIp = null;
        try {
            String siteName = SrTestUtils.getInstance().getGeneralProperty("TEST_SITE_NAME");
            Site workingSite = SrTestUtils.getInstance().createSite(siteName);
            LogicMgrTest.assertNotNull((String)"Could not create the site needed for the test.", (Object)workingSite);
            String clusterName = SrTestUtils.getInstance().getGeneralProperty("TEST_CLUSTER_NAME");
            ClusterImpl workingCluster = SrTestUtils.getInstance().createCluster(clusterName, workingSite);
            firstVsIp = this.myTestProperties.getProperty(VS_1_IP);
            LogicMgrTest.assertNotNull((String)"The VS_1_IP property could not be read from the properties file.", (Object)firstVsIp);
            secondVsIp = this.myTestProperties.getProperty(VS_2_IP);
            LogicMgrTest.assertNotNull((String)"The VS_2_IP property could not be read from the properties file.", (Object)secondVsIp);
            String defIpMask = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
            int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
            int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
            int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
            String defWriteComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
            String defReadComm = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
            int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
            SnmpVersion defVersion = SnmpVersion.V2C;
            try {
                LogicMgrAOImpl.getInstance().addClusterVSwitch(workingCluster.getCommKeyClassId(), firstVsIp, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
                LogicMgrAOImpl.getInstance().addClusterVSwitch(workingCluster.getCommKeyClassId(), secondVsIp, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
            }
            catch (InterruptedException exp1) {
                LogicMgrTest.fail((String)("The test failed because of the exception: " + exp1));
            }
            catch (SrExecutionException exp1) {
                LogicMgrTest.fail((String)("The test failed because of the exception: " + exp1));
            }
            if (aFirstVS) {
                SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            }
            if (aSecondVS) {
                SrTestUtils.getInstance().cliRemoveNeighbor(secondVsIp, CLI_USER, CLI_PASSWORD, firstVsIp);
            }
            try {
                workingCluster.rediscover();
            }
            catch (RemoteException exp) {
                LogicMgrTest.fail((String)("A remote exception has occured: " + exp));
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException exp) {
                LogicMgrTest.fail((String)("The test was interrupted: " + exp));
            }
            LogicMgrTest.assertEquals((String)"There should only be one VS in the cluster.", (int)1, (int)workingCluster.getVSwitchesCount());
            LogicMgrTest.assertEquals((String)"The original VS should be retained, not the neighbor VS.", (String)firstVsIp, (String)workingCluster.getVSwitches().get(0).getMgmIPAddr());
            SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            SrTestUtils.getInstance().cliRemoveNeighbor(secondVsIp, CLI_USER, CLI_PASSWORD, firstVsIp);
        }
        catch (Throwable throwable) {
            SrTestUtils.getInstance().cliRemoveNeighbor(firstVsIp, CLI_USER, CLI_PASSWORD, secondVsIp);
            SrTestUtils.getInstance().cliRemoveNeighbor(secondVsIp, CLI_USER, CLI_PASSWORD, firstVsIp);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        theLock = new Semaphore(1);
        EVENT_TYPE_CONTROL = "Control";
        EVENT_TYPE_DATA = "Data";
        theLogger = null;
        CLI_USER = "admin";
        CLI_PASSWORD = "admin";
        ALIAS_MAX_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.ALIAS_MAX_LENGTH));
        CONF_FILE = "config" + File.separator + "log.properties";
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(CONF_FILE);
            Properties logProps = new Properties();
            logProps.load(inFile);
            SrLogger.init(logProps);
            theLogger = SrLogger.getLogger();
        }
        catch (FileNotFoundException e1) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        catch (IOException e) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        finally {
            try {
                if (inFile != null) {
                    inFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Can not close the logger configuration file.");
            }
        }
        myProps = new Properties();
        try {
            myProps.load(new FileInputStream("test//config//LogicMgrTest.properties"));
        }
        catch (FileNotFoundException exp) {
            System.err.println("Could not load the LogicMgrTest.properties because of the following exception: " + exp);
        }
        catch (IOException exp) {
            System.err.println("Could not load the LogicMgrTest.properties because of the following exception: " + exp);
        }
    }
}

