/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.EventType;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteEventImpl;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientStateListener;
import com.sanrad.nms.server.logic.ClientThreadImpl;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.ElementListenerToServerEventsListenerAdapter;
import com.sanrad.nms.server.logic.EventService;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.ServerConnectionException;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.SrEventSender;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class EventServiceImpl
extends RemoteObjectImpl
implements EventService {
    private static EventServiceImpl theInstance = null;
    private Vector<ClientThreadImpl> myServerEventsListeners = new Vector();
    private SrEventListenerManager m_listeners = new SrEventListenerManager();
    private byte serialNumber;
    SrEventListenerManager.Informer<ClientStateListener, ClientStateEvent> remoteClientClosedInformer = new SrEventListenerManager.Informer<ClientStateListener, ClientStateEvent>(){

        @Override
        public void inform(ClientStateListener listener, ClientStateEvent event) {
            listener.remoteClientClosed(event);
        }
    };
    private static SrLogger theLogger = SrLogger.getLogger();

    EventServiceImpl() throws RemoteException {
        this.clearSerialNumber();
    }

    public void addClientStateListener(ClientStateListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeClientStateListener(ClientStateListener listener) {
        this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementListener(ClientThreadImpl aListener) throws ServerConnectionException {
        Vector<ClientThreadImpl> vector = this.myServerEventsListeners;
        synchronized (vector) {
            theLogger.trace(SrLogCategories.LEGACY, "Trying to register client ", aListener.getAddress(), " ...");
            if (this.myServerEventsListeners.contains(aListener)) {
                theLogger.trace(SrLogCategories.LEGACY, "Client ", aListener.getAddress(), " is already registered");
                return;
            }
            for (ClientThreadImpl curListener : this.myServerEventsListeners) {
                String ip = curListener.getIP();
                int port = curListener.getPort();
                if (!ip.equals(aListener.getIP()) || port != aListener.getPort()) continue;
                if (!this.checkConnectivity(curListener)) {
                    try {
                        this.removeElementListener(curListener);
                    }
                    catch (RemoteException exp) {
                        theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not remove the listener " + curListener + " from the listeners list.");
                    }
                    continue;
                }
                throw new ServerConnectionException("Could not connect to the server because there is a client already logged in with the IP:port " + aListener.getAddress());
            }
            if (!this.checkConnectivity(aListener)) {
                theLogger.warn(SrLogCategories.INFORMATIVE, "The listener " + aListener + " tried to connect but the connectivity check failed.");
                return;
            }
            this.myServerEventsListeners.addElement(aListener);
            theLogger.info(SrLogCategories.LEGACY, "Register: Client ", aListener.getAddress(), " registered");
            theLogger.trace(SrLogCategories.LEGACY, "Index of listener: ", this.myServerEventsListeners.indexOf(aListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementListener(ClientThreadImpl listener) throws RemoteException {
        Vector<ClientThreadImpl> vector = this.myServerEventsListeners;
        synchronized (vector) {
            theLogger.trace(SrLogCategories.LEGACY, "Trying to unregister client ", listener.getAddress(), " ...");
            theLogger.trace(SrLogCategories.LEGACY, "Index of listener: ", this.myServerEventsListeners.indexOf(listener));
            if (this.myServerEventsListeners.removeElement(listener)) {
                theLogger.info(SrLogCategories.LEGACY, "Unregister: Client ", listener.getAddress(), " removed");
                ClientStateEvent event = new ClientStateEvent(listener, this.getConnectedRemoteClientIPAddresses().size());
                this.m_listeners.fireEvent(ClientStateListener.class, event, this.remoteClientClosedInformer);
            } else {
                theLogger.info(SrLogCategories.LEGACY, "Unregister: Client ", listener.getAddress(), " not registered");
            }
        }
    }

    boolean checkConnectivity(ClientThreadImpl listener) {
        try {
            listener.checkConnectivity();
            return true;
        }
        catch (ConnectException ce) {
            theLogger.info(SrLogCategories.LEGACY, ce, "Cannot connect to ", listener.getAddress(), ".  Client won't receive events from server.");
            return false;
        }
        catch (RemoteException re) {
            theLogger.warn(SrLogCategories.LEGACY, re, "Cannot connect to ", listener.getAddress(), ".  Client won't receive events from server.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegisterAsListener(ServerEventsListener listener) {
        Vector<ClientThreadImpl> vector = this.myServerEventsListeners;
        synchronized (vector) {
            return this.myServerEventsListeners.contains(listener);
        }
    }

    public synchronized void fireElementCreate(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.ELEMENT_CREATED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.elementCreated(elementEvent);
            }
        });
    }

    public synchronized void fireElementRemove(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.ELEMENT_REMOVED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.elementRemoved(elementEvent);
            }
        });
    }

    public synchronized void fireElementChanged(final ElementEvent elementEvent) throws RemoteException {
        if (!elementEvent.getParameterList().isEmpty()) {
            this.fireEventToListeners(elementEvent, EventType.ELEMENT_CHANGED, new SrEventSender(){

                @Override
                public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                    aListener.elementChanged(elementEvent);
                }
            });
        }
    }

    public synchronized void fireElementChanged(final ElementEvent elementEvent, boolean forceFire) throws RemoteException {
        if (forceFire) {
            this.fireEventToListeners(elementEvent, EventType.ELEMENT_CHANGED, new SrEventSender(){

                @Override
                public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                    aListener.elementChanged(elementEvent);
                }
            });
        } else {
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        }
    }

    public synchronized void fireStartManualDiscovering(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.START_MANUAL_DISCOVERING, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.startManualDiscovering(elementEvent);
            }
        });
    }

    public synchronized void fireStartReset(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.START_RESET, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.startReset(elementEvent);
            }
        });
    }

    public synchronized void fireStartDiscovering(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.START_DISCOVERING, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.startDiscovering(elementEvent);
            }
        });
    }

    public synchronized void fireDiscoverCompleted(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.DISCOVER_COMPLETED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.discoverCompleted(elementEvent);
            }
        });
    }

    public synchronized void fireSnmpError(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.SNMP_ERROR, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.snmpError(elementEvent);
            }
        });
    }

    public void fireServerShutDown(final ElementEvent elementEvent) throws RemoteException {
        ((ElementEventImpl)elementEvent).setType(EventType.SERVER_SHUTDOWN);
        this.fireEventToListeners(elementEvent, EventType.SERVER_SHUTDOWN, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.serverWasShutdown(elementEvent);
            }
        });
    }

    public synchronized void fireConfigurationError(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.CONFIGURATION_ERROR, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.configurationError(elementEvent);
            }
        });
    }

    public synchronized void fireFatalConfigurationError(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.FATAL_CONFIGURATION_ERROR, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.fatalConfigurationError(elementEvent);
            }
        });
    }

    public synchronized void fireLogConfigChange(final ElementEvent elementEvent) throws RemoteException {
        this.fireEventToListeners(elementEvent, EventType.LOG_CONFIG_CHANGED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.elementChanged(elementEvent);
            }
        });
    }

    public synchronized void fireAlarmOpened(final AlarmEvent event) throws RemoteException {
        if (!event.getAlarm().isSilent()) {
            this.fireEventToListeners(event, EventType.ALARM_OPENED, new SrEventSender(){

                @Override
                public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                    aListener.alarmOpened(event);
                }
            });
        }
    }

    public synchronized void fireAlarmClosed(final AlarmEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.ALARM_CLOSED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.alarmClosed(event);
            }
        });
    }

    public synchronized void fireAlarmChanged(final AlarmEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.ALARM_CHANGED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.alarmChanged(event);
            }
        });
    }

    public synchronized void firePropagatedStateChanged(final PropagatedStateEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.PROP_STATE_CHANGED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.propagatedStateChanged(event);
            }
        });
    }

    public synchronized void fireDRDiscoveryStarted(final ElementEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.DR_DISCOVER_STARTED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.drDiscoveryStarted(event);
            }
        });
    }

    public synchronized void fireDRDiscoveryCompleted(final ElementEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.DR_DISCOVER_COMPLETED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.drDiscoveryCompleted(event);
            }
        });
    }

    public synchronized void fireSystemDiscoveryCompleted(final ElementEvent event) throws RemoteException {
        this.fireEventToListeners(event, EventType.SYSTEM_DISCOVER_COMPLETED, new SrEventSender(){

            @Override
            public void sendEvent(ServerEventsListener aListener) throws RemoteException {
                aListener.systemDiscoveryCompleted(event);
            }
        });
    }

    @Override
    public synchronized byte getCurrentSerialNumber() throws RemoteException {
        return this.serialNumber;
    }

    private synchronized void clearSerialNumber() {
        this.serialNumber = (byte)-128;
    }

    private synchronized byte getNextSerialNumberAndIncrementIt() {
        if (this.serialNumber == 122) {
            this.clearSerialNumber();
        }
        byte by = this.serialNumber;
        this.serialNumber = (byte)(by + 1);
        byte sn = by;
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventToListeners(RemoteEvent aEvent, EventType aType, SrEventSender aSender) throws RemoteException {
        Vector<ClientThreadImpl> listenersClone;
        Object cluster;
        if (aEvent == null || aType == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters should not be null. aEvent = ", aEvent, "; aType = ", aType);
            return;
        }
        try {
            Object element = aEvent.getSource();
            if (element == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The event source should not be null.");
                return;
            }
            if (element instanceof LogicObject) {
                boolean bl;
                cluster = ((LogicObject)element).getCluster();
                boolean bl2 = bl = element instanceof Cluster && aType.equals(EventType.ELEMENT_REMOVED);
                if (!(element instanceof VSwitch || element instanceof NeighborImpl || cluster == null || cluster.isDiscoverCompleted() || !aType.isConfigurationEvent() || bl)) {
                    return;
                }
            }
        }
        catch (RemoteException re) {
            theLogger.warn(SrLogCategories.LEGACY, re);
        }
        ((RemoteEventImpl)aEvent).setSerialNumber(this.getNextSerialNumberAndIncrementIt());
        ((RemoteEventImpl)aEvent).setType(aType);
        cluster = this.myServerEventsListeners;
        synchronized (cluster) {
            listenersClone = new Vector<ClientThreadImpl>(this.myServerEventsListeners);
        }
        for (ServerEventsListener serverEventsListener : listenersClone) {
            aSender.sendEvent(serverEventsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getConnectedRemoteClientIPAddresses() {
        Vector<ClientThreadImpl> vector = this.myServerEventsListeners;
        synchronized (vector) {
            Vector<String> clients = new Vector<String>();
            Enumeration<ClientThreadImpl> e = this.myServerEventsListeners.elements();
            while (e.hasMoreElements()) {
                ClientThreadImpl listener = e.nextElement();
                if (!this.checkConnectivity(listener)) continue;
                String ip = listener.getAddress();
                clients.addElement(ip);
            }
            return clients;
        }
    }

    @Override
    @Deprecated
    public synchronized boolean addElementListener(ElementListener aListener) throws RemoteException {
        ServerFacade facade;
        if (aListener == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given listener should not be null.");
            return false;
        }
        ElementListenerToServerEventsListenerAdapter adapter = new ElementListenerToServerEventsListenerAdapter(aListener);
        try {
            facade = LogicMgrAOImpl.getInstance().openSession(adapter);
        }
        catch (ServerConnectionException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not open a session with the server.");
            return false;
        }
        return facade != null;
    }

    @Override
    public synchronized boolean isRegisterAsListener(ElementListener aListener) throws RemoteException {
        if (aListener == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given listener should not be null.");
            return false;
        }
        ElementListenerToServerEventsListenerAdapter adapter = new ElementListenerToServerEventsListenerAdapter(aListener);
        return this.isRegisterAsListener(adapter);
    }

    @Override
    public synchronized void removeElementListener(ElementListener aListener) throws RemoteException {
        if (aListener == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given listener should not be null.");
        }
        ClientThreadImpl remClient = null;
        ElementListenerToServerEventsListenerAdapter adapter = new ElementListenerToServerEventsListenerAdapter(aListener);
        for (ClientThreadImpl curClientThread : this.myServerEventsListeners) {
            if (!curClientThread.isEqualToMyAdapter(adapter)) continue;
            remClient = curClientThread;
            break;
        }
        if (remClient != null) {
            this.removeElementListener(remClient);
        } else {
            theLogger.info(SrLogCategories.INFORMATIVE, "Tried to remove the listener: ", aListener, " which did not exist in the first place. Therefore no action was taken.");
        }
    }
}

