/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class DataWarehouse {
    private static DataWarehouse theInstance = new DataWarehouse();
    private static SrLogger theLogger = SrLogger.getLogger();
    private Map<CommKeyClassId, LogicObjectImpl> myCKCIToLogicObjectImplMap;
    private Map<String, RemoteObject> myHashkeyToRemoteObjectMap;
    private Map<String, AlarmImpl> myHashkeyToAlarmImplMap = new HashMap<String, AlarmImpl>();

    public static DataWarehouse getInstance() {
        return theInstance;
    }

    public DataWarehouse() {
        this.myCKCIToLogicObjectImplMap = new HashMap<CommKeyClassId, LogicObjectImpl>();
        this.myHashkeyToRemoteObjectMap = new HashMap<String, RemoteObject>();
    }

    public void addAlarm(String aHashkey, AlarmImpl aAlarm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlarm(String aHashkey) {
        if (aHashkey == null) {
            throw new IllegalArgumentException("The given parameters should not be null. aHashkey = " + aHashkey);
        }
        Map<String, RemoteObject> map = this.myHashkeyToAlarmImplMap;
        synchronized (map) {
            this.myHashkeyToAlarmImplMap.remove(aHashkey);
        }
        map = this.myHashkeyToRemoteObjectMap;
        synchronized (map) {
            this.myHashkeyToRemoteObjectMap.remove(aHashkey);
        }
    }

    public void removeAlarms(Iterable<Alarm> aAlarms) {
        if (aAlarms == null) {
            throw new IllegalArgumentException("The given alarms should not be null.");
        }
        for (Alarm curAlarm : aAlarms) {
            try {
                this.removeAlarm(curAlarm.hashKey());
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, exp, "A remote exception has occured inside a server context.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmImpl getAlarm(String aHashkey) {
        if (aHashkey == null) {
            throw new IllegalArgumentException("The given paramaters should not be null. aHashkey = " + aHashkey);
        }
        Map<String, AlarmImpl> map = this.myHashkeyToAlarmImplMap;
        synchronized (map) {
            return this.myHashkeyToAlarmImplMap.get(aHashkey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteObject getRemoteObject(String aHashkey) {
        if (aHashkey == null) {
            throw new IllegalArgumentException("The given paramaters should not be null. aHashkey = " + aHashkey);
        }
        Map<String, RemoteObject> map = this.myHashkeyToRemoteObjectMap;
        synchronized (map) {
            return this.myHashkeyToRemoteObjectMap.get(aHashkey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicObjectImpl getLogicObject(CommKeyClassId aCKCI) {
        if (aCKCI == null) {
            throw new IllegalArgumentException("The given paramaters should not be null. aHashkey = " + aCKCI);
        }
        Map<CommKeyClassId, LogicObjectImpl> map = this.myCKCIToLogicObjectImplMap;
        synchronized (map) {
            return this.myCKCIToLogicObjectImplMap.get(aCKCI);
        }
    }
}

