/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.event.DbErrorListener;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SnmpErrorListener;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.alarm.HistoryAlarmData;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.util.List;
import java.util.Properties;

public class DataMgrAdapter {
    private static final DataMgrAdapter theInstance = new DataMgrAdapter();
    private static SrLogger theLogger = SrLogger.getLogger();
    private Boolean myIsLogicUpdateFutureEnabled = ServerPropertiesFetcher.isLogicUpdateFutureEnabled();

    private DataMgrAdapter() {
        System.out.println("The 'logicUpdateFutureEnable' flag is set to " + this.myIsLogicUpdateFutureEnabled);
    }

    public static DataMgrAdapter getInstance() {
        return theInstance;
    }

    public SrFuture<Void> addDbErrorListener(DbErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addDbErrorListener(aListener);
    }

    public SrFuture<Void> addErrorListener(ErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addErrorListener(aListener);
    }

    public SrFuture<Void> addEventListener(DataMgrListener aListener) {
        return DataMgrAOImpl.getInstance().addEventListener(aListener);
    }

    public SrFuture<Void> addSnmpErrorListener(SnmpErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addSnmpErrorListener(aListener);
    }

    public SrFuture<Void> attachIdentityToTargetACL(ConfigElementData aIdentityCed, CommKeyClassId aTargetId) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().attachIdentityToTargetACL(aIdentityCed, aTargetId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.attachIdentityToTargetACL");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> changeElement(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().changeElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.changeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> suspendPolling() {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().suspendAllPolling();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.suspendPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> suspendPolling(PollingGroupType aPollingType) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().suspendPolling(aPollingType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.suspendPolling(" + aPollingType + ")");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> resumePolling(PollingGroupType aPollingType) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().resumePolling(aPollingType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.resumePolling(" + aPollingType + ")");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> resumePolling() {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().resumeAllPolling();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.resumePolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> createElement(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().createElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.createElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> createElement(ConfigElementDataList aCedList) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().createElement(aCedList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.createElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> discover(CommKeyClassId aVswitchId) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().discover(aVswitchId);
        SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.discover");
        this.updateThroughLogic(dmFuture, retFuture);
        return retFuture;
    }

    public SrFuture<Void> executeOperations(ElementOperationList aOperationsList) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().executeOperations(aOperationsList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.executeOperations");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<String> getSnmpManagerIPAddress(CommKey[] aVSwitchCommKeys) {
        SrFuture<String> dmFuture = DataMgrAOImpl.getInstance().getSnmpManagerIPAddress(aVSwitchCommKeys);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<String> retFuture = new SrFuture<String>("DataMgrAdapter.getSnmpManagerIPAddress");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> load() {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().load();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.load");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<ConfigElementDataList> loadCluster(String aCluster) {
        SrFuture<ConfigElementDataList> dmFuture = DataMgrAOImpl.getInstance().loadCluster(aCluster);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<ConfigElementDataList> retFuture = new SrFuture<ConfigElementDataList>("DataMgrAdapter.loadCluster");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public List<HistoryAlarmData> loadFromFile(String aFileName) {
        return DataMgrAOImpl.getInstance().synchLoadHistoryAlarmsFromFile(aFileName);
    }

    public SrFuture<Void> operate(ConfigElementData aCed, VolumeOperationType aOperType) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().executeVolumeOperation(aCed, aOperType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.operate");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> readElement(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().readElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.readElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> readElementFields(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().readElementFields(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.readElementFields");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> refreshTableFields(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().refreshTableFields(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.refreshTableFields");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeDbErrorListener(DbErrorListener aListener) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeDbErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeDbErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeElement(ConfigElementData aCed) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeElement(ConfigElementDataList aCedList) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeElement(aCedList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeErrorListener(ErrorListener aListener) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeEventListener(DataMgrListener aListener) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeEventListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeEventListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeSnmpErrorListener(SnmpErrorListener aListener) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().removeSnmpErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.removeSnmpErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> setToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarm) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().setToFile(aFileName, aAlarm);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.setToFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public void synchSetToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) {
        DataMgrAOImpl.getInstance().syncSetToFile(aFileName, aAlarms);
    }

    public void shutdown() {
        DataMgrAOImpl.getInstance().shutdown();
    }

    public SrFuture<Void> startPollingProcess(CommKeyClassId aVswitchId) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().startPollingProcess(aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.startPollingProcess");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> startPolling(PollingGroupType aPollingType, CommKeyClassId aVswitchId) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().startPolling(aPollingType, aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.startPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> stopPolling(PollingGroupType aPollingType, CommKeyClassId aVswitchId) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().stopPolling(aPollingType, aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.stopPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public String getSnmpManagerIp(CommKeyClassId aVS) throws SrCommException {
        return DataMgrAOImpl.getSnmpManagerIp(aVS);
    }

    public int getManagerTrapPort(CommKeyClassId aVS) {
        return DataMgrAOImpl.getManagerTrapPort(aVS);
    }

    public SrFuture<Void> setPropertiesToFile(String aFileName, Properties aProperties) {
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().setPropertiesToFile(aFileName, aProperties);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.setPropertiesToFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Properties> loadPropertiesFromFile(String aFileName) {
        SrFuture<Properties> dmFuture = DataMgrAOImpl.getInstance().loadPropertiesFromFile(aFileName);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<Properties> retFuture = new SrFuture<Properties>("DataMgrAdapter.loadPropertiesFromFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<List<String>> getAllVSs(String aCluster, String aSite) {
        SrFuture<List<String>> dmFuture = DataMgrAOImpl.getInstance().getAllVSs(aCluster, aSite);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture<List<String>> retFuture = new SrFuture<List<String>>("DataMgrAdapter.getAllVSs");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    private synchronized <T> void updateThroughLogic(final SrFuture<T> aSource, final SrFuture<T> aTarget) {
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                if (!aSource.isDone()) {
                    theLogger.fatal(SrLogCategories.ILLEGAL_STATE, "The future ", aSource, " which was created by the following stacktrace: ", aSource.getStackTraceString(), " has been given to the update future by given future before ", "it has been updated where the target future = ", aTarget, ";  The stack trace is: ", Thread.currentThread().getStackTrace());
                }
                LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(aSource, aTarget);
            }
        };
        DefaultFutureListener.listenTo(toRun, aSource);
    }

    public SrFuture<Void> configureElements(ConfigElementDataList aCedList) {
        SrFuture<Void> retFuture = new SrFuture<Void>("DataMgrAdapter.configureElements");
        SrFuture<Void> dmFuture = DataMgrAOImpl.getInstance().configureElements(aCedList);
        this.updateThroughLogic(dmFuture, retFuture);
        return retFuture;
    }
}

