/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CreationDeletionDependencyMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private final ConsistencyValidator myDefaultValidator = new ConsistencyValidator();
    private ClusterImpl myCluster;
    private HashMap<ClassID, ConsistencyValidator> myConsistencyValidatorMap = new HashMap();
    private final HashSet<LogicObjectImpl> myInconsistentCreatedElements = new HashSet();
    private final HashSet<LogicObjectImpl> myInconsistentDeletedElements = new HashSet();

    public CreationDeletionDependencyMgr(ClusterImpl aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster cannot be null");
        }
        this.myCluster = aCluster;
        this.myConsistencyValidatorMap.put(ClassID.SNAPSHOT_VOLUME, new SnapshotConsistencyValidator());
        this.myConsistencyValidatorMap.put(ClassID.ISCSI_TARGET, new TargetConsistencyValidator());
        this.myConsistencyValidatorMap.put(ClassID.LUN, new LuConsistencyValidator());
    }

    public void clear() {
        this.myInconsistentCreatedElements.clear();
        this.myInconsistentDeletedElements.clear();
    }

    public boolean publishCreatedElementOrPostpone(LogicObjectImpl aElement) throws RemoteException {
        ConsistencyValidator validator = this.getConsistencyValidator(aElement.getClassId());
        if (!validator.isElementCreationOK(aElement)) {
            this.myInconsistentCreatedElements.add(aElement);
            return false;
        }
        ElementEventImpl elementEvent = new ElementEventImpl((Object)aElement, aElement);
        LogicMgrAOImpl.getInstance().__elementCreated(elementEvent);
        for (LogicObjectImpl parentElement : validator.getParentElements(aElement)) {
            boolean isParentInInconsistencyList = this.myInconsistentCreatedElements.contains(parentElement);
            ConsistencyValidator parentValidator = this.getConsistencyValidator(parentElement.getClassId());
            boolean isParentValid = parentValidator.isElementCreationOK(parentElement);
            if (!isParentInInconsistencyList || !isParentValid) continue;
            this.myInconsistentCreatedElements.remove(parentElement);
            this.publishCreatedElementOrPostpone(parentElement);
        }
        return true;
    }

    public boolean publishDeletedElementOrPostpone(LogicObjectImpl aElement) throws RemoteException {
        ConsistencyValidator validator = this.getConsistencyValidator(aElement.getClassId());
        if (!validator.isElementDeletionOK(aElement)) {
            this.myInconsistentDeletedElements.add(aElement);
            return false;
        }
        ElementEventImpl elementEvent = new ElementEventImpl((Object)aElement, aElement);
        LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
        for (LogicObjectImpl childElement : validator.getDependencyElements(aElement)) {
            boolean isChildInInconsistencyList = this.myInconsistentDeletedElements.contains(childElement);
            ConsistencyValidator childValidator = this.getConsistencyValidator(childElement.getClassId());
            boolean isChildValid = childValidator.isElementDeletionOK(childElement);
            if (!isChildInInconsistencyList || !isChildValid) continue;
            this.myInconsistentDeletedElements.remove(childElement);
            this.publishDeletedElementOrPostpone(childElement);
        }
        return true;
    }

    private ConsistencyValidator getConsistencyValidator(ClassID aClassId) {
        ConsistencyValidator validator = this.myConsistencyValidatorMap.get(aClassId);
        return validator != null ? validator : this.myDefaultValidator;
    }

    private class LuConsistencyValidator
    extends ConsistencyValidator {
        private LuConsistencyValidator() {
        }

        @Override
        List<LogicObjectImpl> getDependencyElements(LogicObjectImpl aElement) {
            VolumeNodeImpl vol;
            LUImpl lu = (LUImpl)aElement;
            ArrayList<LogicObjectImpl> childElements = new ArrayList<LogicObjectImpl>();
            TargetImpl target = lu.getParentTarget();
            if (target != null) {
                childElements.add(target);
            }
            if ((vol = lu.getVolumeChild()) != null) {
                childElements.add(vol);
            }
            return childElements;
        }

        @Override
        boolean areAllDependencyElementsExist(LogicObjectImpl aElement) {
            LUImpl lu = (LUImpl)aElement;
            return lu.getParentTarget() != null && lu.getVolumeChild() != null;
        }
    }

    private class TargetConsistencyValidator
    extends ConsistencyValidator {
        private TargetConsistencyValidator() {
        }

        @Override
        List<LogicObjectImpl> getParentElements(LogicObjectImpl aElement) {
            ISCSITargetImpl target = (ISCSITargetImpl)aElement;
            ArrayList<LogicObjectImpl> parentElements = new ArrayList<LogicObjectImpl>();
            parentElements.addAll(target.getLUs());
            return parentElements;
        }
    }

    private class SnapshotConsistencyValidator
    extends ConsistencyValidator {
        private SnapshotConsistencyValidator() {
        }

        @Override
        List<LogicObjectImpl> getDependencyElements(LogicObjectImpl aElement) {
            ArrayList<LogicObjectImpl> dependencyElements = new ArrayList<LogicObjectImpl>();
            SnapshotVolumeImpl snapshot = (SnapshotVolumeImpl)aElement;
            VolumeNodeImpl sourceVol = snapshot.getSourceVolume();
            if (sourceVol != null) {
                dependencyElements.add(sourceVol);
            }
            dependencyElements.addAll(snapshot.getChildren());
            return dependencyElements;
        }

        @Override
        List<LogicObjectImpl> getParentElements(LogicObjectImpl aElement) {
            SnapshotVolumeImpl snapshot = (SnapshotVolumeImpl)aElement;
            ArrayList<LogicObjectImpl> parentElements = new ArrayList<LogicObjectImpl>();
            LUImpl lu = snapshot.getParentLU();
            if (lu != null) {
                parentElements.add(lu);
            }
            return parentElements;
        }

        @Override
        boolean areAllDependencyElementsExist(LogicObjectImpl aElement) {
            SnapshotVolumeImpl snapshot = (SnapshotVolumeImpl)aElement;
            return snapshot.getSourceVolume() != null && !snapshot.getChildren().isEmpty();
        }
    }

    private class ConsistencyValidator {
        private ConsistencyValidator() {
        }

        boolean areAllDependencyElementsExist(LogicObjectImpl aElement) {
            return true;
        }

        List<LogicObjectImpl> getDependencyElements(LogicObjectImpl aElement) {
            return new ArrayList<LogicObjectImpl>();
        }

        List<LogicObjectImpl> getParentElements(LogicObjectImpl aElement) {
            return new ArrayList<LogicObjectImpl>();
        }

        final boolean isElementCreationOK(LogicObjectImpl aElement) {
            for (LogicObjectImpl dependencyElement : this.getDependencyElements(aElement)) {
                ConsistencyValidator validator = CreationDeletionDependencyMgr.this.getConsistencyValidator(dependencyElement.getClassId());
                if (validator.isElementCreationOK(dependencyElement) && !CreationDeletionDependencyMgr.this.myInconsistentCreatedElements.contains(dependencyElement)) continue;
                return false;
            }
            return this.areAllDependencyElementsExist(aElement);
        }

        final boolean isElementDeletionOK(LogicObjectImpl aElement) {
            return this.getParentElements(aElement).isEmpty();
        }
    }
}

