/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientThread_AG;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.ElementListenerToServerEventsListenerAdapter;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrActiveObject;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class ClientThreadImpl
extends ClientThread_AG
implements ServerEventsListener {
    private static int theClientThreadNumber = 0;
    private static final String CREATE_ACTION_STRING = "create";
    private static final String REMOVE_ACTION_STRING = "remove";
    private static final String REMOVE_TREE_ACTION_STRING = "remove tree";
    private static final String CHANGE_ACTION_STRING = "change";
    private static SrLogger theUserLogger = SrLogger.getUserLogger();
    private static SrLogger theLogger = SrLogger.getLogger();
    private ServerEventsListener myListener = null;
    private String myIP;
    private int myPort;

    private static synchronized void incClientThreadCount() {
        ++theClientThreadNumber;
    }

    private static synchronized void decClientThreadCount() {
        --theClientThreadNumber;
    }

    private static synchronized int getClientThreadCount() {
        return theClientThreadNumber;
    }

    public ClientThreadImpl(ServerEventsListener aListener) throws RemoteException {
        this.myListener = aListener;
        if (this.myListener != null) {
            this.myIP = Util.getStubIP(aListener);
            this.myPort = Util.getStubPort(aListener);
        }
        ClientThreadImpl.incClientThreadCount();
    }

    @Override
    protected void __createAclEntry(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aIdentityCommKeyClassId, Permission aPermission, Integer aPosition) throws Exception {
        this.logUserCreate(ClassID.ACL, "Identity", this.getObjString(aIdentityCommKeyClassId), "Permission", aPermission, "Position", aPosition);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createAclEntry(aObject, aIdentityCommKeyClassId, aPermission, aPosition);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createAclEntryFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createAclEntryFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __updateAcl(final SrFuture<Void> aFuture, String aObject, Vector adata) throws Exception {
        this.logUserChange(aObject, "Data", adata);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().updateAcl(aObject, adata);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.updateAclFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __updateAclFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addUser(final SrFuture<Void> aFuture, String aUserName, String aPassword) throws Exception {
        this.logUserAction("Add", "User", "N/A", "UserName", aUserName, "Password", aPassword);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().addUser(aUserName, aPassword);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.addUserFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __removeUser(final SrFuture<Void> aFuture, String aUserToRemove) throws Exception {
        this.logUserAction("Remove", "User", aUserToRemove, new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().removeUser((User)LogicMgrAOImpl.getInstance().getLogicObject(aUserToRemove));
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.removeUserFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __removeUsers(final SrFuture<Void> aFuture, Vector aUsersList) throws Exception {
        this.logUserAction("Remove", "User", "N/A", "UsersList", this.getObjString(aUsersList));
        Vector<User> paramList = new Vector<User>();
        for (Object curObj : aUsersList) {
            RemoteObject curLogicObj = LogicMgrAOImpl.getInstance().getLogicObject((String)curObj);
            if (!(curLogicObj instanceof User)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The alarms list should only contain users, but instead it contains a " + curLogicObj.getClass() + " instance.");
                continue;
            }
            paramList.add((User)curLogicObj);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().removeUsers(paramList);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.removeUserFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getCopyPercentageFinished(SrFuture<Integer> aFutureToUpdate, SrFuture<Integer> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __addUserFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __removeUserFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __isDiscoverCompletedFinished(SrFuture<Boolean> aFutureToUpdate, SrFuture<Boolean> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getSessionStub(final SrFuture<ISCSISession> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<ISCSISession> fromLogicFuture = LogicMgrAOImpl.getInstance().getSessionStub(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getSessionStubFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getSessionStubFinished(SrFuture<ISCSISession> aFutureToUpdate, SrFuture<ISCSISession> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getCopyPercentage(final SrFuture<Integer> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<Integer> fromLogicFuture = LogicMgrAOImpl.getInstance().getCopyPercentage(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getCopyPercentageFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __isDiscoverCompleted(final SrFuture<Boolean> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<Boolean> fromLogicFuture = LogicMgrAOImpl.getInstance().isDiscoverCompleted(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.isDiscoverCompletedFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __silentAlarms(final SrFuture<Void> aFuture, List aAlarms) {
        this.logUserAction("Silent", "Alarm", this.getObjString(aAlarms), new Object[0]);
        ArrayList<Alarm> paramList = new ArrayList<Alarm>();
        for (Object curObj : aAlarms) {
            RemoteObject curLogicObj = LogicMgrAOImpl.getInstance().getLogicObject((String)curObj);
            if (!(curLogicObj instanceof Alarm)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, this.getInvalidLogicObjectInAlarmListString(curLogicObj));
                continue;
            }
            paramList.add((Alarm)curLogicObj);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().silentAlarms(paramList);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.silentAlarmsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    private String getInvalidLogicObjectInAlarmListString(RemoteObject aObj) {
        StringBuilder retVal = new StringBuilder("The alarms list should only contain alarms, but instead it contains ");
        if (aObj == null) {
            retVal.append(" null.");
        } else {
            retVal.append("a ").append(aObj.getClass()).append(" instance.");
        }
        return retVal.toString();
    }

    @Override
    protected Void __silentAlarmsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __acknowledgeAlarms(final SrFuture<Void> aFuture, List aAlarms, long aperiod, String auserName) {
        this.logUserAction("Acknowlegde", "Alarm", "N/A", "Alarms", this.getObjString(aAlarms), "Period", aperiod, "UserName", auserName);
        ArrayList<Alarm> paramList = new ArrayList<Alarm>();
        for (Object curObj : aAlarms) {
            RemoteObject curLogicObj = LogicMgrAOImpl.getInstance().getLogicObject((String)curObj);
            if (!(curLogicObj instanceof Alarm)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, this.getInvalidLogicObjectInAlarmListString(curLogicObj));
            }
            paramList.add((Alarm)curLogicObj);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().acknowledgeAlarms(paramList, aperiod, auserName);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.acknowledgeAlarmsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __acknowledgeAlarmsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __unacknowledgeAlarms(final SrFuture<Void> aFuture, List aAlarms) {
        this.logUserAction("Unacknowlegde", "Alarm", this.getObjString(aAlarms), new Object[0]);
        ArrayList<Alarm> paramList = new ArrayList<Alarm>();
        for (Object curObj : aAlarms) {
            RemoteObject curLogicObj = LogicMgrAOImpl.getInstance().getLogicObject((String)curObj);
            if (!(curLogicObj instanceof Alarm)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The alarms list should only contain alarms, but instead it contains a " + curLogicObj.getClass() + " instance.");
                continue;
            }
            paramList.add((Alarm)curLogicObj);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().unacknowledgeAlarms(paramList);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.unacknowledgeAlarmsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __unacknowledgeAlarmsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setEmailEnabledAlarmTypes(final SrFuture<Void> aFuture, List aEnabledAlarmTypes, List aDisabledAlarmTypes) throws IllegalValueException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setEmailEnabledAlarmTypes(aEnabledAlarmTypes, aDisabledAlarmTypes);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setEmailEnabledAlarmTypesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setEmailEnabledAlarmTypesFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setEmailContactParameters(final SrFuture<Void> aFuture, HashMap aParameters) {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setEmailContactParameters(aParameters);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setEmailContactParametersFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setEmailContactParametersFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortCopyOper(final SrFuture<Void> aFuture, String aSource, CommKeyClassId aCopyOper) throws IllegalArgumentException, RemoteException {
        this.logUserAction("Abort", this.getObjTypeString(aCopyOper), this.getObjString(aCopyOper), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortCopyOper(aSource, (CopyOperation)((Object)LogicMgrAOImpl.getInstance().getLogicObject(aCopyOper)));
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortCopyOperFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __abortCopyOperFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshCopyTable(final SrFuture<Void> aFuture, String aSource) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshCopyTable(aSource);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshCopyTableFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshCopyTableFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restoreSnapshots(final SrFuture<Void> aFuture, String aSource, CommKeyClassId[] aSnapshots) throws RemoteException {
        this.logUserAction("Restore", "Snapshots", this.getObjString(Arrays.asList(aSnapshots)), new Object[0]);
        SnapshotVolume[] objs = new SnapshotVolume[aSnapshots.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (SnapshotVolume)((Object)LogicMgrAOImpl.getInstance().getLogicObject(aSnapshots[index]));
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().restoreSnapshots(aSource, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.restoreSnapshotsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __restoreSnapshotsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCG) throws IllegalValueException {
        this.logUserCreate(ClassID.ASYNC_PAIR, "InitialSyncType", aInitialSyncType, "Primary", this.getObjString(aPrimaryId), "Secondary", this.getObjString(aSecondaryId), "LocalTarget", aLocalTarget, "LocalLun", aLocalLun, "RemoteTarget", aRemoteTarget, "RemoteLun", aRemoteLun, "PrimarySnapshotId", this.getObjString(aPrimarySnapshotId), "SecondarySnapshotId", this.getObjString(aSecondarySnapshotId), "SecondarySnapshotParams", aSecondarySnapshotParams, "PrimaryJournalId", this.getObjString(aPrimaryJournalId), "SecondaryJournalId", this.getObjString(aSecondaryJournalId), "CG", aCG);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, (DRConsistencyGroup)LogicMgrAOImpl.getInstance().getLogicObject(aCG));
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createAsyncPairFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCgAlias, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws IllegalValueException {
        this.logUserCreate(ClassID.ASYNC_PAIR, "InitialSyncType", aInitialSyncType, "Primary", this.getObjString(aPrimaryId), "Secondary", this.getObjString(aSecondaryId), "LocalTarget", aLocalTarget, "LocalLun", aLocalLun, "RemoteTarget", aRemoteTarget, "RemoteLun", aRemoteLun, "PrimarySnapshotId", this.getObjString(aPrimarySnapshotId), "SecondarySnapshotId", this.getObjString(aSecondarySnapshotId), "SecondarySnapshotParams", aSecondarySnapshotParams, "PrimaryJournalId", this.getObjString(aPrimaryJournalId), "SecondaryJournalId", this.getObjString(aSecondaryJournalId), "CgAlias", aCgAlias, "PitPolicy", aPitPolicy, "TransferPolicy", aTransferPolicy, "MergePolicy", aMergePolicy);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aCgAlias, aPitPolicy, aTransferPolicy, aMergePolicy);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createAsyncPairFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createAsyncPairFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws IllegalValueException {
        this.logUserCreate(ClassID.ASYNC_PAIR, "InitialSyncType", aInitialSyncType, "Primary", this.getObjString(aPrimaryId), "Secondary", this.getObjString(aSecondaryId), "LocalTarget", aLocalTarget, "LocalLun", aLocalLun, "RemoteTarget", aRemoteTarget, "RemoteLun", aRemoteLun, "PrimarySnapshotId", this.getObjString(aPrimarySnapshotId), "SecondarySnapshotId", this.getObjString(aSecondarySnapshotId), "SecondarySnapshotParams", aSecondarySnapshotParams, "PrimaryJournalId", this.getObjString(aPrimaryJournalId), "SecondaryJournalId", this.getObjString(aSecondaryJournalId), "PitPolicy", aPitPolicy, "TransferPolicy", aTransferPolicy, "MergePolicy", aMergePolicy);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aPitPolicy, aTransferPolicy, aMergePolicy);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createAsyncPairFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __createSyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun) throws IllegalValueException {
        this.logUserCreate(ClassID.SYNC_PAIR, "InitialSyncType", aInitialSyncType, "Primary", this.getObjString(aPrimaryId), "Secondary", this.getObjString(aSecondaryId), "LocalTarget", aLocalTarget, "LocalLun", aLocalLun, "RemoteTarget", aRemoteTarget, "RemoteLun", aRemoteLun);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSyncPairFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createSyncPairFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __clusterSync(final SrFuture<Void> aFuture) throws IllegalValueException {
        this.logUserAction("Cluster Sync", "N/A", "N/A", new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().clusterSync();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.clusterSyncFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __clusterSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __elementCreated(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.elementCreated(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __elementRemoved(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.elementRemoved(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __elementChanged(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.elementChanged(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __logConfigChange(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.elementChanged(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __startDiscovering(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.startDiscovering(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __discoverCompleted(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.discoverCompleted(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __connectionTimeOut(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.connectionTimeOut(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __configurationError(ElementEvent aEvent) {
        return null;
    }

    @Override
    protected Void __fatalConfigurationError(ElementEvent aEvent) {
        return null;
    }

    @Override
    protected Void __startManualDiscovering(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.startManualDiscovering(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __startReset(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.startReset(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __alreadyKnownByVSwitch(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.alreadyKnownByVSwitch(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __fireElementRemoveFromVSwitch(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.fireElementRemoveFromVSwitch(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __alarmOpened(AlarmEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.alarmOpened(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        try {
            theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent), " (" + aEvent.getAlarm() + ") ");
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
        }
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __alarmClosed(AlarmEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.alarmClosed(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        try {
            theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent), " (" + aEvent.getAlarm() + ") ");
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
        }
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __alarmChanged(AlarmEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.alarmChanged(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        try {
            theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent), " (" + aEvent.getAlarm() + ") ");
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
        }
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __propagatedStateChanged(PropagatedStateEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.propagatedStateChanged(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        try {
            theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent), " (" + aEvent.getState() + ") ");
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
        }
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __snmpError(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.snmpError(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected void __checkConnectivity(final SrFuture<Void> aFuture) {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().checkConnectivity();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.checkConnectivityFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __checkConnectivityFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __serverWasShutdown(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.serverWasShutdown(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __drDiscoveryStarted(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.drDiscoveryStarted(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __drDiscoveryCompleted(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.drDiscoveryCompleted(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected Void __systemDiscoveryCompleted(ElementEvent aEvent) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null");
            theLogger.traceExiting("Exiting because the given parameter is null", "NULL");
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPreSendingString(aEvent));
        try {
            if (this.myListener != null) {
                this.myListener.systemDiscoveryCompleted(aEvent);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.INFORMATIVE, exp, "A remote exception occured while firing an event to the client: ", this.myListener);
            this.terminateClientThread();
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, this.getLogEventPostSendingString(aEvent));
        theLogger.traceExiting("Normal exit", "Null");
        return null;
    }

    @Override
    protected void __isRegisterAsListener(final SrFuture<Boolean> aFuture, ElementListener aListener) {
        final SrFuture<Boolean> fromLogicFuture = LogicMgrAOImpl.getInstance().isRegisterAsListener(aListener);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.isRegisterAsListenerFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __isRegisterAsListenerFinished(SrFuture<Boolean> aFutureToUpdate, SrFuture<Boolean> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __downloadFile(final SrFuture<byte[]> aFuture, String aFileName) throws IllegalArgumentException {
        final SrFuture<byte[]> fromLogicFuture = LogicMgrAOImpl.getInstance().downloadFile(aFileName);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.downloadFileFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __downloadFileFinished(SrFuture<byte[]> aFutureToUpdate, SrFuture<byte[]> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __uploadFile(final SrFuture<Void> aFuture, byte[] aFiledata) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().uploadFile(aFiledata);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.uploadFileFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __uploadFileFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __deleteElement(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserRemove(aObject, new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().deleteElement(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.deleteElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __deleteElement(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserRemove(aObject, new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().deleteElement(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.deleteElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __deleteElementFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, CommKeyClassId aObject, ClientParameterCode aCode, Object aValue) throws IllegalArgumentException, IllegalValueException {
        this.logUserChange(aObject, "Code", aCode, "Value", aValue);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().changeElement(aObject, aCode, aValue);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.changeElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, String aObject, ClientParameterCode aCode, Object aValue) throws IllegalArgumentException, IllegalValueException {
        this.logUserChange(aObject, "Code", aCode, "Value", aValue);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().changeElement(aObject, aCode, aValue);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.changeElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, CommKeyClassId aObject, HashMap aParameterList) throws IllegalArgumentException, IllegalValueException {
        this.logUserChange(aObject, "ParameterList", aParameterList);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().changeElement(aObject, aParameterList);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.changeElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, String aObject, HashMap aParameterList) throws IllegalArgumentException, IllegalValueException {
        this.logUserChange(aObject, "ParameterList", aParameterList);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().changeElement(aObject, aParameterList);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.changeElementFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __changeElementFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __checkConsistencyBetweenVSwitches(final SrFuture<HashMap> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<HashMap> fromLogicFuture = LogicMgrAOImpl.getInstance().checkConsistencyBetweenVSwitches(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.checkConsistencyBetweenVSwitchesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __checkConsistencyBetweenVSwitchesFinished(SrFuture<HashMap> aFutureToUpdate, SrFuture<HashMap> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setStateSeverity(final SrFuture<Boolean> aFuture, CommKeyClassId aObject, AlarmSeverity aState) throws IllegalArgumentException {
        final SrFuture<Boolean> fromLogicFuture = LogicMgrAOImpl.getInstance().setStateSeverity(aObject, aState);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setStateSeverityFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setStateSeverityFinished(SrFuture<Boolean> aFutureToUpdate, SrFuture<Boolean> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setAcknowledgeStateSeverity(final SrFuture<Void> aFuture, CommKeyClassId aObject, AlarmSeverity aSeverity) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setAcknowledgeStateSeverity(aObject, aSeverity);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setAcknowledgeStateSeverityFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setAcknowledgeStateSeverityFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshFields(final SrFuture<Void> aFuture, List<Object> aObject, ClientParameterCode[] aCodes) throws Exception {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshFields(aObject, aCodes);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshFieldsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshFieldsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Start replicate", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startReplicate(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Start replicate", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startReplicate(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __startReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Abort", "Replicate", "N/A", new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortReplicate(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Abort", "Replicate", "N/A", new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortReplicate(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __plannedFailover(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Planned failover", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().plannedFailover(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.plannedFailoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __fallback(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Fallback", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().fallback(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.fallbackFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __fallbackFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __disasterOccured(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().disasterOccured(aObject);
        this.logUserAction("Disaster occured", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.disasterOccuredFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __forceReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Force replicate", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().forceReplicate(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.forceReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __forceReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshPiTs(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshPiTs(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshPiTsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshPiTsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __recover(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aVolume) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Recover", this.getObjTypeString(aObject), this.getObjString(aObject), "Volume", this.getObjString(aVolume));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().recover(aObject, aVolume);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.recoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __recoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __recover(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aVolume, CommKeyClassId aSnapshot, CommKeyClassId aJournal) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Recover", this.getObjTypeString(aObject), this.getObjString(aObject), "Volume", aVolume, "Snapshot", aSnapshot, "Journal", aJournal);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().recover(aObject, aVolume, aSnapshot, aJournal);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.recoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __checkNonFunctionalOfVolumes(final SrFuture<Boolean> aFuture, String aObject) throws IllegalArgumentException {
        final SrFuture<Boolean> fromLogicFuture = LogicMgrAOImpl.getInstance().checkNonFunctionalOfVolumes(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.checkNonFunctionalOfVolumesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __checkNonFunctionalOfVolumesFinished(SrFuture<Boolean> aFutureToUpdate, SrFuture<Boolean> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __endInitialSync(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("End", "Initial sync", "N/A", "Pair", this.getObjString(aObject));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().endInitialSync(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.endInitialSyncFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __endInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortInitialSync(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Abort", "Initial sync", "N/A", this.getObjTypeString(aObject), this.getObjString(aObject));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortInitialSync(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortInitialSyncFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __abortInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startInitialSync(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Start initial sync", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startInitialSync(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startInitialSyncFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __startInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshInitialSyncProgress(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshInitialSyncProgress(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshInitialSyncProgressFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshInitialSyncProgressFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __returnSource(final SrFuture<DRSyncPair> aFuture, String aObject) throws IllegalArgumentException {
        final SrFuture<DRSyncPair> fromLogicFuture = LogicMgrAOImpl.getInstance().returnSource(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.returnSourceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __returnSourceFinished(SrFuture<DRSyncPair> aFutureToUpdate, SrFuture<DRSyncPair> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __validAndActivate(final SrFuture<Boolean> aFuture, String aObject, DRActivateConstant aState, boolean aIsSnapshotNeeded) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Boolean> fromLogicFuture = LogicMgrAOImpl.getInstance().validAndActivate(aObject, aState, aIsSnapshotNeeded);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.validAndActivateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __validAndActivateFinished(SrFuture<Boolean> aFutureToUpdate, SrFuture<Boolean> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __validAndActivateClusterFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __checkAliasConsistencyBetweenVSwitches(final SrFuture<String[]> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<String[]> fromLogicFuture = LogicMgrAOImpl.getInstance().checkAliasConsistencyBetweenVSwitches(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.checkAliasConsistencyBetweenVSwitchesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __checkAliasConsistencyBetweenVSwitchesFinished(SrFuture<String[]> aFutureToUpdate, SrFuture<String[]> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __synchronize(final SrFuture<Integer> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Integer> fromLogicFuture = LogicMgrAOImpl.getInstance().synchronize(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.synchronizeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __synchronizeFinished(SrFuture<Integer> aFutureToUpdate, SrFuture<Integer> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIdentityName(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.IDENTITY_NAME, "Name", aName);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createIdentityName(aObject, aName);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createIdentityNameFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createIdentityNameFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSRPCredentials(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aPassword) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.SRP_CREDENTIALS, "Name", aName, "Password", aPassword);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSRPCredentials(aObject, aName, aPassword);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSRPCredentialsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createSRPCredentialsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createCHAPCredentials(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aPassword, boolean aisRadiusEnabled) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.CHAP_CREDENTIALS, "Name", aName, "Password", aPassword, "IsRadiusEnabled", aisRadiusEnabled);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createCHAPCredentials(aObject, aName, aPassword, aisRadiusEnabled);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createCHAPCredentialsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createCHAPCredentialsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __discoverRemoteTargets(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().discoverRemoteTargets(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.discoverRemoteTargetsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __discoverRemoteTargetsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSIRemoteTargetPortal(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIp, int aPort, int aPortalGroupTag) throws IllegalArgumentException {
        this.logUserCreate(ClassID.ISCSI_REMOTE_TARGET_PORTAL, "IP", aIp, "Port", aPort, "PortalGroupTag", aPortalGroupTag);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createISCSIRemoteTargetPortal(aObject, aIp, aPort, aPortalGroupTag);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createISCSIRemoteTargetPortalFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createISCSIRemoteTargetPortalFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setExposed(final SrFuture<Void> aFuture, CommKeyClassId aObject, boolean aExposed) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setExposed(aObject, aExposed);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setExposedFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setExposedFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setFree(final SrFuture<Void> aFuture, CommKeyClassId aObject, boolean aFree) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setFree(aObject, aFree);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setFreeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setFreeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setParent(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aParent, int aStam) throws IllegalArgumentException, RemoteException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setParent(aObject, (VolumeNode)((Object)LogicMgrAOImpl.getInstance().getLogicObject(aParent)), aStam);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setParentFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setParentFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setParentLU(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aParent) throws IllegalArgumentException, RemoteException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setParentLU(aObject, (LUImpl)LogicMgrAOImpl.getInstance().getLogicObject(aParent));
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setParentLUFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setParentLUFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __mirrorSync(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Mirror sync", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().mirrorSync(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.mirrorSyncFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __mirrorSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __offlineCopy(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aDestination) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.OFFLINE_COPY, "Source", this.getObjString(aObject), "Destination", this.getObjString(aDestination));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().offlineCopy(aObject, aDestination);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.offlineCopyFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __offlineCopyFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __replace(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aNewVolume) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Replace", this.getObjTypeString(aObject), this.getObjString(aObject), "NewVolume", aNewVolume);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().replace(aObject, aNewVolume);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.replaceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __replaceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addMirror(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aChild, String aMirrVolAlias, boolean aAutoSync) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Add mirror", this.getObjTypeString(aObject), this.getObjString(aObject), "Child", this.getObjString(aChild), "MirrorVolumeAlias", aMirrVolAlias, "AutoSync", aAutoSync);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().addMirror(aObject, aChild, aMirrVolAlias, aAutoSync);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.addMirrorFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __addMirrorFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __resize(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aChild, String aMirrVolAlias) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Resize", this.getObjTypeString(aObject), this.getObjString(aObject), "Child", this.getObjString(aChild), "MirrorVolumeAlias", aMirrVolAlias);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().resize(aObject, aChild, aMirrVolAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.resizeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __resizeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, BigInteger aSize) throws IllegalArgumentException {
        this.logUserCreate(ClassID.SUB_DIRECT_ACCESS_DEVICE, "Alias", aAlias, "Size", aSize);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSubDirectAccessDevice(aObject, aAlias, aSize);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSubDirectAccessDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createSubDirectAccessDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, BigInteger aStartAddr, BigInteger aSize) throws IllegalArgumentException {
        this.logUserCreate(ClassID.SUB_DIRECT_ACCESS_DEVICE, "Alias", aAlias, "StartAddress", aStartAddr, "Size", aSize);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSubDirectAccessDevice(aObject, aAlias, aStartAddr, aSize);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSubDirectAccessDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws IllegalArgumentException {
        this.logUserCreate(ClassID.SUB_DIRECT_ACCESS_DEVICE, "Alias", aAlias);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSubDirectAccessDevice(aObject, aAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSubDirectAccessDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __expand(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Expand", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().expand(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.expandFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __expandFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __retract(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Retract", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().retract(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.retractFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __retractFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshPercentUtilization(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshPercentUtilization(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshPercentUtilizationFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshPercentUtilizationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __breakMirror(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId[] aChildren) throws IllegalArgumentException {
        this.logUserAction("Break mirror", this.getObjTypeString(aObject), this.getObjString(aObject), "Children", Arrays.asList(aChildren));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().breakMirror(aObject, aChildren);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.breakMirrorFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __breakMirrorFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setActivedState(final SrFuture<Void> aFuture, CommKeyClassId aObject, SnapshotActivateTypeConstants aState) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setActivedState(aObject, aState);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setActivedStateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setActivedStateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restore(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Restore", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().restore(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.restoreFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __restoreFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startPolling(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startPolling(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __startPollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __stopPolling(final SrFuture<Integer> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Integer> fromLogicFuture = LogicMgrAOImpl.getInstance().stopPolling(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.stopPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __stopPollingFinished(SrFuture<Integer> aFutureToUpdate, SrFuture<Integer> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __rediscover(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Rediscover", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().rediscover(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.rediscoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __rediscoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __manualDiscover(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Manual discover", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().manualDiscover(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.manualDiscoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __manualDiscoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __reset(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Reset", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().reset(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.resetFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __resetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __shutdown(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Shutdown", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().shutdown(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.shutdownFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __shutdownFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __wakeOnLAN(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().wakeOnLAN(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.wakeOnLANFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __wakeOnLANFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIPTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIP, String aMask, String aActivity, String aInterfaceName) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createIPTableRow(aObject, aIP, aMask, aActivity, aInterfaceName);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createIPTableRowFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createIPTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIPRouteTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aDestIP, String aDestMask, String aGateway, String aInterfaceName) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.IP_ROUTE, "VSwitch", this.getObjString(aObject), "Dest IP", aDestIP, "Dest Mask", aDestMask, "Gateway", aGateway, "Interface Name", aInterfaceName);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createIPRouteTableRow(aObject, aDestIP, aDestMask, aGateway, aInterfaceName);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createIPRouteTableRowFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createIPRouteTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createPortalTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIP, int aPort) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.PORTAL, "VSwitch", this.getObjString(aObject), "IP", aIP, "Port", aPort);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createPortalTableRow(aObject, aIP, aPort);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createPortalTableRowFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createPortalTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshRemoteDiscoveryPortalsTable(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().refreshRemoteDiscoveryPortalsTable(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.refreshRemoteDiscoveryPortalsTableFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __refreshRemoteDiscoveryPortalsTableFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Add VS to Group", this.getObjTypeString(aObject), this.getObjString(aObject), "IP", aIpAddr, "Mask", aMask, "SnmpPort", aSnmpPort, "TrapPort", aTrapPort, "ReadCommunity", aReadCommunity, "WriteCommunity", aWriteCommunity, "Timeout", aTimeout, "NumOfRetries", aNumOfRetries, "SnmpVersion", aSnmpVer);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().addVSwitch(aObject, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.addVSwitchFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __addVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Add VS to Group", this.getObjTypeString(aObject), this.getObjString(aObject), "IP", aIpAddr, "cluster name", aName, "Mask", aMask, "SnmpPort", aSnmpPort, "TrapPort", aTrapPort, "ReadCommunity", aReadCommunity, "WriteCommunity", aWriteCommunity, "Timeout", aTimeout, "NumOfRetries", aNumOfRetries, "SnmpVersion", aSnmpVer);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().addVSwitch(aObject, aName, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.addVSwitchFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __addVSwitchFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addClusterVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Add VS to cluster", this.getObjTypeString(aObject), this.getObjString(aObject), "IP", aIpAddr, "Mask", aMask, "SnmpPort", aSnmpPort, "TrapPort", aTrapPort, "ReadCommunity", aReadCommunity, "WriteCommunity", aWriteCommunity, "Timeout", aTimeout, "NumberOfRetries", aNumOfRetries, "SnmpVersion", aSnmpVer);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().addClusterVSwitch(aObject, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.addClusterVSwitchFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __addClusterVSwitchFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIdentity(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, String aDescription) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.IDENTITY, "Alias", aAlias, "Description", aDescription);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createIdentity(aObject, aAlias, aDescription);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createIdentityFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createIdentityFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __deleteObjects(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId[] aCkciToDelete) throws IllegalArgumentException, IllegalValueException {
        this.logUserRemove(aCkciToDelete[0], "ObjectsToDelete", this.getObjString(Arrays.asList(aCkciToDelete)));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().deleteObjects(aObject, aCkciToDelete);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.deleteObjectsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __deleteObjectsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createRadiusServer(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aServerIP, String aPort, String aKey) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.RADIUS_SERVER, "ServerIP", aServerIP, "Port", aPort, "Key", aKey);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createRadiusServer(aObject, aServerIP, aPort, aKey);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createRadiusServerFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createRadiusServerFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISNSServer(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aServerIP) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.ISNS_SERVER, "ServerIP", aServerIP);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createISNSServer(aObject, aServerIP);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createISNSServerFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createISNSServerFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __moveToSite(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aSite) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Move", this.getObjTypeString(aObject), this.getObjString(aObject), "DestinationSite", this.getObjString(aSite));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().moveToSite(aObject, aSite);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.moveToSiteFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __moveToSiteFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createRemoteDiscoveryPortal(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddress, Integer aPort) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, "IP", aIpAddress, "Port", aPort);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createRemoteDiscoveryPortal(aObject, aIpAddress, aPort);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createRemoteDiscoveryPortalFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createRemoteDiscoveryPortalFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createCluster(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.CLUSTER, "Alias", aAlias);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createCluster(aObject, aAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createClusterFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createClusterFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSite(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.SITE, "Alias", aAlias);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSite(aObject, aAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSiteFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createSiteFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __plannedFailover(final SrFuture<Void> aFuture, CommKeyClassId aObject, String[] aDrActivateObjects) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Planned failover", this.getObjTypeString(aObject), this.getObjString(aObject), "ActivateObjects", this.getObjString(Arrays.asList(aDrActivateObjects)));
        DRActivate[] objs = new DRActivate[aDrActivateObjects.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (DRActivate)LogicMgrAOImpl.getInstance().getLogicObject(aDrActivateObjects[index]);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().plannedFailover(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.plannedFailoverFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __plannedFailoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __fallback(final SrFuture<Void> aFuture, CommKeyClassId aObject, String[] aDrActivateObjects) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Fallback", this.getObjTypeString(aObject), this.getObjString(aObject), "DRActivateObjects", this.getObjString(Arrays.asList(aDrActivateObjects)));
        DRActivate[] objs = new DRActivate[aDrActivateObjects.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (DRActivate)LogicMgrAOImpl.getInstance().getLogicObject(aDrActivateObjects[index]);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().fallback(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.fallbackFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __disasterOccured(final SrFuture<Void> aFuture, CommKeyClassId aObject, String[] aDrActivateObjects) throws IllegalArgumentException, IllegalValueException {
        DRActivate[] objs = new DRActivate[aDrActivateObjects.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (DRActivate)LogicMgrAOImpl.getInstance().getLogicObject(aDrActivateObjects[index]);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().disasterOccured(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.disasterOccuredFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __disasterOccuredFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject, String[] aDrActivateObjects) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Abort", "Replicate", "N/A", "DrActivateObjects", this.getObjString(Arrays.asList(aDrActivateObjects)));
        DRActivate[] objs = new DRActivate[aDrActivateObjects.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (DRActivate)LogicMgrAOImpl.getInstance().getLogicObject(aDrActivateObjects[index]);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortReplicate(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __abortReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject, String[] aDrActivateObjects) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Start replicate", "DRActivateObjects", this.getObjString(Arrays.asList(aDrActivateObjects)), new Object[0]);
        DRActivate[] objs = new DRActivate[aDrActivateObjects.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (DRActivate)LogicMgrAOImpl.getInstance().getLogicObject(aDrActivateObjects[index]);
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startReplicate(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startReplicateFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __getFileInterface(final SrFuture<FileInterface> aFuture) {
        final SrFuture<FileInterface> fromLogicFuture = LogicMgrAOImpl.getInstance().getFileInterface();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getFileInterfaceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getFileInterfaceFinished(SrFuture<FileInterface> aFutureToUpdate, SrFuture<FileInterface> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __exportConfigurationFile(final SrFuture<Void> aFuture) {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().exportConfigurationFile();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.exportConfigurationFileFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __exportConfigurationFileFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __importConfigurationFile(final SrFuture<Void> aFuture) {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().importConfigurationFile();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.importConfigurationFileFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __importConfigurationFileFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortOperation(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException {
        this.logUserAction("Abort", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().abortOperation(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.abortOperationFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __abortOperationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restartOperation(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Restart", this.getObjTypeString(aObject), this.getObjString(aObject), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().restartOperation(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.restartOperationFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __restartOperationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __validAndActivateCluster(final SrFuture<Void> aFuture, CommKeyClassId aObject, ParameterList aParams) throws IllegalArgumentException, IllegalValueException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().validAndActivateCluster(aObject, aParams);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.validAndActivateClusterFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __setClientLogProperties(final SrFuture<Void> aFuture, Properties aProps) {
        this.logUserAction("Set", "Log properties", "Client log properties", "Properties", aProps);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setClientLogProperties(aProps);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setClientLogPropertiesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setClientLogPropertiesFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setServerLogProperties(final SrFuture<Void> aFuture, Properties aProps) {
        this.logUserAction("Set", "Log Properties", "Server Log Properties", "Properties", aProps);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().setServerLogProperties(aProps);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.setServerLogPropertiesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __setServerLogPropertiesFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getClientLogProps(final SrFuture<Properties> aFuture) {
        final SrFuture<Properties> fromLogicFuture = LogicMgrAOImpl.getInstance().getClientLogProps();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getClientLogPropsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getClientLogPropsFinished(SrFuture<Properties> aFutureToUpdate, SrFuture<Properties> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getServerLogProps(final SrFuture<Properties> aFuture) {
        final SrFuture<Properties> fromLogicFuture = LogicMgrAOImpl.getInstance().getServerLogProps();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getServerLogPropsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getServerLogPropsFinished(SrFuture<Properties> aFutureToUpdate, SrFuture<Properties> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getPhysStorBySimpleVol(final SrFuture<CommKeyClassId> aFuture, char aAgentId, String aSimpleVolId) {
        final SrFuture<CommKeyClassId> fromLogicFuture = LogicMgrAOImpl.getInstance().getPhysStorBySimpleVol(aAgentId, aSimpleVolId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getPhysStorBySimpleVolFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getPhysStorBySimpleVolFinished(SrFuture<CommKeyClassId> aFutureToUpdate, SrFuture<CommKeyClassId> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getSimpleVolByPhysStor(final SrFuture<String> aFuture, char aAgentId, CommKeyClassId aPhysStorData) {
        final SrFuture<String> fromLogicFuture = LogicMgrAOImpl.getInstance().getSimpleVolByPhysStor(aAgentId, aPhysStorData);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getSimpleVolByPhysStorFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getSimpleVolByPhysStorFinished(SrFuture<String> aFutureToUpdate, SrFuture<String> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createConcatinationVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.CONCAT_VOLUME, "Alias", aVolAlias, "Children", this.getObjString(Arrays.asList(achildrenCommKeyClassId)));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createConcatinationVolume(aObject, aVolAlias, achildrenCommKeyClassId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createConcatinationVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createConcatinationVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createMirrorVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.MIRROR_VOLUME, "Alias", aVolAlias, "Children", this.getObjString(Arrays.asList(achildrenCommKeyClassId)));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createMirrorVolume(aObject, aVolAlias, achildrenCommKeyClassId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createMirrorVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createMirrorVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSnapshotVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId aSourceVolume, CommKeyClassId aChildCKCI, int aThreshold) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.SNAPSHOT_VOLUME, "Alias", aVolAlias, "Source", this.getObjString(aSourceVolume), "Child", this.getObjString(aChildCKCI), "Threshold", aThreshold);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSnapshotVolume(aObject, aVolAlias, aSourceVolume, aChildCKCI, aThreshold);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSnapshotVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createSnapshotVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSnapshotVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId aSourceVolume, CommKeyClassId aChildCKCI, int aThreshold, SnapshotActivateTypeConstants aSnapActType) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.SNAPSHOT_VOLUME, "Alias", aVolAlias, "Source", this.getObjString(aSourceVolume), "Child", this.getObjString(aChildCKCI), "Threshold", aThreshold, "Activation type", aSnapActType);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createSnapshotVolume(aObject, aVolAlias, aSourceVolume, aChildCKCI, aThreshold, aSnapActType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createSnapshotVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __createStripeVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId, BigInteger aStripeSize) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.STRIPE_VOLUME, "Alias", aVolAlias, "Children", this.getObjString(Arrays.asList(achildrenCommKeyClassId)), "Stripe size", aStripeSize);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createStripeVolume(aObject, aVolAlias, achildrenCommKeyClassId, aStripeSize);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createStripeVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createStripeVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createTransparentVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId achildCommKeyClassId) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.TRANSPARENT_VOLUME, "Alias", aVolAlias, "Child", this.getObjString(achildCommKeyClassId));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createTransparentVolume(aObject, aVolAlias, achildCommKeyClassId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createTransparentVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createTransparentVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createJournalVolume(final SrFuture<Void> aFuture, String aObject, String aAlias, Integer aThreshold, CommKeyClassId aVolumeNodeChildId, CommKeyClassId aActiveOnVswitchId) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.JOURNAL_VOLUME, "Alias", aAlias, "Threshold", aThreshold, "Child", this.getObjString(aVolumeNodeChildId), "ActiveOnVS", this.getObjString(aActiveOnVswitchId));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createJournalVolume(aObject, aAlias, aThreshold, aVolumeNodeChildId, aActiveOnVswitchId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createJournalVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createJournalVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __exposeVolume(final SrFuture<Void> aFuture, String aObject, int aLuNumber, CommKeyClassId aVolumeCommKeyClassId, CommKeyClassId aTargetCommKeyClassId) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Expose", this.getObjTypeString(aVolumeCommKeyClassId), this.getObjString(aVolumeCommKeyClassId), "Lun", aLuNumber, "Target", this.getObjString(aTargetCommKeyClassId));
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().exposeVolume(aObject, aLuNumber, aVolumeCommKeyClassId, aTargetCommKeyClassId);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.exposeVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __exposeVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __exposeVolume(final SrFuture<Void> aFuture, String aObject, int aLuNumber, CommKeyClassId aVolumeCommKeyClassId, CommKeyClassId aTargetCommKeyClassId, String aSerialNumber) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Expose", this.getObjTypeString(aVolumeCommKeyClassId), this.getObjString(aVolumeCommKeyClassId), "Lun", aLuNumber, "Target", this.getObjString(aTargetCommKeyClassId), "SerialNumber", aSerialNumber);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().exposeVolume(aObject, aLuNumber, aVolumeCommKeyClassId, aTargetCommKeyClassId, aSerialNumber);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.exposeVolumeFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __createISCSITarget(final SrFuture<Void> aFuture, String aObject, String aName, String aAlias, String aVS) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.ISCSI_TARGET, "Name", aName, "Alias", aAlias, "VS", aVS);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createISCSITarget(aObject, aName, aAlias, aVS);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createISCSITargetFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createISCSITargetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSITarget(final SrFuture<Void> aFuture, String aObject, String aName, String aAlias, Permission aDefaultAccess, String aVS) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.ISCSI_TARGET, "Name", aName, "Alias", aAlias, "VS", aVS, "Permission", aDefaultAccess);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createISCSITarget(aObject, aName, aAlias, aDefaultAccess, aVS);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createISCSITargetFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __readSnapshotVolumes(final SrFuture<Void> aFuture, String aObject) throws IllegalArgumentException {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().readSnapshotVolumes(aObject);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.readSnapshotVolumesFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __readSnapshotVolumesFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralISCSIDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, String aTarget, int aLun, String aSerialNumber) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.GENERAL_SCSI_DEVICE, "Type", aType, "Alias", aAlias, "Target", aTarget, "Lun", aLun, "Serial number", aSerialNumber);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createGeneralISCSIDevice(aObject, aType, aAlias, aTarget, aLun, aSerialNumber);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createGeneralISCSIDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createGeneralISCSIDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralParallelSCSIDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, int aPort, int aBus, int aLun, String aSerialNumber) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.GENERAL_SCSI_DEVICE, "Type", aType, "Alias", aAlias, "Port", aPort, "Bus", aBus, "Lun", aLun, "Serial number", aSerialNumber);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createGeneralParallelSCSIDevice(aObject, aType, aAlias, aPort, aBus, aLun, aSerialNumber);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createGeneralParallelSCSIDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createGeneralParallelSCSIDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralFiberChannelDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, byte[] aTargetName, int aLun, String aSerialNumber) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.FC_NODE, "Type", aType, "Alias", aAlias, "TargetName", aTargetName, "Lun", aLun, "Serial number", aSerialNumber);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createGeneralFiberChannelDevice(aObject, aType, aAlias, aTargetName, aLun, aSerialNumber);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createGeneralFiberChannelDeviceFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createGeneralFiberChannelDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSIRemoteTarget(final SrFuture<Void> aFuture, String aObject, String aRemoteTargetName, String aRemoteTargetAlias) throws IllegalArgumentException, IllegalValueException {
        this.logUserCreate(ClassID.ISCSI_REMOTE_TARGET, "Name", aRemoteTargetName, "Alias", aRemoteTargetAlias);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().createISCSIRemoteTarget(aObject, aRemoteTargetName, aRemoteTargetAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.createISCSIRemoteTargetFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __createISCSIRemoteTargetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __discoverRemoteTargets(final SrFuture<Void> aFuture, String aObject, CommKeyClassId[] aRemoteDiscoveryPortals) throws IllegalArgumentException, IllegalValueException, RemoteException {
        ISCSIRemotePortalDiscovery[] objs = new ISCSIRemotePortalDiscovery[aRemoteDiscoveryPortals.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (ISCSIRemotePortalDiscovery)((Object)LogicMgrAOImpl.getInstance().getLogicObject(aRemoteDiscoveryPortals[index]));
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().discoverRemoteTargets(aObject, objs);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.discoverRemoteTargetsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __activateDeactivateSnapshots(final SrFuture<Void> aFuture, String aObject, CommKeyClassId[] aSnapshots, SnapshotActivateTypeConstants aSnapActivateType) throws IllegalArgumentException, IllegalValueException, RemoteException {
        this.logUserAction("Activate/Deactivate", ClassID.SNAPSHOT_VOLUME.toString(), this.getObjString(Arrays.asList(aSnapshots)), "ActivationType", aSnapActivateType);
        SnapshotVolume[] objs = new SnapshotVolume[aSnapshots.length];
        for (int index = 0; index < objs.length; ++index) {
            objs[index] = (SnapshotVolume)((Object)LogicMgrAOImpl.getInstance().getLogicObject(aSnapshots[index]));
        }
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().activateDeactivateSnapshots(aObject, objs, aSnapActivateType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.activateDeactivateSnapshotsFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __activateDeactivateSnapshotsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getVolumeByAlias(final SrFuture<Volume> aFuture, String aObject, String aAlias) throws IllegalArgumentException {
        final SrFuture<Volume> fromLogicFuture = LogicMgrAOImpl.getInstance().getVolumeByAlias(aObject, aAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getVolumeByAliasFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getVolumeByAliasFinished(SrFuture<Volume> aFutureToUpdate, SrFuture<Volume> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __getExposedOrUnexposedVolumeByAlias(final SrFuture<Volume> aFuture, String aObject, String aAlias) throws IllegalArgumentException {
        final SrFuture<Volume> fromLogicFuture = LogicMgrAOImpl.getInstance().getExposedOrUnexposedVolumeByAlias(aObject, aAlias);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.getExposedOrUnexposedVolumeByAliasFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __getExposedOrUnexposedVolumeByAliasFinished(SrFuture<Volume> aFutureToUpdate, SrFuture<Volume> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __changePassword(final SrFuture<Void> aFuture, String aObject, String aOldPassword, String aNewPassword) throws IllegalArgumentException, IllegalValueException {
        this.logUserAction("Change password", this.getObjTypeString(aObject), this.getObjString(aObject), "Old", aOldPassword, "New", aNewPassword);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().changePassword(aObject, aOldPassword, aNewPassword);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.changePasswordFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __changePasswordFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startStatisticsPolling(final SrFuture<Void> aFuture, CommKeyClassId aVs, ClassID aStatType) throws Exception {
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().startStatisticsPolling(aVs, aStatType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.startPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __stopStatisticsPolling(final SrFuture<Integer> aFuture, CommKeyClassId aVs, ClassID aStatType) throws Exception {
        final SrFuture<Integer> fromLogicFuture = LogicMgrAOImpl.getInstance().stopStatisticsPolling(aVs, aStatType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.stopPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    private String getLogEventPreSendingString(RemoteEvent aEvent) {
        return this.getLogEventString(aEvent, "Going to fire");
    }

    private String getLogEventPostSendingString(RemoteEvent aEvent) {
        return this.getLogEventString(aEvent, "After  firing");
    }

    private String getLogEventString(RemoteEvent aEvent, String aTiming) {
        theLogger.traceEntering("", aEvent);
        if (aEvent == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given event should not be null.");
            theLogger.traceExiting("Exiting because the given event is null.", "");
            return "";
        }
        StringBuffer debugMsg = new StringBuffer();
        try {
            Object eventSource = aEvent.getSource();
            if (eventSource != null) {
                debugMsg.append(aTiming).append(" ").append(aEvent.getType());
                debugMsg.append(" (serial# ").append(aEvent.getSerialNumber()).append(") ");
                debugMsg.append("event for ");
                if (eventSource instanceof GeneralLogicObject) {
                    debugMsg.append(((GeneralLogicObject)eventSource).getClassId());
                    debugMsg.append(" ");
                }
            } else {
                theLogger.traceExiting("Exiting because the source of the event could not be found", "");
                return "";
            }
            debugMsg.append(eventSource).append(" to ").append(this.myListener);
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
            theLogger.traceExiting("Exiting because of a remote exception", "");
            return null;
        }
        theLogger.traceExiting("Normal exit", debugMsg);
        return debugMsg.toString();
    }

    private String getObjString(CommKeyClassId aObj) {
        if (aObj == null) {
            return "N/A";
        }
        GeneralLogicObjectImpl logicObj = null;
        logicObj = LogicMgrAOImpl.getInstance().getLogicObject(aObj);
        if (logicObj != null) {
            return logicObj.toString();
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "The given object could not be found.");
        return "";
    }

    private String getObjString(String aHash) {
        RemoteObject logicObj = LogicMgrAOImpl.getInstance().getLogicObject(aHash);
        if (logicObj != null) {
            return logicObj.toString();
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "The given object was not found.");
        return "";
    }

    private String getObjTypeString(String aHash) {
        RemoteObject logicObj = LogicMgrAOImpl.getInstance().getLogicObject(aHash);
        if (logicObj != null) {
            return logicObj.getClass().getName();
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "The given object's type was not found.");
        return "";
    }

    private String getObjTypeString(CommKeyClassId aCKCI) {
        if (aCKCI == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameter should not be null.");
            return "";
        }
        return aCKCI.getClassID().toString();
    }

    private String getObjString(Iterable aIter) {
        if (aIter == null) {
            return "N/A";
        }
        StringBuffer retStr = new StringBuffer();
        for (Object curObj : aIter) {
            RemoteObject logicObj = null;
            logicObj = curObj instanceof String ? LogicMgrAOImpl.getInstance().getLogicObject((String)curObj) : (curObj instanceof CommKeyClassId ? LogicMgrAOImpl.getInstance().getLogicObject((CommKeyClassId)curObj) : curObj);
            if (logicObj == null) continue;
            if (retStr.length() != 0) {
                retStr.append("; ");
            }
            retStr.append(logicObj);
        }
        return retStr.toString();
    }

    private void logUserCreate(ClassID aObjClass, Object ... aParameters) {
        if (aParameters.length % 2 == 1) {
            throw new IllegalArgumentException("The number of given parameters should not be odd since it must contain a parameter name and value.");
        }
        StringBuffer userAction = new StringBuffer("The client " + this.getAddress() + " tried to " + CREATE_ACTION_STRING + " " + aObjClass);
        if (aParameters.length > 0) {
            userAction.append(" with the parameters: ");
        }
        int index = 0;
        while (index < aParameters.length) {
            if (index != 0) {
                userAction.append("; ");
            }
            userAction.append(aParameters[index++]).append(" = ");
            userAction.append(aParameters[index++]);
        }
        theUserLogger.info(SrLogCategories.USER, userAction);
    }

    private void logUserRemove(String aObj, Object ... aParameters) {
        this.logUserRemoveOrChange(REMOVE_ACTION_STRING, aObj, aParameters);
    }

    private void logUserRemoveOrChange(String aAction, CommKeyClassId aObj, Object ... aParameters) {
        if (aParameters.length % 2 == 1) {
            throw new IllegalArgumentException("The number of given parameters should not be odd since it must contain a parameter name and value.");
        }
        StringBuffer userAction = new StringBuffer("The client " + this.getAddress() + " tried to " + aAction + " the " + aObj.getClassID() + " - " + aObj);
        if (aParameters.length > 0) {
            userAction.append(" with the parameters: ");
        }
        int index = 0;
        while (index < aParameters.length) {
            if (index != 0) {
                userAction.append("; ");
            }
            userAction.append(aParameters[index++]).append(" = ");
            userAction.append(aParameters[index++]);
        }
        theUserLogger.info(SrLogCategories.USER, userAction);
    }

    private void logUserRemoveOrChange(String aAction, String aHashKey, Object ... aParameters) {
        if (aParameters.length % 2 == 1) {
            throw new IllegalArgumentException("The number of given parameters should not be odd since it must contain a parameter name and value.");
        }
        RemoteObject reqObj = LogicMgrAOImpl.getInstance().getLogicObject(aHashKey);
        StringBuffer userAction = reqObj == null ? new StringBuffer("The client " + this.getAddress() + " tried to " + aAction + " an unknown object.") : new StringBuffer("The client " + this.getAddress() + " tried to " + aAction + " the " + reqObj.getClass() + " - " + reqObj);
        if (aParameters.length > 0) {
            userAction.append(" with the parameters: ");
        }
        int index = 0;
        while (index < aParameters.length) {
            if (index != 0) {
                userAction.append("; ");
            }
            userAction.append(aParameters[index++]).append(" = ");
            userAction.append(aParameters[index++]);
        }
        theUserLogger.info(SrLogCategories.USER, userAction);
    }

    private void logUserRemove(CommKeyClassId aObj, Object ... aParameters) {
        this.logUserRemoveOrChange(REMOVE_ACTION_STRING, aObj, aParameters);
    }

    private void logUserRemoveTree(CommKeyClassId aObj, Object ... aParameters) {
        this.logUserRemoveOrChange(REMOVE_TREE_ACTION_STRING, aObj, aParameters);
    }

    private void logUserChange(CommKeyClassId aObj, Object ... aParameters) {
        this.logUserRemoveOrChange(CHANGE_ACTION_STRING, aObj, aParameters);
    }

    private void logUserChange(String aObj, Object ... aParameters) {
        this.logUserRemoveOrChange(CHANGE_ACTION_STRING, aObj, aParameters);
    }

    private void logUserAction(String aOperation, String aObjectType, String aObjectString, Object ... aParameters) {
        if (aParameters.length % 2 == 1) {
            throw new IllegalArgumentException("The number of given parameters should not be odd since it must contain a parameter name and value.");
        }
        StringBuffer userAction = new StringBuffer("The client " + this.getAddress() + " tried to " + aOperation + ", on type: " + aObjectType + ", on instance: " + aObjectString);
        if (aParameters.length > 0) {
            userAction.append(", using the parameters: ");
        }
        int index = 0;
        while (index < aParameters.length) {
            if (index != 0) {
                userAction.append("; ");
            }
            userAction.append(aParameters[index++]).append(" = ");
            userAction.append(aParameters[index++]);
        }
        theUserLogger.info(SrLogCategories.USER, userAction);
    }

    private void terminateClientThread() {
        LogicMgrAOImpl.getInstance().removeElementListener(this);
        ClientThreadImpl.decClientThreadCount();
        LogicMgrAOImpl.getInstance().remoteClientClosed(new ClientStateEvent(this, ClientThreadImpl.getClientThreadCount()));
        this.shutdown();
        this.myListener = null;
        theLogger.info(SrLogCategories.INFORMATIVE, "Removing client thread for ip: " + this.myIP + ", port: " + this.myPort);
    }

    @Override
    public void closeSession() {
        this.terminateClientThread();
    }

    public String getIP() {
        return this.myIP;
    }

    public int getPort() {
        return this.myPort;
    }

    public String getAddress() {
        return this.getIP() + ":" + this.getPort();
    }

    public boolean isEqualToMyAdapter(ElementListenerToServerEventsListenerAdapter aAdapter) {
        if (aAdapter == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameter should not be null.");
            return false;
        }
        return aAdapter.equals(this.myListener);
    }

    @Override
    protected void __execCLICommand(final SrFuture<Void> aFuture, String aCliCommand) throws Exception {
        this.logUserAction("Execute", "CLI command", "SP server: " + aCliCommand, new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().execCliCommand(aCliCommand);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.execCLICommandFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __execCLICommandFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __configureElementsTree(final SrFuture<Void> aFuture, ClientConfigElementData aCreationData) throws Exception {
        this.logUserCreate(aCreationData.getClassId(), "Client CED", aCreationData);
        final SrFuture<Void> createFuture = LogicMgrAOImpl.getInstance().configureElementsTree(aCreationData);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.configureElementsTreeFinished(aFuture, createFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        };
        DefaultFutureListener.listenTo(toRun, createFuture);
    }

    @Override
    protected Void __configureElementsTreeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aSourceFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aSourceFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __suspendPolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        this.logUserAction("Suspend", "polling group ", aPollingType.toString(), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().suspendPolling(aPollingType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.suspendPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected void __resumePolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        this.logUserAction("Resume", "polling group ", aPollingType.toString(), new Object[0]);
        final SrFuture<Void> fromLogicFuture = LogicMgrAOImpl.getInstance().resumePolling(aPollingType);
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.suspendPollingFinished(aFuture, fromLogicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        }, fromLogicFuture);
    }

    @Override
    protected Void __suspendPollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __resumePollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __deleteElementTree(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        this.logUserRemoveTree(aObject, new Object[0]);
        final SrFuture<Void> logicFuture = LogicMgrAOImpl.getInstance().deleteElementTree(aObject);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                try {
                    ClientThreadImpl.this.deleteElementFinished(aFuture, logicFuture);
                }
                catch (RemoteException exp) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, exp, "A remote exception has been thrown inside a server context.");
                }
            }
        };
        DefaultFutureListener.listenTo(toRun, logicFuture);
    }
}

