/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.AliasSynchronizer;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.types.SrString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class AliasSynchronizerTest
extends TestCase {
    private Class mySyncClass;
    private AliasSynchronizer myAliasSync;
    private Method getNewAlias;
    private Method getAliasDiff;
    private Method isAliasOverflow;
    private Method isUserAlias;
    private Method sync;
    private Method copyAlias;
    private Method createNewAlias;
    private Method getAliasParts;
    private Method getAliasStorNum;

    public AliasSynchronizerTest() {
        Thread.currentThread().getStackTrace();
        this.mySyncClass = AliasSynchronizer.class;
        Class[] params = new Class[]{VolumeNodeImpl.class};
        try {
            this.getAliasDiff = this.mySyncClass.getDeclaredMethod("getAliasDiff", params);
            this.getAliasDiff.setAccessible(true);
            params = new Class[]{VolumeNodeImpl.class, this.mySyncClass.getDeclaredClasses()[0]};
            this.createNewAlias = this.mySyncClass.getDeclaredMethod("createNewAlias", params);
            this.createNewAlias.setAccessible(true);
            params = new Class[]{List.class};
            this.sync = this.mySyncClass.getDeclaredMethod("sync", params);
            this.sync.setAccessible(true);
            params = new Class[]{Integer.TYPE, Integer.TYPE};
            this.getNewAlias = this.mySyncClass.getDeclaredMethod("getNewAlias", params);
            this.getNewAlias.setAccessible(true);
            params = new Class[]{String.class};
            this.isAliasOverflow = this.mySyncClass.getDeclaredMethod("isAliasOverflow", params);
            this.isAliasOverflow.setAccessible(true);
            this.isUserAlias = this.mySyncClass.getDeclaredMethod("isUserAlias", params);
            this.isUserAlias.setAccessible(true);
            this.getAliasParts = this.mySyncClass.getDeclaredMethod("getAliasParts", params);
            this.getAliasParts.setAccessible(true);
            this.getAliasStorNum = this.mySyncClass.getDeclaredMethod("getAliasStorNum", params);
            this.getAliasStorNum.setAccessible(true);
            params = new Class[]{List.class, VolumeNodeImpl.class};
            this.copyAlias = this.mySyncClass.getDeclaredMethod("copyAlias", params);
            this.copyAlias.setAccessible(true);
        }
        catch (SecurityException e) {
            AliasSynchronizerTest.fail((String)"Could not initialize the test.");
        }
        catch (NoSuchMethodException e) {
            AliasSynchronizerTest.fail((String)"Could not initialize the test.");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init(new Properties());
        this.myAliasSync = new AliasSynchronizer("Stor");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateNewAlias1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.createNewAlias.invoke((Object)this.myAliasSync, new Object[]{param, param});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testCopyAlias1() {
        Object param1 = null;
        Object param2 = null;
        boolean expThrown = false;
        try {
            this.copyAlias.invoke((Object)this.myAliasSync, new Object[]{param1, param2});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testSync1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.sync.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testIsUserAlias1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.isUserAlias.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testIsUserAlias2() {
        String param = "Stor_4";
        Boolean retVal = new Boolean(true);
        try {
            retVal = (Boolean)this.isUserAlias.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertFalse((String)"The method should return false but it returned true.", (boolean)retVal);
    }

    public void testIsUserAlias3() {
        String param = "Stor_2147483649";
        Boolean retVal = new Boolean(true);
        try {
            retVal = (Boolean)this.isUserAlias.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should return true but it returned false", (boolean)retVal);
    }

    public void testIsUserAlias4() {
        String param = "Unlike_Pattern";
        Boolean retVal = new Boolean(true);
        try {
            retVal = (Boolean)this.isUserAlias.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should return true but it returned false", (boolean)retVal);
    }

    public void testIsAliasOverflow1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.isAliasOverflow.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testIsAliasOverflow2() {
        String param = "UNLIKE_PATTERN";
        boolean expThrown = false;
        try {
            this.isAliasOverflow.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testIsAliasOverflow3() {
        String param = "Stor_46";
        Boolean retVal = new Boolean(true);
        try {
            retVal = (Boolean)this.isAliasOverflow.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertFalse((String)"The method should return false but it returned true.", (boolean)retVal);
    }

    public void testIsAliasOverflow4() {
        String param = "Stor_2147483648";
        Boolean retVal = new Boolean(true);
        try {
            retVal = (Boolean)this.isAliasOverflow.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should return true but it returned false", (boolean)retVal);
    }

    public void testGetAliasParts1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.getAliasParts.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetAliasParts2() {
        String param = new String("User_defined");
        boolean expThrown = false;
        try {
            this.getAliasParts.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetAliasParts3() {
        String param = new String("Stor_1");
        int retVal = -1;
        try {
            retVal = (Integer)this.getAliasParts.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)("The number of parts should be 0 but it is: " + retVal), (retVal == 0 ? 1 : 0) != 0);
    }

    public void testGetAliasParts4() {
        String param = new String("Stor_1_1_6");
        int retVal = -1;
        try {
            retVal = (Integer)this.getAliasParts.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)("The number of parts should be 2 but it is: " + retVal), (retVal == 2 ? 1 : 0) != 0);
    }

    public void testGetAliasStorNum1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.getAliasStorNum.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetAliasStorNum2() {
        String param = new String("User_defined");
        boolean expThrown = false;
        try {
            this.getAliasStorNum.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetAliasStorNum3() {
        String param = new String("Stor_1");
        int retVal = -1;
        try {
            retVal = (Integer)this.getAliasStorNum.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)("The number of parts should be 1 but it is: " + retVal), (retVal == 1 ? 1 : 0) != 0);
    }

    public void testGetAliasStorNum4() {
        String param = new String("Stor_1_1_6");
        int retVal = -1;
        try {
            retVal = (Integer)this.getAliasStorNum.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)("The number of parts should be 6 but it is: " + retVal), (retVal == 6 ? 1 : 0) != 0);
    }

    public void testGetAliasDiff1() {
        Object param = null;
        boolean expThrown = false;
        try {
            this.getAliasDiff.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalArgumentException) {
                expThrown = true;
            } else {
                AliasSynchronizerTest.fail();
            }
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetAliasDiff2() {
        GeneralSCSIDeviceImpl param = null;
        try {
            ConfigElementData clusterCED = SrTestUtils.generateClusterCED();
            ClusterImpl tmpCluster = new ClusterImpl(clusterCED);
            ConfigElementData gsdCED = SrTestUtils.generateGeneralSCSIDeviceCED();
            param = new GeneralSCSIDeviceImpl(tmpCluster, gsdCED);
        }
        catch (RemoteException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalValueException e) {
            AliasSynchronizerTest.fail();
        }
        catch (InvalidElementException e) {
            AliasSynchronizerTest.fail();
        }
        Object retVal = null;
        try {
            retVal = this.getAliasDiff.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertNull((String)("The return value should be null, but it is " + retVal), (Object)retVal);
    }

    public void testGetAliasDiff3() {
        ClusterImpl tmpCluster = null;
        VSwitchImpl vs1 = null;
        VSwitchImpl vs2 = null;
        try {
            ConfigElementData clusterCED = SrTestUtils.generateClusterCED();
            tmpCluster = new ClusterImpl(clusterCED);
            ConfigElementData vswitchCED = SrTestUtils.generateVSwitchCED();
            vs1 = new VSwitchImpl(tmpCluster, vswitchCED);
            vs2 = new VSwitchImpl(tmpCluster, vswitchCED);
        }
        catch (RemoteException e1) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalValueException e) {
            AliasSynchronizerTest.fail();
        }
        catch (InvalidElementException e) {
            AliasSynchronizerTest.fail();
        }
        GeneralSCSIDeviceImpl param = null;
        try {
            ConfigElementData gsdCED = SrTestUtils.generateGeneralSCSIDeviceCED();
            param = new GeneralSCSIDeviceImpl(tmpCluster, gsdCED);
            param.setOneParameter(new Parameter(param.getParameterCode(MasterParameterCode.ALIAS), new SrString("Alias1")), vs1);
            param.setOneParameter(new Parameter(param.getParameterCode(MasterParameterCode.ALIAS), new SrString("Alias2")), vs2);
        }
        catch (RemoteException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalValueException e) {
            AliasSynchronizerTest.fail();
        }
        catch (InvalidElementException e) {
            AliasSynchronizerTest.fail();
        }
        Object retVal = null;
        try {
            retVal = this.getAliasDiff.invoke((Object)this.myAliasSync, param);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertNotNull((String)"The method should return a non null value, but it returned null.", retVal);
    }

    public void testGetNewAlias1() {
        Object stringToCheck = null;
        boolean expThrown = false;
        try {
            this.getNewAlias.invoke((Object)this.myAliasSync, stringToCheck);
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
        catch (SecurityException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            expThrown = true;
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        AliasSynchronizerTest.assertTrue((String)"The method should throw an exception.", (boolean)expThrown);
    }

    public void testGetNewAlias4() {
        try {
            Object[] args = new Integer[]{new Integer(3), new Integer(0)};
            String retVal = (String)this.getNewAlias.invoke((Object)this.myAliasSync, args);
            AliasSynchronizerTest.assertEquals((String)("The return value should be Stor_4 but it is: " + retVal), (String)"Stor_4", (String)retVal);
        }
        catch (SecurityException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
    }

    public void testGetNewAlias2() {
        try {
            Object[] args = new Integer[]{new Integer(2), new Integer(1)};
            String retVal = (String)this.getNewAlias.invoke((Object)this.myAliasSync, args);
            AliasSynchronizerTest.assertEquals((String)("The value should be Stor_1_3 but it is: " + retVal), (String)"Stor_1_3", (String)retVal);
        }
        catch (SecurityException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalArgumentException e) {
            AliasSynchronizerTest.fail();
        }
        catch (IllegalAccessException e) {
            AliasSynchronizerTest.fail();
        }
        catch (InvocationTargetException e) {
            AliasSynchronizerTest.fail();
        }
    }
}

