/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.license;

import com.sanrad.nms.server.license.SrFeatureName;
import com.sanrad.nms.server.license.SrFeatureNameConstant;

public class SrLicenseTreePath {
    private static final SrFeatureName[] GENERAL_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.GENERAL};
    private static final SrFeatureName[] GDR_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.GDR};
    private static final SrFeatureName[] STORAGE_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.STORAGE};
    private static final SrFeatureName[] SUBDISK_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.STORAGE, SrFeatureNameConstant.SUBDISK};
    private static final SrFeatureName[] VOLUME_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.VOLUME};
    private static final SrFeatureName[] ISCSI_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.ISCSI};
    private static final SrFeatureName[] REMOTE_TARGET_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.ISCSI, SrFeatureNameConstant.REMOTE_TARGET};
    private static final SrFeatureName[] REMOTE_PORTAL_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.ISCSI, SrFeatureNameConstant.REMOTE_PORTAL};
    private static final SrFeatureName[] INITIATOR_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.ISCSI, SrFeatureNameConstant.INITIATOR};
    private static final SrFeatureName[] LU_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.LU};
    private static final SrFeatureName[] ALARMS_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.GENERAL, SrFeatureNameConstant.ALARMS};
    private static final SrFeatureName[] NEXSAN_PATH_FEATURES = new SrFeatureName[]{SrFeatureNameConstant.NEXSAN};
    public static final SrLicenseTreePath GENERAL_PATH = new SrLicenseTreePath(GENERAL_PATH_FEATURES);
    public static final SrLicenseTreePath GDR_PATH = new SrLicenseTreePath(GDR_PATH_FEATURES);
    public static final SrLicenseTreePath STORAGE_PATH = new SrLicenseTreePath(STORAGE_PATH_FEATURES);
    public static final SrLicenseTreePath SUBDISK_PATH = new SrLicenseTreePath(SUBDISK_PATH_FEATURES);
    public static final SrLicenseTreePath VOLUME_PATH = new SrLicenseTreePath(VOLUME_PATH_FEATURES);
    public static final SrLicenseTreePath ISCSI_PATH = new SrLicenseTreePath(ISCSI_PATH_FEATURES);
    public static final SrLicenseTreePath REMOTE_TARGET_PATH = new SrLicenseTreePath(REMOTE_TARGET_PATH_FEATURES);
    public static final SrLicenseTreePath REMOTE_PORTAL_PATH = new SrLicenseTreePath(REMOTE_PORTAL_PATH_FEATURES);
    public static final SrLicenseTreePath INITIATOR_PATH = new SrLicenseTreePath(INITIATOR_PATH_FEATURES);
    public static final SrLicenseTreePath LU_PATH = new SrLicenseTreePath(LU_PATH_FEATURES);
    public static final SrLicenseTreePath ALARMS_PATH = new SrLicenseTreePath(ALARMS_PATH_FEATURES);
    public static final SrLicenseTreePath NEXSAN_PATH = new SrLicenseTreePath(NEXSAN_PATH_FEATURES);
    private SrFeatureName[] path;

    public SrLicenseTreePath(SrFeatureName[] path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        this.path = path;
    }

    public SrLicenseTreePath(SrLicenseTreePath base, SrFeatureName[] path) {
        if (path == null || base == null) {
            throw new NullPointerException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        SrFeatureName[] totalPath = new SrFeatureName[base.length() + path.length];
        System.arraycopy(base.path, 0, totalPath, 0, base.length());
        System.arraycopy(path, 0, totalPath, base.length(), path.length);
        this.path = totalPath;
    }

    public SrLicenseTreePath(SrLicenseTreePath base, SrFeatureName child) {
        if (base == null || child == null) {
            throw new NullPointerException();
        }
        SrFeatureName[] totalPath = new SrFeatureName[base.length() + 1];
        System.arraycopy(base.path, 0, totalPath, 0, base.length());
        totalPath[totalPath.length - 1] = child;
        this.path = totalPath;
    }

    public SrFeatureName getFeatureNameAt(int index) {
        return this.path[index];
    }

    public int length() {
        return this.path.length;
    }

    public boolean equals(Object o) {
        if (o instanceof SrLicenseTreePath) {
            SrLicenseTreePath other = (SrLicenseTreePath)o;
            if (this.path.length == other.path.length) {
                int i = this.path.length;
                while (i-- > 0) {
                    if (this.path[i].equals(other.path[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.path.length; ++i) {
            sb.append(this.path[i]);
            sb.append(':');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

