/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.license;

import BlowfishJ.BlowfishEasy;
import com.sanrad.nms.server.license.SrFeatureStateConstant;
import com.sanrad.nms.server.license.SrInstallationNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.license.XMLFileAttributes;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.Util;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class LicenseManager {
    private static final String s_codeKey = "The alias is already in use. Please select another alias";
    private static final LicenseManager m_instance = new LicenseManager();
    private static final String LICENSE_CONFIG_FILE = "resources/license_config.xml";
    private static final String LICENSE_ENCRYPTED_CONFIG_FILE = "resources/license";
    private Document m_document;
    private Element m_root;
    private SrInstallationNameConstant m_installation;

    private LicenseManager() {
        SAXBuilder builder = new SAXBuilder();
        try {
            Util util = new Util();
            boolean encodedLicense = true;
            URL url = util.getURL(LICENSE_ENCRYPTED_CONFIG_FILE);
            if (url == null) {
                url = util.getURL(LICENSE_CONFIG_FILE);
                encodedLicense = false;
            }
            String content = Util.getFileTextualContent(url);
            if (encodedLicense) {
                BlowfishEasy blowfish = new BlowfishEasy(s_codeKey);
                content = blowfish.decryptString(content);
            }
            this.m_document = builder.build((Reader)new StringReader(content));
            this.m_root = this.m_document.getRootElement();
            String installCode = SrResourceBundle.getInstance("constants").getString(SrConstantsBundleKeys.INSTALLATION_CODE);
            this.m_installation = SrInstallationNameConstant.valueOf(installCode);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public static LicenseManager getInstance() {
        return m_instance;
    }

    public SrInstallationNameConstant getInstallationType() {
        return this.m_installation;
    }

    public boolean isEnabled(SrLicenseTreePath path, SrBITSConstant vswitchCapability) {
        Element feature = this.getElement(path, 0, this.m_root);
        Element license = feature.getChild("License");
        boolean licenseEnabledState = this.isEnabledFeatureState(SrFeatureStateConstant.valueOf(license.getAttributeValue(this.m_installation.getName())));
        boolean vsEnabledState = true;
        if (vswitchCapability != null) {
            Element vswitch = feature.getChild("Vswitch");
            String vsCapabilityAttr = XMLFileAttributes.getCapabilityAttribute(vswitchCapability);
            vsEnabledState = this.isEnabledFeatureState(SrFeatureStateConstant.valueOf(vswitch.getAttributeValue(vsCapabilityAttr)));
        }
        return licenseEnabledState && vsEnabledState;
    }

    public boolean isVisible(SrLicenseTreePath path, SrBITSConstant vswitchCapability) {
        Element feature = this.getElement(path, 0, this.m_root);
        Element license = feature.getChild("License");
        boolean licenseVisibility = this.isVisibleFeatureState(SrFeatureStateConstant.valueOf(license.getAttributeValue(this.m_installation.getName())));
        boolean vsVisibility = true;
        if (vswitchCapability != null) {
            Element vswitch = feature.getChild("Vswitch");
            String vsCapabilityAttr = XMLFileAttributes.getCapabilityAttribute(vswitchCapability);
            vsVisibility = this.isVisibleFeatureState(SrFeatureStateConstant.valueOf(vswitch.getAttributeValue(vsCapabilityAttr)));
        }
        return licenseVisibility && vsVisibility;
    }

    private Element getElement(SrLicenseTreePath path, int indexInPath, Element parent) {
        List featureChildren = parent.getChildren("Feature");
        for (Element currFeature : featureChildren) {
            String currFeatureName = currFeature.getAttributeValue("name");
            if (!currFeatureName.equals(path.getFeatureNameAt(indexInPath).getName())) continue;
            if (indexInPath == path.length() - 1) {
                return currFeature;
            }
            Element child = this.getElement(path, indexInPath + 1, currFeature);
            if (child == null) continue;
            return child;
        }
        StringBuffer sb = new StringBuffer("License Path \"");
        sb.append(path);
        sb.append("\" not found");
        if (indexInPath == 0) {
            throw new IllegalArgumentException(sb.toString());
        }
        return parent;
    }

    private boolean isEnabledFeatureState(SrFeatureStateConstant state) {
        return !SrFeatureStateConstant.DISABLED.equals(state);
    }

    private boolean isVisibleFeatureState(SrFeatureStateConstant state) {
        return !SrFeatureStateConstant.HIDDEN.equals(state);
    }
}

