/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.exception;

import com.sanrad.SrException;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ParameterCode;

public abstract class SrServerException
extends SrException {
    private static SrLogger theLogger = SrLogger.getLogger();
    private char myVSwitchID;
    private ConfigElementData myErrorElement = null;
    private ParameterCode myErrorParameterCode;

    public SrServerException(char aSwitchID, String aMessage) {
        super(aMessage);
        this.myVSwitchID = aSwitchID;
    }

    public SrServerException(char aSwitchID, String aMessage, Throwable aCause) {
        super(aMessage, aCause);
        this.myVSwitchID = aSwitchID;
    }

    protected void setErrorConfigElementAndParameterCode(ConfigElementData aElement, ParameterCode aParameterCode) {
        theLogger.logAndAssert(SrLogCategories.ERROR, aElement != null, new Object[]{"aElement must NOT be null"});
        this.myErrorElement = aElement;
        this.myErrorParameterCode = aParameterCode;
    }

    public char getVSwitchID() {
        return this.myVSwitchID;
    }

    public ConfigElementData getErrorElement() {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myErrorElement != null, new Object[]{"At this point, the myErrorElement should have already been assigned, otherwise, this method shouldn't have been called."});
        return this.myErrorElement;
    }

    public ParameterCode getErrorParameterCode() {
        return this.myErrorParameterCode;
    }
}

