/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.event;

import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;

public abstract class SrElementEvent
extends SrEvent {
    private ConfigElementDataList myElements = new ConfigElementDataList();
    private CommKeyClassId myVswitchId;
    protected String typeStr = "";

    public SrElementEvent(Object source, int type, ElementData element, String typeName) {
        super(source, type, typeName);
        this.myElements.clear();
        this.myElements.add(element);
        this.initVswitchId();
    }

    public SrElementEvent(Object source, int type, ConfigElementDataList elements, String typeName) {
        super(source, type, typeName);
        this.myElements.clear();
        this.myElements.addAll(elements);
        this.initVswitchId();
    }

    private void initVswitchId() {
        for (ElementData ced : this.myElements) {
            if (this.myVswitchId != null) break;
            this.myVswitchId = ced.getVswitchId();
        }
    }

    public ConfigElementDataList getElements() {
        return this.myElements;
    }

    @Override
    protected String getDetailsString() {
        StringBuilder sb = new StringBuilder();
        if (this.myVswitchId != null) {
            sb.append('[').append(this.myVswitchId.toDisplayString()).append(']');
        }
        sb.append(" Elements: ");
        sb.append(this.myElements.toString());
        return sb.toString();
    }
}

