/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.event;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.event.SrEventMgr;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;

public class ErrorMgr
extends SrEventMgr {
    private static ErrorMgr theInstance = new ErrorMgr();
    private static SrLogger theLogger = SrLogger.getLogger();

    private ErrorMgr() {
        super(SrEventHandler.getInstance());
    }

    public static ErrorMgr getInstance() {
        return theInstance;
    }

    public void sendConfigurationError(String message, CommKeyClassId vSwitch) {
        ErrorEvent event = new ErrorEvent((Object)vSwitch, message, 3);
        DataMgrAOImpl.getInstance().sendConfigurationError(event);
        theLogger.trace(SrLogCategories.LEGACY, message);
    }

    public void sendConfigurationError(String message, char snmpAgentIndex) {
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(snmpAgentIndex);
        this.sendConfigurationError(message, vSwitch);
    }

    public void sendFatalConfigurationError(String message, CommKeyClassId vSwitch) {
        ErrorEvent event = new ErrorEvent((Object)vSwitch, message, vSwitch, 4);
        DataMgrAOImpl.getInstance().sendFatalConfigurationError(event);
        theLogger.trace(SrLogCategories.LEGACY, message);
    }
}

