/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.event;

import com.sanrad.nms.server.event.SrEventObject;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.io.PrintStream;

public class ErrorEvent
extends SrEventObject {
    public static final int SNMP_TIMEOUT = 1;
    public static final int SNMP_ERROR = 2;
    public static final int CONFIGURATION_ERROR = 3;
    public static final int FATAL_CONFIGURATION_ERROR = 4;
    private int m_errorType;
    private Exception stackTrace;

    public ErrorEvent(Object source, int errorType) {
        super(source);
        this.m_errorType = errorType;
        this.stackTrace = new Exception("Event " + this.errorTypeToString(this.m_errorType) + " creation trace");
    }

    protected ErrorEvent(Object source, String message, int errorType) {
        super(source, message);
        this.m_errorType = errorType;
        this.stackTrace = new Exception("Event " + this.errorTypeToString(this.m_errorType) + " creation trace");
    }

    protected ErrorEvent(Object source, String message, CommKeyClassId vSwtich, int errorType) {
        super(source, message, vSwtich);
        this.m_errorType = errorType;
        this.stackTrace = new Exception("Event " + this.errorTypeToString(this.m_errorType) + " creation trace");
    }

    protected ErrorEvent(Object source, String message, CommKeyClassId vSwtich, ConfigElementData element, int errorType) {
        super(source, message, vSwtich, element);
        this.m_errorType = errorType;
        this.stackTrace = new Exception("Event " + this.errorTypeToString(this.m_errorType) + " creation trace");
    }

    public int getErrorType() {
        return this.m_errorType;
    }

    @Override
    public String toString() {
        ConfigElementData element;
        CommKeyClassId vSwitchData;
        StringBuffer sb = new StringBuffer();
        sb.append("ErrorEvent source: ");
        sb.append(this.getSource());
        sb.append("\nError type: ");
        sb.append(this.errorTypeToString(this.m_errorType));
        String msg = this.getMessage();
        if (msg != null) {
            sb.append("\nError message: ").append(msg);
        }
        if ((vSwitchData = this.getVSwitchData()) != null) {
            sb.append("\nV-Switch: ").append(vSwitchData);
        }
        if ((element = this.getEventElement()) != null) {
            sb.append("\nConfigElementData: ").append(element);
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace(PrintStream out) {
        this.stackTrace.printStackTrace(out);
    }

    @Override
    public Throwable getStackTrace() {
        return this.stackTrace;
    }

    private String errorTypeToString(int type) {
        switch (type) {
            case 1: {
                return "SNMP_TIMEOUT";
            }
            case 2: {
                return "SNMP_ERROR";
            }
            case 3: {
                return "CONFIGURATION_ERROR";
            }
            case 4: {
                return "FATAL_CONFIGURATION_ERROR";
            }
        }
        return "type is not defined";
    }
}

