/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.trap;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.trap.SnmpTrapMonitor;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.NetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.engine.SnmpTransportException;

public class TrapManager {
    private static TrapManager instance = null;
    private Hashtable m_trapMonitorsMap = new Hashtable(4);
    private HashMap m_busyTrapsMap = null;
    private ArrayList<TrapListener> listenersToAllMonitors = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();

    private TrapManager() {
    }

    public static synchronized TrapManager getInstance() {
        if (instance == null) {
            instance = new TrapManager();
        }
        return instance;
    }

    public void addTrapListenerToAllMonitors(TrapListener listener) {
        if (!this.listenersToAllMonitors.contains(listener)) {
            this.listenersToAllMonitors.add(listener);
        }
    }

    public void removeTrapListenerFromAllMonitors(TrapListener listener) {
        this.listenersToAllMonitors.remove(listener);
    }

    public int createTrapMonitorIfNeeded(int port, char agentIndex, SrIpAddress ip) throws SnmpException {
        return this.createTrapMonitorIfNeeded(port, agentIndex, ip.toString());
    }

    private int createTrapMonitorIfNeeded(int port, char agentIndex, String ip) throws SnmpException {
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(new Integer(port));
        if (monitor != null) {
            theLogger.trace(SrLogCategories.LEGACY, "Trap port ", port, " already has a monitor");
            monitor.addAgentIndex(agentIndex, ip);
            this.m_trapMonitorsMap.put(new Character(agentIndex), monitor);
            return port;
        }
        if (NetUtil.isUDPPortBusy(port)) {
            int originBusyPort;
            Integer alternativePort;
            if (this.m_busyTrapsMap != null && (alternativePort = (Integer)this.m_busyTrapsMap.get(new Integer(port))) != null) {
                return this.createTrapMonitorIfNeeded((int)alternativePort, agentIndex, ip);
            }
            int busyPort = originBusyPort = port;
            int n = port = port + 1000 > 65535 ? port + 1000 - 65535 + 1 : port + 1000;
            while (NetUtil.isUDPPortBusy(port)) {
                if (port > 65535) {
                    port = ++busyPort;
                    if (busyPort > 65535) {
                        port = originBusyPort;
                        theLogger.error(SrLogCategories.LEGACY, "Couldn't find free trap port");
                        break;
                    }
                }
                port += 1000;
            }
            if (this.m_busyTrapsMap == null) {
                this.m_busyTrapsMap = new HashMap(1);
            }
            this.m_busyTrapsMap.put(new Integer(originBusyPort), new Integer(port));
        }
        monitor = new SnmpTrapMonitor(port);
        monitor.addAgentIndex(agentIndex, ip);
        this.m_trapMonitorsMap.put(new Integer(port), monitor);
        this.m_trapMonitorsMap.put(new Character(agentIndex), monitor);
        monitor.addTrapListeners(this.listenersToAllMonitors);
        theLogger.trace(SrLogCategories.LEGACY, "Trap Monitor created for trap port - ", port);
        return port;
    }

    public int getManagerTrapPort(char aVsIndex) {
        SnmpTrapMonitor vsTrapMon = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(Character.valueOf(aVsIndex));
        if (vsTrapMon == null) {
            return 0;
        }
        return vsTrapMon.getTrapPort();
    }

    public void removeTrapMonitorIfNeeded(char index) {
        Character agent = new Character(index);
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(agent);
        if (monitor == null) {
            theLogger.trace(SrLogCategories.LEGACY, "Found No monitor for agent - ", Character.valueOf(index), " Remove Operation N/A");
            return;
        }
        boolean needsToBeDeleted = monitor.removeAgentIndex(index);
        this.m_trapMonitorsMap.remove(agent);
        theLogger.trace(SrLogCategories.LEGACY, "Agent - ", index, "was removed from Monitor: ", monitor);
        if (needsToBeDeleted) {
            monitor.terminateMonitorOperation();
            theLogger.trace(SrLogCategories.LEGACY, "Deleting Monitor - ", monitor, ". has no agents.");
            this.m_trapMonitorsMap.remove(new Integer(monitor.getTrapPort()));
            monitor.removeAllTrapListeners();
        }
    }

    public int changeTrapPort(char snmpAgentIndex, int port, String ip) throws SnmpException {
        SnmpTrapMonitor monitor = (SnmpTrapMonitor)this.m_trapMonitorsMap.get(new Character(snmpAgentIndex));
        int prevPort = 0;
        if (monitor != null) {
            prevPort = monitor.getTrapPort();
            if (prevPort == port) {
                return port;
            }
            this.removeTrapMonitorIfNeeded(snmpAgentIndex);
        }
        try {
            return this.createTrapMonitorIfNeeded(port, snmpAgentIndex, ip);
        }
        catch (SnmpTransportException e) {
            if (monitor != null && prevPort != 0) {
                theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{e, "port (" + port + ") might be busy, retrying with port (" + prevPort + ")..."});
                return this.createTrapMonitorIfNeeded(prevPort, snmpAgentIndex, ip);
            }
            theLogger.error(SrLogCategories.EXCEPTION, "port (" + port + ") might be busy.", e.getMessage());
            throw e;
        }
    }
}

