/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.trap;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.util.Queue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.engine.TransportEntity;
import monfox.toolkit.snmp.engine.UdpEntity;
import monfox.toolkit.snmp.mgr.SnmpSession;
import monfox.toolkit.snmp.mgr.SnmpTrap;
import monfox.toolkit.snmp.mgr.SnmpTrapListener;

public class SnmpTrapMonitor
implements SnmpTrapListener {
    private SnmpSession trapSession = null;
    private int port;
    private Hashtable<String, Character> myAgents = new Hashtable();
    private ArrayList<TrapListener> myListeners = new ArrayList();
    private static int trapCounter = 0;
    private static SrLogger theTrapLogger = SrLogger.getTrapLogger();
    private static SrLogger theLogger = SrLogger.getLogger();
    TrapsInvoker trapsInvoker = new TrapsInvoker();

    public SnmpTrapMonitor(int port) throws SnmpException {
        this.trapSession = new SnmpSession(port);
        this.trapSession.addTrapListener((SnmpTrapListener)this);
        this.port = port;
        this.trapsInvoker.start();
    }

    protected void finalize() throws Throwable {
        theLogger.trace(SrLogCategories.LEGACY, " **********  Trap Monitor deleted for port: ", this.port);
        super.finalize();
    }

    public void terminateMonitorOperation() {
        this.trapSession.removeTrapListener((SnmpTrapListener)this);
        this.trapSession.shutdown();
        this.trapSession = null;
        this.trapsInvoker.stopThread();
    }

    public void addTrapListener(TrapListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void addTrapListeners(List<TrapListener> trapListeners) {
        for (TrapListener listener : trapListeners) {
            this.addTrapListener(listener);
        }
    }

    public void removeAllTrapListeners() {
        this.myListeners.clear();
    }

    public void removeTrapListener(TrapListener listener) {
        this.myListeners.remove(listener);
    }

    public void handleTrap(SnmpTrap trap) {
        if (trap != null) {
            theTrapLogger.info(SrLogCategories.TRAP, "Received trap: ", trap);
        }
        long receivedTime = System.currentTimeMillis();
        TrapWrap trapW = new TrapWrap(trap, receivedTime, trapCounter++);
        this.trapsInvoker.addElement(trapW);
    }

    private void convertTrap(TrapWrap trapW) {
        SnmpTrap trap = trapW.trap;
        long receivedTime = trapW.time;
        TransportEntity trans = trap.getSource();
        String host = "";
        if (trans instanceof UdpEntity) {
            host = ((UdpEntity)trans).getAddress().getHostAddress();
        }
        theLogger.trace(SrLogCategories.LEGACY, "New Trap From: ", host, trapW);
        Character c = this.myAgents.get(host);
        if (c == null) {
            theLogger.trace(SrLogCategories.LEGACY, "Monitor  - ", this, " Got trap from unknown host ", host);
            return;
        }
        char agentIndex = c.charValue();
        SnmpOid trapOid = trap.getTrapOid();
        SrTrapType trapType = DsnmpUtil.convertDSnmpTrapTypeToSrTrapType(trapOid);
        if (trapType == null) {
            theLogger.warn(SrLogCategories.LEGACY, "Unknown Trap ", trapOid, " ", trap.getMessage());
            return;
        }
        SnmpVarBindList vbList = trap.getVarBindList();
        SrSnmpVarBindList srList = null;
        try {
            srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(vbList);
        }
        catch (SrSnmpConversionException sse) {
            theLogger.warn(SrLogCategories.LEGACY, sse, "Cannot convert Trap data. Type format mismatch.");
            return;
        }
        catch (Exception ex) {
            theLogger.warn(SrLogCategories.LEGACY, ex, "Cannot convert Trap data.");
            return;
        }
        SrDateAndTime time = new SrDateAndTime(new Long(receivedTime));
        SrTrap srTrap = new SrTrap(trapType, srList, time, agentIndex, host);
        this.fireTrapCreatedEvent(srTrap);
    }

    private void fireTrapCreatedEvent(SrTrap trap) {
        TrapEvent event = new TrapEvent(this, trap);
        for (TrapListener listener : this.myListeners) {
            listener.trapReceived(event);
        }
    }

    public int getTrapPort() {
        return this.port;
    }

    public void addAgentIndex(char index, SrIpAddress ip) {
        this.addAgentIndex(index, ip.toString());
    }

    public void addAgentIndex(char index, String ip) {
        this.myAgents.put(ip, new Character(index));
        theLogger.trace(SrLogCategories.LEGACY, "Add IP to Trap Monitor. ", ip, " Agent: ", index);
    }

    public boolean removeAgentIndex(char index) {
        Character value = new Character(index);
        Enumeration<String> keys = this.myAgents.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.myAgents.get(key).equals(value)) continue;
            theLogger.trace(SrLogCategories.LEGACY, "Remove IP from Trap Monitor. ", this.myAgents.get(key), " Agent: ", index);
            this.myAgents.remove(key);
            return this.myAgents.isEmpty();
        }
        return this.myAgents.isEmpty();
    }

    public boolean holdsIndex(char index) {
        return this.myAgents.contains(new Character(index));
    }

    public String toString() {
        return "[port - " + this.port + "]";
    }

    public String getAgentIp(char index) {
        Character value = new Character(index);
        Enumeration<String> keys = this.myAgents.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.myAgents.get(key).equals(value)) continue;
            return key;
        }
        return null;
    }

    class TrapsInvoker
    extends Thread {
        private boolean doRun;
        private Queue trapsQueue;

        public TrapsInvoker() {
            super("Traps Invoker");
            this.doRun = true;
            this.trapsQueue = new Queue();
        }

        public void addElement(TrapWrap aTrap) {
            this.trapsQueue.addElement(aTrap);
        }

        public synchronized void stopThread() {
            this.doRun = false;
            this.trapsQueue.addElementToHead(TrapWrap.LAST_ONE);
        }

        private synchronized boolean doRun() {
            return this.doRun;
        }

        @Override
        public void run() {
            TrapWrap headTrap;
            while (this.doRun() && !(headTrap = (TrapWrap)this.trapsQueue.removeHead()).equals(TrapWrap.LAST_ONE)) {
                try {
                    SnmpTrapMonitor.this.convertTrap(headTrap);
                }
                catch (Exception e) {
                    theLogger.info(SrLogCategories.LEGACY, e, "Error Converting Trap! ", headTrap.trap);
                }
            }
        }
    }

    static class TrapWrap {
        public long time;
        public SnmpTrap trap;
        public int trapIndex;
        public static final TrapWrap LAST_ONE = new TrapWrap(null, 0L, 0);

        TrapWrap(SnmpTrap theTrap, long recieveTime, int trapId) {
            this.time = recieveTime;
            this.trap = theTrap;
            this.trapIndex = trapId;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("--- Id: ");
            str.append(this.trapIndex);
            str.append(" Trap Data: ");
            str.append(this.trap.toString());
            return str.toString();
        }
    }
}

