/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.AbstractSnmpMgr;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.SnmpAgentParams;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidMibItem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidController;
import com.sanrad.nms.server.comm.snmp.raid.RaidControllerMgr;
import com.sanrad.nms.server.comm.snmp.raid.RaidMgmtInitializationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.NetUtil;
import com.sanrad.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.mgr.SnmpSession;
import monfox.toolkit.snmp.mgr.SnmpTrap;
import monfox.toolkit.snmp.mgr.SnmpTrapListener;

public class RaidSnmpMgr
extends AbstractSnmpMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static RaidSnmpMgr theInstance = null;
    private static SnmpMetadata RAID_MIB_METADATA;
    private static final int DEFAULT_SNMP_TRAP_PORT = 162;
    private static final String ERROR_INITIALIZATION_MSG = "Failed to initialize RAID Manager";
    private static RaidMgmtInitializationException theInitializationException;
    private SnmpSession mySnmpSession;
    private HashMap<String, TrapRegistration> myRaidIdToTrapRegistrationMap = new HashMap();
    private HashMap<Character, TrapRegistration> myAgentToTrapRegistrationMap = new HashMap();

    private RaidSnmpMgr() throws UnknownHostException, RaidConfigurationException {
        super(new SnmpAgentParams(new SrIpAddress(InetAddress.getLocalHost().getHostAddress())), '\u0000');
        this.initSession(162);
    }

    public static RaidSnmpMgr getInstance() throws RaidMgmtInitializationException {
        if (theInitializationException != null) {
            throw theInitializationException;
        }
        return theInstance;
    }

    private static void setInitializationException(RaidMgmtInitializationException aRaidException) {
        theInitializationException = aRaidException;
    }

    public void setOrReplaceManagedRaid(char aAgentIndex, SrString aRaidVendorName, SrString aRaidName, SrIpAddress ... aRaidIPs) throws RaidConfigurationException, RaidMgmtInitializationException {
        Util.validateInputNotNull(aRaidVendorName, "RAID's vendor name");
        Util.validateInputNotNull(aRaidIPs, "IP addresses");
        this.checkInitializationStatus();
        RaidController raidCtrlr = RaidControllerMgr.getRaidControllerByVsType(aRaidVendorName.toString());
        if (raidCtrlr == null) {
            String vsIp = CommKeyUtil.getIpFromIndex(aAgentIndex);
            throw new IllegalArgumentException("Failed to find controller for RAID " + aRaidName + " of the vendor " + aRaidVendorName + " on system " + vsIp);
        }
        this.validateManagedRaid(aAgentIndex, aRaidName, aRaidIPs);
        RaidSubsystem raidSys = raidCtrlr.addOrReplaceRaid(aAgentIndex, aRaidName, aRaidIPs);
        raidCtrlr.registerSnmpManager(this.mgrParams.getIpAddress(), raidSys, aAgentIndex);
        this.updateTrapRegistration(aAgentIndex, aRaidVendorName.toString(), raidSys);
    }

    private void updateTrapRegistration(char aAgentIndex, String aVendorName, RaidSubsystem aRaid) {
        TrapRegistration existingReg = this.myAgentToTrapRegistrationMap.get(Character.valueOf(aAgentIndex));
        if (existingReg != null) {
            RaidSubsystem oldRaid = existingReg.addOrReplaceRaid(aRaid);
            if (oldRaid != null) {
                this.myRaidIdToTrapRegistrationMap.remove(oldRaid.getRaidSysID());
            }
            this.myRaidIdToTrapRegistrationMap.put(aRaid.getRaidSysID(), existingReg);
        } else {
            TrapRegistration reg = new TrapRegistration(aVendorName, aAgentIndex);
            reg.addOrReplaceRaid(aRaid);
            this.myRaidIdToTrapRegistrationMap.put(aRaid.getRaidSysID(), reg);
            this.myAgentToTrapRegistrationMap.put(Character.valueOf(aAgentIndex), reg);
        }
    }

    private void validateManagedRaid(char aAgentIndex, SrString aRaidName, SrIpAddress ... aRaidIPs) throws RaidConfigurationException {
        TrapRegistration existRegInNameMap;
        if (aRaidName != null && (existRegInNameMap = this.myAgentToTrapRegistrationMap.get(Character.valueOf(aAgentIndex))) != null && existRegInNameMap.getAgentIndex() != aAgentIndex) {
            String msg = "Trying to register agent " + aAgentIndex + ": The TRAP registration is already exists, " + existRegInNameMap;
            throw new RaidConfigurationException(aAgentIndex, msg);
        }
        for (char agentIndex : this.myAgentToTrapRegistrationMap.keySet()) {
            TrapRegistration reg;
            RaidSubsystem raid;
            if (agentIndex == aAgentIndex || (raid = (reg = this.myAgentToTrapRegistrationMap.get(Character.valueOf(agentIndex))).getRaid(Util.convertToList(aRaidIPs))) == null) continue;
            List<SrIpAddress> raidIpAddresses = raid.getIPAddresses();
            for (int i = 0; i < aRaidIPs.length; ++i) {
                if (aRaidIPs[i] == null || !raidIpAddresses.contains(aRaidIPs[i])) continue;
                String msg = "Trying to register agent " + aAgentIndex + " to RAID IP " + aRaidIPs[i] + ": The TRAP registration is already exists, " + reg;
                throw new RaidConfigurationException(aAgentIndex, msg);
            }
        }
    }

    public void removeManagedRaid(char aAgentIndex, SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) throws RaidMgmtInitializationException, RaidConfigurationException {
        RaidSubsystem raidSys;
        this.checkInitializationStatus();
        TrapRegistration reg = this.myAgentToTrapRegistrationMap.get(Character.valueOf(aAgentIndex));
        if (reg != null && (raidSys = reg.getRaid(Util.convertToList(aRaidIp1, aRaidIp2))) != null) {
            this.myRaidIdToTrapRegistrationMap.remove(raidSys.getRaidSysID());
            reg.myRaids.remove(raidSys);
            RaidController raidCtr = RaidControllerMgr.getRaidControllerByVsType(reg.getVendorName());
            raidCtr.unregisterSnmpManager(this.mgrParams.getIpAddress(), raidSys, aAgentIndex);
            raidCtr.removeRaid(aAgentIndex, raidSys);
        }
    }

    public void removeAllManagedRaids(char aAgentIndex) throws RaidMgmtInitializationException, RaidConfigurationException {
        this.checkInitializationStatus();
        TrapRegistration reg = this.myAgentToTrapRegistrationMap.remove(Character.valueOf(aAgentIndex));
        if (reg != null) {
            for (RaidSubsystem raidSys : reg.myRaids) {
                if (raidSys == null) continue;
                this.myRaidIdToTrapRegistrationMap.remove(raidSys.getRaidSysID());
                if (raidSys == null) continue;
                RaidController raidCtr = RaidControllerMgr.getRaidControllerByVsType(reg.getVendorName());
                raidCtr.unregisterSnmpManager(this.mgrParams.getIpAddress(), raidSys, aAgentIndex);
                raidCtr.removeRaid(aAgentIndex, raidSys);
            }
        }
    }

    private void initSession(int aFirstAttemptPort) throws RaidConfigurationException {
        try {
            this.mySnmpSession = new SnmpSession(RAID_MIB_METADATA, aFirstAttemptPort);
            SnmpSession.getDefaultConfig().setReuseRequestIds(true);
            this.mySnmpSession.addTrapListener(new SnmpTrapListener(){

                public void handleTrap(SnmpTrap aSnmpTrap) {
                    RaidSnmpMgr.this.fireTrapReceived(aSnmpTrap);
                }
            });
        }
        catch (SnmpException e) {
            if (aFirstAttemptPort == 162) {
                try {
                    this.initSession(NetUtil.getRandomFreePort());
                    return;
                }
                catch (IOException e1) {
                    throw new RaidConfigurationException(this.snmpAgentIndex, "Failed to create RAID Manager", e1);
                }
            }
            throw new RaidConfigurationException(this.snmpAgentIndex, "Failed to create RAID Manager", e);
        }
    }

    public void addTrapListener(TrapListener aTrapListener, char aAgentIndex) throws RaidMgmtInitializationException {
        this.checkInitializationStatus();
        TrapRegistration reg = this.myAgentToTrapRegistrationMap.get(Character.valueOf(aAgentIndex));
        if (reg != null) {
            reg.myTrapListeners.add(aTrapListener);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Trace (exception wasn't thrown): Trying to add TrapListener ");
            sb.append(aTrapListener);
            sb.append(" to agent ");
            sb.append((int)aAgentIndex);
            sb.append(", this agent is not initialized");
            theLogger.error(SrLogCategories.BUG, new IllegalArgumentException(sb.toString()), new Object[0]);
        }
    }

    private SrSnmpVarBindList convertIbmRaidTrap(SnmpTrap aTrap) {
        SnmpVarBindList objVals = aTrap.getObjectValues();
        try {
            String userLabel = objVals.get(IbmRaidMibItem.DEVICE_USER_LABEL.toString()).getValueString();
            SrSnmpVarBind userLabelVarBind = new SrSnmpVarBind(IbmRaidMibItem.DEVICE_USER_LABEL.toString(), (SrType)new SrString(userLabel));
            String deviceHostIP = objVals.get("deviceHostIPAddr").getValueString().trim();
            if (deviceHostIP.trim().isEmpty()) {
                deviceHostIP = "0.0.0.0";
            }
            SrSnmpVarBind deviceHostIPVarBind = new SrSnmpVarBind(IbmRaidMibItem.DEVICE_HOST_IP.toString(), (SrType)new SrIpAddress(deviceHostIP));
            String deviceHostName = objVals.get(IbmRaidMibItem.DEVICE_HOST_NAME.toString()).getValueString().trim();
            SrSnmpVarBind deviceHostNameVarBind = new SrSnmpVarBind(IbmRaidMibItem.DEVICE_HOST_NAME.toString(), (SrType)new SrString(deviceHostName));
            String deviceErrCode = objVals.get(IbmRaidMibItem.DEVICE_ERROR_CODE.toString()).getValueString().trim();
            SrSnmpVarBind deviceErrCodeVarBind = new SrSnmpVarBind(IbmRaidMibItem.DEVICE_ERROR_CODE.toString(), (SrType)new SrString(deviceErrCode));
            String eventTime = objVals.get(IbmRaidMibItem.EVENT_TIME.toString()).getValueString().trim();
            SrSnmpVarBind eventTimeVarBind = new SrSnmpVarBind(IbmRaidMibItem.EVENT_TIME.toString(), (SrType)new SrString(eventTime));
            String trapDesc = objVals.get(IbmRaidMibItem.TRAP_DESCRIPTION.toString()).getValueString().trim();
            SrSnmpVarBind trapDescVarBind = new SrSnmpVarBind(IbmRaidMibItem.TRAP_DESCRIPTION.toString(), (SrType)new SrString(trapDesc));
            String compType = objVals.get(IbmRaidMibItem.COMPONENT_TYPE.toString()).getValueString().trim();
            SrSnmpVarBind compTypeVarBind = new SrSnmpVarBind(IbmRaidMibItem.COMPONENT_TYPE.toString(), (SrType)new SrString(compType));
            String compLocation = objVals.get(IbmRaidMibItem.COMPONENT_LOCATION.toString()).getValueString().trim();
            SrSnmpVarBind compLocationVarBind = new SrSnmpVarBind(IbmRaidMibItem.COMPONENT_LOCATION.toString(), (SrType)new SrString(compLocation));
            SrSnmpVarBindList ibmVbList = new SrSnmpVarBindList();
            ibmVbList.add(userLabelVarBind);
            ibmVbList.add(deviceHostIPVarBind);
            ibmVbList.add(deviceHostNameVarBind);
            ibmVbList.add(deviceErrCodeVarBind);
            ibmVbList.add(eventTimeVarBind);
            ibmVbList.add(trapDescVarBind);
            ibmVbList.add(compTypeVarBind);
            ibmVbList.add(compLocationVarBind);
            return ibmVbList;
        }
        catch (SnmpException exp) {
            theLogger.error(SrLogCategories.RAID, exp, "The trap ", aTrap, " could not be converted as an IBM DS3400 trap. Please verify the Oids sent in the trap.");
            return null;
        }
    }

    private void fireTrapReceived(SnmpTrap aSnmpTrap) {
        SnmpOid trapOid = aSnmpTrap.getTrapOid();
        SrTrapType trapType = DsnmpUtil.convertDSnmpTrapTypeToSrTrapType(trapOid);
        if (trapType == null) {
            theLogger.warn(SrLogCategories.TRAP, "Unknown Trap ", trapOid, " ", aSnmpTrap.getMessage());
            return;
        }
        RaidController raidController = RaidControllerMgr.getRaidControllerByTrapType(trapType);
        if (raidController == null) {
            theLogger.warn(SrLogCategories.TRAP, "Recieved Trap for unknown Raid Controller", trapOid, " ", aSnmpTrap.getMessage());
            return;
        }
        SnmpVarBindList vbList = aSnmpTrap.getVarBindList();
        SrSnmpVarBindList srVbList = null;
        if (SrTrapType.IBM_RAID_TRAP_EVENT.equals(trapType) || SrTrapType.IBM_RAID_VERSION_10_TRAP_EVENT.equals(trapType)) {
            srVbList = this.convertIbmRaidTrap(aSnmpTrap);
        } else {
            try {
                srVbList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(vbList);
            }
            catch (SrSnmpConversionException exp) {
                theLogger.warn(SrLogCategories.TRAP, exp, "Cannot convert Trap data. Type format mismatch.");
                return;
            }
        }
        if (srVbList == null) {
            return;
        }
        String raidId = raidController.extractRaidId(srVbList);
        if (raidId != null) {
            TrapRegistration reg = this.myRaidIdToTrapRegistrationMap.get(raidId);
            if (reg != null) {
                SrDateAndTime time = new SrDateAndTime(System.currentTimeMillis());
                SrTrap srTrap = new SrTrap(trapType, srVbList, time, reg.getAgentIndex(), this.mgrParams.getIpAddress().toString());
                TrapEvent event = new TrapEvent(this, srTrap);
                ArrayList listeners = new ArrayList(reg.myTrapListeners);
                for (TrapListener l : listeners) {
                    l.trapReceived(event);
                }
            } else {
                theLogger.info(SrLogCategories.TRAP, "A storage notification TRAP received for subsystem Id=", raidId, " but no registry found in the map");
            }
        }
    }

    public RaidSubsystem getRaidSubsystem(char aAgentIndex, SrIpAddress aRaidIp1, SrIpAddress aRaidIp2) throws RaidMgmtInitializationException {
        this.checkInitializationStatus();
        TrapRegistration reg = this.myAgentToTrapRegistrationMap.get(Character.valueOf(aAgentIndex));
        if (reg != null) {
            List<SrIpAddress> ips = Util.convertToList(aRaidIp1, aRaidIp2);
            return reg.getRaid(ips);
        }
        return null;
    }

    private void checkInitializationStatus() throws RaidMgmtInitializationException {
        if (theInitializationException != null) {
            throw theInitializationException;
        }
    }

    @Override
    public String getAgentHostname() {
        return null;
    }

    @Override
    public String getReadCommunity() {
        return null;
    }

    @Override
    public int getRetries() {
        return 0;
    }

    @Override
    public int getSnmpPort() {
        return 0;
    }

    @Override
    public SnmpVersion getSnmpVersion() {
        return null;
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public String getWriteCommunity() {
        return null;
    }

    @Override
    public void setAgentHostname(String hostname) {
    }

    @Override
    public void setReadCommunity(String community) throws SrSnmpException {
    }

    @Override
    public void setRetries(int retries) throws SrSnmpException {
    }

    @Override
    public void setSnmpPort(int port) throws UnknownHostException, SnmpException {
    }

    @Override
    public void setSnmpVersion(SnmpVersion version) throws SrSnmpException {
    }

    @Override
    public void setTimeout(long timeout) throws SrSnmpException {
    }

    @Override
    public void setWriteCommunity(String community) throws SrSnmpException {
    }

    @Override
    public void snmpSendTrap(String enterprise, String Mgrhost, int genericType, int specificType, long uptime, String[] values) {
    }

    public static boolean isInitializationExceptionOccured() {
        return theInitializationException != null;
    }

    static {
        try {
            URL mibMetadataUrl = new Util().getURL("mibs/raid-mibs.xml");
            RAID_MIB_METADATA = SnmpMetadata.loadXML((InputStream)mibMetadataUrl.openStream(), null);
            theInstance = new RaidSnmpMgr();
        }
        catch (IOException e) {
            RaidSnmpMgr.setInitializationException(new RaidMgmtInitializationException(ERROR_INITIALIZATION_MSG, e));
        }
        catch (SnmpException e) {
            RaidSnmpMgr.setInitializationException(new RaidMgmtInitializationException(ERROR_INITIALIZATION_MSG, e));
        }
        catch (RaidConfigurationException e) {
            RaidSnmpMgr.setInitializationException(new RaidMgmtInitializationException(ERROR_INITIALIZATION_MSG, e));
        }
    }

    private class TrapRegistration {
        private HashSet<TrapListener> myTrapListeners = new HashSet();
        private HashSet<RaidSubsystem> myRaids = new HashSet();
        private char myAgentIndex;
        private String myVendorName;

        TrapRegistration(String aVendorName, char aAgentIndex) {
            Util.validateInputNotNull(aVendorName, "RAID's vendor name");
            this.myAgentIndex = aAgentIndex;
            this.myVendorName = aVendorName;
        }

        RaidSubsystem addOrReplaceRaid(RaidSubsystem aRaid) {
            RaidSubsystem existsRaid = this.getRaid(aRaid.getIPAddresses());
            if (existsRaid != null) {
                this.myRaids.remove(existsRaid);
            }
            this.myRaids.add(aRaid);
            return existsRaid;
        }

        void removeRaid(RaidSubsystem aRaid) {
            this.myRaids.remove(aRaid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TrapRegistration[");
            sb.append(this.myRaids).append(", ");
            sb.append("agentIndex=");
            sb.append((int)this.myAgentIndex);
            sb.append(']');
            return sb.toString();
        }

        char getAgentIndex() {
            return this.myAgentIndex;
        }

        String getVendorName() {
            return this.myVendorName;
        }

        RaidSubsystem getRaid(List<SrIpAddress> aRaidIPs) {
            Util.validateInputNotNull(aRaidIPs, "IP addresses");
            if (aRaidIPs.isEmpty()) {
                throw new IllegalArgumentException("Empty IP addresses array");
            }
            for (RaidSubsystem raid : this.myRaids) {
                List<SrIpAddress> raidIpAddresses = raid.getIPAddresses();
                for (SrIpAddress ip : aRaidIPs) {
                    if (!raidIpAddresses.contains(ip)) continue;
                    return raid;
                }
            }
            return null;
        }
    }
}

