/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.nms.server.comm.snmp.raid.IbmRaidControllerExecutor;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidSubsystem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class RaidControllerTest
extends TestCase {
    public static final String STORAGE_SUBSYSTEM_IP1 = "STORAGE_SUBSYSTEM_IP1";
    public static final String STORAGE_SUBSYSTEM_IP2 = "STORAGE_SUBSYSTEM_IP2";
    public static final String STORAGE_SUBSYSTEM_NAME = "STORAGE_SUBSYSTEM_NAME";
    public static final String STORAGE_SUBSYSTEM_FAKED_NAME = "STORAGE_SUBSYSTEM_FAKED_NAME";
    public static final String STORAGE_SUBSYSTEM_FAKED_IP = "STORAGE_SUBSYSTEM_FAKED_IP";
    public static final String NEW_NAME_POSTFIX = "_new";
    public static final String V_STOR_IP = "V_STOR_IP";
    public static final String OTHER_STORAGE_SUBSYSTEM_IP1 = "OTHER_STORAGE_SUBSYSTEM_IP1";
    public static final String OTHER_STORAGE_SUBSYSTEM_IP2 = "OTHER_STORAGE_SUBSYSTEM_IP2";
    public static final String OTHER_STORAGE_SUBSYSTEM_NAME = "OTHER_STORAGE_SUBSYSTEM_NAME";
    public static final String OTHER_V_STOR_IP = "OTHER_V_STOR_IP";
    public static final String VSWITCH_IP = "VSWITCH_IP";
    private Properties myTestProperties = new Properties();
    private String mySnmpMgrIP;
    private char myDummyAgentIndex = '\u0000';

    public RaidControllerTest() {
        try {
            this.myTestProperties.load(new FileInputStream("test/config/RaidController.properties"));
            this.mySnmpMgrIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cleanAll();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cleanAll();
    }

    private void cleanAll() {
        try {
            List<IbmRaidSubsystem> systems = IbmRaidControllerExecutor.getAllStorageSubsystems(this.myDummyAgentIndex);
            for (IbmRaidSubsystem raid : systems) {
                String oldName = raid.getName().replaceAll(NEW_NAME_POSTFIX, "");
                IbmRaidControllerExecutor.renameStorageSubsystem(raid.getName(), oldName, this.myDummyAgentIndex);
                IbmRaidControllerExecutor.removeStorageSubsystem(oldName, this.myDummyAgentIndex);
            }
        }
        catch (RaidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void testRegisterSnmpManager_register() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidControllerExecutor.registerSnmpManager(new SrIpAddress(this.mySnmpMgrIP), raidSubsystem.getName(), this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testRegisterSnmpManager_raidNotExistsFailure() {
        String fakeName = this.getProperty(STORAGE_SUBSYSTEM_FAKED_NAME);
        boolean isFailed = false;
        try {
            IbmRaidControllerExecutor.registerSnmpManager(new SrIpAddress(this.mySnmpMgrIP), fakeName, this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            isFailed = true;
        }
        RaidControllerTest.assertTrue((String)"Registering a non-exists name didn't fail", (boolean)isFailed);
    }

    public void testRegisterSnmpManager_registerTwice() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidControllerExecutor.registerSnmpManager(new SrIpAddress(this.mySnmpMgrIP), raidSubsystem.getName(), this.myDummyAgentIndex);
            IbmRaidControllerExecutor.registerSnmpManager(new SrIpAddress(this.mySnmpMgrIP), raidSubsystem.getName(), this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testRenameStorageSubsystem_rename() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            String raidNewName = raidSubsystem.getName() + NEW_NAME_POSTFIX;
            IbmRaidControllerExecutor.renameStorageSubsystem(raidSubsystem.getName(), raidNewName, this.myDummyAgentIndex);
            IbmRaidSubsystem newRaidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertFalse((String)"RAID wasn't renamed (exception wasn't thrown)", (boolean)raidSubsystem.getName().equals(newRaidSubsystem.getName()));
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testRenameStorageSubsystem_renameTwiceFailure() {
        IbmRaidSubsystem raidSubsystem = null;
        String raidNewName = null;
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(raidSubsystem.getName() + NEW_NAME_POSTFIX, firstIP, secondIP, this.myDummyAgentIndex);
            raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
        boolean isFailed = false;
        try {
            IbmRaidControllerExecutor.renameStorageSubsystem(raidSubsystem.getName(), raidNewName, this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            isFailed = true;
        }
        RaidControllerTest.assertTrue((String)"Renaming again didn't failed", (boolean)isFailed);
    }

    public void testRenameStorageSubsystem_raidNotExistsFailure() {
        boolean isFailed = false;
        try {
            String raidNewName = "new";
            IbmRaidControllerExecutor.renameStorageSubsystem(this.getProperty(STORAGE_SUBSYSTEM_FAKED_NAME), raidNewName, this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            isFailed = true;
        }
        RaidControllerTest.assertTrue((String)"Renaming non-exitsting subsystem didn't fail", (boolean)isFailed);
    }

    public void testRenameStorageSubsystem_nameAlreadyExistsFailure() {
    }

    public void testAddStorageSubsystem_OnlyFirstControlIP() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, null, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, null, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IP " + firstIP + " wasn't created"), (Object)raidSubsystem);
            RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + firstIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(firstIP));
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testAddStorageSubsystem_OnlySecondControlIP() {
        try {
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, null, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(null, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IP " + secondIP + " wasn't created"), (Object)raidSubsystem);
            RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + secondIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(secondIP));
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testAddStorageSubsystem_TwoControlIPs() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IPs " + firstIP + " and " + secondIP + " wasn't created"), (Object)raidSubsystem);
            RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + firstIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(firstIP));
            RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + secondIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(secondIP));
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testAddStorageSubsystem_alreadyExists() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IPs " + firstIP + " and " + secondIP + " wasn't created"), (Object)raidSubsystem);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            List<IbmRaidSubsystem> raids = IbmRaidControllerExecutor.getAllStorageSubsystems(this.myDummyAgentIndex);
            if (raids.size() > 1) {
                RaidControllerTest.fail((String)("Should be 1 RAID defined only, but found: " + raids));
            }
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testAddStorageSubsystem_alreadyExists_oneSystemTwoIPs() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, null, this.myDummyAgentIndex);
            IbmRaidControllerExecutor.addStorageSubsystem(null, null, secondIP, this.myDummyAgentIndex);
            List<IbmRaidSubsystem> raids = IbmRaidControllerExecutor.getAllStorageSubsystems(this.myDummyAgentIndex);
            if (raids.size() > 1) {
                RaidControllerTest.fail((String)("Should be 1 RAID defined only, but found: " + raids));
            }
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testAddStorageSubsystem_noSubsystemFoundFailure() {
        boolean isFailed = false;
        String fakeIP = this.getProperty(STORAGE_SUBSYSTEM_FAKED_IP);
        try {
            IbmRaidControllerExecutor.addStorageSubsystem(null, fakeIP, null, this.myDummyAgentIndex);
            IbmRaidSubsystem raid = IbmRaidControllerExecutor.getStorageSubsystem(fakeIP, null, this.myDummyAgentIndex);
            RaidControllerTest.assertNull((String)("RAID " + fakeIP + " was created though this IP is not connected"), (Object)raid);
        }
        catch (RaidConfigurationException e) {
            isFailed = true;
        }
        RaidControllerTest.assertTrue((String)("Adding a storage subsystem with disconnected IP " + fakeIP + " didn't failed"), (boolean)isFailed);
    }

    public void testRemoveStorageSubsystem_remove() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IPs " + firstIP + " and " + secondIP + " wasn't created"), (Object)raidSubsystem);
            IbmRaidControllerExecutor.removeStorageSubsystem(raidSubsystem.getName(), this.myDummyAgentIndex);
            IbmRaidSubsystem removedRaidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNull((String)("Storage subsystem with IPs " + firstIP + " and " + secondIP + " wasn't removed"), (Object)removedRaidSubsystem);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testRemoveStorageSubsystem_notExistFailure() {
        boolean isFailed = false;
        try {
            String dummyName = this.getProperty(STORAGE_SUBSYSTEM_FAKED_NAME);
            IbmRaidControllerExecutor.removeStorageSubsystem(dummyName, this.myDummyAgentIndex);
        }
        catch (RaidConfigurationException e) {
            isFailed = true;
        }
        RaidControllerTest.assertTrue((String)"Removing a non-existing storage subsystem didn't failed", (boolean)isFailed);
    }

    public void testGetStorageSubsystem_createAndGet() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            IbmRaidSubsystem raidSubsystem = IbmRaidControllerExecutor.getStorageSubsystem(firstIP, secondIP, this.myDummyAgentIndex);
            RaidControllerTest.assertNotNull((String)("Storage subsystem with IPs " + firstIP + " and " + secondIP + " wasn't created"), (Object)raidSubsystem);
            RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + firstIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(firstIP));
            if (secondIP != null) {
                RaidControllerTest.assertTrue((String)("Created Storage subsystem with IP " + secondIP + " doesn't contain this IP"), (boolean)raidSubsystem.getIPAddresses().contains(secondIP));
            }
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testGetStorageSubsystem_getNotExist_fullDB() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            String fakeIP = this.getProperty(STORAGE_SUBSYSTEM_FAKED_IP);
            IbmRaidSubsystem raid = IbmRaidControllerExecutor.getStorageSubsystem(fakeIP, null, this.myDummyAgentIndex);
            RaidControllerTest.assertNull((String)"", (Object)raid);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testGetStorageSubsystem_getNotExist_emptyDB() {
        try {
            String fakeIP = this.getProperty(STORAGE_SUBSYSTEM_FAKED_IP);
            IbmRaidSubsystem raid = IbmRaidControllerExecutor.getStorageSubsystem(fakeIP, null, this.myDummyAgentIndex);
            RaidControllerTest.assertNull((String)"", (Object)raid);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testGetAllStorageSubsystems_emptyDB() {
        try {
            List<IbmRaidSubsystem> raids = IbmRaidControllerExecutor.getAllStorageSubsystems(this.myDummyAgentIndex);
            RaidControllerTest.assertTrue((String)("Found RAID subsystems in empty DB: " + raids), (boolean)raids.isEmpty());
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    public void testGetAllStorageSubsystems_fullDB() {
        try {
            String firstIP = this.getProperty(STORAGE_SUBSYSTEM_IP1);
            String secondIP = this.getProperty(STORAGE_SUBSYSTEM_IP2);
            IbmRaidControllerExecutor.addStorageSubsystem(null, firstIP, secondIP, this.myDummyAgentIndex);
            List<IbmRaidSubsystem> raids = IbmRaidControllerExecutor.getAllStorageSubsystems(this.myDummyAgentIndex);
            RaidControllerTest.assertTrue((String)"RAID subsystems not found in full DB", (!raids.isEmpty() ? 1 : 0) != 0);
        }
        catch (RaidConfigurationException e) {
            RaidControllerTest.fail((String)e.getMessage());
        }
    }

    private String getProperty(String key) {
        String value = this.myTestProperties.getProperty(key);
        if (value != null && value.trim().length() != 0) {
            return value;
        }
        return null;
    }

    public static void registerSnmpManager(SrIpAddress aSnmpMgrIpAddr, String aRaidName, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.registerSnmpManager(aSnmpMgrIpAddr, aRaidName, aAgentIndex);
    }

    public static void renameStorageSubsystem(String aRaidOldName, String aRaidNewName, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.renameStorageSubsystem(aRaidOldName, aRaidNewName, aAgentIndex);
    }

    public static RaidSubsystem addStorageSubsystem(String aName, String aIp1, String aIp2, char aAgentIndex) throws RaidConfigurationException {
        return IbmRaidControllerExecutor.addStorageSubsystem(aName, aIp1, aIp2, aAgentIndex);
    }

    public static void removeStorageSubsystem(String aRaidName, char aAgentIndex) throws RaidConfigurationException {
        IbmRaidControllerExecutor.removeStorageSubsystem(aRaidName, aAgentIndex);
    }

    public static IbmRaidSubsystem getStorageSubsystem(String aIp1, String aIp2, char aAgentIndex) throws RaidConfigurationException {
        return IbmRaidControllerExecutor.getStorageSubsystem(aIp1, aIp2, aAgentIndex);
    }
}

