/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.nms.server.comm.snmp.raid.IbmRaidController;
import com.sanrad.nms.server.comm.snmp.raid.NexsanRaidController;
import com.sanrad.nms.server.comm.snmp.raid.RaidController;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RaidControllerMgr {
    private static final String VENDOR_NAME_IBM = "IBM";
    private static final String VENDOR_NAME_NEXSAN = "NEXSAN";
    private static Map<SrTrapType, RaidController> theTrapToRaidControllerMap = new HashMap<SrTrapType, RaidController>();

    private RaidControllerMgr() {
    }

    public static RaidController getRaidControllerByVsType(String aVendorName) {
        Util.validateInputNotNull(aVendorName, "RAID's vendor name");
        if (VENDOR_NAME_IBM.equals(aVendorName)) {
            return IbmRaidController.getInstance();
        }
        if (VENDOR_NAME_NEXSAN.equals(aVendorName)) {
            return NexsanRaidController.getInstance();
        }
        return null;
    }

    public static RaidController getRaidControllerByTrapType(SrTrapType aTrapType) {
        return theTrapToRaidControllerMap.get(aTrapType);
    }

    static {
        theTrapToRaidControllerMap.put(SrTrapType.IBM_RAID_TRAP_EVENT, IbmRaidController.getInstance());
        theTrapToRaidControllerMap.put(SrTrapType.NEXSAN_RAID_TRAP_EVENT, NexsanRaidController.getInstance());
    }
}

