/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class NexsanRaidSubsystem
implements RaidSubsystem {
    private List<SrIpAddress> myIPAddress = new ArrayList<SrIpAddress>();
    private static SrLogger theLogger = SrLogger.getLogger();
    private String myName;
    private String myWWN = null;
    private ClusterImpl myCluster = null;

    public NexsanRaidSubsystem(SrString aName, SrIpAddress ... aIpAddress) {
        String raidName;
        String string = raidName = aName == null ? null : aName.toString();
        if (aIpAddress == null || aIpAddress.length == 0) {
            throw new IllegalArgumentException("RaidSubsystem " + aName + " need at least one IP address; the gives address is " + aIpAddress);
        }
        this.myName = raidName;
        for (SrIpAddress ip : aIpAddress) {
            this.myIPAddress.add(ip);
        }
    }

    private SrIpAddress extractIp(String aIpOrUrl) {
        if (aIpOrUrl != null) {
            if (SrString.isUrl(aIpOrUrl)) {
                try {
                    return new SrIpAddress(new URL(aIpOrUrl));
                }
                catch (MalformedURLException e) {
                    theLogger.error(SrLogCategories.EXCEPTION, e, "Should not be here, Ip = " + aIpOrUrl + " checked to be URL but failed in creating URL object");
                }
            } else {
                return new SrIpAddress(aIpOrUrl);
            }
        }
        return null;
    }

    @Override
    public List<SrIpAddress> getIPAddresses() {
        return new ArrayList<SrIpAddress>(this.myIPAddress);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getRaidSysID() {
        return this.myIPAddress.get(0).toString();
    }

    @Override
    public String getWWN() {
        return this.myWWN;
    }

    @Override
    public boolean equals(Object aRaidSys) {
        if (!(aRaidSys instanceof NexsanRaidSubsystem)) {
            return false;
        }
        return Util.equalsListNotOrdered(this.getIPAddresses(), ((NexsanRaidSubsystem)aRaidSys).getIPAddresses());
    }

    public ClusterImpl getCluster() {
        return this.myCluster;
    }
}

